/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;

public class Unicode {
    static final String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

    public static String convCp1251ToUnicode(byte[] buf) {
        if (buf == null) {
            return null;
        }
        int count = buf.length;
        char[] chars = new char[count];
        for (int i = 0; i < count; ++i) {
            byte b = buf[i];
            int ch = b == -77 ? 1110 : (b == -65 ? 1111 : (b == -70 ? 1108 : (b == -76 ? 1169 : (b == -78 ? 1030 : (b == -81 ? 1031 : (b == -91 ? 1168 : (b == -86 ? 1028 : (b == -70 ? 1025 : (b == -72 ? 1105 : (b < 0 ? (int)((char)(0x400 | (b & 0x7F) - 48)) : (int)((char)b)))))))))));
            chars[i] = ch;
        }
        return new String(chars);
    }

    public static String convCp1251ToUnicode(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer b = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            int ch = s.charAt(i);
            if (ch == 179) {
                ch = 1110;
            } else if (ch == 191) {
                ch = 1111;
            } else if (ch == 186) {
                ch = 1108;
            } else if (ch == 180) {
                ch = 1169;
            } else if (ch == 178) {
                ch = 1030;
            } else if (ch == 175) {
                ch = 1031;
            } else if (ch == 165) {
                ch = 1168;
            } else if (ch == 170) {
                ch = 1028;
            } else if (ch > 191 && ch < 1040 && ch != 1025) {
                ch = (char)(ch + 848);
            } else if (ch == 168) {
                ch = 1025;
            } else if (ch == 184) {
                ch = 1105;
            }
            b.append((char)ch);
        }
        return b.toString();
    }

    public static String convUnicodeToCp1251(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer b = new StringBuffer(s.length());
        for (int i = 0; i < s.length(); ++i) {
            int ch = s.charAt(i);
            if (ch == 1110) {
                ch = 179;
            } else if (ch == 1111) {
                ch = 191;
            } else if (ch == 1108) {
                ch = 186;
            } else if (ch == 1169) {
                ch = 180;
            } else if (ch == 1030) {
                ch = 178;
            } else if (ch == 1031) {
                ch = 175;
            } else if (ch == 1168) {
                ch = 165;
            } else if (ch == 1028) {
                ch = 170;
            } else if (ch == 1025) {
                ch = 168;
            } else if (ch == 1105) {
                ch = 184;
            } else if (ch > 1033) {
                ch = (char)(ch - 848);
            }
            b.append((char)ch);
        }
        return b.toString();
    }

    public static byte[] convUnicodeToCp1251Byte(String s) {
        char[] ch = Unicode.convUnicodeToCp1251(s).toCharArray();
        int count = ch.length;
        byte[] b = new byte[count];
        for (int i = 0; i < count; ++i) {
            b[i] = (byte)ch[i];
        }
        return b;
    }

    public static String toBase64(String source) {
        int len = source.length();
        char[] out = new char[(len + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < len) {
            boolean trip = false;
            boolean quad = false;
            int val = (0xFF & source.charAt(i)) << 8;
            if (i + 1 < len) {
                val |= 0xFF & source.charAt(i + 1);
                trip = true;
            }
            val <<= 8;
            if (i + 2 < len) {
                val |= 0xFF & source.charAt(i + 2);
                quad = true;
            }
            out[index + 3] = alphabet.charAt(quad ? val & 0x3F : 64);
            out[index + 2] = alphabet.charAt(trip ? (val >>= 6) & 0x3F : 64);
            out[index + 1] = alphabet.charAt((val >>= 6) & 0x3F);
            out[index] = alphabet.charAt((val >>= 6) & 0x3F);
            i += 3;
            index += 4;
        }
        return new String(out);
    }

    public static String toBase64(byte[] source, int len) {
        if (len < 0) {
            len = source.length;
        }
        char[] out = new char[(len + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < len) {
            boolean trip = false;
            boolean quad = false;
            int val = (0xFF & source[i]) << 8;
            if (i + 1 < len) {
                val |= 0xFF & source[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < len) {
                val |= 0xFF & source[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet.charAt(quad ? val & 0x3F : 64);
            out[index + 2] = alphabet.charAt(trip ? (val >>= 6) & 0x3F : 64);
            out[index + 1] = alphabet.charAt((val >>= 6) & 0x3F);
            out[index] = alphabet.charAt((val >>= 6) & 0x3F);
            i += 3;
            index += 4;
        }
        return new String(out);
    }

    public static StringBuffer toUTFSb(StringBuffer str) {
        int srcLen = str.length();
        StringBuffer outbuf = new StringBuffer(srcLen);
        for (int i = 0; i < srcLen; ++i) {
            char c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                outbuf.append(c);
            }
            if (c >= '\u0080' && c <= '\u07ff' || c == '\u0000') {
                outbuf.append((char)(0xC0 | 0x1F & c >> 6));
                outbuf.append((char)(0x80 | 0x3F & c));
            }
            if (c < '\u0800' || c > '\uffff') continue;
            outbuf.append((char)(0xE0 | 0xF & c >> 12));
            outbuf.append((char)(0x80 | 0x3F & c >> 6));
            outbuf.append((char)(0x80 | 0x3F & c));
        }
        return outbuf;
    }

    public static byte[] fromBase64(String s) {
        return Unicode.baosFromBase64(s).toByteArray();
    }

    public static String sFromBase64(String s) {
        return Unicode.baosFromBase64(s).toString();
    }

    private static ByteArrayOutputStream baosFromBase64(String s) {
        int padding = 0;
        int ibuf = 1;
        ByteArrayOutputStream baos = new ByteArrayOutputStream(2048);
        for (int i = 0; i < s.length(); ++i) {
            char nextChar = s.charAt(i);
            int base64 = -1;
            if (nextChar > '@' && nextChar < '[') {
                base64 = nextChar - 65;
            } else if (nextChar > '`' && nextChar < '{') {
                base64 = nextChar + 26 - 97;
            } else if (nextChar > '/' && nextChar < ':') {
                base64 = nextChar + 52 - 48;
            } else if (nextChar == '+') {
                base64 = 62;
            } else if (nextChar == '/') {
                base64 = 63;
            } else if (nextChar == '=') {
                base64 = 0;
                ++padding;
            } else if (nextChar == '<') break;
            if (base64 >= 0) {
                ibuf = (ibuf << 6) + base64;
            }
            if (ibuf < 0x1000000) continue;
            baos.write(ibuf >> 16 & 0xFF);
            if (padding < 2) {
                baos.write(ibuf >> 8 & 0xFF);
            }
            if (padding == 0) {
                baos.write(ibuf & 0xFF);
            }
            ibuf = 1;
        }
        try {
            baos.close();
        }
        catch (Exception ignored) {
            // empty catch block
        }
        return baos;
    }

    public static String unicodeToUTF(String src) {
        return Unicode.toUTFSb(new StringBuffer(src)).toString();
    }
}

