/*
 * Decompiled with CFR 0.152.
 */
package com.gui;

import com.gui.DeviceScreen;
import com.gui.GUICommand;
import com.gui.GUIGraphics;
import com.gui.GUIManager;
import com.gui.UniKeys;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GUIListTree
extends DeviceScreen {
    public static final GUICommand SELECT_COMMAND = new GUICommand("OK", 7);
    private Object[] TABLE = null;
    private int stepX = 10;
    private int Y = 0;
    private Object[] TABLE_ITEM = null;
    private Object[] TABLE_IMAGE = null;
    private int cursorY;
    private int totalItem;
    private int cursorPosition = 0;
    private int YS = 0;
    private int XS = 0;
    private int STEP;
    private int count = 0;

    public GUIListTree(String title) {
        super.setTitle(title);
        this.addCommand(SELECT_COMMAND);
    }

    public void append(String name, String path, Image image) {
        if (name != null && path != null) {
            TableList tl = new TableList(name, path, image, false);
            if (this.searchOfElement(this.TABLE, name, path) == -1) {
                this.TABLE = super.addElement(this.TABLE, tl);
            }
        }
    }

    public void append(String[] names, String path, Image[] images) {
        if (names != null && path != null) {
            int sz = names.length;
            for (int i = 0; i < sz; ++i) {
                Image img = images == null ? null : images[i];
                this.append(names[i], path, img);
            }
        }
    }

    public void removeElement(String name, String path) {
        int id;
        if (name != null && path != null && (id = this.searchOfElement(this.TABLE, name, path)) != -1) {
            Object[] tmp;
            if (name.endsWith("/") && (tmp = this.searchOfPath(this.TABLE, path + name)) != null) {
                for (int i = 0; i < tmp.length; ++i) {
                    TableList tl = (TableList)tmp[i];
                    this.removeElement(tl.getName(), path + name);
                }
            }
            this.TABLE = super.removeElement(this.TABLE, id);
        }
    }

    public String getName() {
        if (this.TABLE_ITEM != null) {
            String name = "";
            String ts = (String)this.TABLE_ITEM[this.cursorPosition];
            int i = ts.lastIndexOf(47, ts.length() - 2);
            name = i != -1 ? ts.substring(i + 1) : ts;
            return name;
        }
        return null;
    }

    public String getPath() {
        if (this.TABLE_ITEM != null) {
            String path = "";
            String ts = (String)this.TABLE_ITEM[this.cursorPosition];
            int i = ts.lastIndexOf(47, ts.length() - 2);
            if (i != -1) {
                path = ts.substring(0, i + 1);
            }
            return path;
        }
        return null;
    }

    public String getFullPath() {
        if (this.TABLE_ITEM != null) {
            return (String)this.TABLE_ITEM[this.cursorPosition];
        }
        return null;
    }

    public void update() {
        String updatePath;
        Object[] tmp;
        if (this.getName().endsWith("/") && (tmp = this.searchOfPath(this.TABLE, updatePath = this.getFullPath())) != null) {
            int sz = tmp.length;
            for (int i = 0; i < sz; ++i) {
                TableList tl = (TableList)tmp[i];
                this.removeElement(tl.getName(), updatePath);
            }
        }
    }

    void paintScreen(Graphics g, int width, int height) {
        g.setFont(this.itemFont);
        g.setColor(GUIManager.getTheme().itemRGB);
        this.STEP = this.itemHeight;
        this.totalItem = 0;
        this.TABLE_ITEM = null;
        this.TABLE_IMAGE = null;
        this.paintTree(g, 5 + this.XS, this.YS, "");
        g.setStrokeStyle(0);
        this.count = 0;
    }

    void keyPress(int key) {
        if (this.TABLE_ITEM != null) {
            if (UniKeys.isKey(key, "DOWN") || GUIManager.isDuplicationOfKeysOfNavigation() && UniKeys.isKey(key, "KEY_NUM8")) {
                if (this.cursorY > this.clipHeight - 2 * this.itemHeight && this.cursorPosition < this.totalItem - 1) {
                    this.YS -= this.STEP;
                }
                if (this.cursorPosition < this.totalItem - 1) {
                    ++this.cursorPosition;
                }
            } else if (UniKeys.isKey(key, "UP") || GUIManager.isDuplicationOfKeysOfNavigation() && UniKeys.isKey(key, "KEY_NUM2")) {
                if (this.YS < 0 && this.cursorY < this.itemHeight) {
                    this.YS += this.STEP;
                }
                if (this.cursorPosition > 0) {
                    --this.cursorPosition;
                }
            } else if (UniKeys.isKey(key, "RIGHT") || GUIManager.isDuplicationOfKeysOfNavigation() && UniKeys.isKey(key, "KEY_NUM6")) {
                this.XS = this.XS < this.STEP ? (this.XS -= this.STEP) : 0;
            } else if (UniKeys.isKey(key, "LEFT") || GUIManager.isDuplicationOfKeysOfNavigation() && UniKeys.isKey(key, "KEY_NUM4")) {
                if (this.XS < 0) {
                    this.XS += this.STEP;
                }
            } else if (UniKeys.isKey(key, "FIRE") || GUIManager.isDuplicationOfKeysOfNavigation() && UniKeys.isKey(key, "KEY_NUM5")) {
                String name = "";
                String path = "";
                String ts = (String)this.TABLE_ITEM[this.cursorPosition];
                int i = ts.lastIndexOf(47, ts.length() - 2);
                if (i != -1) {
                    path = ts.substring(0, i + 1);
                    name = ts.substring(i + 1);
                } else {
                    name = ts;
                }
                int index = this.searchOfElement(this.TABLE, name, path);
                if (index != -1) {
                    TableList tl = (TableList)this.TABLE[index];
                    if (tl.isOpen()) {
                        tl.setOpen(false);
                    } else {
                        tl.setOpen(true);
                        this.guicl.commandAction(SELECT_COMMAND, this);
                    }
                    this.TABLE = this.setElement(this.TABLE, tl, index);
                }
            }
        }
    }

    void keyRepeat(int key) {
        this.keyPress(key);
    }

    private void paintTree(Graphics g, int x, int y, String parent) {
        int ith = this.itemHeight;
        int xs = x + ith;
        this.Y = y;
        int ys = y;
        int iw = 0;
        Object[] tmp = this.searchOfPath(this.TABLE, parent);
        if (tmp != null) {
            TableList tb = null;
            int sz = tmp.length;
            for (int i = 0; i < sz; ++i) {
                tb = (TableList)tmp[i];
                String name = tb.getName();
                if (this.TABLE.length == 1) {
                    if (tb.getImage() != null) {
                        GUIGraphics.drawImage(g, tb.getImage(), x, this.Y + ith / 2, 6);
                        iw = tb.getImage().getWidth();
                    }
                    this.cursorY = this.Y;
                    GUIManager.getTheme().gradientFill(g, x + iw + 2, this.cursorY, this.itemFont.stringWidth(name), ith, true, GUIManager.getTheme().cursorFonRGB1, GUIManager.getTheme().cursorFonRGB2);
                    g.setColor(GUIManager.getTheme().itemPasteRGB);
                    GUIGraphics.drawString(g, name.endsWith("/") ? name.replace('/', ' ') : name, x + iw + 2, this.Y + 2, 0);
                    this.TABLE_ITEM = super.addElement(this.TABLE_ITEM, tb.getPath() + name);
                    return;
                }
                if (tb.getImage() != null) {
                    GUIGraphics.drawImage(g, tb.getImage(), xs, this.Y + ith / 2, 6);
                    iw = tb.getImage().getWidth();
                }
                xs += iw;
                this.TABLE_ITEM = super.addElement(this.TABLE_ITEM, tb.getPath() + name);
                if (this.cursorPosition == this.totalItem) {
                    this.cursorY = this.Y;
                    g.setStrokeStyle(0);
                    GUIManager.getTheme().gradientFill(g, xs, this.cursorY, this.itemFont.stringWidth(name), ith, true, GUIManager.getTheme().cursorFonRGB1, GUIManager.getTheme().cursorFonRGB2);
                    g.setColor(GUIManager.getTheme().itemPasteRGB);
                } else {
                    g.setColor(GUIManager.getTheme().itemRGB);
                }
                GUIGraphics.drawString(g, name.endsWith("/") ? name.replace('/', ' ') : name, xs, this.Y + 2, 0);
                g.setColor(GUIManager.getTheme().lineRGB);
                g.setStrokeStyle(1);
                ++this.totalItem;
                if (this.count != 0 || sz != 1) {
                    g.drawLine(xs - ith - iw, this.Y + ith / 2, xs - iw, this.Y + ith / 2);
                }
                if (i == 0 && this.count > 0) {
                    g.drawLine(xs - ith - iw, this.Y + ith / 2, xs - ith - iw, this.Y - 2);
                }
                if (i == sz - 1) {
                    g.drawLine(xs - ith - iw, ys + ith / 2, xs - ith - iw, this.Y + ith / 2);
                }
                xs = x + ith;
                this.Y += ith;
                if (tb.isOpen()) {
                    String str = parent + name;
                    ++this.count;
                    Object[] tmp1 = this.searchOfPath(this.TABLE, str);
                    if (tmp1 != null) {
                        g.drawLine(xs - ith, ys + ith / 2, xs, ys + ith / 2);
                        this.TABLE_IMAGE = this.addElement(this.TABLE_IMAGE, new TableImage(GUIManager.getImages()[5], xs - ith - 4, this.Y - ith + 3));
                    }
                    this.paintTree(g, xs += this.stepX, this.Y, str);
                    xs = x + ith;
                    continue;
                }
                Object[] tmp1 = this.searchOfPath(this.TABLE, parent + name);
                if (tmp1 == null) continue;
                g.drawLine(xs - ith, ys + ith / 2, xs, ys + ith / 2);
                this.TABLE_IMAGE = this.addElement(this.TABLE_IMAGE, new TableImage(GUIManager.getImages()[4], xs - ith - 4, this.Y - ith + 3));
            }
            if (this.TABLE_IMAGE != null) {
                int sz1 = this.TABLE_IMAGE.length;
                for (int i = 0; i < sz1; ++i) {
                    TableImage ti = (TableImage)this.TABLE_IMAGE[i];
                    g.drawImage(ti.getImage(), ti.getX(), ti.getY(), 0);
                }
            }
        }
    }

    Object[] searchOfPath(Object[] search, String pathSearch) {
        if (pathSearch != null && search != null) {
            int sz = search.length;
            Object[] tmp = null;
            for (int i = 0; i < sz; ++i) {
                TableList tl = (TableList)search[i];
                if (!tl.getPath().equals(pathSearch)) continue;
                tmp = super.addElement(tmp, tl);
            }
            return tmp;
        }
        return null;
    }

    Object[] searchOfString(Object[] search, String nameSearch) {
        if (search != null && nameSearch != null) {
            int sz = search.length;
            Object[] tmp = null;
            for (int i = 0; i < sz; ++i) {
                TableList tl = (TableList)search[i];
                if (!tl.getName().equals(nameSearch)) continue;
                tmp = super.addElement(tmp, tl);
            }
            return tmp;
        }
        return null;
    }

    int searchOfElement(Object[] search, String name, String path) {
        if (search != null && name != null && path != null) {
            int sz = search.length;
            for (int i = 0; i < sz; ++i) {
                TableList tl = (TableList)search[i];
                if (!tl.getName().equals(name) || !tl.getPath().equals(path)) continue;
                return i;
            }
        }
        return -1;
    }

    void reset() {
        this.YS = 0;
        this.XS = 0;
        this.cursorPosition = 0;
    }

    void showNotifyScreen() {
    }

    void hideNotifyScreen() {
    }

    final class TableImage {
        private Image img;
        private int x;
        private int y;

        TableImage(Image img, int x, int y) {
            this.img = img;
            this.x = x;
            this.y = y;
        }

        Image getImage() {
            return this.img;
        }

        int getX() {
            return this.x;
        }

        int getY() {
            return this.y;
        }
    }

    final class TableList {
        String name;
        String path;
        boolean open;
        Image image;

        TableList(String name, String path, Image image, boolean open) {
            this.name = name;
            this.path = path;
            this.image = image;
            this.open = open;
        }

        String getName() {
            return this.name;
        }

        String getPath() {
            return this.path;
        }

        Image getImage() {
            return this.image;
        }

        void setImage(Image image) {
            this.image = image;
        }

        boolean isOpen() {
            return this.open;
        }

        void setOpen(boolean open) {
            this.open = open;
        }
    }
}

