/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class HumanPlayer
extends Player {
    int step = 0;
    int max_step = 8;
    int dir = 0;

    public HumanPlayer(Game g, int px, int py, int ray, int sx, int sy, int minx, int miny, int maxx, int maxy, int b1, int b2) {
        super(g, px, py, ray, sx, sy, minx, miny, maxx, maxy, b1, b2, true);
    }

    public void pressKey(int keyCode) {
        switch (keyCode) {
            case -3: 
            case 52: {
                this.dir = 0;
                this.speedX = -this.stepX;
                this.speedY = 0;
                this.move = true;
                break;
            }
            case -1: 
            case 50: {
                this.dir = 1;
                this.speedX = 0;
                this.speedY = -this.stepY;
                this.move = true;
                break;
            }
            case -4: 
            case 54: {
                this.dir = 2;
                this.speedX = this.stepX;
                this.speedY = 0;
                this.move = true;
                break;
            }
            case -2: 
            case 56: {
                this.dir = 3;
                this.speedX = 0;
                this.speedY = this.stepY;
                this.move = true;
                break;
            }
            case 53: {
                this.move = !this.move;
                break;
            }
        }
    }

    public void movePlayer() {
        this.run();
    }

    public void updateState() {
        if (this.posY + this.speedY + this.r >= this.moveAreaMaxY) {
            this.speedY = this.moveAreaMaxY - (this.posY + this.r);
        }
        if (this.posX + this.speedX + this.r >= this.moveAreaMaxX) {
            this.speedX = this.moveAreaMaxX - (this.posX + this.r);
        }
        if (this.posX + this.speedX <= this.moveAreaMinX) {
            this.speedX = this.moveAreaMinX - this.posX;
        }
        if (this.posX + this.speedX < this.moveAreaMinX || this.posX + this.speedX + this.r > this.moveAreaMaxX) {
            return;
        }
        if (this.posY + this.speedY < this.moveAreaMinY || this.posY + this.speedY + this.r > this.moveAreaMaxY) {
            return;
        }
        this.posX += this.speedX;
        this.posY += this.speedY;
        ++this.step;
        if (this.step >= this.max_step) {
            switch (this.dir) {
                case 0: {
                    this.speedX -= 2;
                    break;
                }
                case 1: {
                    this.speedY -= 2;
                    break;
                }
                case 2: {
                    this.speedX += 2;
                    break;
                }
                case 3: {
                    this.speedY += 2;
                    break;
                }
            }
            this.step = 0;
        }
    }

    public void run() {
        if (this.objectGame.state == 3) {
            if (this.move) {
                this.updateState();
            } else {
                this.speedY = 0;
                this.speedX = 0;
            }
        }
    }

    public void paint(Graphics g) {
        switch ((this.posY - 27 - 64) / 27) {
            case 0: {
                g.drawImage(Resources.IMAGE_PLAYER_H2, this.objectGame.ball.perspectiveX(this.posX, this.posY), this.posY, 0x10 | 4);
                break;
            }
            case 1: {
                g.drawImage(Resources.IMAGE_PLAYER_H3, this.objectGame.ball.perspectiveX(this.posX, this.posY), this.posY, 0x10 | 4);
                break;
            }
            case 2: {
                g.drawImage(Resources.IMAGE_PLAYER_H4, this.objectGame.ball.perspectiveX(this.posX, this.posY), this.posY, 0x10 | 4);
            }
        }
    }
}

