/*
 * Decompiled with CFR 0.152.
 */
package menu;

import containers.Localizaton;
import framework.AppState;
import framework.MainGameCanvas;
import framework.graphics.TextRenderer;
import framework.math.FP;
import framework.menu.IMenuFormListener;
import framework.menu.MenuForm;
import framework.sound.Music;
import framework.utils.rms.RMSUtils;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import menu.HighscoresAppState;
import menu.RMSHighscore;
import root.GoolGlobals;
import root.GoolMidlet;

public class AddHighscoreAppState
extends AppState
implements IMenuFormListener {
    private static final int KEY_DELAY = 150;
    private int keyDelayTimer;
    private short nextLevelNumber;
    private MenuForm addHighscore;
    private int[] letterButtonIds = new int[7];
    private int okButtonId;
    private int deleteLetterButtonId;
    private int descButtonId;
    private int scoreButtonId;
    private int timeButtonId;
    private boolean exitFlag = false;
    private byte[] nickLetterNumbers = new byte[]{0, 0, 0, 0, 0, 0, 0};

    public AddHighscoreAppState(String name, MainGameCanvas gameCanvas) {
        super(name, gameCanvas);
    }

    private void createMenu() {
        try {
            this.addHighscore = null;
            TextRenderer.getInstance().setCurrentFont("FONT_NORMAL");
            int width = TextRenderer.getInstance().getStringWidth(1);
            int height = TextRenderer.getInstance().getStringHeight(1);
            int[] rowsSizes = new int[]{height * 2, height * 7, height * 4, height * 2, height, height, height, height, -1, 20};
            int[] columnsSizes = new int[]{-1, width, width, width, width, width, width, width, -1};
            this.addHighscore = MenuForm.createMenuForm(13, rowsSizes, columnsSizes, 240, 320, (byte)1, (byte)1);
            this.addHighscore.listener = this;
            this.addHighscore.createControl(1, 150, 80, -1, 1, 4, 10, 18, null, Localizaton.TEXT_ADDHIGHSCORE_CONGRATULATIONS, 0, 0);
            this.addHighscore.createControl(4, 100, 30, -1, 3, 4, 18, 18, null, Localizaton.TEXT_ADDHIGHSCORE_ENTER_NAME, 0, 0);
            this.scoreButtonId = this.addHighscore.createControl(4, 100, 10, -1, 2, 4, 18, 18, null, new StringBuffer("score 0"), 0, 0);
            for (int i = 0; i < this.letterButtonIds.length; ++i) {
                this.letterButtonIds[i] = this.addHighscore.createControl(4, width, height, i, 6, i + 1, 18, 18, null, new StringBuffer("a"), 0, 0);
                this.addHighscore.controls[this.letterButtonIds[i]].text.setCharAt(0, GoolMidlet.language[this.nickLetterNumbers[i]]);
            }
            this.descButtonId = this.addHighscore.createScrollBox(250, 130, -1, 8, 4, 18, 18, Localizaton.TEXT_ADDHIGHSCORE_INSTRUCTION, 0);
            this.okButtonId = this.addHighscore.createControl(4, 100, 10, -1, 9, 0, 17, 17, null, Localizaton.TEXT_MENUS_OK, 0, 5);
            this.deleteLetterButtonId = this.addHighscore.createControl(4, 100, 10, -1, 9, 8, 20, 20, null, Localizaton.TEXT_ADDHIGHSCORE_CLEAR, 0, 5);
            this.addHighscore.focusedID = this.letterButtonIds[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createDynamicElements() {
        int fp_rope1AnchorX = 270 << FP.SHIFT;
        int fp_rope1AnchorY = 55 << FP.SHIFT;
        int fp_rope2AnchorX = fp_rope1AnchorX;
        int fp_rope2AnchorY = (240 << FP.SHIFT) - fp_rope1AnchorY;
        int fp_ropeLength = 80 << FP.SHIFT;
        int fp_starOuterRadius = 15 << FP.SHIFT;
        int fp_starInnerRadius = 8 << FP.SHIFT;
        int fp_initialBallOffsetX = 12 << FP.SHIFT;
    }

    public boolean initialize(Object param) {
        this.createMenu();
        this.exitFlag = false;
        for (int i = 0; i < this.letterButtonIds.length; ++i) {
            this.addHighscore.controls[this.letterButtonIds[i]].text.setCharAt(0, GoolMidlet.language[this.nickLetterNumbers[i]]);
        }
        if (param != null) {
            this.nextLevelNumber = (Short)param;
        }
        this.addHighscore.controls[0].text = new StringBuffer();
        this.addHighscore.controls[0].text.append((Object)Localizaton.TEXT_ADDHIGHSCORE_CONGRATULATIONS);
        this.addHighscore.controls[this.scoreButtonId].text = new StringBuffer();
        this.addHighscore.controls[this.scoreButtonId].text.append((Object)Localizaton.TEXT_ADDHIGHSCORE_SCORE);
        this.addHighscore.controls[this.scoreButtonId].text.append(GoolGlobals.score);
        int xOffset = -((TextRenderer.getInstance().getStringWidth(this.addHighscore.controls[this.scoreButtonId].text.length()) - TextRenderer.getInstance().getStringWidth(Localizaton.TEXT_ADDHIGHSCORE_SCORE.length())) / 2);
        this.addHighscore.controls[this.scoreButtonId].calculatePositions(xOffset, 0, TextRenderer.getInstance());
        this.addHighscore.focusedID = this.letterButtonIds[0];
        this.highlightFocusedControl();
        this.mainGameCanvas.getKeyStates();
        try {
            Thread.sleep(200L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void saveHighscore() {
        Vector highscoresRecordsScores;
        StringBuffer nick = new StringBuffer("");
        for (int i = 0; i < this.nickLetterNumbers.length; ++i) {
            nick.append(GoolMidlet.language[this.nickLetterNumbers[i]]);
        }
        try {
            highscoresRecordsScores = RMSUtils.loadRecords("highs", Class.forName("menu.RMSHighscore"));
        }
        catch (ClassNotFoundException exc) {
            throw new RuntimeException("Impossibleeee!");
        }
        int highscoresRecordsScoresSize = highscoresRecordsScores.size();
        if (nick.toString().compareTo("       ") == 0) {
            RMSUtils.storeRecord("highs", new RMSHighscore(-1, new String("anonym"), GoolGlobals.score));
            ++highscoresRecordsScoresSize;
        } else {
            RMSUtils.storeRecord("highs", new RMSHighscore(-1, nick.toString(), GoolGlobals.score));
            ++highscoresRecordsScoresSize;
        }
        if (highscoresRecordsScoresSize > 5) {
            HighscoresAppState.highscoresInsertionSortScores(highscoresRecordsScores);
            RMSUtils.deleteRecord("highs", ((RMSHighscore)highscoresRecordsScores.lastElement()).recordId);
        }
    }

    public void handleInput() {
        int keyStates = this.mainGameCanvas.getKeyStates();
        for (int i = 0; i < this.letterButtonIds.length; ++i) {
            if (this.addHighscore.focusedID != this.letterButtonIds[i]) continue;
            if ((keyStates & 2) != 0) {
                if (this.keyDelayTimer > 0) continue;
                if (this.nickLetterNumbers[i] == 0) {
                    int n = i;
                    this.nickLetterNumbers[n] = (byte)(this.nickLetterNumbers[n] + 14);
                } else {
                    int n = i;
                    this.nickLetterNumbers[n] = (byte)(this.nickLetterNumbers[n] + 1);
                }
                int n = i;
                this.nickLetterNumbers[n] = (byte)(this.nickLetterNumbers[n] % GoolMidlet.language.length);
                this.addHighscore.controls[this.letterButtonIds[i]].text.setCharAt(0, GoolMidlet.language[this.nickLetterNumbers[i]]);
                this.keyDelayTimer = 150;
                continue;
            }
            if ((keyStates & 0x40) == 0 || this.keyDelayTimer > 0) continue;
            if (this.nickLetterNumbers[i] == 14) {
                int n = i;
                this.nickLetterNumbers[n] = (byte)(this.nickLetterNumbers[n] - 14);
            } else {
                int n = i;
                this.nickLetterNumbers[n] = (byte)(this.nickLetterNumbers[n] - 1);
            }
            if (this.nickLetterNumbers[i] < 0) {
                this.nickLetterNumbers[i] = (byte)(GoolMidlet.language.length - 1);
            }
            this.addHighscore.controls[this.letterButtonIds[i]].text.setCharAt(0, GoolMidlet.language[this.nickLetterNumbers[i]]);
            this.keyDelayTimer = 150;
        }
        this.addHighscore.handleInput(keyStates);
        this.highlightFocusedControl();
    }

    public void keyPressed(int keyCode) {
        if (keyCode == -7) {
            for (int i = 0; i < this.letterButtonIds.length; ++i) {
                if (this.addHighscore.focusedID != this.letterButtonIds[i]) continue;
                this.nickLetterNumbers[i] = 0;
                this.addHighscore.controls[this.letterButtonIds[i]].text.setCharAt(0, GoolMidlet.language[0]);
                if (this.addHighscore.focusedID == this.letterButtonIds[0]) continue;
                --this.addHighscore.focusedID;
            }
        }
        if (!(keyCode != -6 && keyCode != 53 && keyCode != -5 && keyCode != 53 || this.exitFlag)) {
            this.saveHighscore();
            this.addHighscore.focusedID = this.okButtonId;
            this.mainGameCanvas.requestAppStateChange("Tournament");
            GoolGlobals.nextPhaze = true;
        }
        this.addHighscore.keyPressed(keyCode);
        this.highlightFocusedControl();
    }

    private void highlightFocusedControl() {
        int i;
        this.addHighscore.controls[this.okButtonId].state = 0;
        this.addHighscore.controls[this.deleteLetterButtonId].state = 0;
        for (i = 0; i < this.letterButtonIds.length; ++i) {
            this.addHighscore.controls[this.letterButtonIds[i]].state = 0;
        }
        for (i = 0; i < this.letterButtonIds.length; ++i) {
            if (this.addHighscore.focusedID != this.letterButtonIds[i]) continue;
            this.addHighscore.controls[this.letterButtonIds[i]].state = 1;
        }
        if (this.addHighscore.focusedID == this.okButtonId) {
            this.addHighscore.controls[this.okButtonId].state = 1;
        }
    }

    public void render(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, 240, 320);
        this.addHighscore.drawMenu(g);
        g.setColor(0xFFFFFF);
        g.drawLine(this.addHighscore.controls[this.letterButtonIds[0]].pozX - this.addHighscore.controls[this.letterButtonIds[0]].width / 2 - 5, this.addHighscore.controls[this.letterButtonIds[0]].pozY - this.addHighscore.controls[this.letterButtonIds[0]].height / 2 - 2, this.addHighscore.controls[this.letterButtonIds[0]].pozX - this.addHighscore.controls[this.letterButtonIds[0]].width / 2 - 5, this.addHighscore.controls[this.letterButtonIds[0]].pozY + this.addHighscore.controls[this.letterButtonIds[0]].height / 2 + 1);
        g.drawLine(this.addHighscore.controls[this.letterButtonIds[0]].pozX - this.addHighscore.controls[this.letterButtonIds[0]].width / 2 - 5, this.addHighscore.controls[this.letterButtonIds[0]].pozY - this.addHighscore.controls[this.letterButtonIds[0]].height / 2 - 2, this.addHighscore.controls[this.letterButtonIds[0]].pozX - this.addHighscore.controls[this.letterButtonIds[0]].width / 2 - 3, this.addHighscore.controls[this.letterButtonIds[0]].pozY - this.addHighscore.controls[this.letterButtonIds[0]].height / 2 - 2);
        g.drawLine(this.addHighscore.controls[this.letterButtonIds[0]].pozX - this.addHighscore.controls[this.letterButtonIds[0]].width / 2 - 5, this.addHighscore.controls[this.letterButtonIds[0]].pozY + this.addHighscore.controls[this.letterButtonIds[0]].height / 2 + 1, this.addHighscore.controls[this.letterButtonIds[0]].pozX - this.addHighscore.controls[this.letterButtonIds[0]].width / 2 - 3, this.addHighscore.controls[this.letterButtonIds[0]].pozY + this.addHighscore.controls[this.letterButtonIds[0]].height / 2 + 1);
        g.drawLine(this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].pozX + this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].width / 2 + 5, this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].pozY - this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].height / 2 - 2, this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].pozX + this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].width / 2 + 5, this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].pozY + this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].height / 2 + 1);
        g.drawLine(this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].pozX + this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].width / 2 + 5, this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].pozY - this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].height / 2 - 2, this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].pozX + this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].width / 2 + 3, this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].pozY - this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].height / 2 - 2);
        g.drawLine(this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].pozX + this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].width / 2 + 5, this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].pozY + this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].height / 2 + 1, this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].pozX + this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].width / 2 + 3, this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].pozY + this.addHighscore.controls[this.letterButtonIds[this.letterButtonIds.length - 1]].height / 2 + 1);
        for (int i = 0; i < this.letterButtonIds.length; ++i) {
            if (this.addHighscore.focusedID != this.letterButtonIds[i]) continue;
            g.setColor(0xFFFFFF);
            g.drawLine(this.addHighscore.controls[this.letterButtonIds[i]].pozX - this.addHighscore.controls[this.letterButtonIds[i]].width / 2, this.addHighscore.controls[this.letterButtonIds[i]].pozY + this.addHighscore.controls[this.letterButtonIds[i]].height / 2 + 4, this.addHighscore.controls[this.letterButtonIds[i]].pozX + this.addHighscore.controls[this.letterButtonIds[i]].width / 2, this.addHighscore.controls[this.letterButtonIds[i]].pozY + this.addHighscore.controls[this.letterButtonIds[i]].height / 2 + 4);
            g.drawLine(this.addHighscore.controls[this.letterButtonIds[i]].pozX - this.addHighscore.controls[this.letterButtonIds[i]].width / 2, this.addHighscore.controls[this.letterButtonIds[i]].pozY + this.addHighscore.controls[this.letterButtonIds[i]].height / 2 + 3, this.addHighscore.controls[this.letterButtonIds[i]].pozX - this.addHighscore.controls[this.letterButtonIds[i]].width / 2, this.addHighscore.controls[this.letterButtonIds[i]].pozY + this.addHighscore.controls[this.letterButtonIds[i]].height / 2 + 4);
            g.drawLine(this.addHighscore.controls[this.letterButtonIds[i]].pozX + this.addHighscore.controls[this.letterButtonIds[i]].width / 2, this.addHighscore.controls[this.letterButtonIds[i]].pozY + this.addHighscore.controls[this.letterButtonIds[i]].height / 2 + 3, this.addHighscore.controls[this.letterButtonIds[i]].pozX + this.addHighscore.controls[this.letterButtonIds[i]].width / 2, this.addHighscore.controls[this.letterButtonIds[i]].pozY + this.addHighscore.controls[this.letterButtonIds[i]].height / 2 + 4);
        }
    }

    public void update(int deltaTime) {
        this.keyDelayTimer -= deltaTime;
        if (this.keyDelayTimer < 0) {
            this.keyDelayTimer = 0;
        }
        this.addHighscore.update(deltaTime);
        if (this.exitFlag) {
            this.mainGameCanvas.requestAppStateChange("HighScores", new Boolean(false));
        }
    }

    public void notifyKeypressed(int formID, int controlID) {
    }

    public void pauseStateChanged(boolean paused) {
        super.pauseStateChanged(paused);
        if (GoolGlobals.playMusic) {
            if (paused) {
                Music.stopMusic();
            } else {
                Music.playMusic(GoolGlobals.menuMusicId);
            }
        }
    }
}

