/*
 * Decompiled with CFR 0.152.
 */
package root;

import containers.Localizaton;
import framework.AppState;
import framework.MainGameCanvas;
import framework.graphics.SimpleSprite;
import framework.graphics.TextRenderer;
import framework.math.FP;
import framework.math.Vector2D;
import framework.menu.IMenuFormListener;
import framework.menu.MenuForm;
import framework.sound.Music;
import framework.utils.rms.RMSUtils;
import java.io.IOException;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import menu.MainMenu;
import menu.RMSGame;
import menu.RMSSettings;
import root.Ball;
import root.GoolGlobals;
import root.GoolMidlet;
import root.Player;
import root.StaticBall;

public class Game
extends AppState
implements IMenuFormListener {
    public static RMSGame gameRecord;
    private static int currentMapNr;
    public Random rand = new Random();
    public static Player[] players;
    public static Ball ball;
    public int[] score = new int[2];
    public Image pitchImage = null;
    public boolean resume = true;
    public boolean matchOver = false;
    public boolean matchPause = false;
    public boolean pauseGame = false;
    public boolean redCard = false;
    public int animationSpeed = 1000;
    public int animationID = 0;
    public int animationTime = 4000;
    public long animationStart = 0L;
    public long animationCurrentTime = 0L;
    public int animationX = 50;
    public int animationY = 50;
    public SimpleSprite[] animations = new SimpleSprite[5];
    public boolean upPressed;
    public boolean downPressed;
    public boolean leftPressed;
    public boolean rightPressed;
    public boolean overtime = false;
    public int cornerCounter = 0;
    public int goalCounter = 8;
    boolean block = false;
    boolean masterBlock = false;
    boolean switchAi = true;
    int pla = 0;
    public int goolBufferX;
    public int goolBufferY;
    public int timeBuffX;
    public int timeBuffY;
    public int scoreBufferX;
    public int endMatchBufferX;
    public int endMatchBufferY;
    public int thumbXSpace = 10;
    public int scoreXSpace;
    public int timeLX = 117;
    public int timeRX = 123;
    public long time = 180000L;
    public long pauseTime = 0L;
    public long startTime = 0L;
    public long currentTime = 0L;
    public long currentTime2 = 0L;
    public long ballStoppedTime = 0L;
    public long maxBallStoppedTime = 7000L;
    public long ballInZoneTime = 0L;
    public long maxBallInZoneTime = 15000L;
    public int lastBallOwner = 0;
    public StringBuffer timeBuffer = new StringBuffer("0.00");
    public StringBuffer scoreBuffer = new StringBuffer("0   0");
    public static boolean doubleCollision;
    public int doubleCollisionCounter = 0;
    public SimpleSprite normalFont;
    public SimpleSprite specialFont;
    public SimpleSprite numbers;
    public Image pointsBGL;
    public Image pointsBGR;
    public Image team0thb;
    public Image team1thb;
    public Image goalImage;
    public Image goalImageUp;
    public Image timeBG;
    public Image goool;
    private long animationFrameTime;
    private Vector2D aiMovingVector = new Vector2D(0, 0);
    private int infoBufferY;
    private int infoBufferX;
    private int overtimeBufferX;
    private int menuBufferX;
    private int textsY;
    public boolean isExit = false;
    public static RMSSettings settingsRecord;
    int nrActive = 0;
    int offset = 20;
    int offsetWidth = 115;
    MenuForm menu;
    public static MenuForm qMenu;
    public static MenuForm emptyMenu;
    public static MenuForm nextMenu;
    private int menuOffset;
    private String nextState;
    public long moveStart = 0L;
    public long moveSpeed = 50L;
    public boolean enter = false;
    public static boolean out;
    private int continue2ID;
    private int music2ID;
    private int exit2ID;
    private int continueID;
    private int exitID;
    private StringBuffer sensitivityBuff = new StringBuffer("1");
    private int maxSensitivity = 5;
    private int minTime = 1;
    private int maxTime = 5;
    public int bgOffset;

    public Game(String stateName, MainGameCanvas mainGameCanvas) {
        super(stateName, mainGameCanvas);
        this.menuBufferX = 240 - TextRenderer.getInstance().getStringWidth(Localizaton.MENU.length());
        this.textsY = 320 - TextRenderer.getInstance().getStringHeight(1);
        this.goolBufferX = 120 - (TextRenderer.getInstance().getStringWidth(Localizaton.GOAL.length()) >> 1);
        this.goolBufferY = 160 - (TextRenderer.getInstance().getStringHeight(1) >> 1);
        this.timeBuffX = 120 - (TextRenderer.getInstance().getStringWidth(this.timeBuffer.length()) >> 1);
        this.timeBuffY = 320 - TextRenderer.getInstance().getStringHeight(1);
        this.scoreBufferX = 120 - (TextRenderer.getInstance().getStringWidth(this.scoreBuffer.length()) >> 1);
        this.endMatchBufferX = 120 - (TextRenderer.getInstance().getStringWidth(Localizaton.MATCH_OVER.length()) >> 1);
        this.endMatchBufferY = 160 - TextRenderer.getInstance().getStringHeight(1) - 20;
        this.infoBufferX = 120 - (TextRenderer.getInstance().getStringWidth(Localizaton.BUTTON_INFO.length()) >> 1);
        this.infoBufferY = 160 + TextRenderer.getInstance().getStringHeight(1);
        this.overtimeBufferX = 120 - (TextRenderer.getInstance().getStringWidth(Localizaton.OVERTIME.length()) >> 1);
        this.normalFont = TextRenderer.getInstance().getFont("FONT_NORMAL");
        this.specialFont = TextRenderer.getInstance().getFont("FONT_HIGHLIGHTED");
    }

    public void displayScore(Graphics g) {
        g.drawImage(this.pointsBGL, this.scoreXSpace, 0, 0);
        g.drawImage(this.pointsBGR, 240 - this.scoreXSpace, 0, 0x10 | 8);
        this.numbers.paint(g, this.scoreXSpace + this.numbers.frameWidth / 4, 0, Game.players[0].score / 10);
        this.numbers.paint(g, this.scoreXSpace + this.numbers.frameWidth + this.numbers.frameWidth / 4, 0, Game.players[0].score % 10);
        this.numbers.paint(g, 240 - this.scoreXSpace - 2 * this.numbers.frameWidth - this.numbers.frameWidth / 4, 0, Game.players[1].score / 10);
        this.numbers.paint(g, 240 - this.scoreXSpace - this.numbers.frameWidth - this.numbers.frameWidth / 4, 0, Game.players[1].score % 10);
    }

    private void displayTime(Graphics g) {
        int mins = (int)(this.time - this.currentTime) / 60000;
        int secs = (int)(this.time - this.currentTime - (long)(mins * 60000)) / 1000;
        if (secs < 0) {
            secs = 0;
        }
        if (mins < 0) {
            mins = 0;
        }
        g.drawImage(this.timeBG, 120, 320, 1 | 0x20);
        this.numbers.paint(g, this.timeRX, 320 - this.numbers.frameHeight, secs / 10);
        this.numbers.paint(g, this.timeRX + this.numbers.frameWidth, 320 - this.numbers.frameHeight, secs % 10);
        this.numbers.paint(g, this.timeLX - 2 * this.numbers.frameWidth, 320 - this.numbers.frameHeight, mins / 10);
        this.numbers.paint(g, this.timeLX - this.numbers.frameWidth, 320 - this.numbers.frameHeight, mins % 10);
    }

    private void SetSpeed() {
        if (GoolGlobals.sensitivity == 1) {
            GoolGlobals.MAX_HUMAN_VELOCITY = 700;
            GoolGlobals.MAX_AI_VELOCITY = 250;
            Game.ball.fp_maxScalarVelocity = 550;
        } else if (GoolGlobals.sensitivity == 2) {
            GoolGlobals.MAX_HUMAN_VELOCITY = 1000;
            GoolGlobals.MAX_AI_VELOCITY = 600;
            Game.ball.fp_maxScalarVelocity = 800;
        } else if (GoolGlobals.sensitivity == 3) {
            GoolGlobals.MAX_HUMAN_VELOCITY = 1500;
            GoolGlobals.MAX_AI_VELOCITY = 900;
            Game.ball.fp_maxScalarVelocity = 1300;
        }
    }

    private void startGame() {
        this.pauseGame = true;
        ball = new Ball(this);
        try {
            this.goool = Image.createImage((String)"/t_gooal_o.png");
            this.playersSetup(GoolGlobals.currentPlayerTeam, GoolGlobals.currentOpponentTeam);
            this.pitchImage = null;
            System.gc();
            this.pitchAndBallSetup(Math.abs(this.rand.nextInt() % 6));
            Game.ball.fp_x = (GoolGlobals.PITCH_WIDTH >> 1) + GoolGlobals.PITCH_X << FP.SHIFT;
            Game.ball.fp_y = (GoolGlobals.PITCH_HEIGHT >> 1) + GoolGlobals.PITCH_Y << FP.SHIFT;
            this.time = this.overtime ? (long)(60000 * GoolGlobals.overtimeTime) : (long)(60000 * GoolGlobals.matchTime);
            this.startTime = 0L;
            this.currentTime = 0L;
            this.currentTime2 = 0L;
            this.ballStoppedTime = 0L;
            this.ballInZoneTime = 0L;
            this.matchOver = false;
            this.SetSpeed();
        }
        catch (IOException ex) {
            this.pauseGame = false;
            ex.printStackTrace();
        }
        this.pauseGame = false;
    }

    private void continueGame() {
        ball = new Ball(this);
        try {
            int i;
            this.goool = Image.createImage((String)"/t_gooal_o.png");
            this.playersSetup(RMSGame.currentPlayerTeam, RMSGame.currentOpponentTeam);
            GoolGlobals.currentPlayerTeam = RMSGame.currentPlayerTeam;
            GoolGlobals.currentOpponentTeam = RMSGame.currentOpponentTeam;
            for (i = 0; i < 3; ++i) {
                Game.players[0].team[i].fp_x = RMSGame.team_fp_x[i];
                Game.players[0].team[i].move(0, 0);
            }
            for (i = 0; i < 3; ++i) {
                Game.players[1].team[i].fp_x = RMSGame.team_fp_x[i + 3];
                Game.players[1].team[i].move(0, 0);
            }
            for (i = 0; i < 3; ++i) {
                Game.players[0].team[i].fp_y = RMSGame.team_fp_y[i];
                Game.players[0].team[i].move(0, 0);
            }
            for (i = 0; i < 3; ++i) {
                Game.players[1].team[i].fp_y = RMSGame.team_fp_y[i + 3];
                Game.players[1].team[i].move(0, 0);
            }
            Game.players[0].score = RMSGame.score[0];
            Game.players[1].score = RMSGame.score[1];
            this.pitchImage = null;
            System.gc();
            this.pitchAndBallSetup(RMSGame.currentMapNr);
            Game.ball.fp_x = RMSGame.ball_fp_x;
            Game.ball.fp_y = RMSGame.ball_fp_y;
            GoolGlobals.winGame = RMSGame.winGame;
            this.time = RMSGame.time;
            this.currentTime = RMSGame.currTime;
            this.startTime = this.startTime = System.currentTimeMillis() - this.currentTime;
            this.currentTime2 = 0L;
            this.ballStoppedTime = 0L;
            this.ballInZoneTime = 0L;
            this.matchOver = false;
            this.SetSpeed();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.masterBlock = true;
    }

    private void saveGame() {
        int i;
        RMSGame.currentPlayerTeam = (byte)GoolGlobals.currentPlayerTeam;
        RMSGame.currentOpponentTeam = (byte)GoolGlobals.currentOpponentTeam;
        for (i = 0; i < 3; ++i) {
            RMSGame.team_fp_x[i] = Game.players[0].team[i].fp_x;
        }
        for (i = 0; i < 3; ++i) {
            RMSGame.team_fp_x[i + 3] = Game.players[1].team[i].fp_x;
        }
        for (i = 0; i < 3; ++i) {
            RMSGame.team_fp_y[i] = Game.players[0].team[i].fp_y;
        }
        for (i = 0; i < 3; ++i) {
            RMSGame.team_fp_y[i + 3] = Game.players[1].team[i].fp_y;
        }
        RMSGame.score[0] = (byte)Game.players[0].score;
        RMSGame.score[1] = (byte)Game.players[1].score;
        RMSGame.currentMapNr = (byte)currentMapNr;
        RMSGame.ball_fp_x = Game.ball.fp_x;
        RMSGame.ball_fp_y = Game.ball.fp_y;
        RMSGame.time = this.time;
        RMSGame.currTime = this.currentTime;
        RMSGame.winGame = GoolGlobals.winGame;
        RMSUtils.updateRecord("game", gameRecord);
    }

    private void startOvertime() {
        this.pauseGame = true;
        ball = new Ball(this);
        try {
            this.goool = Image.createImage((String)"/t_gooal_o.png");
            this.pitchImage = null;
            System.gc();
            this.pitchAndBallSetup(Math.abs(this.rand.nextInt() % 6));
            Game.ball.fp_x = (GoolGlobals.PITCH_WIDTH >> 1) + GoolGlobals.PITCH_X << FP.SHIFT;
            Game.ball.fp_y = (GoolGlobals.PITCH_HEIGHT >> 1) + GoolGlobals.PITCH_Y << FP.SHIFT;
            this.time = this.overtime ? (long)(60000 * GoolGlobals.overtimeTime) : (long)(60000 * GoolGlobals.matchTime);
            players[0].resetPosition();
            players[1].resetPosition();
            this.startTime = 0L;
            this.currentTime = 0L;
            this.currentTime2 = 0L;
            this.ballStoppedTime = 0L;
            this.ballInZoneTime = 0L;
            this.matchOver = false;
            this.SetSpeed();
        }
        catch (IOException ex) {
            this.pauseGame = false;
            ex.printStackTrace();
        }
        this.pauseGame = false;
    }

    public void afterGoal(Player player) {
        ++player.score;
        Game.ball.fp_x = (GoolGlobals.PITCH_WIDTH >> 1) + GoolGlobals.PITCH_X << FP.SHIFT;
        if (player.playerID == 0) {
            Game.ball.fp_y = Game.players[1].team[1].fp_upBound + Game.ball.fp_radius;
            if (player.score / 10 == 0) {
                this.scoreBuffer.setCharAt(0, GoolMidlet.language[4 + player.score % 10]);
            } else {
                this.scoreBuffer.setCharAt(1, GoolMidlet.language[4 + player.score % 10]);
                this.scoreBuffer.setCharAt(0, GoolMidlet.language[4 + player.score / 10]);
            }
        } else {
            Game.ball.fp_y = Game.players[0].team[1].fp_downBound - Game.ball.fp_radius;
            if (player.score / 10 == 0) {
                this.scoreBuffer.setCharAt(4, GoolMidlet.language[4 + player.score % 10]);
            } else {
                this.scoreBuffer.setCharAt(4, GoolMidlet.language[4 + player.score % 10]);
                this.scoreBuffer.setCharAt(3, GoolMidlet.language[4 + player.score / 10]);
            }
        }
        players[0].resetPosition();
        players[1].resetPosition();
        this.goalCounter = 8;
        this.resume = false;
    }

    public boolean initialize(Object param) {
        GoolGlobals.clearMenuImages();
        try {
            Image tmpImage = Image.createImage((String)"/czerwona_kartka.png");
            this.animations[0] = new SimpleSprite(tmpImage, tmpImage.getWidth() / 4, tmpImage.getHeight());
            tmpImage = Image.createImage((String)"/time.png");
            this.animations[1] = new SimpleSprite(tmpImage, tmpImage.getWidth() / 2, tmpImage.getHeight());
            this.animations[2] = this.animations[0];
            tmpImage = Image.createImage((String)"/points.png");
            this.numbers = new SimpleSprite(tmpImage, tmpImage.getWidth() / 10, tmpImage.getHeight());
            this.pointsBGL = Image.createImage((String)"/points_bg.png");
            this.pointsBGR = Image.createImage((Image)this.pointsBGL, (int)0, (int)0, (int)this.pointsBGL.getWidth(), (int)this.pointsBGL.getHeight(), (int)2);
            this.timeBG = Image.createImage((String)"/time.png");
            tmpImage = null;
            System.gc();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.scoreXSpace = this.thumbXSpace + this.pointsBGL.getWidth();
        this.overtime = false;
        if (GoolGlobals.playMusic) {
            Music.stopMusic();
            Music.playMusic(GoolGlobals.gameMusicId);
        }
        try {
            Vector gameVector;
            RecordStore.openRecordStore((String)"game", (boolean)false);
            try {
                gameVector = RMSUtils.loadRecords("game", Class.forName("menu.RMSGame"));
            }
            catch (ClassNotFoundException exc) {
                throw new RuntimeException("Impossible!");
            }
            gameRecord = (RMSGame)gameVector.elementAt(0);
        }
        catch (RecordStoreException ex) {
            RMSUtils.createRecordStore("game");
            gameRecord = new RMSGame(0, 0, 0);
            RMSUtils.updateRecord("game", gameRecord);
        }
        if (param != null && (Integer)param == 1) {
            this.continueGame();
        } else {
            this.startGame();
            this.saveGame();
        }
        super.initialize(param);
        if (this.menu == null) {
            this.createQuickMenu();
            this.createEmptyMenu();
        } else {
            Game.qMenu.getControlByID((int)this.music2ID).text = GoolGlobals.playMusic ? new StringBuffer().append((Object)Localizaton.OPTIONS_MUSIC).append(" ").append((Object)Localizaton.ON) : new StringBuffer().append((Object)Localizaton.OPTIONS_MUSIC).append(" ").append((Object)Localizaton.OFF);
        }
        this.menuOffset = 240;
        if (Game.qMenu.absoluteX >= 0) {
            this.changeMenuOffset(this.menuOffset, qMenu);
        }
        if (Game.emptyMenu.absoluteX >= 0) {
            this.changeMenuOffset(this.menuOffset, emptyMenu);
        }
        if (this.bgOffset >= 0) {
            this.changeBgOffset(this.menuOffset);
        }
        this.enter = true;
        this.nextState = null;
        nextMenu = null;
        return true;
    }

    public void pitchAndBallSetup(int pitch) throws IOException {
        switch (pitch) {
            case 0: {
                Game.ball.fp_resistance = GoolGlobals.NORMAL_RES;
                Game.ball.fp_maxScalarVelocity = GoolGlobals.MAX_BALL_VELOCITY;
                this.pitchImage = Image.createImage((String)"/8ball.jpg");
                this.goalImage = null;
                break;
            }
            case 1: {
                Game.ball.fp_resistance = GoolGlobals.SAND_RES;
                Game.ball.fp_maxScalarVelocity = GoolGlobals.MAX_BALL_VELOCITY;
                this.pitchImage = Image.createImage((String)"/africa.jpg");
                this.goalImage = Image.createImage((String)"/africa.png");
                break;
            }
            case 2: {
                Game.ball.fp_resistance = 256;
                Game.ball.fp_maxScalarVelocity = GoolGlobals.MAX_BALL_VELOCITY;
                this.pitchImage = Image.createImage((String)"/heaven.jpg");
                this.goalImage = null;
                break;
            }
            case 3: {
                Game.ball.fp_resistance = 254;
                Game.ball.fp_maxScalarVelocity = GoolGlobals.MAX_BALL_VELOCITY;
                this.pitchImage = Image.createImage((String)"/city.jpg");
                this.goalImage = null;
                break;
            }
            case 4: {
                Game.ball.fp_resistance = 252;
                Game.ball.fp_maxScalarVelocity = GoolGlobals.MAX_BALL_VELOCITY * 500 >> FP.SHIFT;
                this.pitchImage = Image.createImage((String)"/hell.jpg");
                this.goalImage = Image.createImage((String)"/hell.png");
                break;
            }
            case 5: {
                Game.ball.fp_resistance = 256;
                Game.ball.fp_maxScalarVelocity = GoolGlobals.MAX_BALL_VELOCITY * 300 >> FP.SHIFT;
                this.pitchImage = Image.createImage((String)"/heaven.jpg");
                this.goalImage = null;
            }
        }
        this.goalImageUp = this.goalImage != null ? Image.createImage((Image)this.goalImage, (int)0, (int)0, (int)this.goalImage.getWidth(), (int)this.goalImage.getHeight(), (int)1) : null;
        currentMapNr = pitch;
    }

    public void update(int deltaTime) {
        block28: {
            if (this.pauseGame) {
                return;
            }
            if (this.matchOver) {
                return;
            }
            if (this.redCard) {
                this.playAnimation();
                return;
            }
            if (Game.players[0].score == 10 || Game.players[0].score == 10) {
                this.matchOver = true;
            }
            if (this.startTime == 0L) {
                this.startTime = System.currentTimeMillis();
            }
            if (this.masterBlock) {
                this.block = true;
            }
            this.currentTime2 = System.currentTimeMillis() - this.startTime;
            if (this.block && !Game.ball.goal && !this.matchPause) {
                if (!this.matchPause) {
                    this.currentTime = System.currentTimeMillis() - this.startTime;
                    if (this.currentTime >= this.time) {
                        this.matchOver = true;
                    }
                    if (this.downPressed) {
                        Game.players[this.pla].yMoovingSpeed += Game.players[this.pla].fp_acceleration;
                    }
                    if (this.upPressed) {
                        Game.players[this.pla].yMoovingSpeed -= Game.players[this.pla].fp_acceleration;
                    }
                    if (!this.upPressed && !this.downPressed) {
                        Game.players[this.pla].yMoovingSpeed = 0;
                    }
                    if (this.leftPressed) {
                        Game.players[this.pla].xMoovingSpeed -= Game.players[this.pla].fp_acceleration;
                    }
                    if (this.rightPressed) {
                        Game.players[this.pla].xMoovingSpeed += Game.players[this.pla].fp_acceleration;
                    }
                    if (!this.leftPressed && !this.rightPressed) {
                        Game.players[this.pla].xMoovingSpeed = 0;
                    }
                    this.checkCorners();
                    if (this.switchAi) {
                        this.moveAI(players[1]);
                    }
                    try {
                        ball.move(deltaTime);
                        players[0].update(deltaTime);
                        players[1].update(deltaTime);
                        ball.correctMove();
                        players[0].correctMove();
                        players[1].correctMove();
                        ball.reCorrectMove();
                        players[0].reCorrectMove();
                        players[1].reCorrectMove();
                        ball.resolveCollision();
                        this.block = false;
                        if (!this.matchPause && !Game.ball.goal) {
                            this.checkBallKeeping();
                            break block28;
                        }
                        this.ballInZoneTime = 0L;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (Game.ball.goal && this.resume) {
                if (this.goalCounter > 0) {
                    --this.goalCounter;
                    Game.ball.fp_y = Game.ball.fp_y > 160 << FP.SHIFT ? (Game.ball.fp_y += 256) : (Game.ball.fp_y -= 256);
                } else if (Game.ball.fp_y > 160 << FP.SHIFT) {
                    this.afterGoal(players[0]);
                } else {
                    this.afterGoal(players[1]);
                }
            }
        }
        this.menu.update(deltaTime);
        if (this.enter) {
            this.enter(deltaTime);
        } else if (out) {
            this.out(deltaTime);
        }
    }

    public void keyReleased(int keyCode) {
        block15: {
            block14: {
                block13: {
                    block12: {
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        if (keyCode == -2) break block8;
                                        if (keyCode != 56) break block9;
                                    }
                                    this.downPressed = false;
                                }
                                if (keyCode == -1) break block10;
                                if (keyCode != 50) break block11;
                            }
                            this.upPressed = false;
                        }
                        if (keyCode == -3) break block12;
                        if (keyCode != 52) break block13;
                    }
                    this.leftPressed = false;
                }
                if (keyCode == -4) break block14;
                if (keyCode != 54) break block15;
            }
            this.rightPressed = false;
        }
    }

    private void loadSettings() {
        Vector settingsVector;
        try {
            RecordStore.openRecordStore((String)"sett", (boolean)false);
        }
        catch (RecordStoreException ex) {
            // empty catch block
        }
        try {
            settingsVector = RMSUtils.loadRecords("sett", Class.forName("menu.RMSSettings"));
        }
        catch (ClassNotFoundException exc) {
            throw new RuntimeException("Impossible!");
        }
        settingsRecord = (RMSSettings)settingsVector.elementAt(0);
    }

    private void DisableContinue() {
        this.loadSettings();
        RMSSettings.save = 0;
        RMSUtils.updateRecord("sett", settingsRecord);
        MainMenu.createMenu();
    }

    /*
     * Enabled aggressive block sorting
     */
    public void keyPressed(int keyCode) {
        block66: {
            block65: {
                block64: {
                    block63: {
                        block62: {
                            block61: {
                                block60: {
                                    block59: {
                                        block57: {
                                            block54: {
                                                block58: {
                                                    block56: {
                                                        if (keyCode == -5) break block56;
                                                        if (keyCode == -6) break block56;
                                                        if (keyCode != 53) break block57;
                                                    }
                                                    if (this.matchPause) {
                                                        if (this.menu.id == Game.qMenu.id) {
                                                            if (this.menu.focusedID == this.continue2ID) {
                                                                this.matchPause = false;
                                                                if (!Game.ball.goal) {
                                                                    this.ballInZoneTime = System.currentTimeMillis();
                                                                    this.ballStoppedTime = System.currentTimeMillis();
                                                                    this.resume = true;
                                                                    this.startTime = System.currentTimeMillis() - this.currentTime;
                                                                    this.currentTime = System.currentTimeMillis() - this.startTime;
                                                                }
                                                                nextMenu = emptyMenu;
                                                                out = true;
                                                            } else if (this.menu.focusedID == this.exit2ID) {
                                                                nextMenu = emptyMenu;
                                                                out = true;
                                                                this.isExit = true;
                                                            } else if (this.menu.focusedID == this.music2ID) {
                                                                this.changeMusic();
                                                            }
                                                        }
                                                        this.notifyKeypressed(this.menu.id, this.menu.focusedID);
                                                        return;
                                                    }
                                                    if (!this.matchOver) break block54;
                                                    if (!GoolGlobals.tournamentStarted) break block58;
                                                    GoolGlobals.goalPlayer += Game.players[0].score;
                                                    GoolGlobals.goalEnemy += Game.players[1].score;
                                                    if (Game.players[0].score > Game.players[1].score) {
                                                        GoolGlobals.playerWon = true;
                                                        ++GoolGlobals.winGame;
                                                        if (GoolGlobals.currentTournamentPhaze == 2) {
                                                            this.DisableContinue();
                                                            this.mainGameCanvas.requestAppStateChange("WinLoseState", new Integer(2));
                                                            if (GoolGlobals.playMusic) {
                                                                Music.stopMusic();
                                                                Music.playMusic(GoolGlobals.menuMusicId);
                                                            }
                                                            GoolGlobals.endTournament = true;
                                                            GoolGlobals.score += 5 * GoolGlobals.sensitivity;
                                                            GoolGlobals.score += GoolGlobals.goalPlayer * GoolGlobals.sensitivity - GoolGlobals.goalEnemy * GoolGlobals.sensitivity + GoolGlobals.winGame * GoolGlobals.sensitivity * 2;
                                                            break block54;
                                                        } else {
                                                            this.mainGameCanvas.requestAppStateChange("Tournament");
                                                            if (GoolGlobals.playMusic) {
                                                                Music.stopMusic();
                                                                Music.playMusic(GoolGlobals.menuMusicId);
                                                            }
                                                            GoolGlobals.nextPhaze = true;
                                                        }
                                                        break block54;
                                                    } else {
                                                        if (Game.players[0].score >= Game.players[1].score) {
                                                            this.overtime = true;
                                                            this.startOvertime();
                                                            return;
                                                        }
                                                        GoolGlobals.endTournament = true;
                                                        GoolGlobals.playerWon = false;
                                                        this.DisableContinue();
                                                        this.mainGameCanvas.requestAppStateChange("Statistic");
                                                        if (GoolGlobals.playMusic) {
                                                            Music.stopMusic();
                                                            Music.playMusic(GoolGlobals.menuMusicId);
                                                        }
                                                        GoolGlobals.score += GoolGlobals.goalPlayer * GoolGlobals.sensitivity - GoolGlobals.goalEnemy * GoolGlobals.sensitivity + GoolGlobals.winGame * GoolGlobals.sensitivity * 2;
                                                    }
                                                    break block54;
                                                }
                                                if (Game.players[0].score > Game.players[1].score) {
                                                    GoolGlobals.playerWon = true;
                                                    this.mainGameCanvas.requestAppStateChange("Menu");
                                                    if (GoolGlobals.playMusic) {
                                                        Music.stopMusic();
                                                        Music.playMusic(GoolGlobals.menuMusicId);
                                                    }
                                                } else if (Game.players[0].score < Game.players[1].score) {
                                                    GoolGlobals.playerWon = false;
                                                    this.mainGameCanvas.requestAppStateChange("Menu");
                                                    if (GoolGlobals.playMusic) {
                                                        Music.stopMusic();
                                                        Music.playMusic(GoolGlobals.menuMusicId);
                                                    }
                                                } else {
                                                    this.mainGameCanvas.requestAppStateChange("Menu");
                                                    if (GoolGlobals.playMusic) {
                                                        Music.stopMusic();
                                                        Music.playMusic(GoolGlobals.menuMusicId);
                                                    }
                                                }
                                            }
                                            if (Game.ball.goal && this.goalCounter == 8) {
                                                Game.ball.goal = false;
                                                Game.ball.fp_scalarVelocity = 0;
                                                this.resume = true;
                                                this.startTime = System.currentTimeMillis() - this.currentTime;
                                                this.currentTime = System.currentTimeMillis() - this.startTime;
                                            }
                                            if (!this.masterBlock) {
                                                this.masterBlock = !this.masterBlock;
                                                this.startTime = System.currentTimeMillis() - this.currentTime;
                                                this.currentTime = System.currentTimeMillis() - this.startTime;
                                                this.ballInZoneTime = 0L;
                                                this.ballStoppedTime = 0L;
                                            }
                                        }
                                        if (keyCode == -2) break block59;
                                        if (keyCode != 56) break block60;
                                    }
                                    this.downPressed = true;
                                }
                                if (keyCode == -1) break block61;
                                if (keyCode != 50) break block62;
                            }
                            this.upPressed = true;
                        }
                        if (keyCode == -3) break block63;
                        if (keyCode != 52) break block64;
                    }
                    this.leftPressed = true;
                }
                if (keyCode == -4) break block65;
                if (keyCode != 54) break block66;
            }
            this.rightPressed = true;
        }
        if (keyCode == -7 && !this.matchOver) {
            if (this.enter || out) {
                return;
            }
            boolean bl = this.matchPause = !this.matchPause;
            if (!this.matchPause) {
                if (!Game.ball.goal) {
                    this.ballInZoneTime = System.currentTimeMillis();
                    this.ballStoppedTime = System.currentTimeMillis();
                    this.resume = true;
                    this.startTime = System.currentTimeMillis() - this.currentTime;
                    this.currentTime = System.currentTimeMillis() - this.startTime;
                }
                nextMenu = emptyMenu;
                out = true;
            } else {
                if (!Game.ball.goal) {
                    this.goalCounter = 8;
                    this.resume = false;
                }
                nextMenu = qMenu;
                out = true;
            }
        } else if (keyCode == -7) {
            // empty if block
        }
        if (keyCode == 42) {
            this.switchAi = !this.switchAi;
        }
    }

    public void render(Graphics g) {
        int helpY;
        int helpX;
        int helpY2;
        int helpX2;
        int textHeight;
        if (this.pauseGame) {
            return;
        }
        g.drawImage(this.pitchImage, 0, 0, 0x10 | 4);
        ball.draw(g);
        players[0].draw(g);
        players[1].draw(g);
        g.drawImage(this.team0thb, this.thumbXSpace, 0, 0x10 | 4);
        g.drawImage(this.team1thb, 240 - this.thumbXSpace, 0, 0x10 | 8);
        if (Game.ball.goal) {
            g.drawImage(GoolGlobals.menuBackground, 0, 160 - GoolGlobals.menuBackground.getHeight() / 2 + this.offset, 0);
            g.drawImage(this.goool, this.offsetWidth, 160 - GoolGlobals.menuBackground.getHeight() / 2 + 10 + this.offset, 0x10 | 1);
            TextRenderer.getInstance().setCurrentFont(this.normalFont);
            textHeight = TextRenderer.getInstance().getStringHeight(1);
            TextRenderer.getInstance().setCurrentFont("FONT_HIGHLIGHTED");
            TextRenderer.getInstance().renderText(g, this.offsetWidth - TextRenderer.getInstance().getStringWidth(Localizaton.BUTTON_INFO.length()) / 2, this.endMatchBufferY + textHeight + 25 + this.offset, Localizaton.BUTTON_INFO);
            TextRenderer.getInstance().renderText(g, this.offsetWidth - TextRenderer.getInstance().getStringWidth(Localizaton.BUTTON_INFO2.length()) / 2, this.endMatchBufferY + 2 * textHeight + 4 + 25 + this.offset, Localizaton.BUTTON_INFO2);
            TextRenderer.getInstance().setCurrentFont(this.specialFont);
            helpX2 = (GoolGlobals.button.frameWidth - TextRenderer.getInstance().getStringWidth(Localizaton.PLAY.length())) / 2;
            helpY2 = 320 - GoolGlobals.button.frameHeight + (GoolGlobals.button.frameHeight - TextRenderer.getInstance().getStringHeight(1)) / 2;
            GoolGlobals.button.paintWithAnchor(g, 0, 320 - GoolGlobals.button.frameHeight, 0);
            TextRenderer.getInstance().renderText(g, helpX2, helpY2, Localizaton.PLAY);
        }
        if (this.goalImage != null) {
            g.drawImage(this.goalImage, 120, 37 - this.goalImage.getHeight(), 0x10 | 1);
            g.drawImage(this.goalImageUp, 120, 283 + this.goalImage.getHeight(), 0x20 | 1);
        }
        this.displayTime(g);
        this.displayScore(g);
        if (this.matchOver) {
            g.drawImage(GoolGlobals.menuBackground, 0, 160 - GoolGlobals.menuBackground.getHeight() / 2 + this.offset, 0);
            textHeight = TextRenderer.getInstance().getStringHeight(1);
            TextRenderer.getInstance().setCurrentFont("FONT_HIGHLIGHTED");
            if (Game.players[0].score == Game.players[1].score) {
                if (GoolGlobals.tournamentStarted) {
                    TextRenderer.getInstance().renderText(g, this.offsetWidth - TextRenderer.getInstance().getStringWidth(Localizaton.OVERTIME.length()) / 2, this.endMatchBufferY - (textHeight + 2) + 30 + this.offset, Localizaton.OVERTIME);
                } else {
                    TextRenderer.getInstance().renderText(g, this.offsetWidth - TextRenderer.getInstance().getStringWidth(Localizaton.MATCH_OVER.length()) / 2, this.endMatchBufferY - (textHeight + 2) + 30 + this.offset, Localizaton.MATCH_OVER);
                }
            } else if (!(GoolGlobals.tournamentStarted && Game.players[0].score < Game.players[1].score || Game.players[0].score > Game.players[1].score && GoolGlobals.currentTournamentPhaze == 2)) {
                TextRenderer.getInstance().renderText(g, this.offsetWidth - TextRenderer.getInstance().getStringWidth(Localizaton.MATCH_OVER.length()) / 2, this.endMatchBufferY - (textHeight + 2) + this.offset, Localizaton.MATCH_OVER);
            }
            if (Game.players[0].score > Game.players[1].score) {
                g.drawImage(GoolGlobals.winImage, GoolGlobals.menuBackground.getWidth() / 2 - GoolGlobals.winImage.getWidth() / 2 + 5, 145 + this.offset, 0);
                if (GoolGlobals.tournamentStarted && GoolGlobals.currentTournamentPhaze == 2) {
                    TextRenderer.getInstance().renderText(g, this.offsetWidth - TextRenderer.getInstance().getStringWidth(Localizaton.WIN.length()) / 2, this.endMatchBufferY + this.offset - textHeight - 2, Localizaton.WIN);
                    TextRenderer.getInstance().renderText(g, this.offsetWidth - TextRenderer.getInstance().getStringWidth(Localizaton.TITLE_TOURNAMENT.length()) / 2, this.endMatchBufferY + this.offset, Localizaton.TITLE_TOURNAMENT);
                } else {
                    TextRenderer.getInstance().renderText(g, this.offsetWidth - TextRenderer.getInstance().getStringWidth(Localizaton.WINMATCH.length()) / 2, this.endMatchBufferY + this.offset, Localizaton.WINMATCH);
                }
            } else if (Game.players[0].score < Game.players[1].score) {
                g.drawImage(GoolGlobals.lostImage, GoolGlobals.menuBackground.getWidth() / 2 - GoolGlobals.lostImage.getWidth() / 2 + 5, 145 + this.offset, 0);
                if (GoolGlobals.tournamentStarted) {
                    TextRenderer.getInstance().renderText(g, this.offsetWidth - TextRenderer.getInstance().getStringWidth(Localizaton.LOST.length()) / 2, this.endMatchBufferY + this.offset - textHeight - 2, Localizaton.LOST);
                    TextRenderer.getInstance().renderText(g, this.offsetWidth - TextRenderer.getInstance().getStringWidth(Localizaton.TITLE_TOURNAMENT.length()) / 2, this.endMatchBufferY + this.offset, Localizaton.TITLE_TOURNAMENT);
                } else {
                    TextRenderer.getInstance().renderText(g, this.offsetWidth - TextRenderer.getInstance().getStringWidth(Localizaton.LOSTMATCH.length()) / 2, this.endMatchBufferY + this.offset, Localizaton.LOSTMATCH);
                }
            }
            TextRenderer.getInstance().renderText(g, 120 - TextRenderer.getInstance().getStringWidth(Localizaton.BUTTON_INFO.length()) / 2 - 5, this.endMatchBufferY + textHeight + this.offset - 10, Localizaton.EMPTY);
            TextRenderer.getInstance().renderText(g, 120 - TextRenderer.getInstance().getStringWidth(Localizaton.BUTTON_INFO2.length()) / 2 - 5, this.endMatchBufferY + 2 * textHeight + this.offset, Localizaton.EMPTY);
            TextRenderer.getInstance().setCurrentFont(this.specialFont);
            helpX2 = (GoolGlobals.button.frameWidth - TextRenderer.getInstance().getStringWidth(Localizaton.MENU_NEXT.length())) / 2;
            helpY2 = 320 - GoolGlobals.button.frameHeight + (GoolGlobals.button.frameHeight - TextRenderer.getInstance().getStringHeight(1)) / 2;
            GoolGlobals.button.paintWithAnchor(g, 0, 320 - GoolGlobals.button.frameHeight, 0);
            TextRenderer.getInstance().renderText(g, helpX2, helpY2, Localizaton.MENU_NEXT);
        }
        if (this.redCard && !this.matchOver) {
            if (this.animationID != 1) {
                this.animations[this.animationID].paint(g, 20, 20);
            } else {
                this.animations[this.animationID].paintWithAnchor(g, this.animationX, this.animationY, 1 | 0x20);
            }
        }
        TextRenderer.getInstance().setCurrentFont(this.normalFont);
        if (this.overtime) {
            TextRenderer.getInstance().renderText(g, this.overtimeBufferX, 0, Localizaton.OVERTIME);
        }
        if (!this.masterBlock) {
            TextRenderer.getInstance().setCurrentFont(this.specialFont);
            helpX = (GoolGlobals.button.frameWidth - TextRenderer.getInstance().getStringWidth(Localizaton.PLAY.length())) / 2;
            helpY = 320 - GoolGlobals.button.frameHeight + (GoolGlobals.button.frameHeight - TextRenderer.getInstance().getStringHeight(1)) / 2;
            GoolGlobals.button.paintWithAnchor(g, 0, 320 - GoolGlobals.button.frameHeight, 0);
            TextRenderer.getInstance().renderText(g, helpX, helpY, Localizaton.PLAY);
        }
        TextRenderer.getInstance().setCurrentFont(this.specialFont);
        helpX = 240 - GoolGlobals.button.frameWidth + (GoolGlobals.button.frameWidth - TextRenderer.getInstance().getStringWidth(Localizaton.MENU.length())) / 2;
        helpY = 320 - GoolGlobals.button.frameHeight + (GoolGlobals.button.frameHeight - TextRenderer.getInstance().getStringHeight(1)) / 2;
        if (!this.matchOver) {
            GoolGlobals.button.paintWithAnchor(g, 240 - GoolGlobals.button.frameWidth, 320 - GoolGlobals.button.frameHeight, 0);
            TextRenderer.getInstance().renderText(g, helpX, helpY, Localizaton.MENU);
        }
        if (!this.matchPause && out || this.matchPause && !out || this.isExit) {
            g.drawImage(GoolGlobals.menuBackground, GoolGlobals.MAINMENU_BG_X + this.bgOffset, GoolGlobals.MAINMENU_BG_Y, 0);
        }
        super.render(g);
        this.menu.drawMenu(g);
    }

    public void moveAI(Player player) {
        if (player.cornerRun) {
            return;
        }
        if (doubleCollision) {
            this.doubleCollisionCounter = 5;
        }
        if (this.doubleCollisionCounter > 0) {
            --this.doubleCollisionCounter;
            Game.players[0].yMoovingSpeed -= Game.players[0].fp_acceleration;
            Game.players[1].yMoovingSpeed += Game.players[1].fp_acceleration;
            return;
        }
        int zone = ball.getZoneBetweenPlayers();
        zone = (zone + (1 - player.playerID)) / 2;
        int owner = ball.getBallOwner() % 2;
        boolean i = false;
        StaticBall sbReference = null;
        if (player.team[zone].getFirstVisible(0) == null) {
            return;
        }
        if (player.playerID == 0) {
            if (owner == 0) {
                if (player.team[zone].fp_y + GoolGlobals.PLAYER_RADIUS >= Game.ball.fp_y - (Game.ball.fp_radius >> 1) && player.team[zone].fp_y - GoolGlobals.PLAYER_RADIUS > player.team[zone].fp_upBound) {
                    if (player.team[zone].getClosestBall().behindBall() == -1 && player.team[zone].fp_y - GoolGlobals.PLAYER_RADIUS > Game.ball.fp_y + Game.ball.fp_radius) {
                        player.xMoovingSpeed += player.team[zone].whereMoreSpace() * player.fp_acceleration;
                        player.yMoovingSpeed = 0;
                    } else {
                        player.yMoovingSpeed -= player.fp_acceleration;
                    }
                } else {
                    sbReference = player.team[zone].getClosestBall();
                    if (sbReference.fp_x + GoolGlobals.PLAYER_RADIUS < Game.ball.fp_x + Game.ball.fp_radius && sbReference.fp_x > player.team[zone].fp_leftBound) {
                        player.xMoovingSpeed += player.fp_acceleration;
                        player.yMoovingSpeed = 0;
                    } else if (sbReference.fp_x - GoolGlobals.PLAYER_RADIUS > Game.ball.fp_x - Game.ball.fp_radius && sbReference.fp_x < player.team[zone].fp_rightBound) {
                        player.xMoovingSpeed -= player.fp_acceleration;
                        player.yMoovingSpeed = 0;
                    } else {
                        this.aiMovingVector.fp_x = player.xMoovingSpeed;
                        this.aiMovingVector.fp_y = player.yMoovingSpeed;
                        int length = this.aiMovingVector.getLengthApprox2();
                        this.aiMovingVector.fp_x = Game.ball.fp_x - sbReference.fp_x;
                        this.aiMovingVector.fp_y = Game.ball.fp_y - sbReference.fp_y;
                        this.aiMovingVector.normalizeApprox2();
                        this.aiMovingVector.mul(length += player.fp_acceleration);
                        player.xMoovingSpeed = this.aiMovingVector.fp_x;
                        player.yMoovingSpeed = this.aiMovingVector.fp_y;
                    }
                }
            } else {
                sbReference = player.team[zone].getClosestBall();
                if (sbReference.fp_x + GoolGlobals.PLAYER_RADIUS < Game.ball.fp_x + Game.ball.fp_radius && sbReference.fp_x > player.team[zone].fp_leftBound) {
                    player.xMoovingSpeed += player.fp_acceleration;
                    player.yMoovingSpeed = 0;
                } else if (sbReference.fp_x - GoolGlobals.PLAYER_RADIUS > Game.ball.fp_x - Game.ball.fp_radius && sbReference.fp_x < player.team[zone].fp_rightBound) {
                    player.xMoovingSpeed -= player.fp_acceleration;
                    player.yMoovingSpeed = 0;
                } else {
                    this.aiMovingVector.fp_x = player.xMoovingSpeed;
                    this.aiMovingVector.fp_y = player.yMoovingSpeed;
                    int length = this.aiMovingVector.getLengthApprox2();
                    this.aiMovingVector.fp_x = Game.ball.fp_x - sbReference.fp_x;
                    this.aiMovingVector.fp_y = Game.ball.fp_y - sbReference.fp_y;
                    this.aiMovingVector.normalizeApprox2();
                    this.aiMovingVector.mul(length += player.fp_acceleration);
                    player.xMoovingSpeed = this.aiMovingVector.fp_x;
                    player.yMoovingSpeed = this.aiMovingVector.fp_y;
                }
            }
        } else if (owner == 1) {
            if (player.team[zone].fp_y - GoolGlobals.PLAYER_RADIUS <= Game.ball.fp_y + (Game.ball.fp_radius >> 1) && player.team[zone].fp_y + GoolGlobals.PLAYER_RADIUS < player.team[zone].fp_downBound) {
                if (player.team[zone].getClosestBall().behindBall() == 1) {
                    player.xMoovingSpeed += player.team[zone].whereMoreSpace() * player.fp_acceleration;
                    player.yMoovingSpeed = 0;
                } else {
                    player.yMoovingSpeed += player.fp_acceleration;
                    player.xMoovingSpeed = 0;
                }
            } else {
                sbReference = player.team[zone].getClosestBall();
                if (sbReference.fp_x + GoolGlobals.PLAYER_RADIUS < Game.ball.fp_x + Game.ball.fp_radius && sbReference.fp_x > player.team[zone].fp_leftBound) {
                    player.xMoovingSpeed += player.fp_acceleration;
                    player.yMoovingSpeed = 0;
                } else if (sbReference.fp_x - GoolGlobals.PLAYER_RADIUS > Game.ball.fp_x - Game.ball.fp_radius && sbReference.fp_x < player.team[zone].fp_rightBound) {
                    player.xMoovingSpeed -= player.fp_acceleration;
                    player.yMoovingSpeed = 0;
                } else {
                    this.aiMovingVector.fp_x = player.xMoovingSpeed;
                    this.aiMovingVector.fp_y = player.yMoovingSpeed;
                    int length = this.aiMovingVector.getLengthApprox2();
                    this.aiMovingVector.fp_x = Game.ball.fp_x - sbReference.fp_x;
                    this.aiMovingVector.fp_y = Game.ball.fp_y - sbReference.fp_y;
                    this.aiMovingVector.normalizeApprox2();
                    this.aiMovingVector.mul(length += player.fp_acceleration);
                    player.xMoovingSpeed = this.aiMovingVector.fp_x;
                    player.yMoovingSpeed = this.aiMovingVector.fp_y;
                }
            }
        } else {
            sbReference = player.team[zone].getClosestBall();
            if (Game.ball.fp_y - Game.ball.fp_radius > sbReference.set.fp_downBound) {
                player.xMoovingSpeed = Game.ball.fp_x > sbReference.fp_x ? (player.xMoovingSpeed -= player.fp_acceleration) : (player.xMoovingSpeed += player.fp_acceleration);
            } else if (sbReference.fp_x + GoolGlobals.PLAYER_RADIUS < Game.ball.fp_x + Game.ball.fp_radius && sbReference.fp_x > player.team[zone].fp_leftBound) {
                player.xMoovingSpeed += player.fp_acceleration;
                player.yMoovingSpeed = 0;
            } else if (sbReference.fp_x - GoolGlobals.PLAYER_RADIUS > Game.ball.fp_x - Game.ball.fp_radius && sbReference.fp_x < player.team[zone].fp_rightBound) {
                player.xMoovingSpeed -= player.fp_acceleration;
                player.yMoovingSpeed = 0;
            } else {
                this.aiMovingVector.fp_x = player.xMoovingSpeed;
                this.aiMovingVector.fp_y = player.yMoovingSpeed;
                int length = this.aiMovingVector.getLengthApprox2();
                this.aiMovingVector.fp_x = Game.ball.fp_x - sbReference.fp_x;
                this.aiMovingVector.fp_y = Game.ball.fp_y - sbReference.fp_y;
                this.aiMovingVector.normalizeApprox2();
                this.aiMovingVector.mul(length += player.fp_acceleration);
                player.xMoovingSpeed = this.aiMovingVector.fp_x;
                player.yMoovingSpeed = this.aiMovingVector.fp_y;
            }
        }
        if (this.mainGameCanvas.framesCount % 20L == 0L) {
            if (this.rand.nextInt() % 7 == 0) {
                player.xMoovingSpeed += player.fp_acceleration;
            } else if (this.rand.nextInt() % 7 == 1) {
                player.xMoovingSpeed -= player.fp_acceleration;
            }
        }
    }

    private void checkCorners() {
        if (Game.ball.fp_scalarVelocity > 0) {
            if (Game.ball.fp_x > (GoolGlobals.PITCH_X + GoolGlobals.PITCH_WIDTH << FP.SHIFT) - 2 * Game.ball.fp_radius && Game.ball.fp_y < (GoolGlobals.PITCH_Y << FP.SHIFT) + 2 * Game.ball.fp_radius) {
                if (!Game.players[0].ai) {
                    return;
                }
                ++this.cornerCounter;
                if (this.cornerCounter > 10) {
                    Game.players[0].cornerRun = true;
                    Game.players[0].xMoovingSpeed -= Game.players[0].fp_acceleration;
                    Game.players[0].yMoovingSpeed += Game.players[0].fp_acceleration;
                }
            } else if (Game.ball.fp_x < (GoolGlobals.PITCH_X << FP.SHIFT) + 2 * Game.ball.fp_radius && Game.ball.fp_y < (GoolGlobals.PITCH_Y << FP.SHIFT) + 2 * Game.ball.fp_radius) {
                if (!Game.players[0].ai) {
                    return;
                }
                ++this.cornerCounter;
                if (this.cornerCounter > 10) {
                    Game.players[0].cornerRun = true;
                    Game.players[0].xMoovingSpeed += Game.players[0].fp_acceleration;
                    Game.players[0].yMoovingSpeed += Game.players[0].fp_acceleration;
                }
            } else if (Game.ball.fp_x < (GoolGlobals.PITCH_X << FP.SHIFT) + 2 * Game.ball.fp_radius && Game.ball.fp_y > (GoolGlobals.PITCH_Y + GoolGlobals.PITCH_HEIGHT << FP.SHIFT) - 2 * Game.ball.fp_radius) {
                if (!Game.players[1].ai) {
                    return;
                }
                ++this.cornerCounter;
                if (this.cornerCounter > 10) {
                    Game.players[1].cornerRun = true;
                    Game.players[1].xMoovingSpeed += Game.players[1].fp_acceleration;
                    Game.players[1].yMoovingSpeed += Game.players[1].fp_acceleration;
                }
            } else if (Game.ball.fp_x > (GoolGlobals.PITCH_X + GoolGlobals.PITCH_WIDTH << FP.SHIFT) - 2 * Game.ball.fp_radius && Game.ball.fp_y > (GoolGlobals.PITCH_Y + GoolGlobals.PITCH_HEIGHT << FP.SHIFT) - 2 * Game.ball.fp_radius) {
                if (!Game.players[1].ai) {
                    return;
                }
                ++this.cornerCounter;
                if (this.cornerCounter > 10) {
                    Game.players[1].cornerRun = true;
                    Game.players[1].xMoovingSpeed -= Game.players[1].fp_acceleration;
                    Game.players[1].yMoovingSpeed += Game.players[1].fp_acceleration;
                }
            } else {
                this.cornerCounter = 0;
                Game.players[0].cornerRun = false;
                Game.players[1].cornerRun = false;
            }
        } else {
            this.cornerCounter = 0;
            Game.players[0].cornerRun = false;
            Game.players[1].cornerRun = false;
        }
    }

    private void playersSetup(int id0, int id1) throws IOException {
        Game.players[0] = new Player(0, id0, this.mainGameCanvas);
        Game.players[1] = new Player(1, id1, this.mainGameCanvas);
        Game.players[1].fp_acceleration = GoolGlobals.MAX_AI_ACC;
        Game.players[0].fp_acceleration = GoolGlobals.MAX_HUMAN_ACC;
        Game.players[1].ai = true;
        this.team0thb = Image.createImage((String)("/" + id0 + "tmb.png"));
        this.team1thb = Image.createImage((String)("/" + id1 + "tmb.png"));
        Game.players[0].score = 0;
        Game.players[1].score = 0;
        this.scoreXSpace = this.thumbXSpace + this.team1thb.getWidth();
    }

    private void generateRandomEvent() {
        if (this.mainGameCanvas.framesCount % 1000L == 0L && Math.abs(this.rand.nextInt() % 2) == 0) {
            this.animationID = 0;
            this.redCard = true;
            this.animationFrameTime = this.animationStart = System.currentTimeMillis();
            this.animations[this.animationID].setFrame(0);
            if (this.animationID == 1) {
                StaticBall tb = Game.players[Math.abs((int)(this.rand.nextInt() % 2))].team[Math.abs(this.rand.nextInt() % 2) + 1].kickPlayer(Math.abs(this.rand.nextInt() % 3));
                this.animationX = tb.fp_x >> FP.SHIFT;
                this.animationY = tb.fp_y + tb.fp_radius >> FP.SHIFT;
                this.animationSpeed = 100;
                this.animationTime = 800;
            } else if (this.animationID == 0) {
                this.animationSpeed = 120;
                this.animationTime = 2000;
            }
            this.playAnimation();
        }
    }

    private void playAnimation() {
        this.animationCurrentTime = System.currentTimeMillis();
        if (this.animationCurrentTime - this.animationStart < (long)this.animationTime) {
            if (this.animationID != 1) {
                if (this.animationCurrentTime - this.animationFrameTime >= (long)this.animationSpeed) {
                    if (this.animations[this.animationID].frameID != 3) {
                        this.animations[this.animationID].nextFrame();
                    } else {
                        this.animations[this.animationID].setFrame(2);
                    }
                    this.animationFrameTime = this.animationCurrentTime;
                }
            } else if (this.animations[this.animationID].isAnimationFinished()) {
                this.animations[this.animationID].setFrame(2);
            } else {
                this.animations[this.animationID].nextFrame();
            }
        } else {
            this.redCard = false;
            if (this.animationID != 1 && this.animationID != 2) {
                Game.players[Math.abs((int)(this.rand.nextInt() % 2))].team[Math.abs(this.rand.nextInt() % 2) + 1].kickPlayer(Math.abs(this.rand.nextInt() % 3));
            }
            this.animationSpeed = 1000;
            this.animationTime = 4000;
            this.ballStoppedTime = 0L;
            this.ballInZoneTime = 0L;
        }
    }

    public void checkBallKeeping() {
        if (Game.ball.fp_scalarVelocity == 0) {
            if (this.ballStoppedTime == 0L) {
                this.ballStoppedTime = System.currentTimeMillis();
            } else if (System.currentTimeMillis() - this.ballStoppedTime > this.maxBallStoppedTime) {
                this.ballStoppedTime = 0L;
                this.ballKeepingEvent();
            }
        } else {
            this.ballStoppedTime = 0L;
        }
        int owner = ball.getBallOwner();
        if (owner == this.lastBallOwner) {
            if (this.ballInZoneTime == 0L) {
                this.ballInZoneTime = System.currentTimeMillis();
            } else if (System.currentTimeMillis() - this.ballInZoneTime > this.maxBallInZoneTime) {
                this.ballInZoneTime = 0L;
                this.ballKeepingEvent();
            }
        } else {
            this.ballInZoneTime = 0L;
        }
        this.lastBallOwner = owner;
    }

    private void ballKeepingEvent() {
        int keeper = ball.getBallOwner();
        Game.ball.fp_x = (GoolGlobals.PITCH_WIDTH >> 1) + GoolGlobals.PITCH_X << FP.SHIFT;
        Game.ball.fp_y = keeper == 0 ? Game.players[1].team[1].fp_upBound + Game.ball.fp_radius : Game.players[0].team[1].fp_downBound - Game.ball.fp_radius;
        players[0].resetPosition();
        players[1].resetPosition();
        Game.players[keeper].team[Math.abs(this.rand.nextInt() % 2) + 1].kickPlayer(Math.abs(this.rand.nextInt() % 3));
        this.animationID = 2;
        this.redCard = true;
        this.animationFrameTime = this.animationStart = System.currentTimeMillis();
        this.animations[this.animationID].setFrame(0);
        this.animationSpeed = 120;
        this.animationTime = 2000;
        this.playAnimation();
    }

    private void bigCorrect() {
        for (int i = 0; i < players.length; ++i) {
            players[i].forceCorrection();
        }
    }

    private void createQuickMenu() {
        int fontSize = TextRenderer.getInstance().getStringHeight(1);
        int[] cols = new int[]{GoolGlobals.MAINMENU_MARGIN, GoolGlobals.menuBackground.getWidth() - GoolGlobals.MAINMENU_MARGIN, -1};
        int[] rows = new int[]{GoolGlobals.MAINMENU_BG_Y + 35, fontSize + 2, fontSize + 2, fontSize + 2, fontSize + 2, -1};
        this.menu = MenuForm.createMenuForm(5, rows, cols, 240, 320, (byte)1, (byte)0);
        this.menu.listener = this;
        this.continue2ID = this.menu.createControl(4, 0, 1, 1, null, Localizaton.MENU_CONTINUE);
        this.music2ID = GoolGlobals.playMusic ? this.menu.createControl(4, 1, 2, 1, null, new StringBuffer().append((Object)Localizaton.OPTIONS_MUSIC).append(" ").append((Object)Localizaton.ON)) : this.menu.createControl(4, 1, 2, 1, null, new StringBuffer().append((Object)Localizaton.OPTIONS_MUSIC).append(" ").append((Object)Localizaton.OFF));
        this.exit2ID = this.menu.createControl(4, 2, 3, 1, null, Localizaton.EXIT);
        int tempID = this.menu.createControl(2, GoolGlobals.button.frameWidth, GoolGlobals.button.frameHeight, -1, 5, 0, 33, 18, null, Localizaton.EMPTY, 0, 0);
        this.menu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
        tempID = this.menu.createControl(2, GoolGlobals.button.frameWidth, GoolGlobals.button.frameHeight, -1, 5, 2, 36, 18, null, Localizaton.EMPTY, 0, 0);
        this.menu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
        qMenu = this.menu;
    }

    private void createEmptyMenu() {
        int fontSize = TextRenderer.getInstance().getStringHeight(1);
        int[] cols = new int[]{GoolGlobals.MAINMENU_MARGIN, GoolGlobals.menuBackground.getWidth() - GoolGlobals.MAINMENU_MARGIN, -1};
        int[] rows = new int[]{GoolGlobals.MAINMENU_BG_Y, GoolGlobals.menuBackground.getHeight() / 2 - 2 * fontSize, 2 * fontSize, 2 * fontSize, GoolGlobals.menuBackground.getHeight() / 2 - 2 * fontSize, -1};
        this.menu = MenuForm.createMenuForm(4, rows, cols, 240, 320, (byte)1, (byte)0);
        this.menu.listener = this;
        this.continueID = this.menu.createControl(4, 0, 2, 1, null, Localizaton.EMPTY);
        this.exitID = this.menu.createControl(4, 1, 3, 1, null, Localizaton.EMPTY);
        int tempID = this.menu.createControl(2, GoolGlobals.button.frameWidth, GoolGlobals.button.frameHeight, -1, 5, 0, 33, 18, null, Localizaton.EMPTY, 0, 0);
        this.menu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
        tempID = this.menu.createControl(2, GoolGlobals.button.frameWidth, GoolGlobals.button.frameHeight, -1, 5, 2, 36, 18, null, Localizaton.EMPTY, 0, 0);
        this.menu.setRendererFonts(tempID, "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED", "FONT_HIGHLIGHTED");
        emptyMenu = this.menu;
    }

    public void notifyKeypressed(int formID, int controlID) {
    }

    public void changeMusic() {
        boolean bl = GoolGlobals.playMusic = !GoolGlobals.playMusic;
        if (GoolGlobals.playMusic) {
            this.menu.getControlByID((int)this.music2ID).text = new StringBuffer().append((Object)Localizaton.OPTIONS_MUSIC).append(" ").append((Object)Localizaton.ON);
            Music.playMusic(GoolGlobals.gameMusicId);
        } else {
            this.menu.getControlByID((int)this.music2ID).text = new StringBuffer().append((Object)Localizaton.OPTIONS_MUSIC).append(" ").append((Object)Localizaton.OFF);
            Music.stopMusic();
        }
    }

    public void handleInput() {
        this.menu.handleInput(this.mainGameCanvas.getKeyStates());
    }

    public void enter(int deltaTime) {
        if (this.moveStart == 0L) {
            this.moveStart = this.currentTime2;
        } else if (this.currentTime2 - this.moveStart > this.moveSpeed) {
            if (this.menuOffset > 0) {
                this.menuOffset -= GoolGlobals.MENU_OFFSET;
                this.changeMenuOffset(-GoolGlobals.MENU_OFFSET, this.menu);
                this.changeBgOffset(-GoolGlobals.MENU_OFFSET);
            } else {
                this.enter = false;
                this.moveStart = 0L;
            }
        }
    }

    public void out(int deltaTime) {
        if (this.moveStart == 0L) {
            this.moveStart = this.currentTime2;
        } else if (this.currentTime2 - this.moveStart > this.moveSpeed) {
            if (this.menuOffset < 240) {
                this.menuOffset += GoolGlobals.MENU_OFFSET;
                this.changeMenuOffset(GoolGlobals.MENU_OFFSET, this.menu);
                this.changeBgOffset(GoolGlobals.MENU_OFFSET);
            } else {
                out = false;
                this.moveStart = 0L;
                if (this.nextState != null) {
                    this.mainGameCanvas.requestAppStateChange(this.nextState);
                } else if (nextMenu != null) {
                    this.menu = nextMenu;
                    this.enter = true;
                }
                if (this.isExit) {
                    this.isExit = false;
                    this.masterBlock = false;
                    this.matchPause = false;
                    this.saveGame();
                    GoolGlobals.continueTheGame = true;
                    this.loadSettings();
                    RMSSettings.continueGame = 1;
                    RMSUtils.updateRecord("sett", settingsRecord);
                    this.mainGameCanvas.requestAppStateChange("Menu");
                    if (GoolGlobals.playMusic) {
                        Music.stopMusic();
                        Music.playMusic(GoolGlobals.menuMusicId);
                    }
                }
            }
        }
    }

    public void deinitialize() {
        this.numbers = null;
        this.pointsBGL = null;
        this.pointsBGR = null;
        this.timeBG = null;
        ball.deinitialize();
        ball = null;
        this.goool = null;
        this.goalImageUp = null;
        Game.players[0] = null;
        Game.players[1] = null;
        this.team0thb = null;
        this.team1thb = null;
        this.pitchImage = null;
        this.nextState = null;
        nextMenu = null;
        this.animations[0] = null;
        this.animations[1] = null;
        this.animations[2] = null;
        System.gc();
    }

    public void changeMenuOffset(int offset, MenuForm menu) {
        for (int i = 0; i < menu.controls.length - 2; ++i) {
            menu.controls[i].textPozX -= offset;
            menu.controls[i].pozX -= offset;
        }
        menu.absoluteX -= offset;
        menu.controls[menu.controls.length - 2].textPozY += offset;
        menu.controls[menu.controls.length - 1].textPozY += offset;
        menu.controls[menu.controls.length - 2].pozY += offset;
        menu.controls[menu.controls.length - 1].pozY += offset;
    }

    public void changeBgOffset(int offset) {
        this.bgOffset -= offset;
    }

    public void pauseStateChanged(boolean paused) {
        super.pauseStateChanged(paused);
        if (paused) {
            this.pauseTime = System.currentTimeMillis();
        } else {
            this.startTime += System.currentTimeMillis() - this.pauseTime;
            this.ballStoppedTime = 0L;
            this.ballInZoneTime = 0L;
        }
        if (GoolGlobals.playMusic) {
            if (paused) {
                Music.stopMusic();
            } else {
                Music.playMusic(GoolGlobals.menuMusicId);
            }
        }
    }

    static {
        players = new Player[2];
        doubleCollision = false;
        out = false;
    }
}

