/*
 * Decompiled with CFR 0.152.
 */
package root;

import framework.math.FP;
import framework.math.Vector2D;
import javax.microedition.lcdui.Graphics;
import root.Game;
import root.GoolGlobals;
import root.Player;
import root.StaticBall;

public class StaticSet {
    public int fp_x;
    public int fp_lastX;
    public int fp_y;
    public int fp_lastY;
    public int fp_upBound;
    public int fp_leftBound;
    public int fp_rightBound;
    public int fp_downBound;
    public int ballDistance = GoolGlobals.SET_SPACING;
    public int KICK_TIME = 10000;
    public Player playerRef;
    public boolean active = false;
    public StaticBall[] balls = new StaticBall[GoolGlobals.SET_BALL_COUNT];
    private Vector2D distance = new Vector2D(0, 0);

    public StaticSet(Player player) {
        for (int i = 0; i < this.balls.length; ++i) {
            this.balls[i] = new StaticBall(player, this);
            this.balls[i].fp_x = this.fp_x + i * this.ballDistance;
            this.balls[i].fp_y = this.fp_y;
        }
        this.playerRef = player;
    }

    public void draw(Graphics g) {
        for (int i = 0; i < this.balls.length; ++i) {
            if (!this.balls[i].visible) continue;
            this.balls[i].draw(g);
        }
        this.active = false;
    }

    public void push(int x, int y) {
        int i = 0;
        this.fp_lastX += x;
        this.fp_lastY += y;
        this.fp_x += x;
        this.fp_y += y;
        for (i = 0; i < this.balls.length; ++i) {
            this.balls[i].fp_x = this.fp_x + (i * this.ballDistance << FP.SHIFT);
            this.balls[i].fp_y = this.fp_y;
            if (!this.balls[i].visible) continue;
            if (this.balls[i].wallCollide()) {
                this.fp_x += this.balls[i].afterCollision[0];
                this.fp_y += this.balls[i].afterCollision[1];
                this.fp_lastX += this.balls[i].afterCollision[0];
                this.fp_lastY += this.balls[i].afterCollision[1];
                if (this.balls[i].afterCollision[0] != 0) {
                    this.playerRef.xMoovingSpeed = 0;
                }
                if (this.balls[i].afterCollision[1] != 0) {
                    this.playerRef.yMoovingSpeed = 0;
                }
            }
            for (x = i; x >= 0; --x) {
                this.balls[x].fp_x = this.fp_x + (x * this.ballDistance << FP.SHIFT);
                this.balls[x].fp_y = this.fp_y;
            }
        }
    }

    public void move(int x, int y) {
        int i = 0;
        this.fp_lastX = this.fp_x;
        this.fp_lastY = this.fp_y;
        this.fp_x += x;
        this.fp_y += y;
        for (i = 0; i < this.balls.length; ++i) {
            if (!this.balls[i].visible && System.currentTimeMillis() - this.balls[i].outTime > (long)this.KICK_TIME) {
                this.balls[i].visible = true;
            }
            this.balls[i].fp_x = this.fp_x + (i * this.ballDistance << FP.SHIFT);
            this.balls[i].fp_y = this.fp_y;
            if (!this.balls[i].visible) continue;
            this.balls[i].update();
            if (this.balls[i].wallCollide()) {
                this.fp_x += this.balls[i].afterCollision[0];
                this.fp_y += this.balls[i].afterCollision[1];
                if (this.balls[i].afterCollision[0] != 0) {
                    this.playerRef.xMoovingSpeed = 0;
                }
                if (this.balls[i].afterCollision[1] != 0) {
                    this.playerRef.yMoovingSpeed = 0;
                }
            }
            for (x = i; x >= 0; --x) {
                this.balls[x].fp_x = this.fp_x + (x * this.ballDistance << FP.SHIFT);
                this.balls[x].fp_y = this.fp_y;
            }
        }
    }

    public boolean fallBack(int dist) {
        this.distance.fp_x = this.fp_x - this.fp_lastX;
        this.distance.fp_y = this.fp_y - this.fp_lastY;
        if (this.distance.fp_x == 0 && this.distance.fp_y == 0) {
            Game.ball.fallBack(dist);
            return true;
        }
        this.distance.normalizeApprox2();
        this.distance.mul(-dist);
        this.fp_x += this.distance.fp_x;
        this.fp_y += this.distance.fp_y;
        for (int i = 0; i < this.balls.length; ++i) {
            this.balls[i].fp_x = this.fp_x + (i * this.ballDistance << FP.SHIFT) + this.distance.fp_x;
            this.balls[i].fp_y = this.fp_y + this.distance.fp_y;
        }
        return false;
    }

    public boolean forcedFallBack(int dist) {
        this.distance.fp_x = this.fp_x - this.fp_lastX;
        this.distance.fp_y = this.fp_y - this.fp_lastY;
        if (this.distance.fp_x == 0 && this.distance.fp_y == 0) {
            this.distance.fp_x = -(this.fp_x - Game.ball.fp_x);
            this.distance.fp_y = -(this.fp_y - Game.ball.fp_y);
        }
        this.distance.normalizeApprox2();
        this.distance.mul(-dist);
        this.fp_x += this.distance.fp_x;
        this.fp_y += this.distance.fp_y;
        for (int i = 0; i < this.balls.length; ++i) {
            this.balls[i].fp_x = this.fp_x + (i * this.ballDistance << FP.SHIFT) + this.distance.fp_x;
            this.balls[i].fp_y = this.fp_y + this.distance.fp_y;
        }
        return false;
    }

    public StaticBall getFirstVisible(int direction) {
        if (direction == 0) {
            for (direction = 0; direction < this.balls.length; ++direction) {
                if (!this.balls[direction].visible) continue;
                return this.balls[direction];
            }
        } else {
            for (direction = (int)((byte)(this.balls.length - 1)); direction >= 0; --direction) {
                if (!this.balls[direction].visible) continue;
                return this.balls[direction];
            }
        }
        return null;
    }

    public StaticBall getClosestBall() {
        int minDist = -1;
        int current = 0;
        for (int i = 0; i < this.balls.length; ++i) {
            int temp;
            if (!this.balls[i].visible || (temp = Math.abs(this.balls[i].fp_x - Game.ball.fp_x)) >= minDist && minDist >= 0) continue;
            minDist = temp;
            current = i;
        }
        if (this.balls[current].fp_x - Game.ball.fp_x >= 0 && current > 0 && minDist > this.balls[0].fp_x - this.fp_leftBound) {
            --current;
        } else if (this.balls[current].fp_x - Game.ball.fp_x < 0 && current < 2 && minDist > this.fp_rightBound - this.balls[2].fp_x) {
            ++current;
        }
        return this.balls[current];
    }

    public byte whereMoreSpace() {
        if (this.getFirstVisible((int)0).fp_x - this.fp_leftBound < this.fp_rightBound - this.getFirstVisible((int)1).fp_x) {
            return 1;
        }
        return -1;
    }

    public int getBallInRangeDist() {
        for (int i = 0; i < this.balls.length; ++i) {
            int val = this.balls[i].ballInRange();
            if (val == 0) continue;
            return val;
        }
        return 0;
    }

    public int checkBallCollision() {
        for (int i = 0; i < this.balls.length; ++i) {
            int tmp;
            if (!this.balls[i].visible || (tmp = this.balls[i].ballCollides()) == 0) continue;
            Game.ball.collidingBallInSet[this.playerRef.playerID] = i;
            return tmp;
        }
        return 0;
    }

    public StaticBall kickPlayer(int i) {
        this.balls[i].kickMe();
        return this.balls[i];
    }
}

