/*
 * Decompiled with CFR 0.152.
 */
package tdf;

import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class TDFImageFont {
    private static int counterFont = 0;
    public static final byte RETURN_CHAR = 92;
    private Image police;
    private String imageFontName = "";
    private Character[] CharacterSet;
    private byte charID;
    private byte charPosX;
    private byte charPosY;
    private byte charWidth;
    private byte charHeight;
    private byte charXoffset;
    private byte charYoffset;
    private byte charXadvance;
    private byte charCount;
    public byte charsHeight;
    public int charsWidthSpace;
    public int charsSpaceChar;
    private DataInputStream binReader;

    public TDFImageFont(String binaryFontName) {
        this(binaryFontName, "/images/big/");
    }

    public TDFImageFont(String binaryFontName, String path) {
        this.readBinaryFontFile(binaryFontName, path);
        try {
            this.police = Image.createImage((String)(path + this.imageFontName + ".png"));
        }
        catch (Exception e) {
            System.out.println("-*- Police Non Referencee -*- : " + e);
        }
        ++counterFont;
    }

    public final void DrawChar(Graphics g, char l_char, int x, int y) {
        if ((l_char & 0xFF) == 92 || (l_char & 0xFF) <= 32) {
            return;
        }
        g.setClip(x, y, this.CharacterSet[l_char & 0xFF].width & 0xFF, this.CharacterSet[l_char & 0xFF].height & 0xFF);
        g.drawImage(this.police, x - (this.CharacterSet[l_char & 0xFF].x & 0xFF), y - (this.CharacterSet[l_char & 0xFF].y & 0xFF), 0);
    }

    public final int FontcharWidth(char l_char) {
        if ((l_char & 0xFF) < 32) {
            return 0;
        }
        return this.CharacterSet[l_char & 0xFF].width & 0xFF;
    }

    public final void FontDrawString(Graphics g, int p_x, int p_y, String p_string) {
        this.FontDrawStringLeft(g, p_x -= this.StringWidth(p_string) >> 1, p_y, p_string);
    }

    public final void FontDrawStringLeft(Graphics g, int p_x, int p_y, String p_string) {
        for (int i = 0; i < p_string.length(); ++i) {
            this.DrawChar(g, p_string.charAt(i), p_x, p_y);
            p_x += this.CharacterSet[p_string.charAt((int)i)].xadvance & 0xFF;
        }
    }

    public final void FontDrawStringRight(Graphics g, int p_x, int p_y, String p_string) {
        this.FontDrawStringLeft(g, p_x -= this.StringWidth(p_string), p_y, p_string);
    }

    public final void FontDrawString(Graphics g, int p_x, int p_y, String p_string, int p_deb, int p_fin) {
        for (int i = p_deb; i < p_fin; ++i) {
            if (p_string.charAt(i) < ' ') continue;
            this.DrawChar(g, p_string.charAt(i), p_x, p_y);
            p_x += this.CharacterSet[p_string.charAt((int)i)].xadvance & 0xFF;
        }
    }

    public final int StringWidth(String p_string) {
        int res = 0;
        for (int i = 0; i < p_string.length(); ++i) {
            if (p_string.charAt(i) < ' ') continue;
            res += this.CharacterSet[p_string.charAt((int)i)].xadvance & 0xFF;
        }
        return res;
    }

    public final int GetNbLine(int p_width, String p_Msg) {
        int count = 0;
        int x = 0;
        int lastspace = 0;
        int last = 0;
        if (p_Msg == null || p_Msg.length() == 0) {
            return 0;
        }
        for (int i = 0; i < p_Msg.length(); ++i) {
            char l_char = p_Msg.charAt(i);
            int l_charw = this.FontcharWidth(l_char);
            if (l_char == ' ' || l_char == '\\') {
                lastspace = i;
            }
            if (x + l_charw >= p_width && last != lastspace + 1 && lastspace != 0 || l_char == '\\') {
                ++count;
                x = 0;
                for (int j = last = lastspace + 1; j <= i; ++j) {
                    x += this.FontcharWidth(p_Msg.charAt(j)) + this.charsSpaceChar;
                }
                continue;
            }
            x += l_charw + this.charsSpaceChar;
        }
        return count + 1;
    }

    public final void DrawLines(Graphics g, int p_x, int p_y, int p_width, int p_firstline, int p_lastline, String p_Msg, boolean center) {
        if (p_Msg == null || p_Msg.length() == 0) {
            return;
        }
        int x = 0;
        int y = p_y;
        int last = 0;
        int lastspace = 0;
        int currentLine = 1;
        for (int i = 0; i < p_Msg.length(); ++i) {
            char l_char = p_Msg.charAt(i);
            int l_charw = this.FontcharWidth(l_char);
            if (l_char == ' ' || l_char == '\\') {
                lastspace = i;
            }
            if (x + l_charw >= p_width && last != lastspace + 1 && lastspace != 0 || l_char == '\\') {
                if (currentLine >= p_firstline && currentLine <= p_lastline) {
                    if (center) {
                        this.FontDrawString(g, p_x, y, p_Msg.substring(last, lastspace));
                    } else {
                        this.FontDrawString(g, p_x, y, p_Msg, last, lastspace);
                    }
                    y += this.charsHeight;
                }
                ++currentLine;
                x = 0;
                for (int j = last = lastspace + 1; j <= i; ++j) {
                    x += this.FontcharWidth(p_Msg.charAt(j)) + this.charsSpaceChar;
                }
                continue;
            }
            x += l_charw + this.charsSpaceChar;
        }
        if (currentLine >= p_firstline && currentLine <= p_lastline) {
            if (center) {
                this.FontDrawString(g, p_x, y, p_Msg.substring(last, p_Msg.length()));
            } else {
                this.FontDrawString(g, p_x, y, p_Msg, last, p_Msg.length());
            }
        }
    }

    private final void readBinaryFontFile(String binaryFontName, String path) {
        try {
            int i;
            this.binReader = new DataInputStream(this.getClass().getResourceAsStream(path + binaryFontName + ".fnt"));
            System.out.println("binReader : " + this.binReader + " path: " + path + binaryFontName + ".fnt");
            this.binReader.readByte();
            this.imageFontName = this.binReader.readUTF();
            this.charCount = this.binReader.readByte();
            this.charsHeight = this.binReader.readByte();
            this.CharacterSet = new Character[256];
            for (i = 0; i < this.CharacterSet.length; ++i) {
                this.CharacterSet[i] = new Character(0, 0, 0, 0, 0, 0, 0, 0);
            }
            for (i = 0; i < (this.charCount & 0xFF); ++i) {
                this.charID = this.binReader.readByte();
                this.charPosX = this.binReader.readByte();
                this.charPosY = this.binReader.readByte();
                this.charWidth = this.binReader.readByte();
                this.charHeight = this.binReader.readByte();
                this.charXoffset = this.binReader.readByte();
                this.charYoffset = this.binReader.readByte();
                this.charXadvance = this.binReader.readByte();
                this.CharacterSet[this.charID & 0xFF] = new Character(this.charID, this.charPosX, this.charPosY, this.charWidth, this.charHeight, this.charXoffset, this.charYoffset, this.charXadvance);
            }
            this.CharacterSet[92] = new Character(92, 0, 0, 0, 0, 0, 0, 0);
            this.charsSpaceChar = (this.CharacterSet[69].xadvance & 0xFF) - (this.CharacterSet[69].width & 0xFF);
            this.charsWidthSpace = this.CharacterSet[32].width & 0xFF;
            this.binReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final class Character {
        byte id;
        byte x;
        byte y;
        byte width;
        byte height;
        byte xoffset;
        byte yoffset;
        byte xadvance;

        public Character(byte idChar, byte xChar, byte yChar, byte widthChar, byte heightChar, byte xoffsetChar, byte yoffsetChar, byte xadvanceChar) {
            this.id = idChar;
            this.x = xChar;
            this.y = yChar;
            this.width = widthChar;
            this.height = heightChar;
            this.xoffset = xoffsetChar;
            this.yoffset = yoffsetChar;
            this.xadvance = xadvanceChar;
            this.displayInfos();
        }

        public final void displayInfos() {
        }
    }
}

