/*
 * Decompiled with CFR 0.152.
 */
public class cmTeam {
    cmGame aGame;
    short tID;
    short[] tPlayers;
    short[] tPlayersMemIDs;
    short[] tPlayersPosMem;
    int tBank = 0;
    byte tRank = 0;
    byte tFormation;
    byte tStyle;
    byte gamesmanship = (byte)2;
    byte aggression = (byte)2;
    byte tTrainingFacilities = (byte)3;
    byte manID = 0;
    short tSponVal = 0;
    short[] tPickedPlayers;
    short[][] tQueue;
    byte tNewsRead;
    byte tNewsRead2;
    byte tCount = 0;
    byte[] tForm;
    int[] tFinances;
    byte[] premData;
    int tAttend = 0;
    byte tBased;
    byte[] tTypes = new byte[2];

    cmTeam() {
    }

    cmTeam(cmGame cmGame2, int n) {
        this.aGame = cmGame2;
        this.tID = (short)n;
        this.tPickedPlayers = new short[this.aGame.aMatch.squadSize];
        this.tTypes[0] = (byte)Math.abs(this.aGame.randt.nextInt() % 8);
        this.tTypes[1] = (byte)Math.abs(this.aGame.randt.nextInt() % 10);
        this.tFormation = (byte)Math.abs(this.aGame.randt.nextInt() % 24);
        if (n < this.aGame.numLeagueTeams) {
            int n2;
            this.premData = new byte[13];
            this.premData[11] = -100;
            this.tPlayers = new short[this.aGame.numPlayersTeam];
            this.tPlayersMemIDs = new short[this.aGame.numPlayersTeam];
            this.tPlayersPosMem = new short[this.aGame.numPlayersTeam];
            this.tFinances = new int[8];
            for (n2 = 0; n2 < this.aGame.numPlayersTeam; ++n2) {
                this.tPlayers[n2] = 0;
                this.tPlayersPosMem[n2] = 0;
                if (n2 >= this.aGame.aMatch.squadSize) continue;
                this.tPickedPlayers[n2] = -1;
            }
            this.tForm = new byte[5];
            for (n2 = 0; n2 < 5; ++n2) {
                this.tForm[n2] = -1;
            }
        } else {
            this.tFinances = new int[1];
            this.tPlayers = new short[this.aGame.numPlayersFLTeam];
            this.tPlayersMemIDs = new short[this.aGame.numPlayersTeam];
            this.tPlayersPosMem = new short[this.aGame.numPlayersFLTeam];
            for (int i = 0; i < this.aGame.numPlayersFLTeam; ++i) {
                this.tPlayers[i] = 0;
                this.tPlayersPosMem[i] = 0;
            }
        }
    }

    public String getStringForm() {
        String string = "";
        for (int i = 4; i >= 0; --i) {
            string = this.tForm[i] == 3 ? string + this.aGame.loadInterfaceData(0, 3, 5) : (this.tForm[i] == 1 ? string + this.aGame.loadInterfaceData(0, 3, 6) : (this.tForm[i] == 0 ? string + this.aGame.loadInterfaceData(0, 3, 7) : string + "-"));
        }
        return string;
    }

    public int getIntForm() {
        int n;
        int n2 = 0;
        for (n = 0; n < 5; ++n) {
            n2 += this.tForm[n];
        }
        n = this.getGP(this.aGame.tournament, 0);
        if (n != 0) {
            return n2 / n;
        }
        return 0;
    }

    public int getFairPlay() {
        return (this.getYellow() + 100) * 1 + this.getRed() * 3;
    }

    public int getAvAttend() {
        if (this.getHomeGP(this.aGame.tournament, 0) == 0) {
            return 0;
        }
        return this.tAttend / this.getHomeGP(this.aGame.tournament, 0);
    }

    public byte getPremData(int n) {
        if (n >= this.premData.length || n > 13) {
            return 0;
        }
        return this.premData[n];
    }

    public void setPremData(int n, int n2) {
        if (n < this.premData.length && n <= 13) {
            this.premData[n] = (byte)n2;
        }
    }

    public int getFinance(int n) {
        if (n < 0 || n > 7) {
            return -1;
        }
        return this.tFinances[n];
    }

    public void addFinances(int n, int n2) {
        if (n < 0 || n > 7) {
            return;
        }
        int n3 = n;
        this.tFinances[n3] = this.tFinances[n3] + n2;
    }

    public void cleanTPicked() {
        for (int i = 0; i < this.tPickedPlayers.length; ++i) {
            if (this.tPickedPlayers[i] > -1) continue;
            this.tPickedPlayers[i] = -1;
        }
    }

    public int getWageBill(int n) {
        int n2 = 0;
        for (int i = 0; i < this.tCount; ++i) {
            if (this.getID(i) == 0) continue;
            n2 += this.aGame.loadPlayerDataExtra(this.getID(i), 32, n, -1);
        }
        return n2;
    }

    public int getGate() {
        return Integer.parseInt(this.aGame.loadTeamData(this.tID - 20, 7)) * (12 + (5 - this.getRank())) + (this.getForm() - 5) / 10;
    }

    public void initwBudget() {
        int n = this.getCR();
        int n2 = 10 - (n - 4);
        this.setwBudget(this.getWageBill(this.tID) + this.getWageBill(this.tID) / n2);
    }

    public void setwBudget(int n) {
        this.tFinances[7] = n;
    }

    public int getwBudget() {
        return this.tFinances[7];
    }

    public void setTFBudget() {
        if (this.tBank < 100000) {
            this.tFinances[0] = this.getCR() < -1 ? 0 : (this.getCR() < 2 ? 300000 : 500000);
        } else {
            int n = 0;
            n = this.tBank * 2 / 3;
            n /= 100000;
            this.tFinances[0] = n *= 100000;
        }
    }

    public int getTotalExp() {
        return this.tFinances[4] + this.tFinances[5] + this.tFinances[6];
    }

    public int getTotalInc() {
        return this.tFinances[1] + this.tFinances[2] + this.tFinances[3];
    }

    public boolean isPrem() {
        for (int i = 0; i < this.aGame.numLeagueTeams; ++i) {
            if (this.aGame.tournament.validTeams[i] != this.tID) continue;
            return true;
        }
        return false;
    }

    public void addPlayer(short s, int n, int n2, int n3) {
        int n4 = this.aGame.convertTID(this.tID);
        if (n4 < this.aGame.numLeagueTeams && n >= this.aGame.numPlayersTeam) {
            return;
        }
        if (n4 >= this.aGame.numLeagueTeams && n >= this.aGame.numPlayersFLTeam) {
            return;
        }
        this.setID(n, s);
        if (n3 != -1) {
            this.tPlayersMemIDs[n] = (short)n3;
        }
        if ((this.aGame.convertTID(this.tID) >= this.aGame.numLeagueTeams || this.tID <= this.aGame.numLeagueTeams || n3 == -1) && s > 460 && this.aGame.convertTID(this.tID) < this.aGame.numLeagueTeams) {
            this.aGame.Players[this.aGame.pEle].setLevels(this.tID);
            this.aGame.Players[this.aGame.pEle].pID = s;
            this.aGame.Players[this.aGame.pEle].pAbility = (byte)Integer.parseInt(this.aGame.loadPlayerData(s, 5));
            this.tPlayersMemIDs[n] = this.aGame.pEle;
            this.aGame.pEle = (short)(this.aGame.pEle + 1);
        }
        if (n2 != -1) {
            this.setPosMem(n, n2);
        }
        this.tCount = (byte)(this.tCount + 1);
    }

    public void resetTeam() {
        int n;
        for (n = 0; n < this.tCount; ++n) {
            this.aGame.resetPlayer(this.getID(n));
        }
        for (n = 0; n < 5; ++n) {
            this.tForm[n] = -1;
            this.tFinances[n] = 0;
        }
        this.tFinances[5] = 0;
        this.premData[1] = 0;
        this.premData[10] = 0;
        this.premData[11] = -100;
    }

    public void clearStatStore() {
    }

    public void removePlayer(short s) {
        int n = 0;
        for (int i = 0; i < this.tPlayers.length - 1; ++i) {
            if (this.getID(i) != s) continue;
            for (n = i; n < this.tPlayers.length - 1; ++n) {
                this.tPlayers[n] = this.tPlayers[n + 1];
                this.tPlayersMemIDs[n] = this.tPlayersMemIDs[n + 1];
                this.tPlayersPosMem[n] = this.tPlayersPosMem[n + 1];
            }
            this.tPlayers[this.tPlayers.length - 1] = 0;
            this.tPlayersMemIDs[this.tPlayersMemIDs.length - 1] = 0;
            this.tPlayersPosMem[this.tPlayers.length - 1] = 0;
            this.tCount = (byte)(this.tCount - 1);
            return;
        }
    }

    public int getRandomPlayer() {
        if (this.tCount == 0) {
            return -1;
        }
        boolean bl = true;
        int n = 0;
        int n2 = 0;
        do {
            if (this.getID(n2 = Math.abs(this.aGame.randt.nextInt() % this.tCount)) != 0) {
                bl = false;
            }
            if (++n <= 30) continue;
            return -1;
        } while (bl);
        return this.getID(n2);
    }

    public int getBestTFPosTarget() {
        int n;
        int[] nArray = new int[]{2, 7, 7, 4};
        for (n = 0; n < 4; ++n) {
            int n2 = n;
            nArray[n2] = nArray[n2] - this.countPlayersPos(n);
        }
        n = 3;
        int n3 = 999;
        for (int i = 3; i >= 0; --i) {
            if (nArray[i] >= n3) continue;
            n3 = nArray[i];
            n = i;
        }
        if (n3 < 0) {
            return Math.abs(this.aGame.randt.nextInt() % 16);
        }
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return Math.abs(this.aGame.randt.nextInt() % 6) + 1;
        }
        if (n == 2) {
            return Math.abs(this.aGame.randt.nextInt() % 6) + 7;
        }
        if (n == 3) {
            return 14;
        }
        return 8;
    }

    public int countPlayers() {
        int n = 0;
        for (int i = 0; i < this.tCount; ++i) {
            if (this.getID(i) == 0) continue;
            ++n;
        }
        return n;
    }

    public int countPlayersPos(int n) {
        if (n == 0) {
            return this.getPosFirstDef();
        }
        if (n == 1) {
            return this.getPosFirstMid() - this.getPosFirstDef();
        }
        if (n == 2 || n == 4) {
            return this.getPosFirstAtt() - this.getPosFirstMid();
        }
        return this.tCount - this.getPosFirstAtt();
    }

    public int getNextUnread(int n) {
        if (n < 0 || n > 14) {
            return -1;
        }
        for (int i = n + 1; i < 16; ++i) {
            if (this.getNewsRead(i)) continue;
            return i;
        }
        return -1;
    }

    public void setNewsRead(int n, boolean bl) {
        if (n < 0) {
            return;
        }
        if (n > 7) {
            int[] nArray = cmGame.decode8(this.tNewsRead2);
            nArray[n - 8] = bl ? 1 : 0;
            this.tNewsRead2 = cmGame.encode8(nArray, 0);
        } else {
            int[] nArray = cmGame.decode8(this.tNewsRead);
            nArray[n] = bl ? 1 : 0;
            this.tNewsRead = cmGame.encode8(nArray, 0);
        }
    }

    public boolean getNewsRead(int n) {
        if (n > 7) {
            int[] nArray = cmGame.decode8(this.tNewsRead2);
            return nArray[n - 8] != 0;
        }
        int[] nArray = cmGame.decode8(this.tNewsRead);
        return nArray[n] != 0;
    }

    public int countNews() {
        int n = 0;
        for (int i = 0; i < this.tQueue.length; ++i) {
            if (this.tQueue[i][0] == -1) continue;
            ++n;
        }
        return n;
    }

    public int countNews2() {
        int n = 0;
        for (int i = 0; i < this.tQueue.length; ++i) {
            if (this.tQueue[i][0] != -5) continue;
            ++n;
        }
        return n;
    }

    public int countUnreadNews() {
        int n;
        int[] nArray = cmGame.decode8(this.tNewsRead);
        int n2 = this.countNews();
        int n3 = 0;
        int n4 = 0;
        if (n2 > 7) {
            n3 = n2 - 8;
            n2 = 8;
        }
        for (n = 0; n < n2; ++n) {
            if (nArray[n] != 0) continue;
            ++n4;
        }
        if (n2 > 7) {
            nArray = cmGame.decode8(this.tNewsRead2);
            for (n = 0; n < n3; ++n) {
                if (nArray[n] != 0) continue;
                ++n4;
            }
        }
        return n4;
    }

    public void cleanNewsQ() {
        int n;
        this.tNewsRead = 0;
        this.tNewsRead2 = 0;
        int n2 = 0;
        for (n = 0; n < this.tQueue.length; ++n) {
            if (this.tQueue[n][8] == -99) {
                this.tQueue[n][8] = -1;
                continue;
            }
            for (n2 = 0; n2 < 9; ++n2) {
                this.tQueue[n][n2] = -1;
            }
        }
        if (this.tID == this.aGame.humanTeam) {
            for (n = 0; n < 16; ++n) {
                if (this.aGame.tQueueBuffer[n][0] == -1) continue;
                this.addEvent(this.aGame.tQueueBuffer[n][0], this.aGame.tQueueBuffer[n][1], this.aGame.tQueueBuffer[n][2], this.aGame.tQueueBuffer[n][3], this.aGame.tQueueBuffer[n][4], this.aGame.tQueueBuffer[n][5]);
            }
        }
        for (n = 0; n < 16; ++n) {
            for (n2 = 0; n2 < 9; ++n2) {
                this.aGame.tQueueBuffer[n][n2] = -1;
            }
        }
        this.aGame.bufferCount = 0;
    }

    public void adjustRatings(int n, int n2) {
        if (n == 0) {
            this.setBoard(this.getBoard() + n2);
        } else if (n == 1) {
            this.setTeamOp(this.getTeamOp() + n2);
        } else if (n == 2) {
            this.setFans(this.getFans() + n2);
        } else if (n == 3) {
            this.setMedia(this.getMedia() + n2);
        }
    }

    public void newsResponses() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (int i = 0; i < this.tQueue.length; ++i) {
            if (this.tQueue[i][0] == -1 || !this.aGame.checkOptions(this.tID, i)) continue;
            if (this.tQueue[i][6] - 1 <= 0) {
                this.tQueue[i][6] = 1;
            }
            if ((n7 = Integer.parseInt(this.aGame.loadLookupData(6, 5 + this.tQueue[i][8], this.tQueue[i][6] - 1))) == 0) {
                n7 = 3;
            } else if (n7 == 1) {
                n7 = 2;
            } else if (n7 == 2) {
                n7 = 1;
            } else if (n7 == 3) {
                n7 = 0;
            }
            if (this.tQueue[i][0] == 5 && this.tQueue[i][1] == 25) {
                if (n7 == 3) {
                    this.aGame.setPlayerDataExtra(this.tQueue[i][2], 35, 3, 1);
                    this.aGame.addToBufQ(11, 19, this.tQueue[i][2], -1, -1, -1);
                    this.aGame.listPlayer(this.tID, this.tQueue[i][2], true);
                    continue;
                }
                this.aGame.incPlayerData(this.tQueue[i][2], 14, -1);
                this.aGame.addToBufQ(11, 20, this.tQueue[i][2], -1, -1, -1);
                continue;
            }
            if (this.tQueue[i][0] == 11 && this.tQueue[i][1] == 21) {
                if (n7 != 3) continue;
                this.aGame.unlistPlayer(this.tQueue[i][2]);
                this.aGame.setPlayerDataExtra(this.tQueue[i][2], 35, 3, 0);
                continue;
            }
            if (this.tQueue[i][0] == 1 && this.tQueue[i][1] == 18) {
                if (n7 != 3) continue;
                this.premData[3] = (byte)(this.premData[3] + this.premData[3] / 10);
                continue;
            }
            n4 = this.aGame.getStoryType(this.tQueue[i][0], this.tQueue[i][1]);
            if (n == 0) {
                n2 = this.tTypes[0];
            } else if (n == 1) {
                n8 = this.getRandomPlayer();
                n2 = n8 == -1 ? 8 + Integer.parseInt(this.aGame.loadPlayerData(0, 9)) : 8 + Integer.parseInt(this.aGame.loadPlayerData(n8, 9));
            } else if (n == 2) {
                n2 = 20 + this.tTypes[1];
            } else if (n == 3) {
                n2 = -1;
            }
            n3 = n2 == -1 ? Math.abs(this.aGame.randt.nextInt() % 5) : Integer.parseInt(this.aGame.loadLookupData(5, n2, n4));
            n5 = Integer.parseInt(this.aGame.loadLookupData(6, n3, n7));
            n6 = n5 == 0 ? -3 : (n5 == 1 && Math.abs(this.aGame.randt.nextInt() % 3) != 0 ? 0 : (n5 == 1 ? -2 : (n5 == 2 && Math.abs(this.aGame.randt.nextInt() % 5) == 0 ? 0 : (n5 == 2 ? 3 : (n5 == 0 && Math.abs(this.aGame.randt.nextInt() % 3) == 0 ? 4 : 5)))));
            this.adjustRatings(n, n6);
            if (n != 1 || n8 == -1) {
                this.aGame.addToBufQ(6, n4, n, 24 - n5, n, n6);
                continue;
            }
            this.aGame.addToBufQ(6, n4 + 3, n8, 24 - n5, n, n6);
        }
    }

    public int addEvent(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 0;
        n7 = n != 6 ? this.countNews() : this.countNews2();
        if (n > 14) {
            // empty if block
        }
        if (n == 7 && n2 == 8) {
            for (int i = 0; i < this.tQueue.length; ++i) {
                if (this.tQueue[i][0] == 7 && this.tQueue[i][1] == 8 && this.tQueue[i][4] == n5) {
                    return -1;
                }
                if (this.tQueue[i][0] != 7 || this.tQueue[i][4] != n5 || this.tQueue[i][1] != 1 && this.tQueue[i][1] != 2) continue;
                return -1;
            }
        }
        if (!(this.tID == this.aGame.humanTeam && n7 < 16 || this.tID != this.aGame.humanTeam && n7 < 4)) {
            this.aGame.addToBufQ(n, n2, n3, n4, n5, n6);
            return -1;
        }
        this.tQueue[n7][0] = (short)n;
        this.tQueue[n7][1] = (short)n2;
        this.tQueue[n7][2] = (short)n3;
        this.tQueue[n7][3] = (short)n4;
        this.tQueue[n7][4] = (short)n5;
        this.tQueue[n7][5] = (short)n6;
        this.tQueue[n7][8] = (short)Math.abs(this.aGame.randt.nextInt() % 4);
        this.aGame.newsActionsAndData(this.tID, n7);
        return 0;
    }

    public void addForm(int n) {
        for (int i = 3; i >= 0; --i) {
            this.tForm[i + 1] = this.tForm[i];
        }
        this.tForm[0] = (byte)n;
    }

    public int getForm() {
        int n = 0;
        int n2 = this.getGP(this.aGame.tournament, 0);
        if (n2 == 0) {
            return 0;
        }
        for (int i = 0; i < 5; ++i) {
            if (this.tForm[i] == -1) continue;
            n += this.tForm[i];
        }
        return n / n2;
    }

    public int get5Form() {
        int n = 0;
        int n2 = this.getGP(this.aGame.tournament, 0);
        int n3 = n2 = n2 < 5 ? n2 : 5;
        if (n2 == 0) {
            return 0;
        }
        for (int i = 0; i < 5; ++i) {
            if (this.tForm[i] == -1) continue;
            n += this.tForm[i];
        }
        return n;
    }

    public int getMedia() {
        return this.getPremData(5);
    }

    public int getFans() {
        return this.getPremData(0);
    }

    public void setMedia(int n) {
        if (n > 100) {
            n = 100;
        }
        if (n < 0) {
            n = 0;
        }
        this.setPremData(5, (byte)n);
    }

    public void setFans(int n) {
        if (n > 100) {
            n = 100;
        }
        if (n < 0) {
            n = 0;
        }
        this.setPremData(0, (byte)n);
    }

    public int getTeamOp() {
        return this.getPremData(6);
    }

    public int getBoard() {
        return this.getPremData(12);
    }

    public void setTeamOp(int n) {
        if (n > 100) {
            n = 100;
        }
        if (n < 0) {
            n = 0;
        }
        this.setPremData(6, (byte)n);
    }

    public void setBoard(int n) {
        if (n > 100) {
            n = 100;
        }
        if (n < 0) {
            n = 0;
        }
        this.setPremData(12, (byte)n);
    }

    public int getDYellow() {
        return this.getPremData(10);
    }

    public void setDYellow(int n) {
        this.setPremData(10, n);
    }

    public int getYellow() {
        return this.getPremData(11);
    }

    public int getRed() {
        return this.getPremData(1);
    }

    public void setYellow(int n) {
        if (n > 128) {
            return;
        }
        this.setPremData(11, (byte)n);
    }

    public void setRed(int n) {
        if (n > 128) {
            return;
        }
        this.setPremData(1, (byte)n);
    }

    public int getRank() {
        return cmGame.splitByte(4, this.tRank, true);
    }

    public int getLoc() {
        return cmGame.splitByte(4, this.tRank, false);
    }

    public void setRank(int n) {
        if (n > 16) {
            return;
        }
        if (n < 0) {
            n = 0;
        }
        this.tRank = this.aGame.setSplitByte(4, this.tRank, true, (byte)n);
    }

    public int getTeamCol1(int n) {
        return Integer.parseInt(this.aGame.loadLookupData(1, 13, Integer.parseInt(this.aGame.loadTeamData(n, 3)) - 1), 16);
    }

    public int getTeamCol2(int n) {
        return Integer.parseInt(this.aGame.loadLookupData(1, 13, Integer.parseInt(this.aGame.loadTeamData(n, 4)) - 1), 16);
    }

    public void clearTeam() {
        for (int i = 0; i < 18; ++i) {
            this.tPickedPlayers[i] = -1;
        }
    }

    public void pickTeam(boolean bl) {
        int n;
        if (this.tID != this.aGame.humanTeam) {
            bl = true;
        }
        if (bl) {
            int n2;
            int[][] nArrayArray = new int[][]{{0, 1, 2, 2, 3, 7, 8, 8, 9, 14, 14, 0, 1, 2, 5, 8, 11, 14}, {0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 0, 1, 1, 2, 2, 3, 3}};
            int[][] nArray = new int[this.tCount][2];
            int n3 = 0;
            int n4 = 0;
            for (n4 = 0; n4 < this.aGame.aMatch.squadSize; ++n4) {
                this.tPickedPlayers[n4] = -1;
            }
            for (n4 = 0; n4 < this.tCount; ++n4) {
                nArray[n4][0] = this.getPosMem(n4);
                nArray[n4][1] = this.aGame.convert16to4(this.getPosMem(n4));
            }
            boolean[] blArray = new boolean[this.tCount];
            boolean[] blArray2 = new boolean[this.aGame.aMatch.squadSize];
            for (n4 = 0; n4 < this.aGame.aMatch.squadSize; ++n4) {
                blArray2[n4] = true;
            }
            for (n4 = 0; n4 < this.tCount; ++n4) {
                blArray[n4] = this.aGame.getPlInj(this.getID(n4)) < 0 && this.aGame.getPlSus(this.getID(n4)) < 0;
            }
            for (n2 = 0; n2 < 11; ++n2) {
                for (n4 = 0; n4 < this.tCount; ++n4) {
                    if (nArrayArray[0][n2] != nArray[n4][0] || !blArray[n4]) continue;
                    this.tPickedPlayers[n2] = this.getID(n4);
                    blArray[n4] = false;
                    blArray2[n2] = false;
                    ++n3;
                    n4 = this.tCount + 1;
                }
            }
            for (n2 = 0; n2 < 11; ++n2) {
                if (!blArray2[n2]) continue;
                for (n4 = 0; n4 < this.tCount; ++n4) {
                    if (nArrayArray[1][n2] != nArray[n4][1] || !blArray[n4]) continue;
                    this.tPickedPlayers[n2] = this.getID(n4);
                    blArray[n4] = false;
                    ++n3;
                    n4 = this.tCount + 1;
                    blArray2[n2] = false;
                }
            }
            for (n2 = 0; n2 < this.aGame.aMatch.squadSize; ++n2) {
                if (!blArray2[n2]) continue;
                for (n4 = 0; n4 < this.tCount; ++n4) {
                    if (!blArray[n4]) continue;
                    this.tPickedPlayers[n2] = this.getID(n4);
                    blArray[n4] = false;
                    ++n3;
                    n4 = this.tCount + 1;
                }
            }
            return;
        }
        if (this.getGP(this.aGame.tournament, 0) > 4 && this.tID != this.aGame.humanTeam) {
            boolean bl2 = false;
            int n5 = this.get5Form();
            if (n5 < 5) {
                if ((byte)Math.abs(this.aGame.randt.nextInt() % 2) == 0) {
                    bl2 = true;
                }
            } else if (n5 >= 5 && n5 < 8 && (byte)Math.abs(this.aGame.randt.nextInt() % 3) == 0) {
                bl2 = true;
            }
            if (bl2) {
                int n6 = Math.abs(this.aGame.randt.nextInt() % 5);
                this.tFormation = n6 < 2 ? (byte)(this.tFormation - Math.abs(this.aGame.randt.nextInt() % 3)) : (n6 < 2 ? (byte)(this.tFormation + Math.abs(this.aGame.randt.nextInt() % 3)) : (byte)this.aGame.loadManagerDataInt(this.manID, 20, this.tID));
            }
        }
        boolean[] blArray = new boolean[this.tCount];
        boolean[] blArray3 = new boolean[18];
        byte[][] byArray = new byte[this.tCount][3];
        for (n = 0; n < this.tCount; ++n) {
            if (this.getID(n) == 0) {
                blArray[n] = false;
                continue;
            }
            if (this.aGame.loadPlayerData(this.getID(n), 0).length() == 0) {
                blArray[n] = false;
                continue;
            }
            blArray[n] = this.aGame.getPlInj(this.getID(n)) < 0 && this.aGame.getPlSus(this.getID(n)) < 0;
            byArray[n][0] = this.tID < 20 ? (byte)this.aGame.loadPlayerDataInt(this.getID(n), 11) : (byte)Integer.parseInt(this.aGame.loadPlayerData(this.getID(n), 5));
            byArray[n][1] = (byte)this.getPosMem(n);
            byArray[n][2] = (byte)Integer.parseInt(this.aGame.loadPlayerData(this.getID(n), 4));
        }
        for (n = 0; n < 18; ++n) {
            this.tPickedPlayers[n] = -1;
            blArray3[n] = false;
        }
        n = 0;
        int n7 = 0;
        int n8 = -1;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        for (int i = 0; i < 2; ++i) {
            n11 = i == 0 ? 11 : 18;
            for (n10 = 0; n10 < n11; ++n10) {
                n = -999;
                n8 = -1;
                if (blArray3[n10]) continue;
                for (n9 = 0; n9 < this.tCount; ++n9) {
                    if (!blArray[n9]) continue;
                    n7 = this.getPlScore(byArray[n9], n10, i);
                    if (n7 == n) {
                        // empty if block
                    }
                    if (n7 <= n) continue;
                    n = n7;
                    n8 = n9;
                }
                if (n > 10 && i == 0 || i == 1) {
                    if (i == 1 && n == -789 && n10 > 10) {
                        this.tPickedPlayers[n10] = this.getID(n8);
                        blArray3[n10] = true;
                        continue;
                    }
                    if (n8 == -1) continue;
                    blArray[n8] = false;
                    this.tPickedPlayers[n10] = this.getID(n8);
                    blArray3[n10] = true;
                    continue;
                }
                blArray3[n10] = false;
            }
        }
    }

    public int getPlScore(byte[] byArray, int n, int n2) {
        int[] nArray = new int[]{0, 2, 5, 6, 7, 8, 14};
        int n3 = 0;
        if (this.tFormation < 0 || this.tFormation > 23) {
            this.tFormation = 0;
        }
        n3 = n < 11 ? Integer.parseInt(this.aGame.loadLookupData(3, this.tFormation, n)) : nArray[n - 11];
        int n4 = 0;
        if (byArray[1] > 15) {
            byArray[1] = 15;
        } else if (byArray[1] < 0) {
            byArray[1] = 0;
        }
        n4 = Integer.parseInt(this.aGame.loadLookupData(4, byArray[1], n3));
        int n5 = byArray[0];
        if (n4 == 80) {
            n5 -= 10;
        } else if (n4 == 60) {
            n5 -= 25;
        } else if (n4 == 50) {
            n5 -= 35;
        } else if (n4 == 40) {
            n5 -= 50;
        } else if (n4 == 1 && n2 == 1) {
            n5 -= 40;
        } else if (n4 == 1) {
            n5 -= 80;
        } else if (n4 == 0) {
            n5 -= 120;
        }
        if (byArray[1] == 0 && n3 > 0) {
            n5 = -999;
        }
        int n6 = 0;
        if (byArray[2] > 15) {
            byArray[2] = 15;
        } else if (byArray[2] < -1) {
            byArray[2] = -1;
        }
        if (byArray[2] != -1) {
            int n7 = Integer.parseInt(this.aGame.loadLookupData(4, byArray[2], n3));
            n6 = byArray[0];
            if (n7 == 80) {
                n6 -= 10;
            } else if (n7 == 60) {
                n6 -= 25;
            } else if (n7 == 50) {
                n6 -= 35;
            } else if (n7 == 40) {
                n6 -= 50;
            } else if (n7 == 0) {
                n6 -= 120;
            }
            if (byArray[2] == 0 && n3 > 0) {
                n6 = -999;
            }
        }
        if (n3 != 0 && byArray[1] == 0) {
            return -789;
        }
        if (n5 >= n6) {
            return n5;
        }
        return n6;
    }

    public short calcPoints(cmComp cmComp2, int n) {
        short s = 0;
        int n2 = this.aGame.convertTID(this.tID);
        int n3 = 0;
        int n4 = cmComp2.getRoundStart(n);
        int n5 = cmComp2.getRoundStart(n + 1);
        if (n5 == -1 && n == 0) {
            n5 = cmComp2.draw.length;
        }
        for (int i = n4; i < n5; ++i) {
            for (n3 = 0; n3 < cmComp2.draw[i].length; ++n3) {
                if (cmComp2.draw[i][n3][0] == n2) {
                    if (cmComp2.draw[i][n3][2] == -1) continue;
                    if (cmComp2.draw[i][n3][2] > cmComp2.draw[i][n3][3]) {
                        s = (short)(s + 3);
                        continue;
                    }
                    if (cmComp2.draw[i][n3][2] != cmComp2.draw[i][n3][3]) continue;
                    s = (short)(s + 1);
                    continue;
                }
                if (cmComp2.draw[i][n3][1] != n2 || cmComp2.draw[i][n3][2] == -1) continue;
                if (cmComp2.draw[i][n3][3] > cmComp2.draw[i][n3][2]) {
                    s = (short)(s + 3);
                    continue;
                }
                if (cmComp2.draw[i][n3][3] != cmComp2.draw[i][n3][2]) continue;
                s = (short)(s + 1);
            }
        }
        return s;
    }

    public int getGF(cmComp cmComp2, int n) {
        int n2 = 0;
        int n3 = this.aGame.convertTID(this.tID);
        int n4 = cmComp2.getRoundStart(n);
        int n5 = cmComp2.getRoundStart(n + 1);
        if (n5 == -1 && n == 0) {
            n5 = cmComp2.draw.length;
        }
        int n6 = 0;
        for (int i = n4; i < n5; ++i) {
            for (n6 = 0; n6 < cmComp2.draw[i].length; ++n6) {
                if (cmComp2.draw[i][n6][0] == n3) {
                    if (cmComp2.draw[i][n6][2] == -1) continue;
                    n2 = (short)(n2 + cmComp2.draw[i][n6][2]);
                    continue;
                }
                if (cmComp2.draw[i][n6][1] != n3 || cmComp2.draw[i][n6][2] == -1) continue;
                n2 = (short)(n2 + cmComp2.draw[i][n6][3]);
            }
        }
        return n2;
    }

    public int getGA(cmComp cmComp2, int n) {
        int n2 = this.aGame.convertTID(this.tID);
        int n3 = 0;
        int n4 = cmComp2.getRoundStart(n);
        int n5 = cmComp2.getRoundStart(n + 1);
        if (n5 == -1 && n == 0) {
            n5 = cmComp2.draw.length;
        }
        int n6 = 0;
        for (int i = n4; i < n5; ++i) {
            for (n6 = 0; n6 < cmComp2.draw[i].length; ++n6) {
                if (cmComp2.draw[i][n6][0] == n2) {
                    if (cmComp2.draw[i][n6][2] == -1) continue;
                    n3 = (short)(n3 + cmComp2.draw[i][n6][3]);
                    continue;
                }
                if (cmComp2.draw[i][n6][1] != n2 || cmComp2.draw[i][n6][2] == -1) continue;
                n3 = (short)(n3 + cmComp2.draw[i][n6][2]);
            }
        }
        return n3;
    }

    public int getGD(cmComp cmComp2, int n) {
        return this.getGF(cmComp2, n) - this.getGA(cmComp2, n);
    }

    public short getStat(int n, cmComp cmComp2, int n2) {
        int n3 = this.aGame.convertTID(this.tID);
        int n4 = cmComp2.getRoundStart(n2);
        int n5 = cmComp2.getRoundStart(n2 + 1);
        if (n5 == -1 && n2 == 0) {
            n5 = cmComp2.draw.length;
        }
        short s = 0;
        short s2 = 0;
        short s3 = 0;
        int n6 = 0;
        for (int i = n4; i < n5; ++i) {
            for (n6 = 0; n6 < cmComp2.draw[i].length; ++n6) {
                if (cmComp2.draw[i][n6][0] == n3) {
                    if (cmComp2.draw[i][n6][2] == -1) continue;
                    if (cmComp2.draw[i][n6][2] > cmComp2.draw[i][n6][3]) {
                        s = (short)(s + 1);
                        continue;
                    }
                    if (cmComp2.draw[i][n6][2] == cmComp2.draw[i][n6][3]) {
                        s2 = (short)(s2 + 1);
                        continue;
                    }
                    s3 = (short)(s3 + 1);
                    continue;
                }
                if (cmComp2.draw[i][n6][1] != n3 || cmComp2.draw[i][n6][2] == -1) continue;
                if (cmComp2.draw[i][n6][3] > cmComp2.draw[i][n6][2]) {
                    s = (short)(s + 1);
                    continue;
                }
                if (cmComp2.draw[i][n6][3] == cmComp2.draw[i][n6][2]) {
                    s2 = (short)(s2 + 1);
                    continue;
                }
                s3 = (short)(s3 + 1);
            }
        }
        if (n >= 2) {
            return s;
        }
        if (n == 1) {
            return s2;
        }
        return s3;
    }

    public int getHomeGP(cmComp cmComp2, int n) {
        int n2 = this.aGame.convertTID(this.tID);
        int n3 = cmComp2.getRoundStart(n);
        int n4 = cmComp2.getRoundStart(n + 1);
        if (n4 == -1 && n == 0) {
            n4 = cmComp2.draw.length;
        }
        int n5 = 0;
        int n6 = 0;
        for (int i = n3; i < n4; ++i) {
            for (n5 = 0; n5 < cmComp2.draw[i].length; ++n5) {
                if (cmComp2.draw[i][n5][0] != n2 || cmComp2.draw[i][n5][2] == -1) continue;
                ++n6;
            }
        }
        return n6;
    }

    public int getGP(cmComp cmComp2, int n) {
        int n2 = this.aGame.convertTID(this.tID);
        int n3 = cmComp2.getRoundStart(n);
        int n4 = cmComp2.getRoundStart(n + 1);
        if (n4 == -1 && n == 0) {
            n4 = cmComp2.draw.length;
        }
        int n5 = 0;
        int n6 = 0;
        for (int i = n3; i < n4; ++i) {
            for (n5 = 0; n5 < cmComp2.draw[i].length; ++n5) {
                if (cmComp2.draw[i][n5][0] != n2 && cmComp2.draw[i][n5][1] != n2 || cmComp2.draw[i][n5][2] == -1) continue;
                ++n6;
            }
        }
        return n6;
    }

    public int getAvRating() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.tCount; ++i) {
            if (this.getID(i) == 0) continue;
            n2 += this.aGame.loadPlayerDataInt(this.getID(i), 11);
            ++n;
        }
        if (n == 0) {
            return 0;
        }
        return n2 / n;
    }

    public int getAvAge() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.tCount; ++i) {
            if (this.getID(i) == 0) continue;
            n2 += this.aGame.loadPlayerDataInt(this.getID(i), 2);
            ++n;
        }
        if (n == 0) {
            return 0;
        }
        return n2 / n;
    }

    public int getPlChoice(int n) {
        int n2 = this.aGame.getPlPosTeam(this.tID, n);
        if (n == 0 || n2 == -1) {
            return 0;
        }
        int n3 = 0;
        int n4 = 0;
        String string = this.aGame.loadPlayerData(n, 11);
        n4 = string.length() == 0 ? 0 : Integer.parseInt(string);
        short s = this.getPosMem(n2);
        int n5 = 0;
        int n6 = 0;
        if (s == 0) {
            n6 = this.getPosFirstDef();
        } else if (s >= 1 && s <= 4 || s == 6) {
            n5 = this.getPosFirstDef();
            n6 = this.getPosFirstMid();
        } else if (s >= 1 && s <= 4 || s == 6) {
            n5 = this.getPosFirstDef();
            n6 = this.getPosFirstMid();
        } else if (s >= 7 && s <= 13 || s == 5) {
            n5 = this.getPosFirstMid();
            n6 = this.getPosFirstAtt();
        } else {
            n5 = this.getPosFirstAtt();
            n6 = this.tCount;
        }
        if (n5 == -1 || n6 == -1) {
            return 0;
        }
        int n7 = 0;
        for (int i = n5; i < n6; ++i) {
            if (this.getID(i) == 0 || n2 == i || this.getPosMem(i) != s || (n7 = (string = this.aGame.loadPlayerData(this.getID(i), 11)).length() == 0 ? 0 : Integer.parseInt(string)) <= n4) continue;
            ++n3;
        }
        return n3;
    }

    public int getCR() {
        int n = 4;
        int n2 = 0;
        if (this.tID < 20) {
            n2 = this.getGate() - this.getWageBill(this.tID);
        }
        if (n2 < -1000000) {
            n -= 4;
        } else if (n2 < -500000) {
            n -= 3;
        } else if (n2 < -250000) {
            n -= 2;
        } else if (n2 < -100000) {
            --n;
        } else if (n2 > 100000) {
            ++n;
        } else if (n2 > 250000) {
            n += 2;
        } else if (n2 > 500000) {
            n += 3;
        } else if (n2 > 1000000) {
            n += 4;
        }
        if (this.tBank < -25000000) {
            n -= 4;
        } else if (this.tBank < -10000000) {
            n -= 3;
        } else if (this.tBank < 0) {
            n -= 2;
        } else if (this.tBank > 2000000) {
            ++n;
        } else if (this.tBank > 5000000) {
            n += 2;
        } else if (this.tBank > 10000000) {
            n += 3;
        } else if (this.tBank > 20000000) {
            n += 6;
        } else if (this.tBank > 50000000) {
            n += 9;
        }
        if (n > 7) {
            n = 7;
        }
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public void setID(int n, int n2) {
        int n3 = this.aGame.convertTID(this.tID);
        if (n3 <= this.aGame.numLeagueTeams && n >= this.aGame.numPlayersTeam) {
            return;
        }
        if (n3 >= this.aGame.numLeagueTeams && n >= this.aGame.numPlayersFLTeam) {
            return;
        }
        this.tPlayers[n] = (short)n2;
    }

    public short getID(int n) {
        int n2 = this.aGame.convertTID(this.tID);
        if (n2 <= this.aGame.numLeagueTeams && n >= this.aGame.numPlayersTeam) {
            return 0;
        }
        if (n2 >= this.aGame.numLeagueTeams && n >= this.aGame.numPlayersFLTeam) {
            return 0;
        }
        return this.tPlayers[n];
    }

    public void setPosMem(int n, int n2) {
        this.tPlayersPosMem[n] = (short)n2;
    }

    public short getPosMem(int n) {
        if (n == -1) {
            return 0;
        }
        return this.tPlayersPosMem[n];
    }

    public void sortByPos() {
        int n = 3;
        while (n > 0) {
            for (int i = 0; i < this.tCount; ++i) {
                int n2;
                short s = this.getPosMem(i);
                for (n2 = i; n2 >= n && this.getPosMem(n2 - n) > s; n2 -= n) {
                    this.SwapLocations(n2, n2 - n);
                }
                this.setPosMem(n2, s);
            }
            if (n / 2 != 0) {
                n /= 2;
                continue;
            }
            if (n == 1) {
                n = 0;
                continue;
            }
            n = 1;
        }
    }

    public void SwapLocations(int n, int n2) {
        short s = 0;
        s = this.tPlayers[n];
        this.tPlayers[n] = this.tPlayers[n2];
        this.tPlayers[n2] = s;
        s = this.tPlayersMemIDs[n];
        this.tPlayersMemIDs[n] = this.tPlayersMemIDs[n2];
        this.tPlayersMemIDs[n2] = s;
        s = this.tPlayersPosMem[n];
        this.tPlayersPosMem[n] = this.tPlayersPosMem[n2];
        this.tPlayersPosMem[n2] = s;
    }

    public int getPosFirstDef() {
        for (int i = 0; i < this.tCount; ++i) {
            if (this.getPosMem(i) < 1) continue;
            return i;
        }
        return -1;
    }

    public int getPosFirstMid() {
        for (int i = 0; i < this.tCount; ++i) {
            if (this.getPosMem(i) < 4) continue;
            return i;
        }
        return -1;
    }

    public int getPosFirstAtt() {
        for (int i = 0; i < this.tCount; ++i) {
            if (this.getPosMem(i) < 13) continue;
            return i;
        }
        return -1;
    }

    public void cancelNews(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < this.tQueue.length; ++i) {
            if (this.tQueue[i][0] != n || this.tQueue[i][1] != n2) continue;
            this.tQueue[i][0] = -1;
            this.tQueue[i][1] = -1;
            this.tQueue[i][2] = -1;
            this.tQueue[i][3] = -1;
            this.tQueue[i][4] = -1;
            this.tQueue[i][5] = -1;
            for (n3 = 0; n3 < this.tQueue.length - 1; ++n3) {
                this.tQueue[n3][0] = this.tQueue[n3 + 1][0];
                this.tQueue[n3][1] = this.tQueue[n3 + 1][1];
                this.tQueue[n3][2] = this.tQueue[n3 + 1][2];
                this.tQueue[n3][3] = this.tQueue[n3 + 1][3];
                this.tQueue[n3][4] = this.tQueue[n3 + 1][4];
                this.tQueue[n3][5] = this.tQueue[n3 + 1][5];
            }
        }
    }

    public int getSqValue() {
        int n = 0;
        for (int i = 0; i < this.tCount; ++i) {
            n += this.aGame.loadPlayerDataExtra(this.getID(i), 31, this.tID, -1);
        }
        return n;
    }
}

