/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

class Sprite {
    static final int ANIM_PLAYING = 0;
    static final int END_OF_LOOPING_ANIM = -1;
    static final int END_OF_PLAYONCE_ANIM = -2;
    static final int MAX_ANIMS = 20;
    static final int STATE_DEAD = 0;
    static final int STATE_ALIVE = 1;
    static final int STATE_1 = 2;
    static final int STATE_2 = 3;
    static final int STATE_3 = 4;
    static final int STATE_4 = 5;
    static final int STATE_5 = 6;
    static final int STATE_6 = 7;
    static final int STATE_7 = 8;
    static final int STATE_8 = 9;
    static final int STATE_9 = 10;
    static final int STATE_10 = 11;
    static final int STATE_11 = 12;
    static final int STATE_12 = 13;
    static final int STATE_13 = 14;
    static final int STATE_14 = 15;
    static final int STATE_15 = 16;
    static final int ID_RAIL1 = 0;
    static final int ID_RAIL2 = 1;
    static final int ID_HEART = 2;
    static final int ID_THE3 = 3;
    static final int ID_THE5 = 4;
    static final int ID_P = 5;
    static final int ID_G = 6;
    static final int ID_TREE1 = 7;
    static final int ID_TREE2 = 8;
    static final int ID_FINISHFLAG = 9;
    static final int ID_FINISHPOLE = 10;
    static final int ID_MAYOR = 11;
    static final int ID_PROFESSOR = 12;
    static final int ID_STAR = 13;
    static final int ID_ROCK = 14;
    static final int ID_WARNING_SIGN = 15;
    static final int ID_FOREGROUND_TILE1 = 16;
    static final int ID_FOREGROUND_TILE2 = 17;
    static final int ID_FOREGROUND_TILE3 = 18;
    static final int ID_PICKUP_BUNNY = 19;
    static final int ID_PICKUP_FLOWER = 20;
    static final int ID_BG_RABBIT = 21;
    static final int ID_BG_SNOWMAN = 22;
    static final int ID_SPEEDUP = 23;
    static final int ID_START_FLAG = 24;
    static final int ID_RAIL3 = 25;
    static final int ID_RAIL4 = 26;
    static final int ID_GREENGANG = 27;
    static final int ID_TEACHER = 28;
    static final int ID_FUZZY = 29;
    static final int ID_PRINCESS = 30;
    static final int ID_BANNER1 = 31;
    static final int ID_BANNER2 = 32;
    static final int ID_BALLOON = 33;
    static final int ID_THEX = 50;
    static final int ID_LIL_SPARK = 51;
    static final int ID_HEART_EXP = 52;
    static final int ID_POINTS_1 = 53;
    static final int ID_POINTS_360 = 54;
    static final int ID_DOUBLEJUMP_EXP = 55;
    static final int ID_FLASHING_SCORE = 56;
    static final int ID_LIL_SPARK2 = 57;
    static final int ID_LIL_SPARK3 = 58;
    static final int ID_OBJECTIVE_COMPLETE = 59;
    static final int ID_POLYGON = 60;
    static final int ID_SNOWFLAKE = 61;
    static final int ID_THEX2 = 62;
    static final int ID_LIL_SPARK_GREEN = 63;
    static final int BACK_LAYER = 0;
    static final int FRONT_LAYER = 1;
    private static final byte[] rail1_ypos_array = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] rail2_ypos_array = new byte[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24, 25, 25, 26, 26, 27, 27, 28, 28, 29, 29, 30, 30, 31, 31};
    private static final byte[] rail3_ypos_array = new byte[]{10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 9, 9, 9, 8, 7, 6, 5, 3, 2, 0, 0};
    private static final byte[] rail4_ypos_array = new byte[]{0, 0, 0, 0, 1, 1, 2, 2, 3, 3, 4, 4, 5, 5, 6, 6, 7, 7, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 19, 20, 20, 21, 21, 22, 22, 23, 23, 24, 24, 25, 25, 26, 26, 27, 27, 28, 28, 29, 29, 29, 29, 31, 29, 29, 29, 29, 28, 28, 28, 27, 27, 26, 25, 24, 23, 22, 21, 21, 21};
    int id;
    int x;
    int y;
    int xv;
    int yv;
    int width;
    int height;
    int curr_frame;
    int state;
    int temp;
    int half_width;
    int half_height;
    int curr_frame_index;
    byte[][] anim_list = new byte[20][];
    int curr_anim;
    int num_anims;
    int anim_ticker;
    int anim_speed;
    int draw_index;
    public int index;
    DeviceImage[] frames;
    static final int MAX_LAYER_OBJ = 160;
    static Sprite[] draw_layer_objects = new Sprite[160];
    Sprite parent;
    Sprite child;
    int counter_1;
    int points;
    public boolean sticks;
    public boolean has_collision;
    static Engine game;
    int wqrtr;
    int hqrtr;
    int x1;
    int y1;
    int w1;
    int h1;
    int x2;
    int y2;
    int w2;
    int h2;
    int previous_frame;
    public int target_x;
    public int target_y;
    public static final int[][][] POINTS_3_X;
    public static final int[][][] POINTS_3_Y;
    public static final int MAX_SCALE;
    public static int CENTRE_3_X;
    public static int CENTRE_3_Y;
    public int[][] pointsX;
    public int[][] pointsY;
    public int[][] sourceX;
    public int[][] sourceY;
    public static final int LETTER_3 = 0;
    public static final int LETTER_2 = 1;
    public static final int LETTER_1 = 2;
    public int scale;
    public int scaleFactor;
    public int color;

    public Sprite(Engine engine, int n, int n2, DeviceImage[] deviceImageArray) {
        if (deviceImageArray != null) {
            this.frames = deviceImageArray;
            this.width = deviceImageArray[0].width;
            this.height = deviceImageArray[0].height;
        }
        this.setPos(n, n2);
        this.half_width = this.width >> 1;
        this.half_height = this.height >> 1;
        this.wqrtr = this.width / 4;
        this.hqrtr = this.height / 4;
        this.setParent(engine);
    }

    public Sprite() {
        this.setPos(0, 0);
        this.half_width = this.width >> 1;
        this.half_height = this.height >> 1;
    }

    public void setPoints(int n) {
        this.points = n;
    }

    public void setParent(Engine engine) {
        game = engine;
    }

    public void turnCollisionOn() {
        this.has_collision = true;
    }

    public void turnCollisionOff() {
        this.has_collision = false;
    }

    public void setDrawIndex(int n) {
        this.draw_index = n;
    }

    public void kill() {
        this.state = 0;
    }

    public void clone(Sprite sprite) {
        this.frames = sprite.frames;
        this.width = sprite.width;
        this.height = sprite.height;
        this.half_width = sprite.half_width;
        this.half_height = sprite.half_height;
        this.wqrtr = sprite.wqrtr;
        this.hqrtr = sprite.hqrtr;
        this.curr_frame = 0;
        this.yv = 0;
        this.xv = 0;
        this.temp = 0;
        this.curr_frame_index = 0;
        this.curr_anim = 0;
        this.num_anims = sprite.num_anims;
        this.anim_ticker = 0;
        this.anim_speed = sprite.anim_speed;
        this.sticks = sprite.sticks;
        for (int i = 0; i < this.num_anims; ++i) {
            this.anim_list[i] = sprite.anim_list[i];
        }
        this.has_collision = sprite.has_collision;
        sprite = null;
        this.child = null;
        this.counter_1 = 0;
    }

    public void setChild(Sprite sprite) {
        this.child = sprite;
    }

    public void setParent(Sprite sprite) {
        this.parent = sprite;
    }

    public void killChild() {
        if (this.child != null) {
            this.child.killAndRemoveFromDrawLayer();
            this.child = null;
        }
    }

    public void killParent() {
        if (this.parent != null) {
            this.parent.killAndRemoveFromDrawLayer();
            this.parent = null;
        }
    }

    public boolean hasChild() {
        return this.child != null;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public void killAndRemoveFromDrawLayer() {
        this.state = 0;
        Sprite.draw_layer_objects[this.draw_index] = null;
    }

    public void makeAlive() {
        this.state = 1;
    }

    public boolean isAlive() {
        return this.state >= 1;
    }

    public boolean isDead() {
        return this.state == 0;
    }

    public boolean KillIfOffScreenLeft(int n) {
        int n2 = this.width;
        switch (this.id) {
            case 0: 
            case 1: 
            case 25: 
            case 26: {
                Engine.debug("width " + this.width);
                n2 = this.frames[0].width;
                Engine.debug("ww " + n2);
            }
        }
        if (n >= Engine.scale(this.x2i()) + n2) {
            Engine.debug("vx " + n + "Engine.scale(x2i())+ww) =" + (Engine.scale(this.x2i()) + n2));
            this.killAndRemoveFromDrawLayer();
            return true;
        }
        return false;
    }

    public boolean setAnim(int n) {
        if (this.curr_anim != n) {
            this.anim_ticker = 0;
            this.curr_anim = n;
            this.curr_frame_index = 0;
            this.updateAnimFrame();
            return true;
        }
        return false;
    }

    public void resetCurrAnim() {
        this.curr_frame_index = 0;
        this.updateAnimFrame();
    }

    public int addAnim(byte[] byArray) {
        this.anim_list[this.num_anims] = byArray;
        ++this.num_anims;
        return this.num_anims - 1;
    }

    public void updateAnimFrame() {
        if (this.anim_list != null && this.anim_list[this.curr_anim] != null) {
            this.curr_frame = this.anim_list[this.curr_anim][this.curr_frame_index];
        }
    }

    public void saveCurrAnimFrame() {
        if (this.anim_list != null) {
            this.previous_frame = this.anim_list[this.curr_anim][this.curr_frame_index];
        }
    }

    public int getPreviousFrame() {
        return this.previous_frame;
    }

    public int getCurrAnimLen() {
        if (this.anim_list == null || this.anim_list[this.curr_anim] == null) {
            return 0;
        }
        return this.anim_list[this.curr_anim].length;
    }

    public int getCurrAnimId() {
        return this.curr_anim;
    }

    public int animate() {
        if (this.frames == null || this.frames.length <= 1) {
            return -2;
        }
        if (++this.anim_ticker < this.anim_speed) {
            return 0;
        }
        this.anim_ticker = 0;
        this.curr_frame = this.anim_list[this.curr_anim][this.curr_frame_index];
        ++this.curr_frame_index;
        if (this.curr_frame == -1) {
            this.curr_frame_index = 0;
            this.curr_frame = this.anim_list[this.curr_anim][this.curr_frame_index];
            ++this.curr_frame_index;
            return -1;
        }
        if (this.curr_frame == -2) {
            this.curr_frame_index -= 2;
            this.curr_frame = this.anim_list[this.curr_anim][this.curr_frame_index];
            return -2;
        }
        return 0;
    }

    public void setPos(int n, int n2) {
        this.x = Engine.intToFixed(n);
        this.y = Engine.intToFixed(n2);
    }

    public void move() {
        this.x += this.xv;
        this.y += this.yv;
    }

    public int getCenterX() {
        return this.x2i() + this.half_width;
    }

    public int getCenterY() {
        return this.y2i() + this.half_height;
    }

    public int x2i() {
        return Engine.fixedToInt(this.x);
    }

    public int y2i() {
        return Engine.fixedToInt(this.y);
    }

    public void moveFrameIndex(int n) {
        if (this.curr_frame_index < n) {
            ++this.curr_frame_index;
        }
        if (this.curr_frame_index > n) {
            --this.curr_frame_index;
        }
        this.updateAnimFrame();
    }

    public void draw(Graphics graphics, int n, int n2) {
        int n3 = (this.sticks ? this.x2i() : Engine.scale(this.x2i())) - n;
        int n4 = (this.sticks ? this.y2i() : Engine.scale(this.y2i())) - n2;
        if (n3 >= 240) {
            return;
        }
        if (n4 >= 320) {
            return;
        }
        if (n3 <= -this.width) {
            return;
        }
        if (n4 <= -this.height) {
            return;
        }
        this.frames[this.curr_frame].drawImage(graphics, n3, n4);
        if (Device.DRAW_BOUNDING_RECT) {
            graphics.setColor(255);
            n3 = this.x2i();
            n4 = this.y2i();
            graphics.drawRect(n3 + 1 - n, n4 + 1 - n2, this.width - 2, this.height - 2);
        }
    }

    public void drawPreviousFrame(Graphics graphics, int n, int n2) {
        this.frames[this.previous_frame].drawImage(graphics, this.x2i() - n, this.y2i() - n2);
    }

    public void drawRect(Graphics graphics, int n, int n2) {
        graphics.setClip(this.x2i() - n, this.y2i() - n2, this.width, this.height);
        graphics.setColor(255);
        graphics.fillRect(this.x2i() - n, this.y2i() - n2, this.width, this.height);
    }

    public boolean collide(Sprite sprite) {
        return this.intersectsWith2(sprite);
    }

    public boolean collideTight(Sprite sprite) {
        return this.intersectsWith(sprite);
    }

    public boolean intersectsWith(Sprite sprite) {
        this.x1 = this.x2i();
        this.y1 = this.y2i();
        this.w1 = this.width;
        this.h1 = this.height;
        this.x2 = sprite.x2i();
        this.y2 = sprite.y2i();
        this.w2 = sprite.width;
        this.h2 = sprite.height;
        return this.x1 <= sprite.x2i() + sprite.width && this.x1 + this.w1 >= sprite.x2i() && this.y1 <= sprite.y2i() + sprite.height && this.y1 + this.h1 >= sprite.y2i();
    }

    public boolean intersectsWith2(Sprite sprite) {
        this.x1 = this.x2i() + this.wqrtr;
        this.y1 = this.y2i() + this.hqrtr;
        this.w1 = this.half_width;
        this.h1 = this.half_height;
        this.x2 = sprite.x2i() + sprite.wqrtr;
        this.y2 = sprite.y2i() + sprite.hqrtr;
        this.w2 = sprite.half_width;
        this.h2 = sprite.half_height;
        return this.x1 <= sprite.x2i() + sprite.width && this.x1 + this.w1 >= sprite.x2i() && this.y1 <= sprite.y2i() + sprite.height && this.y1 + this.h1 >= sprite.y2i();
    }

    public boolean setSpriteToRailPixelYpos(int n, Sprite sprite) {
        int n2 = sprite.x2i();
        int n3 = this.x2i();
        int n4 = 0;
        byte[] byArray = null;
        int n5 = 0;
        int n6 = 20;
        switch (n) {
            case 0: {
                n4 = 5;
                byArray = rail1_ypos_array;
                n5 = 64;
                break;
            }
            case 1: {
                n4 = 12;
                byArray = rail2_ypos_array;
                n5 = 66;
                break;
            }
            case 25: {
                n4 = 5;
                byArray = rail3_ypos_array;
                n5 = 76;
                break;
            }
            case 26: {
                n4 = 12;
                byArray = rail4_ypos_array;
                n5 = 82;
            }
        }
        if (sprite.y2i() + 40 < this.y2i() + n4) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            if (n2 >= n3 && n2 < n3 + n5) {
                int n7 = n2 - n3;
                sprite.setPos(sprite.x2i(), this.y2i() + byArray[n7] - (40 - n4));
                if (n == 1 && i > 0) {
                    sprite.y -= Engine.intToFixed(8);
                }
                return true;
            }
            n2 += n6;
        }
        return false;
    }

    static void resetObjectDrawLayers() {
        for (int i = 0; i < 160; ++i) {
            Sprite.draw_layer_objects[i] = null;
        }
    }

    static void drawObjectLayers(Graphics graphics, int n, int n2, int n3) {
        Sprite[] spriteArray = draw_layer_objects;
        int n4 = 0;
        int n5 = 80;
        if (n == 1) {
            n4 = 80;
            n5 = 160;
        }
        for (int i = n4; i < n5; ++i) {
            int n6;
            if (spriteArray[i] == null) continue;
            if (spriteArray[i].id == 60) {
                spriteArray[i].paintPolygon(graphics);
                continue;
            }
            if (spriteArray[i].id == 53 || spriteArray[i].id == 54 || spriteArray[i].id == 56 || spriteArray[i].id == 59) {
                if (spriteArray[i].id == 56) {
                    int n7 = 1;
                    n6 = spriteArray[i].points;
                    String string = "+" + n6;
                    if (spriteArray[i].points < 0) {
                        n7 = 2;
                        n6 = -n6;
                        string = "" + n6;
                    }
                    if (Engine.tick % 3 != 0 && spriteArray[i].points >= 0) continue;
                    game.drawBitmapNumString(graphics, string, spriteArray[i].x2i(), spriteArray[i].y2i(), n7);
                    continue;
                }
                game.drawBitmapNumString(graphics, "" + spriteArray[i].points, Engine.scale(spriteArray[i].x2i()) - n2, Engine.scale(spriteArray[i].y2i()) - n3, 0);
                continue;
            }
            if (spriteArray[i].id == 58) {
                spriteArray[i].draw(graphics, 0, 0);
                continue;
            }
            if (spriteArray[i].id == 33) {
                Sprite sprite = spriteArray[i];
                graphics.setColor(0);
                n6 = sprite.x + Engine.intToFixed(sprite.width / 2);
                int n8 = sprite.y + Engine.intToFixed(sprite.height);
                int n9 = sprite.target_x + Engine.intToFixed(sprite.width / 2);
                int n10 = sprite.target_y + Engine.intToFixed(sprite.height * 3);
                n6 = sprite.x + Engine.intToFixed(6);
                n8 = sprite.y + Engine.intToFixed(17);
                n9 = sprite.target_x + Engine.intToFixed(6);
                n10 = sprite.target_y + Engine.intToFixed(51);
                n6 = Engine.scale(n6);
                n8 = Engine.scale(n8);
                n9 = Engine.scale(n9);
                n10 = Engine.scale(n10);
                graphics.setClip(0, 0, 240, 320);
                graphics.drawLine(Engine.fixedToInt(n6) - n2, Engine.fixedToInt(n8) - n3, Engine.fixedToInt(n9) - n2, Engine.fixedToInt(n10) - n3);
            }
            spriteArray[i].draw(graphics, n2, n3);
        }
    }

    public int getScrX(int n) {
        return this.x2i() - n;
    }

    public int getScrY(int n) {
        return this.y2i() - n;
    }

    static int addObjectToLayer(Sprite sprite, int n) {
        Sprite[] spriteArray = draw_layer_objects;
        int n2 = 0;
        int n3 = 80;
        if (n == 1) {
            n2 = 80;
            n3 = 160;
        }
        for (int i = n2; i < n3; ++i) {
            if (spriteArray[i] != null) continue;
            spriteArray[i] = sprite;
            return i;
        }
        return 0;
    }

    static int countDrawList() {
        int n = 0;
        for (int i = 0; i < 160; ++i) {
            if (draw_layer_objects[i] == null) continue;
            ++n;
        }
        return n;
    }

    public void zeroPos() {
        this.x = 0;
        this.y = 0;
    }

    public void initPoly(int n) {
        this.scale = 256;
        this.scaleFactor = 51;
        this.pointsX = Sprite.copyPoly(POINTS_3_X[n]);
        this.pointsY = Sprite.copyPoly(POINTS_3_Y[n]);
        this.sourceX = POINTS_3_X[n];
        this.sourceY = POINTS_3_Y[n];
    }

    public static void staticInit() {
        Sprite.centrePoly(POINTS_3_X[0], CENTRE_3_X);
        Sprite.centrePoly(POINTS_3_Y[0], CENTRE_3_Y);
        Sprite.centrePoly(POINTS_3_X[1], CENTRE_3_X);
        Sprite.centrePoly(POINTS_3_Y[1], CENTRE_3_Y);
        Sprite.centrePoly(POINTS_3_X[2], CENTRE_3_X);
        Sprite.centrePoly(POINTS_3_Y[2], CENTRE_3_Y);
        Sprite.centrePoly(POINTS_3_X[3], 15);
        Sprite.centrePoly(POINTS_3_Y[3], 13);
    }

    public void paintPolygon(Graphics graphics) {
        if (this.scale < 256) {
            return;
        }
        graphics.setClip(0, 0, 240, 320);
        graphics.setColor(this.color);
        for (int i = 0; i < this.pointsX.length; ++i) {
            for (int j = 0; j < this.pointsX[i].length; ++j) {
                int n = (j + 1) % this.pointsX[i].length;
                graphics.drawLine(Engine.fixedToInt(this.pointsX[i][j] + this.x), Engine.fixedToInt(this.pointsY[i][j] + this.y), Engine.fixedToInt(this.pointsX[i][n] + this.x), Engine.fixedToInt(this.pointsY[i][n] + this.y));
            }
        }
    }

    public static void centrePoly(int[][] nArray, int n) {
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray[i].length; ++j) {
                nArray[i][j] = Engine.intToFixed(nArray[i][j] - n);
            }
        }
    }

    public static int[][] copyPoly(int[][] nArray) {
        int[][] nArrayArray = new int[nArray.length][];
        for (int i = 0; i < nArray.length; ++i) {
            nArrayArray[i] = new int[nArray[i].length];
            for (int j = 0; j < nArray[i].length; ++j) {
                nArrayArray[i][j] = nArray[i][j];
            }
        }
        return nArrayArray;
    }

    public void tickPolygon() {
        for (int i = 0; i < this.pointsX.length; ++i) {
            for (int j = 0; j < this.pointsX[i].length; ++j) {
                this.pointsX[i][j] = Engine.multiFixed(this.sourceX[i][j], this.scale);
                this.pointsY[i][j] = Engine.multiFixed(this.sourceY[i][j], this.scale);
            }
        }
        this.scaleFactor += 51;
        this.scaleFactor = Math.min(this.scaleFactor, 512);
        this.scale += this.scaleFactor;
    }

    public void setToFollowTarget(int n, int n2) {
        this.target_x = n;
        this.target_y = n2;
        this.xv = Engine.multiFixed(Engine.intToFixed(this.target_x - this.x2i()), 102);
        this.yv = Engine.multiFixed(Engine.intToFixed(this.target_y - this.y2i()), 102);
    }

    public void stopToTarget() {
        this.xv = Engine.multiFixed(Engine.intToFixed(this.target_x - this.x2i()), 102);
        this.yv = Engine.multiFixed(Engine.intToFixed(this.target_y - this.y2i()), 102);
        if (this.hitTarget()) {
            this.kill();
        }
    }

    public void addGravity() {
        if (this.yv < Device.MAX_YV) {
            this.yv += 205;
            if (this.yv > Device.MAX_YV) {
                this.yv = Device.MAX_YV;
            }
        }
    }

    public boolean hitTarget() {
        return this.x2i() == this.target_x && this.y2i() == this.target_y;
    }

    static {
        POINTS_3_X = new int[][][]{new int[][]{{0, 11, 13, 13, 11, 13, 13, 11, 0, 0, 9, 9, 2, 2, 9, 9, 0}}, new int[][]{{0, 12, 13, 13, 11, 5, 5, 13, 13, 0, 0, 2, 9, 10, 0}}, new int[][]{{0, 9, 9, 4, 4, 0}}, new int[][]{{15, 19, 22, 25, 29, 29, 15, 1, 0, 4, 8, 11}}};
        POINTS_3_Y = new int[][][]{new int[][]{{0, 0, 2, 4, 6, 8, 12, 15, 15, 10, 10, 8, 8, 5, 5, 4, 4}}, new int[][]{{0, 0, 1, 7, 9, 9, 11, 11, 15, 15, 7, 6, 6, 4, 4}}, new int[][]{{0, 0, 15, 15, 5, 5}}, new int[][]{{6, 1, 0, 1, 6, 12, 25, 13, 5, 1, 0, 1}}};
        MAX_SCALE = Engine.intToFixed(20);
        CENTRE_3_X = 6;
        CENTRE_3_Y = 7;
    }
}

