/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.screens;

import com.jarbull.basket.game.MainMidlet;
import com.jarbull.basket.tools.ImageHandler;
import com.jarbull.jbf.JBAction;
import com.jarbull.jbf.JBManager;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class BeforeGameScreen
extends Canvas
implements Runnable {
    public static final int STATE__IDLE = 0;
    public static final int STATE__WAIT = 1;
    public static final int STATE__EXIT = 2;
    public static final int TEXT_LINE_STATE__NORMAL = 0;
    public static final int TEXT_LINE_STATE__FLICKER = 1;
    private static final int CENTER = 3;
    private MainMidlet midlet;
    private Displayable previousDisplay;
    private Thread thread;
    private Vector textLines;
    private Vector textLinesState;
    private int screenCenterX;
    private int screenCenterY;
    private int state = 0;
    private boolean flicker = true;
    int levelNo;
    Vector strBuffer;
    int maxCharacters = 17;
    int maxLines = 6;
    String newLineRecognizer = ":";
    boolean continueAddTexts;
    int totalLineCounter = 0;
    boolean textShown;
    boolean anyTextShown;
    Vector levelMetin;

    public BeforeGameScreen(MainMidlet midlet) {
        this.initalize(midlet);
        this.textShown = false;
        this.anyTextShown = false;
    }

    private void fillLevelMetin() {
        this.levelMetin = new Vector();
        StringBuffer fileContent = new StringBuffer();
        try {
            InputStream in = this.getClass().getResourceAsStream("/res/inGame/intro.txt");
            byte[] buffer = new byte[2500];
            while (in.read(buffer) != -1) {
                fileContent.append(new String(buffer));
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String content = fileContent.toString() + " ";
        if (!content.equals("\n")) {
            while (content.indexOf(32) != -1) {
                int index = content.indexOf(32);
                String word = content.substring(0, index);
                content = content.substring(index + 1);
                this.levelMetin.addElement(word);
            }
        }
    }

    public void handleText() {
        this.strBuffer = new Vector();
        int charCount = 0;
        int appendIndex = 0;
        while (appendIndex < this.levelMetin.size()) {
            StringBuffer strBufferToDisplay = new StringBuffer();
            while (charCount + this.levelMetin.elementAt(appendIndex).toString().trim().length() < this.maxCharacters + 1) {
                if (this.levelMetin.elementAt(appendIndex).toString().trim().equals(this.newLineRecognizer)) {
                    ++appendIndex;
                    charCount = this.maxCharacters;
                } else {
                    strBufferToDisplay.append(this.levelMetin.elementAt(appendIndex).toString().trim()).append(" ");
                    charCount += this.levelMetin.elementAt(appendIndex).toString().length();
                    ++appendIndex;
                }
                if (appendIndex < this.levelMetin.size()) continue;
            }
            charCount = 0;
            this.strBuffer.addElement(strBufferToDisplay);
        }
        int counter = 0;
        this.addText(" ");
        while (counter < this.maxLines) {
            this.addText(this.strBuffer.elementAt(counter).toString());
            if (++counter == this.strBuffer.size()) break;
            ++this.totalLineCounter;
        }
    }

    private void addTexts(int counter) {
        for (int inCounter = 0; inCounter < this.maxLines; ++inCounter) {
            this.addText(this.strBuffer.elementAt(counter + inCounter).toString());
            ++this.totalLineCounter;
            if (this.totalLineCounter == this.strBuffer.size()) break;
        }
    }

    public BeforeGameScreen(MainMidlet midlet, int levelNo) {
        this.levelNo = levelNo;
        this.initalize(midlet);
    }

    public void initalize(MainMidlet midlet) {
        this.midlet = midlet;
        this.levelMetin = new Vector();
        this.setFullScreenMode(true);
        this.continueAddTexts = true;
        this.previousDisplay = Display.getDisplay((MIDlet)midlet).getCurrent();
        this.textLines = new Vector();
        this.textLinesState = new Vector();
        this.screenCenterX = this.getWidth() / 2;
        this.screenCenterY = this.getHeight() / 2;
        this.fillLevelMetin();
        this.handleText();
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setNextDisplay(Displayable nextDisplay) {
        this.previousDisplay = nextDisplay;
    }

    public void addText(String text) {
        this.addText(text, 0);
    }

    public void addText(String text, String font) {
        this.addText(text, 0, font);
    }

    public void addText(String text, int state) {
        this.textLinesState.addElement(new Integer(state));
        this.textLines.addElement(JBManager.getInstance().getTextImage(text, "10x10-beyaz"));
    }

    public void addText(String text, int state, String font) {
        this.textLinesState.addElement(new Integer(state));
        this.textLines.addElement(JBManager.getInstance().getTextImage(text, font));
    }

    public void removeTextFromEnd(int count) {
        for (int i = 0; i < count; ++i) {
            this.textLines.removeElementAt(this.textLines.size() - 1);
            this.textLinesState.removeElementAt(this.textLines.size() - 1);
        }
    }

    public void show() {
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void waitForClose() {
        try {
            this.thread.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        g.setColor(0, 27, 62);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        block4: for (int i = this.textLines.size() - 1; i >= 0; --i) {
            switch ((Integer)this.textLinesState.elementAt(i)) {
                case 0: {
                    g.drawImage((Image)this.textLines.elementAt(i), this.screenCenterX, this.screenCenterY - this.textLines.size() * 5 + i * 10 + 7, 3);
                    continue block4;
                }
                case 1: {
                    if (this.flicker) continue block4;
                    g.drawImage((Image)this.textLines.elementAt(i), this.screenCenterX, this.screenCenterY - this.textLines.size() * 5 + i * 10 + 7, 3);
                }
            }
        }
        this.flicker = !this.flicker;
    }

    protected void keyPressed(int keyCode) {
        if (this.state == 0 && this.totalLineCounter == this.strBuffer.size()) {
            this.state = 2;
        } else if (this.totalLineCounter != this.strBuffer.size()) {
            this.removeTextFromEnd(this.textLines.size() - 1);
            this.addTexts(this.totalLineCounter);
            this.repaint();
        }
    }

    public void run() {
        while (true) {
            if (this.state == 2) break;
            if (this.totalLineCounter == this.strBuffer.size() && !this.textShown) {
                this.addText(" ");
                this.textShown = true;
            }
            if (this.state == 0 && this.totalLineCounter == this.strBuffer.size() && this.textShown && !this.anyTextShown) {
                this.addText("PRESS ANY KEY", 0);
                this.anyTextShown = true;
            }
            this.repaint();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        Display.getDisplay((MIDlet)this.midlet).setCurrent(this.previousDisplay);
        this.levelMetin = null;
        this.strBuffer = null;
        this.textLines = null;
        this.textLinesState = null;
        System.gc();
        ImageHandler.getInstance().clearImageBuffer();
        JBManager.getInstance().clearFonts();
        JBManager.getInstance().addAction(new JBAction(this, "clearti"));
    }
}

