/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.game;

import com.jarbull.basket.game.BasketMidlet;
import com.jarbull.basket.game.BasketProcessor;
import com.jarbull.jbf.util.KeyCodeAdapter;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;

public class BasketCanvas
extends GameCanvas
implements Runnable {
    private BasketMidlet mid;
    BasketProcessor processor;
    public static int canvasWidth;
    public static int canvasHeigth;
    public static boolean isRunning;
    boolean isPaused = false;
    private Thread t;
    public Displayable previousScreen;
    private Displayable thisScreen;

    public BasketCanvas(BasketMidlet m) throws Exception {
        super(true);
        this.mid = m;
        this.thisScreen = this;
        KeyCodeAdapter.getInstance().setCanvas((Canvas)this);
        this.setFullScreenMode(true);
        canvasWidth = this.getWidth();
        canvasHeigth = this.getHeight();
        this.processor = new BasketProcessor(this);
    }

    public void show() {
        Display.getDisplay((MIDlet)this.mid).setCurrent(this.thisScreen);
        this.t = new Thread(this);
        this.t.start();
    }

    public void waitForClose() {
        try {
            this.t.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    public void run() {
        this.processor.start();
        isRunning = true;
        this.isPaused = false;
        while (isRunning && BasketProcessor.isRunning) {
            if (!this.isPaused) {
                this.repaint();
            }
            try {
                Thread.sleep(40L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.processor.kill();
        this.processor = null;
        Display.getDisplay((MIDlet)this.mid).setCurrent(this.previousScreen);
    }

    public void paint(Graphics g) {
        if (this.processor == null || !this.processor.prepareObjectsFinished) {
            g.setColor(0, 27, 62);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(255, 255, 255);
            g.drawString("Loading...", this.getWidth() / 2 - 10, this.getHeight() / 2, 0);
            return;
        }
        this.processor.layerManager.paint(g, 0, 0);
        this.processor.assistant.paint(g, 0, 0);
        this.processor.gauge.paint(g);
        this.processor.scoreBoard.paint(g);
        this.processor.timeZone.paint(g);
    }

    public void keyPressed(int keyCode) {
        keyCode = KeyCodeAdapter.getInstance().adoptKeyCode(keyCode);
        if (keyCode == -202 || keyCode == 209) {
            this.mid.openPauseMenu();
        }
    }

    static {
        isRunning = true;
    }
}

