/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.screens;

import com.jarbull.basket.game.BasketMidlet;
import com.jarbull.jbf.JBManager;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

public class EndGameScreen
extends Canvas
implements Runnable {
    public static final int STATE__IDLE = 0;
    public static final int STATE__WAIT = 1;
    public static final int STATE__EXIT = 2;
    public static final int TEXT_LINE_STATE__NORMAL = 0;
    public static final int TEXT_LINE_STATE__FLICKER = 1;
    private static final int CENTER = 3;
    private Vector textLines;
    Thread t;
    BasketMidlet mid;
    boolean exit;
    Displayable previousDisplay;
    boolean won;
    Image background;
    private Vector textLinesState;
    private int screenCenterX;
    private int screenCenterY;
    private int state = 0;
    private boolean flicker = true;

    public EndGameScreen(BasketMidlet mid, boolean won) {
        this.setFullScreenMode(true);
        this.mid = mid;
        this.won = won;
        this.previousDisplay = Display.getDisplay((MIDlet)mid).getCurrent();
        this.exit = false;
        if (won) {
            try {
                this.background = Image.createImage((String)"/res/img/endGame-victory.png");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            try {
                this.background = Image.createImage((String)"/res/img/endGame-defeated.png");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        this.textLines = new Vector();
        this.textLinesState = new Vector();
        this.screenCenterX = this.getWidth() / 2;
        this.screenCenterY = this.getHeight() / 2;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setNextDisplay(Displayable nextDisplay) {
        this.previousDisplay = nextDisplay;
    }

    public void addText(String text) {
        this.textLinesState.addElement(new Integer(this.state));
        this.textLines.addElement(JBManager.getInstance().getTextImage(text, "10x10-beyaz"));
    }

    public void removeTextFromEnd(int count) {
        for (int i = 0; i < count; ++i) {
            this.textLines.removeElementAt(this.textLines.size() - 1);
            this.textLinesState.removeElementAt(this.textLines.size() - 1);
        }
    }

    public void show() {
        Display.getDisplay((MIDlet)this.mid).setCurrent((Displayable)this);
        this.t = new Thread(this);
        this.t.start();
    }

    protected void paint(Graphics g) {
        g.setColor(0, 27, 62);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.drawImage(this.background, this.getWidth() / 2 - this.background.getWidth() / 2, this.getHeight() / 2 - this.background.getHeight() / 2 + 30, 0);
        g.drawImage(JBManager.getInstance().getTextImage("Press any key", "10x10-beyaz"), 0, this.getHeight() - 10, 0);
        block4: for (int i = this.textLines.size() - 1; i >= 0; --i) {
            switch ((Integer)this.textLinesState.elementAt(i)) {
                case 0: {
                    g.drawImage((Image)this.textLines.elementAt(i), this.screenCenterX, this.screenCenterY - this.textLines.size() * 5 + i * 10 + 7, 3);
                    continue block4;
                }
                case 1: {
                    if (this.flicker) continue block4;
                    g.drawImage((Image)this.textLines.elementAt(i), this.screenCenterX, this.screenCenterY - this.textLines.size() * 5 + i * 10 + 7, 3);
                }
            }
        }
    }

    public void waitForClose() {
        try {
            this.t.join();
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }

    protected void keyPressed(int keyCode) {
        if (this.state != 1) {
            this.state = 2;
        }
    }

    public void run() {
        while (true) {
            if (this.state == 2) break;
            this.repaint();
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        Display.getDisplay((MIDlet)this.mid).setCurrent(this.previousDisplay);
    }

    public void kill() {
        if (!this.exit) {
            this.exit = true;
        }
    }
}

