/*
 * Decompiled with CFR 0.152.
 */
package com.jarbull.basket.tools;

import com.jarbull.basket.tools.RandomGenerator;
import com.jarbull.basket.tools.XmlDataHolder;
import java.util.Enumeration;
import java.util.Hashtable;

public class Case {
    String name;
    int time;
    int timeStart;
    int timeEnd;
    String caseImagePath;
    String text;
    Hashtable nextCases = new Hashtable();
    String action;

    public Case() {
        this.calculateTime();
    }

    private void calculateTime() {
        this.time = RandomGenerator.getInstance().generateRandomBetween(this.timeStart, this.timeEnd);
    }

    public void setTimeEnd(int timeEnd) {
        this.timeEnd = timeEnd;
    }

    public void setTimeStart(int timeStart) {
        this.timeStart = timeStart;
    }

    public void setCaseImagePath(String caseImage) {
        this.caseImagePath = caseImage;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNextCase(Hashtable nextCases) {
        this.nextCases = nextCases;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Case next() {
        Case nextCase = new Case();
        int calculatedPercentage = RandomGenerator.getInstance().generateRandomBetween(1, 100);
        int total = 0;
        Enumeration it = this.nextCases.keys();
        while (it.hasMoreElements()) {
            String key = (String)it.nextElement();
            int percentage = Integer.parseInt((String)this.nextCases.get(key));
            if (calculatedPercentage > (total += percentage)) continue;
            nextCase = (Case)XmlDataHolder.getInstance().cases.get(key);
            return nextCase;
        }
        return null;
    }

    public String getAction() {
        return this.action;
    }

    public String getCaseImagePath() {
        return "/res/img/caseImages/" + this.caseImagePath;
    }

    public String getName() {
        return this.name;
    }

    public Hashtable getNextCases() {
        return this.nextCases;
    }

    public String getText() {
        return this.text;
    }

    public int getTime() {
        this.calculateTime();
        return this.time;
    }

    public int getTimeEnd() {
        return this.timeEnd;
    }

    public int getTimeStart() {
        return this.timeStart;
    }
}

