/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.DDDebug;
import com.ea.game.DDMath;
import com.ea.game.GameAI;
import com.ea.game.GameLogic;
import com.ea.game.MicroGame;
import com.ea.game.XMLMenuSystem;

public abstract class Controller {
    public static final int CMD_RIGHT = 0;
    public static final int CMD_DOWN_RIGHT = 1;
    public static final int CMD_DOWN = 2;
    public static final int CMD_DOWN_LEFT = 3;
    public static final int CMD_LEFT = 4;
    public static final int CMD_UP_LEFT = 5;
    public static final int CMD_UP = 6;
    public static final int CMD_UP_RIGHT = 7;
    public static final int CMD_PRIMARY_FIRE = 8;
    public static final int CMD_SECONDARY_FIRE = 9;
    public static final int CMD_STAR = 10;
    public static final int CMD_HASH = 11;
    public static final int NUM_COMMANDS = 12;
    public static final int CMD_ACTION_SINGLE_TAP = 0;
    public static final int CMD_ACTION_DOUBLE_TAP = 1;
    public static final int CMD_ACTION_LONG_PRESS = 2;
    public static final int CMD_ACTION_RELEASED = 3;
    public static final int SKIPKEYBOUNCETIME = 6;
    public int m_skipTime;
    public boolean m_skipKey;
    public boolean m_blockShoot;
    public boolean m_180turn;
    public boolean m_aerialSpecial;
    public boolean m_bargePlayer;
    public boolean m_buttonThrough;
    public boolean m_clearBall;
    public boolean m_crossBall;
    public boolean m_forceBreakAway;
    public boolean m_forcePlayerSelect;
    public boolean m_goIntoPause;
    public boolean m_gotoSetPieceMenu;
    public boolean m_hcpSprint;
    public boolean m_kickBallForwards;
    public boolean m_longGoalKick;
    public boolean m_longPress;
    public boolean m_longPressRSK;
    public boolean m_longPass;
    public boolean m_headerPass;
    public boolean m_setPieceLongPass;
    public boolean m_passBall;
    public boolean m_passBallAndRun;
    public boolean m_passBallUseAlternateTarget;
    public boolean m_passFromFreeKickByAI;
    public boolean m_hashBeenPressed;
    public boolean m_ishumankey;
    public boolean m_quickStop;
    public boolean m_shootBall;
    public boolean m_skipReplay;
    public boolean m_skipToKickOff;
    public boolean m_skipToMatchStats;
    public boolean m_skipToNextHighlight;
    public boolean m_exitMotmScreen;
    public boolean m_tappedPass;
    public boolean m_throughBall;
    public boolean m_triggerStepover;
    public boolean m_triggerTurn;
    public boolean m_homeInOnBall;
    public boolean m_crossBallIntoPenaltyArea;
    public boolean m_microGameTackle;
    public boolean m_firstTimePass;
    public boolean m_gotoTrainingMenu;
    public int m_aiTackleResult;
    public boolean m_movingCameraAlongTheTrajectoryLine;
    public int m_movingCameraAlongTheTrajectoryLineDistanceFromTarget;
    public int m_movingCameraAlongTheTrajectoryLineX;
    public int m_movingCameraAlongTheTrajectoryLineY;
    public int m_movingCameraAlongTheTrajectoryLineTimer;
    public boolean m_interrupted;
    public int m_hcpSprintTimer;
    public int m_throughBallTimer;
    public int m_throughBallState;
    public int[] m_throughBallTargetShort;
    public int[] m_throughBallTargetLong;
    public int[] m_returningOneTwoPassPlayer;
    public int[] m_playerLastPass;
    public int[] m_controlPlayer;
    public int m_controlPlayerMoveTimer;
    public int m_controlPlayerMarkingHoldFrames;
    public int m_teamID;
    public int m_joystick;
    public int m_lastJoystickWatchValue;
    public MicroGame m_microGame;
    public boolean m_defensiveHeaderClearance;
    public int m_framesSinceDefensiveHeaderTriggered;

    abstract void setupControls(int var1);

    public Controller(int n2) {
        this.m_teamID = n2;
        this.m_microGame = new MicroGame();
    }

    public void setJoystick(int n2) {
        this.m_joystick = n2;
    }

    abstract void update();

    abstract void updatePlayerSelect(boolean var1);

    abstract boolean assessNeedForPlayerSelect();

    abstract boolean isFireHeldLongEnoughForTackleMicrogame();

    public void setLastJoystick(int n2) {
        this.m_lastJoystickWatchValue = n2;
    }

    public void init() {
        this.m_skipKey = false;
        this.m_skipTime = 0;
        this.m_blockShoot = false;
        this.m_180turn = false;
        this.m_aerialSpecial = false;
        this.m_bargePlayer = false;
        this.m_buttonThrough = false;
        this.m_clearBall = false;
        this.m_crossBall = false;
        this.m_forceBreakAway = false;
        this.m_forcePlayerSelect = false;
        this.m_goIntoPause = false;
        this.m_gotoSetPieceMenu = false;
        this.m_hcpSprint = false;
        this.m_kickBallForwards = false;
        this.m_longGoalKick = false;
        this.m_longPress = false;
        this.m_longPressRSK = false;
        this.m_longPass = false;
        this.m_headerPass = false;
        this.m_setPieceLongPass = false;
        this.m_passBall = false;
        this.m_passBallAndRun = false;
        this.m_passBallUseAlternateTarget = false;
        this.m_passFromFreeKickByAI = false;
        this.m_quickStop = false;
        this.m_shootBall = false;
        this.m_skipReplay = false;
        this.m_skipToKickOff = false;
        this.m_skipToMatchStats = false;
        this.m_skipToNextHighlight = false;
        this.m_exitMotmScreen = false;
        this.m_tappedPass = false;
        this.m_throughBall = false;
        this.m_triggerStepover = false;
        this.m_triggerTurn = false;
        this.m_homeInOnBall = false;
        this.m_crossBallIntoPenaltyArea = false;
        this.m_microGameTackle = false;
        this.m_firstTimePass = false;
        this.m_hashBeenPressed = false;
        this.m_ishumankey = false;
        this.m_gotoTrainingMenu = false;
        this.m_aiTackleResult = 0;
        this.m_movingCameraAlongTheTrajectoryLine = false;
        this.m_movingCameraAlongTheTrajectoryLineDistanceFromTarget = 0;
        this.m_movingCameraAlongTheTrajectoryLineX = 0;
        this.m_movingCameraAlongTheTrajectoryLineY = 0;
        this.m_movingCameraAlongTheTrajectoryLineTimer = 0;
        this.m_interrupted = false;
        this.m_hcpSprintTimer = 0;
        this.m_throughBallTimer = 0;
        this.m_throughBallState = 0;
        this.m_throughBallTargetShort = null;
        this.m_throughBallTargetLong = null;
        this.m_returningOneTwoPassPlayer = null;
        this.m_playerLastPass = null;
        this.m_controlPlayer = null;
        this.m_controlPlayerMoveTimer = 0;
        this.m_defensiveHeaderClearance = false;
        this.m_framesSinceDefensiveHeaderTriggered = 0;
    }

    public void resetAllActions() {
        this.m_180turn = false;
        this.m_aerialSpecial = false;
        this.m_bargePlayer = false;
        this.m_clearBall = false;
        this.m_crossBall = false;
        this.m_forceBreakAway = false;
        this.m_forcePlayerSelect = false;
        this.m_kickBallForwards = false;
        this.m_longPass = false;
        this.m_headerPass = false;
        this.m_setPieceLongPass = false;
        this.m_passBall = false;
        this.m_passFromFreeKickByAI = false;
        this.m_quickStop = false;
        this.m_shootBall = false;
        this.m_throughBall = false;
        this.m_triggerTurn = false;
        this.m_firstTimePass = false;
        this.m_homeInOnBall = false;
        this.m_crossBallIntoPenaltyArea = false;
        this.m_longGoalKick = false;
        this.m_hcpSprint = false;
        this.m_defensiveHeaderClearance = false;
        this.m_framesSinceDefensiveHeaderTriggered = 0;
    }

    public void resetDefensiveActions() {
        this.m_clearBall = false;
        this.m_forcePlayerSelect = false;
        this.m_hcpSprint = false;
        this.m_homeInOnBall = false;
        this.m_microGameTackle = false;
        this.m_180turn = false;
        this.m_passBallAndRun = false;
        this.m_playerLastPass = null;
        this.m_defensiveHeaderClearance = false;
        this.m_framesSinceDefensiveHeaderTriggered = 0;
    }

    public void resetAttackingActions() {
        this.m_180turn = false;
        this.m_aerialSpecial = false;
        this.m_bargePlayer = false;
        this.m_crossBall = false;
        this.m_forceBreakAway = false;
        this.m_hcpSprint = false;
        this.m_kickBallForwards = false;
        this.m_longPass = false;
        this.m_headerPass = false;
        this.m_setPieceLongPass = false;
        this.m_passBall = false;
        this.m_passBallAndRun = false;
        this.m_passBallUseAlternateTarget = false;
        this.m_passFromFreeKickByAI = false;
        this.m_quickStop = false;
        this.m_shootBall = false;
        this.m_tappedPass = false;
        this.m_throughBall = false;
        this.m_triggerStepover = false;
        this.m_triggerTurn = false;
        this.m_crossBallIntoPenaltyArea = false;
        this.m_firstTimePass = false;
        this.m_homeInOnBall = false;
    }

    public void resetJoystick() {
        this.m_joystick = 0;
        this.m_lastJoystickWatchValue = 0;
    }

    public void resetSkipKey() {
        this.m_skipKey = false;
        this.m_skipTime = 0;
    }

    public void setSkipKey() {
        if (this.m_skipTime > 6) {
            this.m_skipKey = true;
        }
    }

    public boolean checkSkipKey() {
        if (this.m_skipKey) {
            this.resetSkipKey();
            return true;
        }
        return false;
    }

    public void updateSkipKey() {
        ++this.m_skipTime;
    }

    public void resetThroughBallTargets() {
        this.m_throughBallTargetShort = null;
        this.m_throughBallTargetLong = null;
    }

    public void updateMoveCameraAlongTheTrajectoryLine() {
        int[] nArray = GameLogic.setPieceGetCurrentTarget();
        int[] nArray2 = GameLogic.m_setPieceTaker;
        if (GameLogic.m_setPieceMode == 0) {
            nArray = GameLogic.m_setPieceTargetObject;
        }
        int n2 = DDMath.calcHorizontalDist(nArray, nArray2);
        int n3 = DDMath.calcAngle(nArray, nArray2);
        if (this.m_movingCameraAlongTheTrajectoryLine) {
            this.m_movingCameraAlongTheTrajectoryLineDistanceFromTarget += GameLogic.SET_PIECE_MANUAL_CAMERA_GROUND_SPEED;
            this.m_movingCameraAlongTheTrajectoryLineTimer = GameLogic.SET_PIECE_MANUAL_CAMERA_PAUSE;
        } else if (this.m_movingCameraAlongTheTrajectoryLineTimer <= 0) {
            this.m_movingCameraAlongTheTrajectoryLineDistanceFromTarget -= GameLogic.SET_PIECE_MANUAL_CAMERA_GROUND_SPEED;
        } else {
            --this.m_movingCameraAlongTheTrajectoryLineTimer;
        }
        this.m_movingCameraAlongTheTrajectoryLineDistanceFromTarget = DDMath.min(this.m_movingCameraAlongTheTrajectoryLineDistanceFromTarget, n2);
        this.m_movingCameraAlongTheTrajectoryLineDistanceFromTarget = DDMath.max(this.m_movingCameraAlongTheTrajectoryLineDistanceFromTarget, 0);
        this.m_movingCameraAlongTheTrajectoryLineX = nArray[0] + (DDMath.sin(n3) * this.m_movingCameraAlongTheTrajectoryLineDistanceFromTarget >> 16);
        this.m_movingCameraAlongTheTrajectoryLineY = nArray[1] + (DDMath.cos(n3) * this.m_movingCameraAlongTheTrajectoryLineDistanceFromTarget >> 16);
    }

    public void setControlPlayer(int[] nArray) {
        if (this.m_controlPlayer != nArray) {
            if (nArray == null && this.m_controlPlayer != null && this.m_controlPlayer[28] == 13) {
                GameAI.playerSetState(this.m_controlPlayer, 0, 0, 71);
            }
            this.m_forcePlayerSelect = false;
            if (nArray != GameAI.m_playerRunningOntoBall) {
                this.resetAllActions();
            }
            this.m_controlPlayer = nArray;
        }
    }

    public void initPass(int n2, int[] nArray) {
        GameLogic.m_lockPassTargetsPlayer = nArray;
        if (nArray[32] == -1 && nArray[33] == -1) {
            if (DDMath.CalcModDifference(nArray[14], nArray[22]) < 64 && GameLogic.isBallInCrossingZone(GameAI.teamGetPitchSide(nArray[12]))) {
                this.m_crossBallIntoPenaltyArea = true;
            } else if (!this.m_hashBeenPressed) {
                this.m_kickBallForwards = true;
            }
        } else {
            switch (n2) {
                case 1: {
                    this.m_tappedPass = true;
                    this.m_passBallAndRun = true;
                    DDDebug.msg("ONE_TWO_PASSING:\n\n\n\n register one-two pass, sets tapped pass and passballandrun");
                    this.m_passBallUseAlternateTarget = false;
                    break;
                }
                case 0: {
                    if (nArray[32] != -1 && this.m_throughBallTargetShort != null) {
                        this.m_tappedPass = true;
                        if (this.m_ishumankey) {
                            this.m_throughBall = XMLMenuSystem.m_tacticsPassing == 0 || this.m_hashBeenPressed;
                            this.m_passBall = XMLMenuSystem.m_tacticsPassing == 1 && !this.m_hashBeenPressed;
                        } else {
                            this.m_throughBall = true;
                        }
                        this.m_passBallUseAlternateTarget = false;
                        break;
                    }
                    if (GameLogic.m_matchState == 5 && nArray == GameLogic.m_setPieceTaker) {
                        this.m_passBall = true;
                        this.m_passBallUseAlternateTarget = false;
                        break;
                    }
                    if (this.m_hashBeenPressed) {
                        GameAI.m_forcePassToSpace = true;
                    }
                    this.m_passBall = true;
                    this.m_tappedPass = true;
                    this.m_passBallUseAlternateTarget = false;
                    break;
                }
                case 2: {
                    if (nArray[33] == -1) break;
                    this.m_passBallUseAlternateTarget = true;
                    break;
                }
                case 3: {
                    this.m_passBall = true;
                    this.m_longPass = true;
                    if (this.m_throughBallTargetLong != null) {
                        this.m_throughBall = this.m_ishumankey ? XMLMenuSystem.m_tacticsPassing == 0 || this.m_hashBeenPressed : true;
                    }
                    if (!this.m_hashBeenPressed || this.m_throughBall) break;
                    if (this.m_throughBallTargetShort != null) {
                        this.m_throughBall = true;
                        this.m_longPass = false;
                        this.m_tappedPass = true;
                        break;
                    }
                    if (nArray[33] != -1) {
                        this.m_throughBall = true;
                        int n3 = nArray[33];
                        this.m_throughBallTargetLong = GameAI.m_playerStorage[nArray[12]][n3];
                        break;
                    }
                    if (nArray[32] == -1) break;
                    this.m_throughBall = true;
                    this.m_longPass = false;
                    this.m_tappedPass = true;
                    int n4 = nArray[32];
                    this.m_throughBallTargetShort = GameAI.m_playerStorage[nArray[12]][n4];
                }
            }
            if (nArray[32] == -1) {
                this.m_passBallUseAlternateTarget = true;
            }
            this.m_playerLastPass = nArray;
        }
        if (this.m_passBallUseAlternateTarget) {
            nArray[32] = -1;
        } else {
            nArray[33] = -1;
        }
        if (this.m_passBall && GameLogic.isBallInCrossingZone(GameAI.teamGetPitchSide(GameLogic.m_possession)) && GameLogic.m_matchState == 2) {
            this.m_crossBall = true;
            this.m_passBall = false;
        }
    }

    public void microGameUpdate() {
        if (this.m_microGame.inProgress()) {
            int[] nArray = this.m_microGame.getMarkerRanges();
            if (this.m_microGame.m_type == 1) {
                this.shootBarUpdateZones(nArray);
            } else if (this.m_microGame.m_type == 0) {
                this.tackleBarUpdateZones(nArray);
            }
            this.m_microGame.update();
        }
    }

    public void shootBarUpdateZones(int[] nArray) {
        if (GameLogic.isObjectInOwnHalf(this.m_teamID, this.m_microGame.m_playerUsingMicroGame) && GameLogic.m_matchState != 8 || this.m_microGame.m_playerUsingMicroGame == null) {
            this.m_microGame.cancelMicroGame();
            return;
        }
        GameLogic.calculateNearFarGoalPostPositions(GameAI.teamGetPitchSide(this.m_teamID) ^ 1);
        int n2 = DDMath.calcHorizontalDist(this.m_microGame.m_playerUsingMicroGame, GameLogic.m_nearGoalPostX, GameLogic.m_nearGoalPostY);
        int n3 = (n2 << 8) / 19200;
        n3 = n3 * 100 >> 8;
        int n4 = this.m_microGame.m_playerUsingMicroGame[38] * 50 / 100;
        n4 = n4 * (100 - n3) / 100;
        n4 = n4 * GameLogic.m_difficultySetttingMicroGameGreenZoneScale / 100;
        n4 = GameLogic.m_gameMode == 5 ? DDMath.max(10, n4) : DDMath.max(20, n4);
        if (30 + n4 > 100) {
            n4 = 70;
        }
        if (n3 + n4 + 15 > 100) {
            n3 = 100 - (15 + n4);
        }
        if (n3 - (n4 + 15) < 0) {
            n3 = 100 - (15 + n4);
        }
        nArray[0] = 0;
        nArray[1] = n3 - n4;
        nArray[2] = 3;
        nArray[3] = n3 - n4;
        nArray[4] = n3 + n4;
        nArray[5] = 2;
        nArray[6] = n3 + n4;
        nArray[7] = 100;
        nArray[8] = 0;
    }

    public void tackleBarUpdateZones(int[] nArray) {
        if (this.m_controlPlayer != null) {
            int n2;
            int n3 = DDMath.calcHorizontalDist(this.m_controlPlayer, GameAI.m_ballStorage);
            int n4 = 100 - n3 * 100 / 1024;
            n4 += this.m_microGame.m_stat >> 1;
            if (GameAI.m_playerWithBall != null) {
                n2 = DDMath.calcAngle(GameAI.m_playerWithBall, this.m_controlPlayer);
                int n5 = DDMath.CalcModDifference(GameAI.m_playerWithBall[22], n2);
                n4 = (n4 << 8) / 180 * (180 - n5) >> 8;
            }
            n2 = 74 * n4 / 100;
            n2 = n2 * GameLogic.m_difficultySetttingMicroGameGreenZoneScale / 100;
            n2 = DDMath.max(n2, 1);
            n2 = DDMath.min(n2, 75);
            nArray[0] = 0;
            nArray[1] = 50 - n2 / 2 - 13;
            nArray[2] = 0;
            nArray[3] = 50 - n2 / 2 - 13;
            nArray[4] = 50 - n2 / 2;
            nArray[5] = 2;
            nArray[6] = 50 - n2 / 2;
            nArray[7] = 50 + n2 / 2;
            nArray[8] = 1;
            nArray[9] = 50 + n2 / 2;
            nArray[10] = 50 + n2 / 2 + 13;
            nArray[11] = 2;
            nArray[12] = 50 + n2 / 2 + 13;
            nArray[13] = 100;
            nArray[14] = 0;
        }
    }
}

