/*
 * Decompiled with CFR 0.152.
 */
package commonstuff;

import commonstuff.Circle;
import commonstuff.CommonTypes;
import commonstuff.Point;
import commonstuff.Vector2D;

public class mMath {
    static final double sq2p1 = 2.414213562373095;
    static final double sq2m1 = 0.41421356237309503;
    static final double p4 = 16.15364129822302;
    static final double p3 = 268.42548195503974;
    static final double p2 = 1153.029351540485;
    static final double p1 = 1780.406316433197;
    static final double p0 = 896.7859740366387;
    static final double q4 = 58.95697050844462;
    static final double q3 = 536.2653740312153;
    static final double q2 = 1666.7838148816338;
    static final double q1 = 2079.33497444541;
    static final double q0 = 896.7859740366387;
    static final double PIO2 = 1.5707963267948966;
    static final double nan = Double.NaN;

    private static double mxatan(double arg) {
        double argsq = arg * arg;
        double value = (((16.15364129822302 * argsq + 268.42548195503974) * argsq + 1153.029351540485) * argsq + 1780.406316433197) * argsq + 896.7859740366387;
        return (value /= ((((argsq + 58.95697050844462) * argsq + 536.2653740312153) * argsq + 1666.7838148816338) * argsq + 2079.33497444541) * argsq + 896.7859740366387) * arg;
    }

    private static double msatan(double arg) {
        if (arg < 0.41421356237309503) {
            return mMath.mxatan(arg);
        }
        if (arg > 2.414213562373095) {
            return 1.5707963267948966 - mMath.mxatan(1.0 / arg);
        }
        return 0.7853981633974483 + mMath.mxatan((arg - 1.0) / (arg + 1.0));
    }

    public static double atan(double arg) {
        if (arg > 0.0) {
            return mMath.msatan(arg);
        }
        return -mMath.msatan(-arg);
    }

    public static double atan2(double arg1, double arg2) {
        if (arg1 + arg2 == arg1) {
            if (arg1 >= 0.0) {
                return 1.5707963267948966;
            }
            return -1.5707963267948966;
        }
        arg1 = mMath.atan(arg1 / arg2);
        if (arg2 < 0.0) {
            if (arg1 <= 0.0) {
                return arg1 + Math.PI;
            }
            return arg1 - Math.PI;
        }
        return arg1;
    }

    public static double asin(double arg) {
        int sign = 0;
        if (arg < 0.0) {
            arg = -arg;
            ++sign;
        }
        if (arg > 1.0) {
            return Double.NaN;
        }
        double temp = Math.sqrt(1.0 - arg * arg);
        temp = arg > 0.7 ? 1.5707963267948966 - mMath.atan(temp / arg) : mMath.atan(arg / temp);
        if (sign > 0) {
            temp = -temp;
        }
        return temp;
    }

    public static double acos(double arg) {
        if (arg > 1.0 || arg < -1.0) {
            return Double.NaN;
        }
        return 1.5707963267948966 - mMath.asin(arg);
    }

    public static CommonTypes.Point_2 TangentPointsToCircle(Point p, Circle c) {
        Vector2D tocircle = Point.Substract(c.p, p);
        double d = p.DistanceFrom(c.p);
        Point half = new Point(p.x + d / 2.0 * tocircle.Unit().x, p.y + d / 2.0 * tocircle.Unit().y);
        CommonTypes.Point_2 tangentpoints = mMath.CircleCircleIntersection(half, d / 2.0, c.p, c.r);
        return tangentpoints;
    }

    public static CommonTypes.Vector2D_2 TangentVectorsToCircle(Point p, Circle c) {
        CommonTypes.Point_2 res = mMath.TangentPointsToCircle(p, c);
        CommonTypes.Vector2D_2 ret = new CommonTypes.Vector2D_2();
        ret.v1 = Point.Substract(res.point1, p);
        ret.v2 = Point.Substract(res.point2, p);
        return ret;
    }

    public static CommonTypes.Point_2 CircleCircleIntersection(Point p1, double r1, Point p2, double r2) {
        double d = p1.DistanceFrom(p2);
        if (d > r1 + r2) {
            return null;
        }
        if (d < Math.abs(r1 - r2)) {
            return null;
        }
        double a = (r1 * r1 - r2 * r2 + d * d) / (2.0 * d);
        double dx = p2.x - p1.x;
        double dy = p2.y - p1.y;
        double x2 = p1.x + dx * a / d;
        double y2 = p1.y + dy * a / d;
        double h = Math.sqrt(r1 * r1 - a * a);
        double rx = (0.0 - dy) * (h / d);
        double ry = dx * (h / d);
        CommonTypes.Point_2 ret = new CommonTypes.Point_2();
        ret.point1 = new Point(x2 + rx, y2 + ry);
        if (rx != 0.0 || ry != 0.0) {
            ret.point2 = new Point(x2 - rx, y2 - ry);
        }
        return ret;
    }

    public static CommonTypes.Point_2 circleLineIntersect(Point begin, Point end, Circle circle) {
        double testY;
        double testX;
        double x1 = begin.x;
        double x2 = end.x;
        double y1 = begin.y;
        double y2 = end.y;
        double cx = circle.p.x;
        double cy = circle.p.y;
        double cr = circle.r;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double a = dx * dx + dy * dy;
        double b = 2.0 * (dx * (x1 - cx) + dy * (y1 - cy));
        double c = cx * cx + cy * cy;
        c += x1 * x1 + y1 * y1;
        c -= 2.0 * (cx * x1 + cy * y1);
        double bb4ac = b * b - 4.0 * a * (c -= cr * cr);
        if (bb4ac < 0.0) {
            return null;
        }
        double mu = (-b + Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
        double ix1 = x1 + mu * dx;
        double iy1 = y1 + mu * dy;
        mu = (-b - Math.sqrt(b * b - 4.0 * a * c)) / (2.0 * a);
        double ix2 = x1 + mu * dx;
        double iy2 = y1 + mu * dy;
        if (mMath.dist(x1, y1, cx, cy) < mMath.dist(x2, y2, cx, cy)) {
            testX = x2;
            testY = y2;
        } else {
            testX = x1;
            testY = y1;
        }
        if (mMath.dist(testX, testY, ix1, iy1) < mMath.dist(x1, y1, x2, y2) || mMath.dist(testX, testY, ix2, iy2) < mMath.dist(x1, y1, x2, y2)) {
            CommonTypes.Point_2 ret = new CommonTypes.Point_2();
            ret.point1 = new Point(ix1, iy1);
            ret.point2 = new Point(ix2, iy2);
            return ret;
        }
        return null;
    }

    public static double dist(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static boolean WillCollideOnPath_Circle_Circle(Circle first, Circle second, Point goto_point) {
        Vector2D v = Point.Substract(goto_point, first.p);
        Vector2D n = new Vector2D(-v.y, v.x);
        Point start1 = Point.TranslatedAlongVector(first.p, n, first.r);
        Point start2 = Point.TranslatedAlongVector(first.p, n, -first.r);
        Point end1 = Point.TranslatedAlongVector(goto_point, n, first.r);
        Point end2 = Point.TranslatedAlongVector(goto_point, n, -first.r);
        return mMath.circleLineIntersect(start1, end1, second) != null || mMath.circleLineIntersect(start2, end2, second) != null;
    }
}

