/*
 * Decompiled with CFR 0.152.
 */
package stringstuff;

import java.util.Vector;

public class StringFunctions {
    public static String[] split(String original, String separator) {
        if (original.charAt(original.length() - 1) != separator.charAt(0)) {
            original = original.concat(separator);
        }
        Vector<String> nodes = new Vector<String>();
        int index = original.indexOf(separator);
        while (index >= 0) {
            nodes.addElement(original.substring(0, index));
            original = original.substring(index + separator.length());
            index = original.indexOf(separator);
        }
        String[] result = new String[nodes.size()];
        if (nodes.size() > 0) {
            for (int loop = 0; loop < nodes.size(); ++loop) {
                result[loop] = (String)nodes.elementAt(loop);
            }
        }
        return result;
    }

    public static String IntArrayToString(int[] data, char separator) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            ret.append(data[i]);
            ret.append(separator);
        }
        String returnS = ret.toString();
        return returnS;
    }

    public static String IntArrayArrayToString(int[][] data, char elementSeparator, char arraySeparator) {
        StringBuffer ret = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            ret.append(StringFunctions.IntArrayToString(data[i], elementSeparator));
            ret.append(arraySeparator);
        }
        String returnS = ret.toString();
        return returnS;
    }

    public static int[] SerializedNumArrayToIntArray(String data, char separator) {
        String[] p = StringFunctions.split(data, "" + separator);
        int[] ret = new int[p.length];
        for (int i = 0; i < p.length; ++i) {
            ret[i] = Integer.parseInt(p[i]);
        }
        return ret;
    }

    public static String StringArrayToString(String[] array, char separator) {
        String ret = "";
        for (int i = 0; i < array.length; ++i) {
            ret = ret + array[i] + separator;
        }
        return ret;
    }

    public static int[][] SerializedMatrixToIntArrayArray(String data, char elementSeparator, char lineSeparator) {
        String[] lines = StringFunctions.split(data, "" + lineSeparator);
        int elementLength = StringFunctions.SerializedNumArrayToIntArray(lines[0], elementSeparator).length;
        int[][] ret = new int[lines.length][elementLength];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = StringFunctions.SerializedNumArrayToIntArray(lines[i], elementSeparator);
        }
        return ret;
    }

    public static class SHA1 {
        private static int rol(int num, int cnt) {
            return num << cnt | num >>> 32 - cnt;
        }

        public static String encode(String str) {
            int i;
            byte[] x = str.getBytes();
            int[] blks = new int[((x.length + 8 >> 6) + 1) * 16];
            for (i = 0; i < x.length; ++i) {
                int n = i >> 2;
                blks[n] = blks[n] | x[i] << 24 - i % 4 * 8;
            }
            int n = i >> 2;
            blks[n] = blks[n] | 128 << 24 - i % 4 * 8;
            blks[blks.length - 1] = x.length * 8;
            int[] w = new int[80];
            int a = 1732584193;
            int b = -271733879;
            int c = -1732584194;
            int d = 271733878;
            int e = -1009589776;
            for (i = 0; i < blks.length; i += 16) {
                int olda = a;
                int oldb = b;
                int oldc = c;
                int oldd = d;
                int olde = e;
                for (int j = 0; j < 80; ++j) {
                    w[j] = j < 16 ? blks[i + j] : SHA1.rol(w[j - 3] ^ w[j - 8] ^ w[j - 14] ^ w[j - 16], 1);
                    int t = SHA1.rol(a, 5) + e + w[j] + (j < 20 ? 1518500249 + (b & c | ~b & d) : (j < 40 ? 1859775393 + (b ^ c ^ d) : (j < 60 ? -1894007588 + (b & c | b & d | c & d) : -899497514 + (b ^ c ^ d))));
                    e = d;
                    d = c;
                    c = SHA1.rol(b, 30);
                    b = a;
                    a = t;
                }
                a += olda;
                b += oldb;
                c += oldc;
                d += oldd;
                e += olde;
            }
            int[] words = new int[]{a, b, c, d, e, 0};
            byte[] base64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes();
            byte[] result = new byte[28];
            for (i = 0; i < 27; ++i) {
                int start = i * 6;
                int word = start >> 5;
                int offset = start & 0x1F;
                result[i] = offset <= 26 ? base64[words[word] >> 26 - offset & 0x3F] : (offset == 28 ? base64[((words[word] & 0xF) << 2 | words[word + 1] >> 30 & 3) & 0x3F] : base64[((words[word] & 3) << 4 | words[word + 1] >> 28 & 0xF) & 0x3F]);
            }
            result[27] = 61;
            return new String(result);
        }
    }
}

