/*
 * Decompiled with CFR 0.152.
 */
package com.magmic;

import com.magmic.DAWGReader;
import com.magmic.Font;
import com.magmic.K;
import com.magmic.MagmicFileIO;
import com.magmic.MagmicIO;
import com.magmic.MagmicStringBuffer;
import com.magmic.MessageWindow;
import com.magmic.RepeatableTileMap;
import com.magmic.Slide2D;
import com.magmic.TileSet;
import com.magmic.Window;
import com.magmic.kahuna.BoardLayer;
import com.magmic.kahuna.CorporateSplashLayer;
import com.magmic.kahuna.LevelSelectionWindow;
import com.magmic.kahuna.MainMenuLayer;
import com.magmic.kahuna.Score;
import com.magmic.maglet.Maglet;
import com.magmic.magmicSound.MagmicSound2;
import com.magmic.pykegame.FontData;
import com.magmic.pykegame.LayeredMaglet;
import com.magmic.pykegame.MagmicLayer;
import com.magmic.pykegame.StringTable;
import com.magmic.pykegame.TransitionLayer;
import com.magmic.pykegame.WindowData;
import com.magmic.slic.Slic;
import com.magmic.slic.Spr;
import com.magmic.ui.MagmicGraphics;
import com.magmic.ui.MagmicImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Random;

public class MagmicGame
extends LayeredMaglet {
    public static MagmicGame maglet;
    public StringTable strings;
    public Font systemFont;
    public WindowData systemWindowData;
    public Slic slic;
    public DAWGReader dawg;
    public Score score;
    public MagmicIO io;
    public static Random random;
    public boolean servicesInitialized;
    public MagmicFileIO fileSystem;
    public String fileSystemName;
    public static final int FILE_ID_SCORES = 0;
    public static final int FILE_ID_GAMESTATE = 1;
    public static final int FILE_ID_SETTINGS = 2;
    public static final int IO_BUFFER_SIZE = 2048;
    public byte[] ioBuffer;
    public MessageWindow menuWindow;
    public MessageWindow helpWindow;
    public MessageWindow systemWindow;
    public MagmicStringBuffer helpWindowBuffer;
    public MagmicStringBuffer genericWindowBuffer;
    public int[] confirmItems;
    public Window levelSelectWindow;
    public int bubbleCount;
    public Spr[] bubbles;
    public Slide2D[] bubblesPos;
    public TileSet tileset;
    public RepeatableTileMap map;
    public MagmicImage menuIcon;
    public MagmicImage arrowLeft;
    public MagmicImage arrowRight;
    public MagmicImage arrowUp;
    public MagmicImage arrowDown;
    public int gameMode;
    public int levelId;
    public int loadMethod;
    public int lastSelectionId;
    public boolean pressAnyKey;
    public static final int LOAD_METHOD_ROM = 0;
    public static final int LOAD_METHOD_SAVESTATE = 1;
    public static final int clipStackCapacity = 4;
    public static int clipStackSize;
    public static int[] cx;
    public static int[] cy;
    public static int[] cw;
    public static int[] ch;
    public static int music;
    public int inputMode;
    public static final int INPUT_MODE_SELECT = 0;
    public static final int INPUT_MODE_DRAG = 1;
    public static final int INPUT_MODE_MULTI = 2;
    public static final int INPUT_MODE_COUNT = 3;
    public static final int INPUT_MODE_DEFAULT = 0;
    public int volume;
    public static final int VOLUME_HIGH = 100;
    public static final int VOLUME_MEDIUM = 70;
    public static final int VOLUME_LOW = 30;
    public static final int VOLUME_NONE = 0;
    public static final int VOLUME_DEFAULT = 70;
    public int audioMode;
    public static final int AUDIO_MODE_MUSIC = 1;
    public static final int AUDIO_MODE_SOUND = 2;
    public boolean showMostRecentUnlockedFish;
    public static int debugInitStep;
    public static String debugString;
    public static boolean cheatEverythingsAWord;
    public static boolean cheatNoVolcanoCooldown;
    public static boolean cheatTimeFreeze;
    public static boolean cheatPlayAllLevels;
    public static boolean cheatSeeAllFish;
    public static final int GAME_VK_UNKNOWN = 0;
    public static final int GAME_VK_ESCAPE = 1;
    public static final int GAME_VK_LEFT = 2;
    public static final int GAME_VK_RIGHT = 3;
    public static final int GAME_VK_UP = 4;
    public static final int GAME_VK_DOWN = 5;
    public static final int GAME_VK_SELECT = 6;
    public static final int GAME_VK_HELP = 7;
    public static final int GAME_VK_LEFT_UP = 8;
    public static final int GAME_VK_RIGHT_UP = 9;
    public static final int GAME_VK_LEFT_DOWN = 10;
    public static final int GAME_VK_RIGHT_DOWN = 11;
    public static final int ROOT_LAYER_CORPORATE_SPLASH = 1;
    public static final int ROOT_LAYER_BOARD = 3;
    public static final int ROOT_LAYER_MAIN_MENU = 4;
    public static final int ROOT_LAYER_MY_FISH = 5;
    public int rootLayer;
    public TransitionLayer transition;
    int volumeBuffer;

    public void process_event_init() {
        this.setup();
        maglet = this;
        this.io = new MagmicIO();
        this.transition = new TransitionLayer(this);
        FontData fontData = new FontData();
        fontData.init(K.systemFont);
        this.systemFont = new Font(fontData);
        clipStackSize = 0;
        cx = new int[4];
        cy = new int[4];
        cw = new int[4];
        ch = new int[4];
        random = new Random(Maglet.currentTimeMillis());
        this.ioBuffer = new byte[2048];
        this.fileSystemName = "kahuna.sav";
        this.fileSystem = new MagmicFileIO(this.fileSystemName);
        this.confirmItems = new int[]{48, 49};
        this.pressAnyKey = true;
        this.loadSettings();
        this.servicesInitialized = false;
        this.changeRootLayer(1);
    }

    public void setup() {
        K.set(this);
    }

    public void init_maglet_services(int n) {
        switch (n) {
            case 0: {
                try {
                    this.slic = new Slic("/main.spk");
                }
                catch (IOException iOException) {}
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                MagmicSound2.initializeAudio(K.maxNumberOfLoadedAudioFile);
                music = -1;
                break;
            }
            case 3: {
                try {
                    Maglet.getInstance();
                    InputStream inputStream = Maglet.getResourceInputStream("/strtab.bin");
                    this.strings = new StringTable();
                    this.strings.init(inputStream);
                    inputStream.close();
                }
                catch (IOException iOException) {}
                break;
            }
            case 4: {
                this.systemWindowData = new WindowData();
                this.systemWindowData.init(K.systemWindow);
                break;
            }
            case 5: {
                this.menuWindow = new MessageWindow(this);
                this.menuWindow.init_fully();
                this.menuWindow.setupPykeWindow(this.systemWindowData, 1);
                this.helpWindow = new MessageWindow(this);
                this.helpWindow.init_fully();
                this.helpWindow.setupFillRect(895963, 34755, 1, 5);
                this.helpWindow.setSizeAndCenter(K.helpWindowWidth, K.helpWindowHeight, K.windowPolicy);
                this.systemWindow = new MessageWindow(this);
                this.systemWindow.init_fully();
                this.systemWindow.setupPykeWindow(this.systemWindowData, 1);
                this.systemWindow.setSizeAndCenter(K.systemWindowWidth, K.systemWindowHeight, K.windowPolicy);
                this.systemWindow.setupTransition(2, 500, 2, 0, true);
                this.levelSelectWindow = new LevelSelectionWindow(maglet);
                this.levelSelectWindow.init_fully();
                this.levelSelectWindow.setupPykeWindow(MagmicGame.maglet.systemWindowData, 1);
                this.levelSelectWindow.setTitle(MagmicGame.maglet.systemFont, "Level Selection");
                this.levelSelectWindow.setSizeAndCenter(K.standardWindowWidth, K.standardWindowHeight, K.windowPolicy);
                this.levelSelectWindow.setupTransition(2, 500, 0, 0, true);
                this.helpWindowBuffer = new MagmicStringBuffer(2048);
                this.genericWindowBuffer = new MagmicStringBuffer(2048);
                break;
            }
            case 6: {
                this.dawg = new DAWGReader();
                this.dawg.init(Maglet.getResourceInputStream("/dictionary.dawg"));
                break;
            }
            case 7: {
                this.score = new Score();
                this.score.load(this.fileSystem, 0);
                break;
            }
            case 8: {
                this.bubbleCount = 5;
                this.bubbles = new Spr[this.bubbleCount];
                this.bubblesPos = new Slide2D[this.bubbleCount];
                for (int i = 0; i < this.bubbleCount; ++i) {
                    this.bubblesPos[i] = new Slide2D();
                    boolean bl = i % 2 == 0;
                    this.bubbles[i] = new Spr(MagmicGame.maglet.slic, bl ? K.spriteBubble : K.spriteBubble2);
                    this.bubbles[i].setSeq(bl ? K.spriteBubbleDefaultSeq : K.spriteBubble2DefaultSeq);
                    this.initBubble(i);
                }
                break;
            }
            case 9: {
                this.tileset = new TileSet();
                this.tileset.set(MagmicGame.loadMagmicImage(K.tileset), K.tileW, K.tileH);
                this.map = new RepeatableTileMap();
                this.map.tiles = this.tileset;
                this.map.nCol = 8;
                this.map.nRow = 8;
                this.map.offsetX = 0;
                this.map.offsetY = this.get_height() - this.map.nRow * this.tileset.th;
                this.map.repeatableBottomRows = 0;
                this.map.repeatableLeftCols = 0;
                this.map.repeatableRightCols = 2;
                this.map.repeatableTopRows = 1;
                this.map.map = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 4, 5, 2, 6, 7, 0, 0, 0, 14, 16, 1, 15, 8, 13, 0, 12, 17, 9, 10, 0, 0, 21, 22, 20, 18, 16, 24, 23, 23, 26, 27, 20, 19, 11, 25, 28, 28, 29, 28};
                break;
            }
            case 10: {
                this.fullscreenBackbuffer = new MagmicImage(this.get_width(), this.get_height());
                this.fullscreenBackbufferGraphics = this.fullscreenBackbuffer.getGraphics();
                this.repaintFullscreenBackbuffer = true;
                break;
            }
            case 11: {
                this.menuIcon = MagmicGame.loadMagmicImage(K.menuSelectionIcon);
                break;
            }
            case 12: {
                this.arrowLeft = MagmicGame.loadMagmicImage(K.arrowLeft);
                break;
            }
            case 13: {
                this.arrowRight = MagmicGame.loadMagmicImage(K.arrowRight);
                break;
            }
            case 14: {
                this.arrowUp = MagmicGame.loadMagmicImage(K.arrowUp);
                break;
            }
            case 15: {
                this.arrowDown = MagmicGame.loadMagmicImage(K.arrowDown);
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                MagmicGame.maglet.servicesInitialized = true;
            }
        }
    }

    public int getNumberOfInitSteps() {
        return 18;
    }

    public void post_process_event(int n, int n2, int n3, Object object) {
        switch (n) {
            case 1: {
                MagmicGraphics magmicGraphics = (MagmicGraphics)object;
                magmicGraphics.setClip(0, 0, this.get_width(), this.get_height());
                if (this.is_layer_visible(this.transition)) break;
                maglet.paintBubbles(magmicGraphics);
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.pauseMusic();
                break;
            }
            case 6: {
                this.resumeMusic();
                break;
            }
            case 7: {
                this.releaseMusic();
            }
        }
    }

    public void pre_process_event(int n, int n2, int n3, Object object) {
        switch (n) {
            case 1: {
                if (this.fullscreenBackbuffer == null || !this.repaintFullscreenBackbuffer) break;
                maglet.paintBackground(MagmicGame.maglet.fullscreenBackbufferGraphics);
            }
        }
    }

    public int get_game_key(int n, int n2, int n3, Object object) {
        this.lastGetGameKeyRepeat = 1;
        if (n == 8 || n == 9) {
            int n4 = this.getGameAction(n2);
            switch (n4) {
                case 29: 
                case 30: {
                    return 1;
                }
                case 6: {
                    return 5;
                }
                case 1: {
                    return 4;
                }
                case 2: {
                    return 2;
                }
                case 5: {
                    return 3;
                }
                case 8: {
                    return 6;
                }
                case 31: {
                    return 7;
                }
            }
            switch (n2) {
                case 49: {
                    return 8;
                }
                case 51: {
                    return 9;
                }
                case 55: {
                    return 10;
                }
                case 57: {
                    return 11;
                }
            }
            return 0;
        }
        if (n == 23) {
            int n5 = n2;
            int n6 = n3;
            if (Math.abs(n5) > Math.abs(n6)) {
                this.lastGetGameKeyRepeat = Math.abs(n5);
                return n5 < 0 ? 2 : 3;
            }
            this.lastGetGameKeyRepeat = Math.abs(n6);
            return n6 < 0 ? 4 : 5;
        }
        if (n == 21 || n == 22) {
            return 6;
        }
        return -1;
    }

    public static int get_key_letters(int n, char[] cArray, boolean bl) {
        int n2 = 0;
        if (n == -1) {
            return 0;
        }
        switch (n) {
            case 48: {
                if (!bl) break;
                cArray[n2++] = 48;
                break;
            }
            case 49: {
                if (!bl) break;
                cArray[n2++] = 49;
                cArray[n2++] = 46;
                cArray[n2++] = 44;
                cArray[n2++] = 64;
                cArray[n2++] = 95;
                cArray[n2++] = 45;
                cArray[n2++] = 32;
                break;
            }
            case 50: {
                cArray[n2++] = 97;
                cArray[n2++] = 98;
                cArray[n2++] = 99;
                if (!bl) break;
                cArray[n2++] = 50;
                break;
            }
            case 51: {
                cArray[n2++] = 100;
                cArray[n2++] = 101;
                cArray[n2++] = 102;
                if (!bl) break;
                cArray[n2++] = 51;
                break;
            }
            case 52: {
                cArray[n2++] = 103;
                cArray[n2++] = 104;
                cArray[n2++] = 105;
                if (!bl) break;
                cArray[n2++] = 52;
                break;
            }
            case 53: {
                cArray[n2++] = 106;
                cArray[n2++] = 107;
                cArray[n2++] = 108;
                if (!bl) break;
                cArray[n2++] = 53;
                break;
            }
            case 54: {
                cArray[n2++] = 109;
                cArray[n2++] = 110;
                cArray[n2++] = 111;
                if (!bl) break;
                cArray[n2++] = 54;
                break;
            }
            case 55: {
                cArray[n2++] = 112;
                cArray[n2++] = 113;
                cArray[n2++] = 114;
                cArray[n2++] = 115;
                if (!bl) break;
                cArray[n2++] = 55;
                break;
            }
            case 56: {
                cArray[n2++] = 116;
                cArray[n2++] = 117;
                cArray[n2++] = 118;
                if (!bl) break;
                cArray[n2++] = 56;
                break;
            }
            case 57: {
                cArray[n2++] = 119;
                cArray[n2++] = 120;
                cArray[n2++] = 121;
                cArray[n2++] = 122;
                if (!bl) break;
                cArray[n2++] = 57;
            }
        }
        return n2;
    }

    public int invert_orientation(int n) {
        if (n == 5) {
            return 3;
        }
        if (n == 4) {
            return 2;
        }
        if (n == 2) {
            return 4;
        }
        if (n == 3) {
            return 5;
        }
        return n;
    }

    public static int rand() {
        return random.nextInt() & 0x7FFFFFF;
    }

    public void changeRootLayer(int n) {
        this.rootLayer = n;
        MagmicLayer magmicLayer = null;
        switch (n) {
            case 1: {
                magmicLayer = new CorporateSplashLayer(this);
                break;
            }
            case 3: {
                magmicLayer = new BoardLayer(this);
                break;
            }
            case 4: {
                magmicLayer = new MainMenuLayer(this);
            }
        }
        this.transition.fill_color = 0;
        this.transition.progress_fill_color = this.transition.progress_border_color = 0xFFFFFF;
        this.transition.startTransition(magmicLayer, true, true);
    }

    public static MagmicImage loadMagmicImage(String string) {
        MagmicImage magmicImage = MagmicImage.loadMagmicImage(string);
        return magmicImage;
    }

    public static void pushClip(MagmicGraphics magmicGraphics) {
        MagmicGame.cx[MagmicGame.clipStackSize] = magmicGraphics.getClipX();
        MagmicGame.cy[MagmicGame.clipStackSize] = magmicGraphics.getClipY();
        MagmicGame.cw[MagmicGame.clipStackSize] = magmicGraphics.getClipWidth();
        MagmicGame.ch[MagmicGame.clipStackSize] = magmicGraphics.getClipHeight();
        ++clipStackSize;
    }

    public static void popClip(MagmicGraphics magmicGraphics) {
        magmicGraphics.setClip(cx[--clipStackSize], cy[clipStackSize], cw[clipStackSize], ch[clipStackSize]);
    }

    public void showSystemMessage(String string, MagmicLayer magmicLayer, int n) {
        if (n == -1) {
            MagmicGame.maglet.systemWindow.setTitle(MagmicGame.maglet.systemFont, null);
        } else {
            MagmicGame.maglet.systemWindow.setTitle(MagmicGame.maglet.systemFont, n);
        }
        this.genericWindowBuffer.clear();
        this.genericWindowBuffer.append(string);
        this.showSystemMessage(this.genericWindowBuffer.chars, 0, this.genericWindowBuffer.length, magmicLayer);
    }

    public void showSystemMessage(int n, MagmicLayer magmicLayer, int n2) {
        if (n2 == -1) {
            MagmicGame.maglet.systemWindow.setTitle(MagmicGame.maglet.systemFont, null);
        } else {
            MagmicGame.maglet.systemWindow.setTitle(MagmicGame.maglet.systemFont, n2);
        }
        this.genericWindowBuffer.clear();
        if (n == 9) {
            this.strings.append_string(n, this.genericWindowBuffer);
            this.genericWindowBuffer.append(maglet.getAppProperty("MIDlet-Version"));
            this.strings.append_string(10, this.genericWindowBuffer);
            this.showSystemMessage(this.genericWindowBuffer.chars, 0, this.genericWindowBuffer.length, magmicLayer);
        } else {
            this.strings.append_string(n, this.genericWindowBuffer);
            this.showSystemMessage(this.genericWindowBuffer.chars, 0, this.genericWindowBuffer.length, magmicLayer);
        }
    }

    public void showSystemMessage(char[] cArray, int n, int n2, MagmicLayer magmicLayer) {
        this._initSystemMessageBounds();
        this.systemWindow.setupMessage(MagmicGame.maglet.systemFont, cArray, n, n2);
        this.systemWindow.setuptNoOptions();
        this.systemWindow.closeOnConfirmOption = true;
        this.systemWindow.open(magmicLayer);
    }

    public void showSystemConfirmation(String string, MagmicLayer magmicLayer) {
        this.genericWindowBuffer.clear();
        this.genericWindowBuffer.append(string);
        this.showSystemConfirmation(this.genericWindowBuffer.chars, 0, this.genericWindowBuffer.length, magmicLayer);
    }

    public void showSystemConfirmation(int n, MagmicLayer magmicLayer) {
        this.genericWindowBuffer.clear();
        this.strings.append_string(n, this.genericWindowBuffer);
        this.showSystemConfirmation(this.genericWindowBuffer.chars, 0, this.genericWindowBuffer.length, magmicLayer);
    }

    public void showSystemConfirmation(char[] cArray, int n, int n2, MagmicLayer magmicLayer) {
        this._initSystemMessageBounds();
        this.systemWindow.setupMessage(MagmicGame.maglet.systemFont, cArray, n, n2);
        this.systemWindow.setupOptions(this.confirmItems, 0, 2, this.confirmItems[1], this.confirmItems[1], 2, false);
        this.systemWindow.closeOnConfirmOption = true;
        this.systemWindow.open(magmicLayer);
    }

    public void _initSystemMessageBounds() {
        this.systemWindow.setSizeAndCenter(K.systemWindowWidth, K.systemWindowHeight, K.windowPolicy);
    }

    public void paintBackground(MagmicGraphics magmicGraphics) {
        this.map.paint(magmicGraphics, 0, 0, this.get_width(), this.get_height());
    }

    public void paintBubbles(MagmicGraphics magmicGraphics) {
        for (int i = 0; i < this.bubbleCount; ++i) {
            this.bubbles[i].paint(magmicGraphics, this.bubblesPos[i].getX(), this.bubblesPos[i].getY());
        }
    }

    public boolean tickBubbles(int n) {
        for (int i = 0; i < this.bubbleCount; ++i) {
            this.bubbles[i].calc(n);
            this.bubblesPos[i].tick(n);
            if (this.bubblesPos[i].getY() >= -this.bubbles[i].get_curr_frame_h()) continue;
            this.initBubble(i);
        }
        return true;
    }

    public void initBubble(int n) {
        int n2 = maglet.get_width();
        int n3 = maglet.get_height();
        short s = this.bubbles[n].get_curr_frame_w();
        int n4 = MagmicGame.rand() % (n2 + 2 * s) - s;
        int n5 = n3 + MagmicGame.rand() % n3;
        int n6 = MagmicGame.rand() % 7000 + 3000;
        this.bubblesPos[n].init(n4, n5, n4, -n3, n6);
    }

    public void appendTime(int n, MagmicStringBuffer magmicStringBuffer) {
        int n2 = (n /= 1000) % 60;
        int n3 = (n /= 60) % 60;
        int n4 = n /= 60;
        if (n4 > 0) {
            magmicStringBuffer.append(n4, 2, '0');
            magmicStringBuffer.append(':');
        }
        magmicStringBuffer.append(n3, 2, '0');
        magmicStringBuffer.append(':');
        magmicStringBuffer.append(n2, 2, '0');
    }

    public void parseAppendStringId(MagmicStringBuffer magmicStringBuffer, int n) {
        MagmicStringBuffer magmicStringBuffer2 = MagmicStringBuffer.global_buffer;
        magmicStringBuffer2.clear();
        magmicStringBuffer2.append(magmicStringBuffer.chars, 0, magmicStringBuffer.length);
        int n2 = -1;
        for (int i = 0; i < magmicStringBuffer2.length - 1 && n2 == -1; ++i) {
            if (magmicStringBuffer2.chars[i] != '$' || magmicStringBuffer2.chars[i + 1] != 'X') continue;
            n2 = i;
        }
        if (n2 != -1) {
            magmicStringBuffer.clear();
            magmicStringBuffer.append(magmicStringBuffer2.chars, 0, n2);
            this.strings.append_string(n, magmicStringBuffer);
            magmicStringBuffer.append(magmicStringBuffer2.chars, n2 + 2, magmicStringBuffer2.length - n2 - 2);
        }
    }

    public void parseAppendInt(MagmicStringBuffer magmicStringBuffer, int n) {
        MagmicStringBuffer magmicStringBuffer2 = MagmicStringBuffer.global_buffer;
        magmicStringBuffer2.clear();
        magmicStringBuffer2.append(magmicStringBuffer.chars, 0, magmicStringBuffer.length);
        int n2 = -1;
        for (int i = 0; i < magmicStringBuffer2.length - 1 && n2 == -1; ++i) {
            if (magmicStringBuffer2.chars[i] != '$' || magmicStringBuffer2.chars[i + 1] != 'X') continue;
            n2 = i;
        }
        if (n2 != -1) {
            magmicStringBuffer.clear();
            magmicStringBuffer.append(magmicStringBuffer2.chars, 0, n2);
            magmicStringBuffer.append(n);
            magmicStringBuffer.append(magmicStringBuffer2.chars, n2 + 2, magmicStringBuffer2.length - n2 - 2);
        }
    }

    public void parseAppendString(MagmicStringBuffer magmicStringBuffer, String string) {
        MagmicStringBuffer magmicStringBuffer2 = MagmicStringBuffer.global_buffer;
        magmicStringBuffer2.clear();
        magmicStringBuffer2.append(magmicStringBuffer.chars, 0, magmicStringBuffer.length);
        int n = -1;
        for (int i = 0; i < magmicStringBuffer2.length - 1 && n == -1; ++i) {
            if (magmicStringBuffer2.chars[i] != '$' || magmicStringBuffer2.chars[i + 1] != 'X') continue;
            n = i;
        }
        if (n != -1) {
            magmicStringBuffer.clear();
            magmicStringBuffer.append(magmicStringBuffer2.chars, 0, n);
            magmicStringBuffer.append(string);
            magmicStringBuffer.append(magmicStringBuffer2.chars, n + 2, magmicStringBuffer2.length - n - 2);
        }
    }

    public static void sleep(long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void saveSettings() {
        this.io.bind(this.ioBuffer, 0, 2048);
        this.io.write_s32(this.inputMode);
        this.io.write_s32(this.volume);
        this.io.write_s32(this.audioMode);
        this.io.write_s8((byte)(this.showMostRecentUnlockedFish ? 1 : 0));
        try {
            this.fileSystem.save(2, this.ioBuffer, 0, this.io.pointer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void loadSettings() {
        if (this.fileSystem.load(2, this.ioBuffer, 0) != 0) {
            this.io.bind(this.ioBuffer, 0, this.ioBuffer.length);
            this.inputMode = this.io.read_s32();
            this.volume = this.io.read_s32();
            this.audioMode = this.io.read_s32();
            this.showMostRecentUnlockedFish = this.io.read_s8() != 0;
        } else {
            this.inputMode = 0;
            this.volume = 70;
            this.audioMode = 1;
            this.showMostRecentUnlockedFish = false;
        }
        boolean bl = MagmicSound2.isSoundEnabled();
        if (bl && this.volume == 0) {
            this.volume = 70;
        }
        if (!bl) {
            this.volume = 0;
            MagmicSound2.setSoundEnabled(true);
        }
    }

    public void cycleVolume() {
        switch (this.volume) {
            case 100: {
                this.volume = 0;
                break;
            }
            case 70: {
                this.volume = 100;
                break;
            }
            case 30: {
                this.volume = 70;
                break;
            }
            case 0: {
                this.volume = 30;
            }
        }
        maglet.saveSettings();
        this.updateMusicVolume();
    }

    public void cycleAudioMode() {
        boolean bl;
        boolean bl2 = (this.audioMode & 1) != 0;
        boolean bl3 = bl = (this.audioMode & 2) != 0;
        this.audioMode = bl2 & bl ? 2 : (bl2 ? 2 : 1);
        maglet.saveSettings();
    }

    public int getVolumeLabelId() {
        switch (this.volume) {
            case 100: {
                return 59;
            }
            case 70: {
                return 58;
            }
            case 30: {
                return 57;
            }
            case 0: {
                return 56;
            }
        }
        return 56;
    }

    public int getAudioModeLabelId() {
        boolean bl;
        boolean bl2 = (this.audioMode & 1) != 0;
        boolean bl3 = bl = (this.audioMode & 2) != 0;
        if (bl2 && bl) {
            return 65;
        }
        if (bl2) {
            return 63;
        }
        return 64;
    }

    public void loadAndPlayRandomBackgroundMusic() {
        if (K.numberOfBackgroundMusic > 0) {
            this.releaseMusic();
            int n = maglet.rand() % K.numberOfBackgroundMusic;
            this.setMusic(K.getBackgroundMusicFilename(n));
            this.playMusic();
        }
    }

    public void setMusic(String string) {
        music = MagmicSound2.addAudio(string);
    }

    public void releaseMusic() {
        if (music != -1) {
            MagmicSound2.stopAudio();
            MagmicSound2.freeAudio(music);
            music = -1;
        }
    }

    public void pauseMusic() {
        if (music != -1) {
            MagmicSound2.pauseAudio();
        }
    }

    public void resumeMusic() {
        if (music != -1) {
            MagmicSound2.resumeAudio();
        }
    }

    public void playMusic() {
        if (music != -1) {
            MagmicSound2.playAudio(music, -1, MagmicGame.maglet.volume);
        }
    }

    public void updateMusicVolume() {
        if (music != -1) {
            MagmicSound2.stopAudio();
            MagmicSound2.playAudio(music, -1, MagmicGame.maglet.volume);
        }
    }

    public int loadSound(String string) {
        if (string == null) {
            return -1;
        }
        return MagmicSound2.addAudio(string);
    }

    public void playSound(int n) {
        if (n != -1) {
            MagmicSound2.playAudio(n, 1, MagmicGame.maglet.volume);
        }
    }

    public void releaseSound(int n) {
        if (n != -1) {
            MagmicSound2.freeAudio(n);
        }
    }

    public void push_layer(MagmicLayer magmicLayer, boolean bl, boolean bl2, boolean bl3, boolean bl4, byte by) {
        super.push_layer(magmicLayer, bl, bl2, bl3, bl4, by);
        if (this.rootLayer == 5) {
            this.repaintFullscreenBackbuffer = true;
        }
    }

    public void remove_layer(MagmicLayer magmicLayer, boolean bl) {
        super.remove_layer(magmicLayer, bl);
        if (this.rootLayer == 5) {
            this.repaintFullscreenBackbuffer = true;
        }
    }
}

