/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.maglet;

import com.magmic.maglet.Event;
import com.magmic.maglet.MagletGameCanvas;
import com.magmic.magmicSound.MagmicSound2;
import com.magmic.magmicSound.ui.MagmicSoundPrompt;
import com.magmic.net.NetClientListener;
import com.magmic.ui.MagmicGraphics;
import com.magmic.ui.MagmicSplash2;
import com.magmic.ui.MagmicSplashInterface;
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public abstract class Maglet
extends MIDlet
implements Runnable,
NetClientListener {
    public static final int PAINT = 1;
    public static final int TIMER = 2;
    public static final int TICK = 3;
    public static final int INIT = 4;
    public static final int PAUSE = 5;
    public static final int RESUME = 6;
    public static final int SHUTDOWN = 7;
    public static final int KEYUP = 8;
    public static final int KEYDOWN = 9;
    public static final int KEYREPEAT = 10;
    public static final int TRACKWHEELCLICK = 11;
    public static final int TRACKWHEELUNCLICK = 12;
    public static final int TRACKWHEELSCROLL = 13;
    public static final int CLOSEMODAL = 15;
    public static final int IDLE = 16;
    public static final int STARTUPREGCHECK = 17;
    public static final int MENU = 18;
    public static final int NETCLIENT = 19;
    public static final int SOUND = 20;
    public static final int CLICK = 21;
    public static final int UNCLICK = 22;
    public static final int MOVEMENT = 23;
    public static final int POINTERDOWN = 25;
    public static final int POINTERUP = 26;
    public static final int POINTERDRAG = 27;
    public static final int USERDEFINED = 28;
    public static final int NUM_USER_DEFINED = 10;
    public static final int MAX_TYPES = 38;
    private static final int[] POST_LIMIT;
    public static final int LOW_PRIORITY = 1;
    public static final int LOW_MEDIUM_PRIORITY = 4;
    public static final int MEDIUM_PRIORITY = 8;
    public static final int MEDIUM_HIGH_PRIORITY = 12;
    public static final int HIGH_PRIORITY = 15;
    public static final int KEY_PRIORITY = 8;
    public static final int PAINT_PRIORITY = 15;
    public static final int TICK_PRIORITY = 1;
    MagmicSoundPrompt magmicsound2prompt;
    MagmicSplashInterface magmicSplash;
    public static final byte STATE_INIT = 0;
    public static final byte STATE_CUSTOMPRESPLASH = 1;
    public static final byte STATE_MAGMICSPLASH = 2;
    public static final byte STATE_REGISTRATIONSPLASH = 3;
    public static final byte STATE_REGISTRATION = 4;
    public static final byte STATE_SOUNDPROMPT = 5;
    public static final byte STATE_LANGUAGEPROMPT = 6;
    public static final byte STATE_GAME = 7;
    private static byte state;
    private boolean startUpRegCheckInit = false;
    public static final int QUEUE_SIZE;
    public static final int MAX_TIMERS = 16;
    public static final int ML_VK_UP = 1;
    public static final int ML_VK_DOWN = 6;
    public static final int ML_VK_LEFT = 2;
    public static final int ML_VK_RIGHT = 5;
    public static final int ML_VK_FIRE = 8;
    public static final int ML_VK_ESCAPE = 29;
    public static final int ML_VK_GAME_A = 9;
    public static final int ML_VK_GAME_B = 10;
    public static final int ML_VK_GAME_C = 11;
    public static final int ML_VK_GAME_D = 12;
    public static final int ML_VK_0 = 48;
    public static final int ML_VK_1 = 49;
    public static final int ML_VK_2 = 50;
    public static final int ML_VK_3 = 51;
    public static final int ML_VK_4 = 52;
    public static final int ML_VK_5 = 53;
    public static final int ML_VK_6 = 54;
    public static final int ML_VK_7 = 55;
    public static final int ML_VK_8 = 56;
    public static final int ML_VK_9 = 57;
    public static final int ML_VK_POUND = 35;
    public static final int ML_VK_STAR = 42;
    public static final int ML_VK_SOFTKEY_LEFT = 30;
    public static final int ML_VK_SOFTKEY_RIGHT = 31;
    private static final Object mutex;
    private static final Object timerMutex;
    private static final Object invalidRegionMutex;
    static final Object processEventMutex;
    protected MagletGameCanvas theGameCanvas;
    private MagmicGraphics theGraphics;
    private boolean alreadyInit;
    private boolean running;
    boolean initEventProcessed = false;
    private boolean keyEventsEnabled;
    private boolean idleEventsEnabled;
    private boolean tickEventsEnabled;
    private long idleDelay;
    private boolean invalidRegionExists;
    int clipX;
    int clipY;
    int clipW;
    int clipH;
    private int timers;
    private boolean[] timerIsActive = new boolean[16];
    private boolean[] timerIsRepeating = new boolean[16];
    private long[] timerInterval = new long[16];
    private long[] timerLastEvent = new long[16];
    private int[] timerID = new int[16];
    private Event currentEvent = null;
    private boolean cancelCurrentTimer = false;
    private long tickInterval;
    private long tickLastEvent;
    private int runCount = 0;
    private static Maglet _instance;
    private int lastEventPriority;
    private long lastEventPostedTime;
    private int frameCount = 0;
    private long frameRate = 0L;
    private long frameTimeStart = 0L;
    private Thread theMagletThread;
    public boolean paused = false;
    private static long previousTime;
    private static long deltaTime;
    private static final long SKEW_TIME = 0L;
    private static char[] letters;

    public MagletGameCanvas getMagletGameCanvas() {
        return this.theGameCanvas;
    }

    public Maglet() {
        _instance = this;
        state = 0;
        this.theGameCanvas = new MagletGameCanvas();
        this.theGraphics = new MagmicGraphics(this.theGameCanvas.getGraphics());
        this.theGraphics.setColor(0);
        this.theGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Graphics graphics = this.theGraphics.getGraphics();
        Event.initPriorityQueue(QUEUE_SIZE);
        this.magmicsound2prompt = new MagmicSoundPrompt(this);
        this.magmicSplash = new MagmicSplash2();
    }

    public static Maglet getInstance() {
        return _instance;
    }

    public static int getState() {
        return state;
    }

    public abstract boolean processEvent(int var1, int var2, int var3, Object var4);

    private void nextState() {
        state = (byte)(state + 1);
        switch (state) {
            case 1: {
                state = (byte)(state + 1);
            }
            case 2: {
                this.magmicSplash.processEvent(4, -1, -1, null);
                break;
            }
            case 3: {
                state = (byte)(state + 1);
            }
            case 4: {
                state = (byte)(state + 1);
            }
            case 5: {
                this.magmicsound2prompt.processEvent(4, -1, -1, null);
                break;
            }
            case 6: {
                state = (byte)(state + 1);
            }
            case 7: {
                this.processEvent(4, -1, -1, null);
            }
        }
    }

    public boolean processEventState(int n, int n2, int n3, Object object) {
        boolean bl = false;
        switch (state) {
            case 2: {
                bl = this.magmicSplash.processEvent(n, n2, n3, object);
                if (bl) break;
                this.magmicSplash.processEvent(7, -1, -1, null);
                this.magmicSplash = null;
                System.gc();
                Thread.yield();
                this.nextState();
                break;
            }
            case 5: {
                bl = this.magmicsound2prompt.processEvent(n, n2, n3, object);
                Maglet maglet = this;
                if (maglet.magmicsound2prompt.getState() == 0) break;
                this.magmicsound2prompt.processEvent(7, -1, -1, null);
                this.magmicsound2prompt = null;
                System.gc();
                Thread.yield();
                this.nextState();
                break;
            }
            case 7: {
                bl = this.processEvent(n, n2, n3, object);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (++this.runCount > 1) {
            this.postEvent(1, -1, -1, this.theGraphics, 15);
        }
        if (this.runCount == 1) {
            this.init2();
        }
        long l = Maglet.currentTimeMillis();
        boolean bl = false;
        boolean bl2 = false;
        long l2 = Long.MAX_VALUE;
        int n = 16;
        long l3 = Maglet.currentTimeMillis();
        this.frameTimeStart = Maglet.currentTimeMillis();
        this.running = true;
        block35: while (this.running) {
            Object object;
            if (this.paused) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            if (!Event.isEmpty()) {
                while (!Event.isEmpty()) {
                    Object object2;
                    block51: {
                        if (this.paused) continue block35;
                        this.currentEvent = Event.remove();
                        object = this.currentEvent;
                        if (((Event)object).type == 9 || ((Event)object).type == 8 || ((Event)object).type == 10) {
                            ((Event)object).paramObj = this.getKeyChars(((Event)object).paramInt1);
                        }
                        n = ((Event)object).type;
                        this.lastEventPriority = ((Event)object).priority;
                        this.lastEventPostedTime = ((Event)object).postedTime;
                        if (this.keyEventsEnabled || ((Event)object).type != 8 && ((Event)object).type != 9 && ((Event)object).type != 10) {
                            if (((Event)object).type == 1) {
                                this.theGraphics.setClip(this.clipX, this.clipY, this.clipW, this.clipH);
                            }
                            try {
                                if (((Event)object).type != 4 && !this.initEventProcessed) break block51;
                                if (((Event)object).type == 6) {
                                    try {
                                        Thread.sleep(1000L);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                object2 = processEventMutex;
                                synchronized (object2) {
                                    if (((Event)object).type == 4 && state == 0) {
                                        this.nextState();
                                        bl = true;
                                    } else {
                                        bl = this.processEventState(((Event)object).type, ((Event)object).paramInt1, ((Event)object).paramInt2, ((Event)object).paramObj);
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    switch (((Event)object).type) {
                        case 2: {
                            if (!this.cancelCurrentTimer && this.timerIsRepeating[((Event)object).paramInt1]) break;
                            object2 = timerMutex;
                            synchronized (object2) {
                                this.cancelCurrentTimer = false;
                                this.timerIsActive[((Event)object).paramInt1] = false;
                            }
                            Event.removeAllOfType(2, ((Event)object).paramInt1, this.timerID[((Event)object).paramInt1]);
                            break;
                        }
                        case 4: {
                            this.invalidateScreen();
                            this.initEventProcessed = true;
                            break;
                        }
                        case 6: {
                            break;
                        }
                        case 5: {
                            object2 = mutex;
                            synchronized (object2) {
                                try {
                                    mutex.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                                break;
                            }
                        }
                        case 17: {
                            this.startUpRegCheck();
                            break;
                        }
                        case 7: {
                            this.running = false;
                            this.notifyDestroyed();
                            return;
                        }
                        case 15: {
                            break;
                        }
                        case 1: {
                            this.theGameCanvas.flushGraphics(this.clipX, this.clipY, this.clipW, this.clipH);
                            ++this.frameCount;
                            object2 = invalidRegionMutex;
                            synchronized (object2) {
                                this.invalidRegionExists = false;
                                break;
                            }
                        }
                    }
                    this.handleInvalidRegion();
                    l2 = this.processTicksAndTimers();
                }
            }
            long l4 = Maglet.currentTimeMillis();
            long l5 = l4 - l3;
            l3 = l4;
            this.currentEvent = null;
            if (Event.isEmpty() && this.idleEventsEnabled && (n != 16 || l5 >= this.idleDelay)) {
                this.postEvent(16, -1, -1, null, 1);
            }
            object = mutex;
            synchronized (object) {
                this.handleInvalidRegion();
                l2 = this.processTicksAndTimers();
                if (Event.isEmpty()) {
                    try {
                        if (this.idleEventsEnabled && this.idleDelay < l2) {
                            l2 = this.idleDelay;
                        }
                        if (l2 > 0L) {
                            mutex.wait(l2);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        --this.runCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleInvalidRegion() {
        boolean bl = false;
        Object object = invalidRegionMutex;
        synchronized (object) {
            bl = this.invalidRegionExists;
        }
        if (bl) {
            this.postEvent(1, -1, -1, this.theGraphics, 15);
        }
    }

    private long processTicksAndTimers() {
        long l = Long.MAX_VALUE;
        for (int i = 0; i < 16; ++i) {
            if (!this.timerIsActive[i]) continue;
            long l2 = this.timerLastEvent[i] + this.timerInterval[i] - Maglet.currentTimeMillis();
            if (l2 <= 0L) {
                this.postEvent(2, i, this.timerID[i], null, 1);
                this.timerLastEvent[i] = this.timerIsRepeating[i] ? Maglet.currentTimeMillis() + l2 % this.timerInterval[i] : Long.MAX_VALUE;
            }
            if (l2 >= l) continue;
            l = l2;
        }
        if (this.tickEventsEnabled) {
            long l3 = this.tickLastEvent + this.tickInterval - Maglet.currentTimeMillis();
            if (l3 <= 0L) {
                this.postEvent(3, -1, -1, null, 1);
                this.tickLastEvent = Maglet.currentTimeMillis() + l3 % this.tickInterval;
            }
            if (l3 < l) {
                l = l3;
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createTimer(long l, long l2, boolean bl, int n) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Invalid IDLE event delay.");
        }
        int n2 = -1;
        Object object = timerMutex;
        synchronized (object) {
            for (int i = 0; i < 16; ++i) {
                if (this.timerIsActive[i]) continue;
                n2 = i;
                break;
            }
            if (n2 == -1) {
                return -1;
            }
            this.timerIsActive[n2] = true;
        }
        this.timerIsRepeating[n2] = bl;
        this.timerInterval[n2] = l2;
        this.timerID[n2] = n;
        this.timerLastEvent[n2] = Maglet.currentTimeMillis() - l2 + l;
        ++this.timers;
        object = mutex;
        synchronized (object) {
            mutex.notify();
        }
        return n2;
    }

    public int createTimer(long l, long l2, int n) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Invalid IDLE event delay.");
        }
        if (l2 > 0L) {
            return this.createTimer(l, l2, true, n);
        }
        return this.createTimer(l, l2, false, n);
    }

    Event getCurrentEvent() {
        return Event.getLastRemoved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelTimer(int n) {
        if (this.currentEvent != null && this.currentEvent.type == 2 && n == this.currentEvent.paramInt1) {
            this.cancelCurrentTimer = true;
            return;
        }
        Object object = timerMutex;
        synchronized (object) {
            if (this.timerIsActive[n]) {
                this.timerIsActive[n] = false;
                --this.timers;
            }
            Event.removeAllOfType(2, n, this.timerID[n]);
        }
    }

    public boolean isTimerActive(int n) {
        if (n < 0 || n > this.timerIsActive.length) {
            return false;
        }
        return this.timerIsActive[n];
    }

    public boolean isTimerRepeating(int n) {
        return this.timerIsRepeating[n];
    }

    public void enableKeyEvents() {
        this.keyEventsEnabled = true;
    }

    public void setKeyEventsEnabled(boolean bl) {
        this.keyEventsEnabled = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enableIdleEvents(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Invalid IDLE event delay.");
        }
        if (l == 0L) {
            this.idleEventsEnabled = false;
        } else {
            this.idleDelay = l;
            this.idleEventsEnabled = true;
            Object object = mutex;
            synchronized (object) {
                mutex.notify();
            }
        }
    }

    public final boolean isTickEnabled() {
        return this.tickEventsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enableTickEvents(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("Invalid TICK event interval.");
        }
        if (l == 0L) {
            this.disableTickEvents();
        } else {
            this.tickInterval = l;
            this.tickLastEvent = Maglet.currentTimeMillis() - this.tickInterval;
            this.tickEventsEnabled = true;
            Object object = mutex;
            synchronized (object) {
                mutex.notify();
            }
        }
    }

    public final void disableTickEvents() {
        this.tickEventsEnabled = false;
        Event.removeAllOfType(3);
    }

    public void enableSeparateTrackwheelEvents(boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postEvent(int n, int n2, int n3, Object object, int n4) {
        int n5 = POST_LIMIT[n];
        Event.add(n, n2, n3, object, n4, n5);
        Object object2 = mutex;
        synchronized (object2) {
            mutex.notifyAll();
        }
    }

    public void postEvent(int n, int n2, int n3, Object object) {
        this.postEvent(n, n2, n3, object, 1);
    }

    public void postEvent(int n, int n2, Object object) {
        this.postEvent(n, n2, -1, object, 1);
    }

    public void postEvent(int n, int n2, Object object, int n3) {
        this.postEvent(n, n2, -1, object, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateRegion(int n, int n2, int n3, int n4) {
        Object object = invalidRegionMutex;
        synchronized (object) {
            if (n3 <= 0 || n4 <= 0 || n <= -n3 || n2 <= -n4 || n >= this.getWidth() || n2 >= this.getHeight()) {
                return;
            }
            if (n < 0) {
                n3 += n;
                n = 0;
            }
            if (n2 < 0) {
                n4 += n2;
                n2 = 0;
            }
            if (n3 > this.getWidth() - n) {
                n3 = this.getWidth() - n;
            }
            if (n4 > this.getHeight() - n2) {
                n4 = this.getHeight() - n2;
            }
            if (this.invalidRegionExists) {
                int n5 = this.clipX + this.clipW;
                int n6 = this.clipY + this.clipH;
                int n7 = n + n3;
                int n8 = n2 + n4;
                n5 = n7 > n5 ? n7 : n5;
                n6 = n8 > n6 ? n8 : n6;
                this.clipX = n < this.clipX ? n : this.clipX;
                this.clipY = n2 < this.clipY ? n2 : this.clipY;
                this.clipW = n5 - this.clipX;
                this.clipH = n6 - this.clipY;
            } else {
                this.clipX = n;
                this.clipY = n2;
                this.clipW = n3;
                this.clipH = n4;
            }
            this.invalidRegionExists = true;
        }
        object = mutex;
        synchronized (object) {
            mutex.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateScreen() {
        Object object = invalidRegionMutex;
        synchronized (object) {
            this.clipX = 0;
            this.clipY = 0;
            this.clipW = this.getWidth();
            this.clipH = this.getHeight();
            this.invalidRegionExists = true;
        }
        object = mutex;
        synchronized (object) {
            mutex.notify();
        }
    }

    public int getCurrentEventPriority() {
        return this.lastEventPriority;
    }

    public long getCurrentEventPostedTime() {
        return this.lastEventPostedTime;
    }

    public int getFrameRate() {
        long l = Maglet.currentTimeMillis() - this.frameTimeStart;
        if (l <= 1000L) {
            return (int)this.frameRate;
        }
        this.frameRate = (long)(this.frameCount * 1000) / l;
        this.frameTimeStart = Maglet.currentTimeMillis();
        this.frameCount = 0;
        return (int)this.frameRate;
    }

    public int getClipX() {
        return this.clipX;
    }

    public int getClipY() {
        return this.clipY;
    }

    public int getClipWidth() {
        return this.clipW;
    }

    public int getClipHeight() {
        return this.clipH;
    }

    public int getKeyStates() {
        return this.theGameCanvas.getKeyStates();
    }

    public int getWidth() {
        return this.theGameCanvas.getScreenWidth();
    }

    public int getHeight() {
        return this.theGameCanvas.getScreenHeight();
    }

    public int getGameAction(int n) {
        return this.theGameCanvas.getGameAction(n);
    }

    public void setDKeypadEnabled(boolean bl) {
        this.theGameCanvas.setDKeypadEnabled(bl);
    }

    public static InputStream getResourceInputStream(String string) {
        return Maglet.getInstance().getClass().getResourceAsStream(string);
    }

    public String getApplicationProperty(String string) {
        if ("Version".equals(string) || "VERSION".equals(string) || "version".equals(string)) {
            return this.getAppProperty("MIDlet-Version");
        }
        if ("Name".equals(string) || "NAME".equals(string) || "name".equals(string)) {
            return this.getAppProperty("MIDlet-Name");
        }
        return this.getAppProperty(string);
    }

    protected final void initMaglet() {
        this.invalidRegionExists = false;
        this.clipX = 0;
        this.clipY = 0;
        this.clipW = 1;
        this.clipH = 1;
        this.keyEventsEnabled = true;
        this.idleEventsEnabled = false;
        this.idleDelay = 0L;
        this.timers = 0;
        this.tickEventsEnabled = false;
        this.tickInterval = 83L;
        this.tickLastEvent = Maglet.currentTimeMillis() - this.tickInterval;
        this.postEvent(4, -1, -1, null, 15);
        this.loadRegRMS();
        if (this.theMagletThread == null) {
            this.theMagletThread = new Thread(this);
            this.theMagletThread.start();
        }
        this.alreadyInit = true;
    }

    protected final void startApp() {
        if (!this.alreadyInit) {
            this.initMaglet();
        } else {
            this.doResume();
        }
    }

    private void init2() {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.theGameCanvas);
    }

    protected final void pauseApp() {
        this.doPause();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void doPause() {
        if (!this.initEventProcessed) {
            this.paused = true;
            return;
        }
        MagmicSound2.eventPause();
        Object object = processEventMutex;
        synchronized (object) {
            if (this.paused) {
                return;
            }
            switch (state) {
                case 2: {
                    this.magmicSplash.processEvent(5, 15, -1, null);
                    this.paused = true;
                    break;
                }
                case 5: {
                    this.magmicsound2prompt.processEvent(5, 15, -1, null);
                    this.paused = true;
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    this.processEvent(5, 15, -1, null);
                    this.paused = true;
                }
            }
        }
        boolean bl = Event.contains(4);
        boolean bl2 = Event.contains(7);
        Event.emptyAllExcept(19);
        if (bl) {
            this.postEvent(4, -1, -1, null, 15);
        }
        if (bl2) {
            this.postEvent(7, -1, -1, null, 15);
        }
    }

    public final void doResume() {
        if (!this.paused) {
            return;
        }
        MagmicSound2.eventResume();
        if (!this.initEventProcessed) {
            this.paused = false;
            if (!this.alreadyInit) {
                this.initMaglet();
            }
        } else {
            this.paused = false;
            this.postEvent(6, 15, -1, null, 15);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void destroyApp(boolean bl) {
        if (!this.initEventProcessed) {
            return;
        }
        Object object = processEventMutex;
        synchronized (object) {
            if (state == 5) {
                this.magmicsound2prompt.processEvent(7, -1, -1, null);
            } else {
                this.processEvent(7, -1, -1, null);
            }
        }
    }

    public static long currentTimeMillis() {
        long l = System.currentTimeMillis();
        if (previousTime != 0L && l - previousTime > 0L) {
            deltaTime += 0L;
        }
        previousTime = l;
        return l - deltaTime;
    }

    public void networkStateChanged(boolean bl) {
    }

    public boolean isRegistered() {
        return true;
    }

    public void showRegisterScreen() {
    }

    public void startUpRegCheck() {
    }

    public void loadRegRMS() {
    }

    public final boolean validateRegCode(String string, String string2, boolean bl) {
        return true;
    }

    public void inform(String string, boolean bl) {
    }

    public void setRegistered() {
    }

    public boolean isExpired() {
        return false;
    }

    public void doRegMessage() {
    }

    public void setRegistrationRestrictions(boolean bl) {
    }

    private char[] getKeyChars(int n) {
        int n2 = 0;
        if (n >= 65 && n <= 90) {
            n += 32;
        }
        switch (n) {
            case 49: {
                Maglet.letters[n2++] = 46;
                Maglet.letters[n2++] = 44;
                Maglet.letters[n2++] = 64;
                Maglet.letters[n2++] = 95;
                Maglet.letters[n2++] = 45;
                break;
            }
            case 50: {
                Maglet.letters[n2++] = 97;
                Maglet.letters[n2++] = 98;
                Maglet.letters[n2++] = 99;
                break;
            }
            case 51: {
                Maglet.letters[n2++] = 100;
                Maglet.letters[n2++] = 101;
                Maglet.letters[n2++] = 102;
                break;
            }
            case 52: {
                Maglet.letters[n2++] = 103;
                Maglet.letters[n2++] = 104;
                Maglet.letters[n2++] = 105;
                break;
            }
            case 53: {
                Maglet.letters[n2++] = 106;
                Maglet.letters[n2++] = 107;
                Maglet.letters[n2++] = 108;
                break;
            }
            case 54: {
                Maglet.letters[n2++] = 109;
                Maglet.letters[n2++] = 110;
                Maglet.letters[n2++] = 111;
                break;
            }
            case 55: {
                Maglet.letters[n2++] = 112;
                Maglet.letters[n2++] = 113;
                Maglet.letters[n2++] = 114;
                Maglet.letters[n2++] = 115;
                break;
            }
            case 56: {
                Maglet.letters[n2++] = 116;
                Maglet.letters[n2++] = 117;
                Maglet.letters[n2++] = 118;
                break;
            }
            case 57: {
                Maglet.letters[n2++] = 119;
                Maglet.letters[n2++] = 120;
                Maglet.letters[n2++] = 121;
                Maglet.letters[n2++] = 122;
                break;
            }
            case 35: {
                Maglet.letters[n2++] = 35;
                Maglet.letters[n2++] = 32;
                break;
            }
            case 42: {
                Maglet.letters[n2++] = 42;
            }
        }
        switch (n) {
            case 48: {
                Maglet.letters[n2++] = 48;
                break;
            }
            case 49: {
                Maglet.letters[n2++] = 49;
                break;
            }
            case 50: {
                Maglet.letters[n2++] = 50;
                break;
            }
            case 51: {
                Maglet.letters[n2++] = 51;
                break;
            }
            case 52: {
                Maglet.letters[n2++] = 52;
                break;
            }
            case 53: {
                Maglet.letters[n2++] = 53;
                break;
            }
            case 54: {
                Maglet.letters[n2++] = 54;
                break;
            }
            case 55: {
                Maglet.letters[n2++] = 55;
                break;
            }
            case 56: {
                Maglet.letters[n2++] = 56;
                break;
            }
            case 57: {
                Maglet.letters[n2++] = 57;
            }
        }
        Maglet.letters[n2] = '\u0000';
        return letters;
    }

    public void netClientEvent(byte by, int n, Object object) {
        this.postEvent(19, (int)by, n, object);
    }

    static {
        int n;
        POST_LIMIT = new int[38];
        for (n = 0; n < 38; ++n) {
            Maglet.POST_LIMIT[n] = 2;
        }
        Maglet.POST_LIMIT[1] = 1;
        Maglet.POST_LIMIT[2] = 2;
        Maglet.POST_LIMIT[3] = 2;
        Maglet.POST_LIMIT[4] = 1;
        Maglet.POST_LIMIT[5] = 1;
        Maglet.POST_LIMIT[6] = 1;
        Maglet.POST_LIMIT[7] = 1;
        Maglet.POST_LIMIT[8] = 8;
        Maglet.POST_LIMIT[9] = 8;
        Maglet.POST_LIMIT[10] = 8;
        Maglet.POST_LIMIT[11] = 8;
        Maglet.POST_LIMIT[12] = 8;
        Maglet.POST_LIMIT[13] = 8;
        Maglet.POST_LIMIT[15] = 4;
        Maglet.POST_LIMIT[16] = 1;
        Maglet.POST_LIMIT[17] = 1;
        Maglet.POST_LIMIT[18] = 1;
        Maglet.POST_LIMIT[19] = 8;
        Maglet.POST_LIMIT[28] = 8;
        Maglet.POST_LIMIT[21] = 8;
        Maglet.POST_LIMIT[22] = 8;
        Maglet.POST_LIMIT[23] = 8;
        Maglet.POST_LIMIT[25] = 8;
        Maglet.POST_LIMIT[26] = 8;
        Maglet.POST_LIMIT[27] = 8;
        state = 0;
        n = 0;
        for (int i = 0; i < 38; ++i) {
            n += POST_LIMIT[i];
        }
        QUEUE_SIZE = n;
        mutex = new Object();
        timerMutex = new Object();
        invalidRegionMutex = new Object();
        processEventMutex = new Object();
        previousTime = 0L;
        deltaTime = 0L;
        letters = new char[10];
    }
}

