/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.kahuna;

import com.magmic.K;
import com.magmic.MagmicGame;
import com.magmic.MagmicStringBuffer;
import com.magmic.Slide2D;
import com.magmic.Window;
import com.magmic.pykegame.MagmicLayer;
import com.magmic.slic.Spr;
import com.magmic.ui.MagmicGraphics;

public class MyFishLayer
extends MagmicLayer {
    public int maxConcurentFish;
    public Slide2D[] fishPosition;
    public Spr[] fish;
    public boolean[] goingLeft;
    public int slicCleanInterval;
    public int slicCleanCount;
    public int freedFish;
    public int[] spawnRequest;
    public int nextSpawnIndex;
    public static int SPRINT_DURATION = 750;
    public int[] keyHistory;
    public int menuMode;
    public boolean cameFromMain;
    public int[] menuItems;
    public int[] spawnItems;
    public static final int MENU_MODE_NONE = 0;
    public static final int MENU_MODE_MAIN = 1;
    public static final int MENU_MODE_SPAWN = 2;

    public MyFishLayer(MagmicGame magmicGame) {
        super(magmicGame);
        this.left_softkey_label = " Back";
        this.keyHistory = new int[8];
        this.maxConcurentFish = 5;
        this.fishPosition = new Slide2D[this.maxConcurentFish];
        this.spawnRequest = new int[this.maxConcurentFish];
        for (int i = 0; i < this.maxConcurentFish; ++i) {
            this.fishPosition[i] = new Slide2D();
        }
        this.fish = new Spr[this.maxConcurentFish];
        this.goingLeft = new boolean[this.maxConcurentFish];
        this.slicCleanInterval = this.maxConcurentFish * 2;
        this.slicCleanCount = 0;
        this.menuItems = new int[]{30, 60, 26};
        this.spawnItems = new int[K.numberOfFish + 1];
    }

    public void init(int n) {
        switch (n) {
            case 0: {
                this.maglet.loadAndPlayRandomBackgroundMusic();
                break;
            }
            case 1: {
                this.maglet.helpWindow.setTitle(this.maglet.systemFont, null);
                this.maglet.helpWindow.setuptNoOptions();
                break;
            }
            case 2: {
                this.freedFish = MagmicGame.cheatSeeAllFish ? K.numberOfFish : this.maglet.score.getNumberOfFreedFishes();
                break;
            }
            case 3: {
                for (int i = 0; i < this.maxConcurentFish; ++i) {
                    this.spawnRequest[i] = -1;
                }
                break;
            }
        }
    }

    public int getNumberOfInitSteps() {
        return 5;
    }

    public void destroy() {
        this.maglet.releaseMusic();
        for (int i = 0; i < this.maxConcurentFish; ++i) {
            if (this.fish[i] == null) continue;
            this.fish[i].destroy();
        }
        this.maglet.slic.cleanup();
    }

    public void show() {
        this.menuMode = 0;
    }

    public void paintBackBuffer(MagmicGraphics magmicGraphics) {
        if (!this.maglet.is_layer_on_top(this)) {
            this.paint(magmicGraphics);
        }
    }

    public void paint(MagmicGraphics magmicGraphics) {
        for (int i = 0; i < this.maxConcurentFish; ++i) {
            if (this.fish[i] == null) continue;
            int n = this.fishPosition[i].getX();
            int n2 = this.fishPosition[i].getY();
            this.fish[i].paint(magmicGraphics, n, n2);
        }
    }

    public boolean tick(int n) {
        if (!this.maglet.is_layer_on_top(this)) {
            return false;
        }
        int n2 = this.maglet.get_width();
        int n3 = this.maglet.get_height();
        this.maglet.tickBubbles(n);
        for (int i = 0; i < this.maxConcurentFish; ++i) {
            if (this.fishPosition[i].is_done()) {
                int n4;
                int n5;
                int n6;
                int n7;
                int n8;
                int n9;
                int n10;
                if (this.fishPosition[i].getX() > 0 && this.fishPosition[i].getX() < n2) {
                    Slide2D slide2D = this.fishPosition[i];
                    n10 = (MagmicGame.rand() % 30000 + 10000) / 2;
                    n9 = slide2D.getX();
                    n8 = slide2D.getY();
                    n7 = n9 + (n9 - slide2D.getXStart());
                    n6 = n8 + (n8 - slide2D.getYStart());
                    this.fishPosition[i].init(n9, n8, n7, n6, n10);
                    continue;
                }
                if (this.freedFish <= 0) continue;
                n10 = 0;
                if (this.spawnRequest[i] != -1) {
                    n5 = this.spawnRequest[i];
                    this.spawnRequest[i] = -1;
                    n10 = 1;
                } else {
                    n5 = this.maglet.showMostRecentUnlockedFish ? Math.max(this.freedFish - 1, 0) : MagmicGame.rand() % this.freedFish;
                }
                if (this.fish[i] == null) {
                    this.fish[i] = new Spr(this.maglet.slic, K.fishSprites[n5]);
                } else {
                    this.fish[i].changeSprite(K.fishSprites[n5]);
                }
                this.goingLeft[i] = n9 = MagmicGame.rand() % 2 == 0 ? 1 : 0;
                n8 = MagmicGame.rand() % (2 * n3 / 4) + n3 / 4;
                n6 = n8 + (MagmicGame.rand() % 2 == 0 ? -1 : 1) * MagmicGame.rand() % (n3 / 4);
                int n11 = n10 != 0 ? SPRINT_DURATION : MagmicGame.rand() % 30000 + 10000;
                short s = this.fish[i].get_max_curr_seq_frame_w();
                if (n9 != 0) {
                    this.fish[i].setSeq(K.fishSequenceLeft[n5]);
                    n7 = n2 + s;
                    n4 = n10 != 0 ? 2 * n2 / 3 : (int)(-s);
                } else {
                    this.fish[i].setSeq(K.fishSequenceRight[n5]);
                    n7 = -s;
                    n4 = n2 + s;
                    n4 = n10 != 0 ? n2 / 3 : n2 + s;
                }
                this.fishPosition[i].init(n7, n8, n4, n6, n11);
                ++this.slicCleanCount;
                if (this.slicCleanCount <= this.slicCleanInterval) continue;
                this.maglet.slic.cleanup();
                this.slicCleanCount = 0;
                continue;
            }
            this.fishPosition[i].tick(n);
            if (this.fish[i] == null) continue;
            this.fish[i].calc(n);
        }
        if (this.maglet.showMostRecentUnlockedFish) {
            this.maglet.showMostRecentUnlockedFish = false;
            this.maglet.saveSettings();
        }
        return true;
    }

    public boolean key_up(int n, int n2) {
        switch (n) {
            case 1: {
                this.showMenu(1);
                return true;
            }
            case 6: {
                this.showMenu(2);
                return true;
            }
        }
        return false;
    }

    public boolean key_down(int n, int n2) {
        for (int i = 0; i < this.keyHistory.length - 1; ++i) {
            this.keyHistory[i] = this.keyHistory[i + 1];
        }
        this.keyHistory[this.keyHistory.length - 1] = n;
        return false;
    }

    public void showMenu(int n) {
        int n2 = this.maglet.menuWindow.w;
        int n3 = this.maglet.menuWindow.h;
        boolean bl = false;
        if (this.maglet.is_layer_visible(this.maglet.menuWindow)) {
            bl = true;
            this.maglet.menuWindow._close();
        }
        switch (n) {
            case 2: {
                this.cameFromMain = this.menuMode == 1;
                int n4 = this.freedFish > 0 ? K.fishNames[0] : 27;
                for (int i = 0; i < this.freedFish; ++i) {
                    this.spawnItems[i] = K.fishNames[i];
                }
                this.spawnItems[this.freedFish] = 27;
                int n5 = n == this.menuMode ? this.maglet.lastSelectionId : n4;
                this.maglet.menuWindow.setTitle(this.maglet.systemFont, 60);
                this.maglet.menuWindow.setupOptions(this.spawnItems, 0, this.freedFish + 1, n5, 27, Math.min(5, this.freedFish + 1), true);
                break;
            }
            case 1: {
                int n6 = n == this.menuMode ? this.maglet.lastSelectionId : 30;
                this.maglet.menuWindow.setTitle(this.maglet.systemFont, null);
                this.maglet.menuWindow.setupOptions(this.menuItems, 0, 3, n6, 30, 3, true);
            }
        }
        this.maglet.menuWindow.setupMessage(this.maglet.systemFont, null, 0, 0);
        this.maglet.menuWindow.pack(K.windowPackPolicy);
        this.maglet.menuWindow.closeOnConfirmOption = false;
        if (!bl) {
            this.maglet.menuWindow.setupTransition(2, 500, 0, 0, true);
        } else {
            this.maglet.menuWindow.setupTransition(1, 500, n2, n3, false);
        }
        this.maglet.menuWindow.open(this);
        this.menuMode = n;
    }

    public void window_confirm_option(Window window, int n, int n2, int n3) {
        if (window == this.maglet.menuWindow) {
            this.maglet.lastSelectionId = this.maglet.menuWindow.selectedOptionId;
            block0 : switch (this.menuMode) {
                case 1: {
                    switch (this.maglet.menuWindow.selectedOptionId) {
                        case 30: {
                            this.maglet.menuWindow.close();
                            break;
                        }
                        case 60: {
                            this.showMenu(2);
                            break;
                        }
                        case 26: {
                            this.maglet.changeRootLayer(4);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.maglet.menuWindow.selectedOptionId) {
                        case 27: {
                            if (this.cameFromMain) {
                                this.showMenu(1);
                                break block0;
                            }
                            this.maglet.menuWindow.close();
                            break block0;
                        }
                    }
                    for (int i = 0; i < this.freedFish; ++i) {
                        if (this.maglet.menuWindow.selectedOptionId != K.fishNames[i]) continue;
                        this.spawnRequest[this.nextSpawnIndex] = i;
                        Slide2D slide2D = this.fishPosition[this.nextSpawnIndex];
                        int n4 = this.fish[this.nextSpawnIndex].get_max_curr_seq_frame_w();
                        int n5 = this.goingLeft[this.nextSpawnIndex] ? -n4 : this.maglet.get_width() + n4;
                        slide2D.init(slide2D.getX(), slide2D.getY(), n5, slide2D.getDestinationY(), SPRINT_DURATION);
                        this.nextSpawnIndex = (this.nextSpawnIndex + 1) % this.maxConcurentFish;
                    }
                    this.maglet.menuWindow.close();
                }
            }
        }
    }

    public void window_key_up(Window window, int n, int n2) {
        if (window == this.maglet.menuWindow) {
            switch (n) {
                case 7: {
                    int n3 = -1;
                    switch (this.maglet.menuWindow.selectedOptionId) {
                        case 30: {
                            n3 = 5;
                            break;
                        }
                        case 26: {
                            n3 = 9;
                            break;
                        }
                        case 27: {
                            n3 = 17;
                            break;
                        }
                        case 60: {
                            n3 = 21;
                            break;
                        }
                        default: {
                            for (int i = 0; i < this.freedFish; ++i) {
                                if (this.maglet.menuWindow.selectedOptionId != K.fishNames[i]) continue;
                                n3 = K.fishDescriptions[i];
                            }
                        }
                    }
                    if (n3 == -1) break;
                    MagmicStringBuffer magmicStringBuffer = this.maglet.helpWindowBuffer;
                    magmicStringBuffer.clear();
                    this.maglet.strings.append_string(n3, magmicStringBuffer);
                    this.maglet.helpWindow.setupMessage(this.maglet.systemFont, magmicStringBuffer.chars, 0, magmicStringBuffer.length);
                    this.maglet.helpWindow.open(this);
                }
            }
        }
    }
}

