/*
 * Decompiled with CFR 0.152.
 */
package com.magmic.magmicSound;

import com.magmic.magmicSound.MagmicSound2;
import com.magmic.magmicSound.Sound;

public final class MagmicSound {
    private static int currentAudioIndex;
    private static int currentLoopCount;
    private static int currentVolume;
    public static MagmicSound magmicSound;

    public static final MagmicSound getInstance() {
        if (magmicSound == null) {
            magmicSound = new MagmicSound();
        }
        return magmicSound;
    }

    public static void setCallingClass(Class clazz) {
        MagmicSound2.setCallingClass(clazz);
    }

    public static void initializeAudio(int n) {
        MagmicSound2.initializeAudio(n);
    }

    public static final int[] initializeAudio(String[] stringArray, int[] nArray) {
        int n = stringArray.length;
        MagmicSound2.initializeAudio(n);
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = MagmicSound2.addAudio(stringArray[i]);
        }
        return nArray2;
    }

    public static void setSoundEnabled(boolean bl) {
        MagmicSound2.setSoundEnabled(bl);
        if (!MagmicSound2.isSoundEnabled()) {
            MagmicSound2.pauseAudio();
        } else {
            MagmicSound2.resumeAudio();
        }
    }

    public static boolean isSoundEnabled() {
        return MagmicSound2.isSoundEnabled();
    }

    public static final void releasePlayer(Sound sound) {
        MagmicSound2.freeAudio(sound.index);
    }

    public static final void removeAudio(Sound sound) {
        MagmicSound2.freeAudio(sound.index);
    }

    public static Sound addAudio(String string, int n) {
        int n2 = MagmicSound2.addAudio(string);
        Sound sound = new Sound(string, n);
        sound.index = n2;
        return sound;
    }

    public static final void playAudio(Sound sound) {
        if (MagmicSound2.isSoundEnabled()) {
            currentAudioIndex = sound.index;
            currentLoopCount = sound.loopCount;
            currentVolume = sound.volume;
            MagmicSound2.playAudio(sound.index, sound.loopCount, sound.volume);
        }
    }

    public static final void stopAudio(Sound sound) {
        currentAudioIndex = -1;
        MagmicSound2.stopAudio();
    }

    public static final void playAudio(int n, int n2, int n3) {
        if (MagmicSound2.isSoundEnabled()) {
            currentAudioIndex = n;
            currentLoopCount = n2;
            currentVolume = n3;
            MagmicSound2.playAudio(n, n2, n3);
        }
    }

    public static final void stopAudio(int n) {
        currentAudioIndex = -1;
        MagmicSound2.stopAudio();
    }

    public static final void stopAllAudio() {
        currentAudioIndex = -1;
        MagmicSound2.stopAudio();
    }

    public static final void resumeCurrentAudio() {
        if (MagmicSound2.getState() == 2 && currentAudioIndex > -1) {
            MagmicSound2.playAudio(currentAudioIndex, currentLoopCount, currentVolume);
        }
    }

    public static final void pauseCurrentAudio() {
        MagmicSound2.stopAudio();
    }
}

