/*
 * Decompiled with CFR 0.152.
 */
package BlockBreaker;

import BlockBreaker.Ball;
import BlockBreaker.BlockBreaker;
import BlockBreaker.Bonus;
import BlockBreaker.Game;
import BlockBreaker.Global;
import BlockBreaker.MyScreen;
import Gfx.GraphicObjectManager;
import Gfx.Sprite;
import com.nokia.mid.ui.DeviceControl;
import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.midlet.MIDlet;

public class GameCanvas
extends MyScreen
implements Runnable {
    Graphics graphic = null;
    public static final int MENU = 0;
    public static final int GAME = 1;
    public static final int HELP = 2;
    public static final int ABOUT = 3;
    public static final int ERROR = 4;
    public static final int CONSTRUCT = 5;
    public static final int LOAD = 6;
    public static final int NEW_HIGH_SCORE = 7;
    public static final int GAME_OVER = 8;
    public static final int HIGH_SCORE = 9;
    public static final int END_OF_GAME = 10;
    public static final int LOADSCREEN = 11;
    public static final int PRE_NEW = 12;
    public static final int PRE_CONTINUE = 13;
    public static final int NEXT_LEVEL = 14;
    public static final int GAME_AREA_WIDTH = 80;
    public static final int GAME_AREA_HEIGHT = 65;
    public static final int GAME_AREA_POSX = 8;
    public static final int GAME_AREA_POSY = 0;
    public static final int LEVEL_HEADER_POSX = 32;
    public static final int LIFE_HEADER_POSX = 0;
    public static final int SCORE_HEADER_POSX = 62;
    public static final int HEADER_POSY = 30;
    public static final int GAME_SCREEN_WIDTH = 96;
    public static final int GAME_SCREEN_HEIGHT = 65;
    public static final int PRESSED = 1;
    public static final int RELEASED = 0;
    private boolean secure = true;
    public DirectGraphics gameScreen;
    public GraphicObjectManager gfxManager = null;
    private byte[] loadingsprite_pix = null;
    private byte[] splash_pix = null;
    private byte[] back_left = null;
    private byte[] back_right = null;
    private byte[] puptext_pix = null;
    private byte[] gameOver_pix = null;
    private byte[] end_pix = null;
    public byte[] wall_pix = null;
    private byte[] wall_back_pix = null;
    private byte[] brick_pix = null;
    private byte[] menu_pix = null;
    private byte[] racket_pix = null;
    private byte[] ball_pix = null;
    private byte[] bonus_pix = null;
    private byte[] missile_pix = null;
    private byte[] menu_arrow_pix = new byte[]{0, 127, 62, 28, 8};
    private byte[] numberB_pix = null;
    private byte[] life_pix = null;
    private byte[] explosion_pix = null;
    private byte[] score_pix = null;
    private byte[] score_mask = null;
    public Sprite racket_spr = null;
    public Sprite missile_spr = null;
    public Sprite puptext_spr = null;
    public Sprite[] number_spr = null;
    public Sprite[] levelB_spr = null;
    public Sprite[] life_spr = null;
    public Sprite[] level_spr = null;
    public static final int BONUS_MAX = 8;
    public static final int EXPLOSION_MAX = 5;
    public int explosionNum = 0;
    public Sprite[] bonusSprArray = new Sprite[8];
    public Sprite[] explosionSprArray = new Sprite[5];
    public Sprite[] scoreSprArray = new Sprite[5];
    public Sprite[] ballSprArray = new Sprite[3];
    public int currentKey;
    public int currentKeyState = 0;
    public int state = 5;
    public int last_state = -1;
    public int screenToLoad = -1;
    public Game game = null;
    private boolean show_high = false;
    private boolean saving = false;
    private byte index_char = 0;
    private int index_name = 0;
    private int index_highScore = 3;
    private byte[] highscore = new byte[]{65, 65, 65, 0, 0};
    private byte[] highscores;
    public boolean paused = true;
    public int draw_loading = 0;
    private int gameover_step = 0;
    public boolean running = true;
    private int help_height = 0;
    public byte[] animal_map;
    public byte[][] animal_pixs = new byte[10][];
    public byte[] animal_pix;
    public Sprite[] animal_sprs = new Sprite[3];
    private boolean menuOn = false;
    public boolean drawBack = true;
    private byte menuPos;
    private byte menuSize;
    private byte[][] menuSet = new byte[][]{{1, 2, 3, 5, 6, 8, 11, -1}, {0, 1, 3, 5, 6, 8, 7, 11, -1}, {15, 16, 17, -1}, {18, -1}, {11, -1}};
    private byte[] menu = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};

    public GameCanvas() {
        Display.getDisplay((MIDlet)BlockBreaker.appz).setCurrent((Displayable)this);
        new Thread(this).start();
    }

    public void start() {
        if (this.paused) {
            this.paused = false;
            Display.getDisplay((MIDlet)BlockBreaker.appz).setCurrent((Displayable)this);
        }
        this.repaint();
    }

    public void loadRez() {
        Font font = Font.getFont((int)0, (int)1, (int)8);
        try {
            switch (this.draw_loading) {
                case 0: {
                    this.game = new Game(this);
                    break;
                }
                case 1: {
                    this.gfxManager = new GraphicObjectManager();
                    this.animal_map = this.ReadByteArray("animap.bin", 240, 0);
                    for (int i = 0; i < 10; ++i) {
                        this.animal_pixs[i] = this.ReadByteArray("animal.bin", 12, i * 12);
                    }
                    break;
                }
                case 2: {
                    this.back_left = this.ReadByteArray("background.bin", 58, 0);
                    this.back_right = this.ReadByteArray("background.bin", 58, 58);
                    this.menu_pix = this.ReadByteArray("menu_sprite.bin", 24, 0);
                    this.puptext_pix = this.ReadByteArray("puptext.bin", 616, 0);
                    this.wall_pix = new byte[360];
                    this.wall_back_pix = new byte[360];
                    this.brick_pix = this.ReadByteArray("bricks.bin", 30, 0);
                    break;
                }
                case 3: {
                    this.bonus_pix = this.ReadByteArray("bonus.bin", 56, 0);
                    this.numberB_pix = this.ReadByteArray("numberB.bin", 140, 0);
                    this.ball_pix = this.ReadByteArray("ball.bin", 4, 0);
                    this.missile_pix = this.ReadByteArray("missile.bin", 8, 0);
                    break;
                }
                case 4: {
                    this.explosion_pix = this.ReadByteArray("explode.bin", 84, 0);
                    this.score_pix = this.ReadByteArray("score.bin", 36, 0);
                    this.score_mask = this.ReadByteArray("score.mask", 36, 0);
                    this.racket_pix = this.ReadByteArray("racket.bin", 48, 0);
                    break;
                }
                case 5: {
                    this.puptext_spr = new Sprite(this.puptext_pix, 0, 64, 11, this.puptext_pix, 0, 7);
                    this.puptext_spr.setPosition(8, 40);
                    this.puptext_spr.setVisible(false);
                    this.gfxManager.addObject(this.puptext_spr);
                    this.number_spr = new Sprite[5];
                    for (int i = 0; i < 5; ++i) {
                        this.number_spr[i] = new Sprite(this.numberB_pix, 0, 8, 14, this.numberB_pix, 0, 10);
                        this.number_spr[i].setPosition(28 + font.stringWidth(Global.MISC_STR[5]) / 2 + i * 6, 45);
                        this.number_spr[i].setVisible(false);
                        this.number_spr[i].setFrame(0);
                        this.gfxManager.addObject(this.number_spr[i]);
                    }
                    break;
                }
                case 6: {
                    int n;
                    this.animal_pix = new byte[12];
                    for (n = 0; n < 3; ++n) {
                        this.animal_sprs[n] = new Sprite(this.animal_pix, 0, 8, 6, this.animal_pix, 0, 2);
                        this.animal_sprs[n].setVisible(false);
                        this.gfxManager.addObject(this.animal_sprs[n]);
                    }
                    this.levelB_spr = new Sprite[2];
                    for (n = 0; n < 2; ++n) {
                        this.levelB_spr[n] = new Sprite(this.numberB_pix, 0, 8, 14, this.numberB_pix, 0, 10);
                        this.levelB_spr[n].setPosition(37 + font.stringWidth(Global.MISC_STR[4]) / 2 + n * 6, 34);
                        this.levelB_spr[n].setFrame(0);
                        this.levelB_spr[n].setVisible(false);
                        this.gfxManager.addObject(this.levelB_spr[n]);
                    }
                    break;
                }
                case 7: {
                    int n;
                    this.life_spr = new Sprite[2];
                    for (n = 0; n < 2; ++n) {
                        this.life_spr[n] = new Sprite(this.ball_pix, 0, 8, 4, this.ball_pix, 0, 1);
                        this.life_spr[n].setPosition(-8, 31 + n * 5);
                        this.life_spr[n].setFrame(0);
                        this.gfxManager.addObject(this.life_spr[n]);
                    }
                    this.missile_spr = new Sprite(this.missile_pix, 0, 8, 8, this.missile_pix, 0, 1);
                    this.racket_spr = new Sprite(this.racket_pix, 0, 32, 3, this.racket_pix, 0, 4);
                    this.racket_spr.setFrame(1);
                    this.racket_spr.setPosition(40, 62);
                    this.gfxManager.addObject(this.racket_spr);
                    for (n = 0; n < 8; ++n) {
                        this.bonusSprArray[n] = new Sprite(this.bonus_pix, 0, 8, 8, this.bonus_pix, 0, 7);
                        this.gfxManager.addObject(this.bonusSprArray[n]);
                    }
                    for (n = 0; n < 5; ++n) {
                        this.explosionSprArray[n] = new Sprite(this.explosion_pix, 0, 16, 14, this.explosion_pix, 0, 3);
                        this.scoreSprArray[n] = new Sprite(this.score_pix, 0, 16, 9, this.score_mask, 0, 2);
                        this.gfxManager.addObject(this.scoreSprArray[n]);
                        this.gfxManager.addObject(this.explosionSprArray[n]);
                    }
                    for (n = 0; n < 3; ++n) {
                        this.ballSprArray[n] = new Sprite(this.ball_pix, 0, 8, 4, this.ball_pix, 0, 1);
                        this.gfxManager.addObject(this.ballSprArray[n]);
                    }
                    break;
                }
                default: {
                    this.switchToMenu();
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.gc();
    }

    public void switchToHelp() {
        this.last_state = this.state;
        this.help_height = 0;
        this.state = 2;
        this.menuSet(this.state);
    }

    public void switchToAbout() {
        this.last_state = this.state;
        this.help_height = 0;
        this.state = 3;
        this.menuSet(this.state);
    }

    public void switchToHighScore() {
        this.last_state = this.state == 1 ? this.state : 0;
        this.highscores = this.getHighScore();
        if (!this.normal) {
            this.state = 4;
            this.menuSet(this.state);
            return;
        }
        this.show_high = true;
        this.state = 9;
        this.menuSet(this.state);
    }

    public void switchToNewHighScore() {
        this.last_state = this.state;
        this.show_high = true;
        this.state = 7;
        this.menuSet(this.state);
    }

    public void switchToGameOver() {
        this.last_state = -1;
        if (this.gameOver_pix == null) {
            this.state = 11;
            this.screenToLoad = 0;
        } else {
            this.state = 8;
        }
        this.menuSet(this.state);
    }

    public void switchToEndOfGame() {
        this.last_state = -1;
        if (this.end_pix == null) {
            this.state = 11;
            this.screenToLoad = 1;
        } else {
            this.state = 10;
        }
        this.menuSet(this.state);
    }

    public void switchToMenu() {
        this.state = 0;
        this.menuSet(this.state);
    }

    public void switchToNextLevel() {
        this.state = 14;
        this.draw_loading = 0;
        this.menuSet(this.state);
    }

    protected void keyPressed(int n) {
        if (this.menuUpdate(n)) {
            return;
        }
        this.currentKey = n;
        if (this.state == 1) {
            switch (n) {
                case 49: 
                case 50: 
                case 51: {
                    this.currentKey = 1;
                    break;
                }
                case 52: 
                case 55: {
                    this.currentKey = 2;
                    break;
                }
                case 53: 
                case 54: 
                case 56: 
                case 57: {
                    this.currentKey = 5;
                    break;
                }
                default: {
                    this.currentKey = 6;
                    break;
                }
            }
        } else {
            switch (n) {
                case -1: 
                case 50: {
                    this.currentKey = 1;
                    break;
                }
                case 2: 
                case 52: {
                    this.currentKey = 2;
                    break;
                }
                case 5: 
                case 54: {
                    this.currentKey = 5;
                    break;
                }
                case -2: 
                case 56: {
                    this.currentKey = 6;
                }
            }
        }
        this.currentKeyState = 1;
    }

    protected void keyReleased(int n) {
        this.currentKeyState = 0;
    }

    public void save() {
        this.saving = true;
        byte[] byArray = new byte[]{(byte)(this.game.score >> 8), (byte)this.game.score, this.game.level};
        this.replaceSavedGame(byArray);
        if (!this.normal) {
            this.state = 4;
            this.menuSet(this.state);
        }
        this.saving = false;
    }

    public void paint(Graphics graphics) {
        if (this.menuOn) {
            this.menuPaint(graphics);
            return;
        }
        if (!this.secure && this.state == 1) {
            this.secure = true;
            this.repaint();
            this.serviceRepaints();
            return;
        }
        this.secure = false;
        switch (this.state) {
            case 5: {
                this.loadingsprite_pix = this.ReadByteArray("loadingsprite.bin", 70, 0);
                this.splash_pix = this.ReadByteArray("title.bin", 780, 0);
                this.state = 6;
                this.last_state = -1;
                this.graphic = graphics;
                this.gameScreen = DirectUtils.getDirectGraphics((Graphics)graphics);
                break;
            }
            case 6: {
                this.gameScreen.drawPixels(this.splash_pix, null, 0, 96, 0, 0, 96, 65, 0, 1);
                this.gameScreen.drawPixels(this.loadingsprite_pix, null, 0, 80, 8, 0, 80, 7, 0, 1);
                graphics.setColor(0xFFFFFF);
                graphics.drawLine(48, 3, 48 + this.draw_loading * 4, 3);
                this.loadRez();
                ++this.draw_loading;
                break;
            }
            case 0: {
                this.gameScreen.drawPixels(this.splash_pix, null, 0, 96, 0, 0, 96, 65, 0, 1);
                this.menuPaint(graphics);
                break;
            }
            case 12: {
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, 96, 65);
                graphics.setColor(0);
                this.gameScreen.drawPixels(this.back_left, null, 0, 8, 0, 0, 8, 58, 0, 1);
                this.gameScreen.drawPixels(this.back_right, null, 0, 8, 88, 0, 8, 58, 0, 1);
                graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
                this.game.initGame();
                System.gc();
                this.state = 1;
                this.last_state = 1;
                this.drawBack = true;
                this.menuSet(this.state);
                break;
            }
            case 13: {
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, 96, 65);
                graphics.setColor(0);
                this.gameScreen.drawPixels(this.back_left, null, 0, 8, 0, 0, 8, 58, 0, 1);
                this.gameScreen.drawPixels(this.back_right, null, 0, 8, 88, 0, 8, 58, 0, 1);
                graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
                this.game.score = 0;
                this.game.level = 0;
                byte[] byArray = this.getSavedGame();
                if (!this.normal) {
                    this.state = 4;
                    this.menuSet(this.state);
                    return;
                }
                if (byArray != null) {
                    this.game.level = (byte)(byArray[2] & 0x1F);
                    this.game.score = 0;
                    this.initLife(2);
                } else {
                    this.initLife(2);
                }
                this.game.initLevel(this.game.level);
                System.gc();
                this.state = 1;
                this.last_state = 1;
                this.drawBack = true;
                this.menuSet(this.state);
                break;
            }
            case 1: {
                this.game.updateGame();
                if (this.drawBack) {
                    this.gameScreen.drawPixels(this.back_left, null, 0, 8, 0, 0, 8, 58, 0, 1);
                    this.gameScreen.drawPixels(this.back_right, null, 0, 8, 88, 0, 8, 58, 0, 1);
                    this.drawBack = false;
                }
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(8, 36, 80, 22);
                graphics.fillRect(0, 58, 96, 7);
                if (this.game.scroll) {
                    this.levelB_spr[0].setVisible(true);
                    this.levelB_spr[1].setVisible(true);
                    for (int i = 0; i < 5; ++i) {
                        this.number_spr[i].setVisible(true);
                    }
                    Font font = Font.getFont((int)0, (int)1, (int)8);
                    graphics.setFont(font);
                    graphics.setColor(0);
                    graphics.drawString(Global.MISC_STR[4], 42 - font.stringWidth(Global.MISC_STR[4]) / 2, 36, 20);
                    graphics.drawString(Global.MISC_STR[5], 33 - font.stringWidth(Global.MISC_STR[5]) / 2, 46, 20);
                    System.arraycopy(this.wall_pix, (this.game.mapOffset - 1) * 10, this.wall_back_pix, 0, (36 - this.game.mapOffset + 1) * 10);
                }
                this.gameScreen.drawPixels(this.wall_back_pix, null, 0, 80, 8, 0, 80, 36, 0, 1);
                this.gfxManager.paint(this.graphic, 8, 0);
                if (this.game.showText <= 0) break;
                --this.game.showText;
                if (this.game.showText != 0) break;
                this.puptext_spr.setVisible(false);
                break;
            }
            case 14: {
                if (this.draw_loading == 0) {
                    graphics.setColor(0xFFFFFF);
                    graphics.fillRect(0, 0, 96, 65);
                    graphics.setColor(0);
                    this.gameScreen.drawPixels(this.back_left, null, 0, 8, 0, 0, 8, 58, 0, 1);
                    this.gameScreen.drawPixels(this.back_right, null, 0, 8, 88, 0, 8, 58, 0, 1);
                    this.game.nextLevel();
                }
                if (this.draw_loading >= 50) break;
                ++this.draw_loading;
                if (this.draw_loading < 10) break;
                System.gc();
                this.state = 1;
                this.last_state = 1;
                this.menuSet(this.state);
                break;
            }
            case 7: {
                this.updateNewScore();
                if (!this.show_high || this.state != 7) break;
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, 96, 65);
                graphics.setColor(0);
                Font font = Font.getFont((int)0, (int)1, (int)8);
                graphics.setFont(font);
                graphics.drawString(Global.MISC_STR[2], 50, 5, 17);
                graphics.drawRect(18 + 24 * this.index_name, 38, 15, 14);
                graphics.drawString(String.valueOf(this.game.score), 48, 20, 17);
                for (int i = 0; i < 3; ++i) {
                    graphics.drawChar((char)this.highscore[i], 23 + 24 * i, 41, 20);
                }
                this.show_high = false;
                break;
            }
            case 9: {
                if (this.currentKeyState == 1) {
                    this.state = this.last_state;
                    this.drawBack = true;
                    this.menuSet(this.state);
                    return;
                }
                if (!this.show_high) break;
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, 96, 65);
                graphics.setColor(0);
                graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
                graphics.drawString(Global.MISC_STR[3], 48, 5, 17);
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        graphics.drawChar((char)this.highscores[j + i * 5], 20 + j * 8, 25 + i * 13, 20);
                    }
                    graphics.drawString(String.valueOf((short)(this.highscores[3 + i * 5] << 8 | this.highscores[4 + i * 5] & 0xFF)), 55, 25 + i * 13, 20);
                }
                this.show_high = false;
                this.gameScreen.drawPixels(this.menu_arrow_pix, this.menu_arrow_pix, 0, 8, 88, 60, 8, 5, 0, 1);
                break;
            }
            case 8: {
                this.updateGameOver();
                if (this.state != 8) break;
                if (this.gameover_step < 64) {
                    this.gameScreen.drawPixels(this.gameOver_pix, null, 0, 96, 0, 0, 96, this.gameover_step, 0, 1);
                } else {
                    this.gameScreen.drawPixels(this.gameOver_pix, null, 0, 96, 0, 0, 96, 65, 0, 1);
                }
                this.gameScreen.drawPixels(this.menu_arrow_pix, this.menu_arrow_pix, 0, 8, 88, 60, 8, 5, 0, 1);
                break;
            }
            case 10: {
                this.updateGameOver();
                if (this.state != 10) break;
                if (this.gameover_step < 64) {
                    this.gameScreen.drawPixels(this.end_pix, null, 0, 96, 0, 0, 96, this.gameover_step, 0, 1);
                    break;
                }
                this.gameScreen.drawPixels(this.end_pix, null, 0, 96, 0, 0, 96, 65, 0, 1);
                break;
            }
            case 2: {
                this.updateHelp();
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, 96, 65);
                graphics.setColor(0);
                int n = 4;
                graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
                if (this.help_height == 0) {
                    graphics.drawString(Global.MISC_STR[6], 48, n, 17);
                    n += 12;
                }
                int n2 = 0;
                graphics.drawString(Global.HELPSTR[this.help_height][n2], 2, n, 20);
                n += 12;
                graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
                for (n2 = 1; n2 < 4; ++n2) {
                    graphics.drawString(Global.HELPSTR[this.help_height][n2], 2, n, 20);
                    n += 12;
                }
                break;
            }
            case 3: {
                graphics.setFont(Font.getFont((int)0, (int)1, (int)8));
                if (this.help_height % 3 == 0) {
                    graphics.setColor(0xFFFFFF);
                    graphics.fillRect(0, 0, 96, 65);
                    graphics.setColor(0);
                    int n = -(this.help_height / 3) % 12;
                    for (int i = this.help_height / 36; i < this.help_height / 36 + (this.help_height % 36 == 0 ? 5 : 6); ++i) {
                        graphics.drawString(Global.ABOUTSTR[i], 48, n, 17);
                        n += 12;
                    }
                }
                if (this.help_height >= 924) {
                    this.help_height = 0;
                    break;
                }
                ++this.help_height;
                break;
            }
            case 11: {
                switch (this.screenToLoad) {
                    case 0: {
                        this.screenToLoad = -1;
                        this.gameOver_pix = this.ReadByteArray("gameover.bin", 780, 0);
                        this.state = 8;
                        break;
                    }
                    case 1: {
                        this.screenToLoad = -1;
                        this.end_pix = this.ReadByteArray("end.bin", 780, 0);
                        this.state = 10;
                    }
                }
                break;
            }
            case 4: {
                graphics.setFont(Font.getFont((int)0, (int)0, (int)8));
                graphics.setColor(0xFFFFFF);
                graphics.fillRect(0, 0, 96, 65);
                graphics.setColor(0);
                graphics.drawString("NOT ENOUGH SPACE TO", 48, 12, 17);
                graphics.drawString("SAVE. PLEASE DELETE", 48, 23, 17);
                graphics.drawString("AN APPLICATION TO", 48, 34, 17);
                graphics.drawString("FREE MORE MEMORY", 48, 45, 17);
            }
        }
        if (this.menuSize > 0) {
            this.menuPaint(graphics);
        }
        this.secure = true;
    }

    private void updateNewScore() {
        if (this.currentKeyState == 1) {
            switch (this.currentKey) {
                case 1: {
                    if (this.index_name < 2) {
                        ++this.index_name;
                    } else {
                        this.highscore[3] = (byte)(this.game.score >> 8);
                        this.highscore[4] = (byte)this.game.score;
                        this.insertHighScore(this.highscore, this.index_highScore);
                        if (!this.normal) {
                            this.state = 4;
                            this.menuSet(this.state);
                            return;
                        }
                        this.index_name = 0;
                        this.switchToHighScore();
                    }
                    this.index_char = (byte)(this.highscore[this.index_name] - 65);
                    this.currentKeyState = 0;
                    this.show_high = true;
                    break;
                }
                case 6: {
                    if (this.index_name > 0) {
                        --this.index_name;
                    }
                    this.index_char = (byte)(this.highscore[this.index_name] - 65);
                    this.currentKeyState = 0;
                    this.show_high = true;
                    break;
                }
                case 2: {
                    this.index_char = (byte)(this.index_char - 1);
                    this.index_char = (byte)(this.index_char + 26);
                    this.index_char = (byte)(this.index_char % 26);
                    this.highscore[this.index_name] = (byte)(this.index_char + 65);
                    this.currentKeyState = 0;
                    this.show_high = true;
                    break;
                }
                case 5: {
                    this.index_char = (byte)(this.index_char + 1);
                    this.index_char = (byte)(this.index_char % 26);
                    this.highscore[this.index_name] = (byte)(this.index_char + 65);
                    this.currentKeyState = 0;
                    this.show_high = true;
                }
            }
            this.currentKeyState = 0;
        }
    }

    private void updateHelp() {
        if (this.currentKeyState == 1) {
            switch (this.currentKey) {
                case 1: {
                    --this.help_height;
                    if (this.help_height >= 0) break;
                    this.help_height = 3;
                    break;
                }
                case 6: {
                    ++this.help_height;
                    if (this.help_height <= 3) break;
                    this.help_height = 0;
                }
            }
            this.currentKeyState = 0;
        }
    }

    private void updateGameOver() {
        if (this.gameover_step > 200 || this.currentKeyState == 1 && this.gameover_step >= 64) {
            this.gameover_step = 0;
            this.index_highScore = this.getHighScoreIndex(this.game.score);
            if (!this.normal) {
                this.state = 4;
                this.menuSet(this.state);
                return;
            }
            if (this.index_highScore == 3) {
                this.eraseHighScore();
                if (!this.normal) {
                    this.state = 4;
                    this.menuSet(this.state);
                    return;
                }
                this.switchToMenu();
            } else {
                this.switchToNewHighScore();
            }
            this.gameOver_pix = null;
            this.end_pix = null;
            return;
        }
        this.gameover_step += 2;
    }

    public void loadWall() {
        int n;
        byte[] byArray = new byte[]{0, 0};
        this.game.leftBrick = 0;
        for (n = 0; n < 360; ++n) {
            this.wall_pix[n] = 0;
            this.wall_back_pix[n] = 0;
        }
        int n2 = 0;
        while (true) {
            if (n2 >= 8) break;
            int n3 = n2 * 10 % 8;
            int n4 = 10 - (8 - n3);
            int n5 = n4 - 8;
            block2: for (int i = 0; i < 12; ++i) {
                int n6 = this.game.map.getBrick(n2, i) - 1;
                if (n6 > 4 || n6 < 0) continue;
                if (n6 != 4) {
                    ++this.game.leftBrick;
                }
                n6 *= 6;
                n = i * 3 * 10 + n2 * 10 / 8;
                int n7 = 0;
                while (true) {
                    int n8;
                    if (n7 >= 3) continue block2;
                    int n9 = 0;
                    if ((n9 += this.brick_pix[n6]) < 0) {
                        n9 += 256;
                    }
                    n9 <<= 8;
                    if ((n8 = this.brick_pix[++n6]) < 0) {
                        n8 += 256;
                    }
                    byArray[0] = (byte)((n9 |= n8) >> n3 + 8);
                    byArray[1] = (byte)(n9 >> n3 & 0xFF);
                    int n10 = n;
                    this.wall_pix[n10] = (byte)(this.wall_pix[n10] | byArray[0]);
                    int n11 = n + 1;
                    this.wall_pix[n11] = (byte)(this.wall_pix[n11] | byArray[1]);
                    if (n5 > 0) {
                        int n12 = n + 2;
                        this.wall_pix[n12] = (byte)(this.wall_pix[n12] | 0xFFFFFF80);
                    }
                    ++n6;
                    n += 10;
                    ++n7;
                }
            }
            ++n2;
        }
    }

    public final void eraseBrick(int n, int n2) {
        byte[] byArray = new byte[]{0, 0};
        int n3 = 8 - n * 10 % 8;
        byArray[0] = (byte)(255 << n3);
        byArray[1] = (n3 = 10 - n3) >= 8 ? (byte)0 : (byte)(127 >> n3 - 1);
        n3 -= 8;
        int n4 = n2 * 3 * 10 + n * 10 / 8;
        int n5 = 0;
        while (true) {
            if (n5 >= 3) break;
            int n6 = n4;
            this.wall_back_pix[n6] = (byte)(this.wall_back_pix[n6] & byArray[0]);
            int n7 = n4 + 1;
            this.wall_back_pix[n7] = (byte)(this.wall_back_pix[n7] & byArray[1]);
            if (n3 > 0) {
                int n8 = n4 + 2;
                this.wall_back_pix[n8] = (byte)(this.wall_back_pix[n8] & 0x7F);
            }
            n4 += 10;
            ++n5;
        }
    }

    public final void manageSprite() {
        Sprite sprite;
        this.racket_spr.setPosition(this.game.racket.left(), this.game.racket.top());
        int n = 0;
        while (true) {
            if (n >= 3) break;
            sprite = this.ballSprArray[n];
            if (sprite.getVisible()) {
                Ball ball = this.game.ballArray[n];
                sprite.setPosition(ball.left(), ball.top());
            }
            ++n;
        }
        for (n = 0; n < 8; ++n) {
            sprite = this.bonusSprArray[n];
            if (!sprite.getVisible()) continue;
            Bonus bonus = this.game.bonusArray[n];
            sprite.setPosition(bonus.left(), bonus.top());
        }
        for (n = 0; n < 5; ++n) {
            sprite = this.explosionSprArray[n];
            Sprite sprite2 = this.scoreSprArray[n];
            if (sprite.getVisible()) {
                int n2 = sprite.getFrame();
                if (n2 == 2) {
                    sprite.setVisible(false);
                    sprite.setFrame(0);
                    continue;
                }
                sprite.setFrame(n2 + 1);
                if (sprite2.getYPosition() < 2) continue;
                sprite2.setPosition(sprite2.getXPosition(), sprite2.getYPosition() - 2);
                continue;
            }
            if (!sprite2.getVisible()) continue;
            sprite2.setVisible(false);
            --this.explosionNum;
        }
        if (this.game.missile.active || this.game.missile.ammo > 0) {
            this.missile_spr.setPosition(this.game.missile.X, this.game.missile.Y);
        }
    }

    public final void setScore() {
        this.number_spr[4].setFrame(this.game.score % 10);
        this.number_spr[3].setFrame(this.game.score % 100 / 10);
        this.number_spr[2].setFrame(this.game.score % 1000 / 100);
        this.number_spr[1].setFrame(this.game.score % 10000 / 1000);
        this.number_spr[0].setFrame(this.game.score % 100000 / 10000);
    }

    public final void initLife(int n) {
        if (this.game.life == n) {
            return;
        }
        if (this.game.life > n) {
            for (int i = n; i < this.game.life; ++i) {
                this.gfxManager.deleteObject(this.life_spr[1 - i]);
            }
        } else {
            for (int i = this.game.life; i < n; ++i) {
                this.gfxManager.addObject(this.life_spr[1 - i]);
            }
        }
        this.game.life = n;
    }

    public void removeAll() {
        int n;
        for (n = 0; n < 8; ++n) {
            this.bonusSprArray[n].setVisible(false);
        }
        for (n = 0; n < 5; ++n) {
            this.explosionSprArray[n].setVisible(false);
            this.scoreSprArray[n].setVisible(false);
        }
        this.explosionNum = 0;
        for (n = 0; n < 3; ++n) {
            this.ballSprArray[n].setVisible(false);
        }
        this.game.ballNum = 0;
        for (n = 0; n < 3; ++n) {
            this.animal_sprs[n].setVisible(false);
        }
        this.currentKeyState = 0;
        if (this.game.missile.active) {
            this.game.missile.active = false;
            this.game.missile.unload();
            if (this.game.show_missile) {
                this.game.show_missile = false;
                this.gfxManager.deleteObject(this.missile_spr);
            }
        }
        this.game.showText = 0;
        this.puptext_spr.setVisible(false);
    }

    public final void newExplosion(int n, int n2, int n3) {
        for (int i = 0; i < 5; ++i) {
            Sprite sprite = this.explosionSprArray[i];
            Sprite sprite2 = this.scoreSprArray[i];
            if (sprite.getVisible() || sprite2.getVisible()) continue;
            ++this.explosionNum;
            if (n > 64) {
                n = 64;
            }
            sprite.setPosition(n, n2);
            sprite.setVisible(true);
            sprite2.setVisible(true);
            if (n2 >= 6) {
                sprite2.setPosition(n, n2 - 6);
            } else {
                sprite2.setPosition(n, n2);
            }
            sprite2.setFrame(n3);
            return;
        }
    }

    public int addBall() {
        int n;
        for (n = 0; n < 3; ++n) {
            if (this.ballSprArray[n].getVisible()) continue;
            this.ballSprArray[n].setVisible(true);
            break;
        }
        return n;
    }

    public void removeBall(int n) {
        this.ballSprArray[n].setVisible(false);
    }

    public int addBonus(int n) {
        int n2;
        for (n2 = 0; n2 < 8; ++n2) {
            Sprite sprite = this.bonusSprArray[n2];
            if (sprite.getVisible()) continue;
            sprite.setVisible(true);
            sprite.setFrame(n);
            break;
        }
        return n2;
    }

    public void removeBonus(int n) {
        this.bonusSprArray[n].setVisible(false);
    }

    public void drawGreat() {
        this.graphic.drawString(Global.MISC_STR[7], 48, 40, 17);
    }

    private boolean menuUpdate(int n) {
        if (this.menuSize <= 0) {
            return false;
        }
        if (this.menuOn) {
            if (n == -6) {
                this.menuOn = false;
                this.drawBack = true;
            } else if (n == -7) {
                this.menuOn = false;
                this.menuExec(this.menu[this.menuPos]);
            } else {
                switch (n) {
                    case -1: 
                    case 50: {
                        this.menuPos = (byte)(this.menuPos - 1);
                        if (this.menuPos >= 0) break;
                        this.menuPos = (byte)(this.menuSize - 1);
                        break;
                    }
                    case -2: 
                    case 56: {
                        this.menuPos = (byte)(this.menuPos + 1);
                        if (this.menuPos < this.menuSize) break;
                        this.menuPos = 0;
                    }
                }
            }
            this.secure = true;
            this.repaint();
            this.serviceRepaints();
            return true;
        }
        if (n == -7) {
            this.menuOn = true;
            this.menuPos = 0;
            this.secure = true;
            this.repaint();
            this.serviceRepaints();
            return true;
        }
        return false;
    }

    private void menuSet(int n) {
        if (n >= this.menuSet.length) {
            this.menuSize = (byte)-1;
            return;
        }
        this.menuSize = (byte)(this.menuSet[n].length - 1);
        System.arraycopy(this.menuSet[n], 0, this.menu, 0, this.menuSet[n].length);
        if (n < 2 && this.game.bSound) {
            this.menu[2] = 9;
        }
    }

    private void menuPaint(Graphics graphics) {
        if (this.menuOn) {
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(4, 2, 92, 46);
            graphics.setColor(0);
            graphics.drawRect(4, 2, 91, 45);
            graphics.drawRect(5, 3, 91, 45);
            graphics.setColor(0xFFFFFF);
            graphics.fillRect(5, 3, 90, 44);
            graphics.setColor(0);
            graphics.setFont(Font.getFont((int)64, (int)1, (int)8));
            graphics.drawString("Block Breaker", 49, 4, 17);
            graphics.drawLine(4, 14, 95, 14);
            int n = this.menuPos - 1;
            byte by = this.menuPos;
            int n2 = this.menuPos + 1;
            if (n < 0) {
                n = this.menuSize - 1;
            }
            if (n2 >= this.menuSize) {
                n2 = 0;
            }
            graphics.setFont(Font.getFont((int)64, (int)0, (int)8));
            if (n != by || by != n2) {
                graphics.drawString(Global.COMMAND_LABELS[this.menu[n]], 7, 16, 20);
                graphics.drawString(Global.COMMAND_LABELS[this.menu[n2]], 7, 37, 20);
            }
            graphics.fillRect(5, 25, 90, 11);
            graphics.setColor(0xFFFFFF);
            Font font = Font.getFont((int)64, (int)1, (int)8);
            graphics.setFont(font);
            graphics.drawString(Global.COMMAND_LABELS[this.menu[by]], 7, 26, 20);
            graphics.setColor(0);
            graphics.fillRect(7 + font.stringWidth(Global.COMMAND_LABELS[this.menu[by]]), 25, 1, 11);
            font = Font.getFont((int)64, (int)1, (int)8);
            graphics.setFont(font);
            n = font.stringWidth(Global.COMMAND_LABELS[13]) + 6;
            if (n < 44) {
                n = 44;
            }
            graphics.fillRect(96 - n, 52, n, 13);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(Global.COMMAND_LABELS[13], 99 - n, 53, 20);
            graphics.setColor(0);
            graphics.fillRect(99 - n + font.stringWidth(Global.COMMAND_LABELS[13]), 52, 1, 13);
            n = font.stringWidth(Global.COMMAND_LABELS[14]) + 6;
            if (n < 44) {
                n = 44;
            }
            graphics.fillRect(0, 52, n, 13);
            graphics.setColor(0xFFFFFF);
            graphics.drawString(Global.COMMAND_LABELS[14], 3, 53, 20);
            graphics.setColor(0);
            graphics.fillRect(3 + font.stringWidth(Global.COMMAND_LABELS[14]), 52, 1, 13);
        } else {
            this.gameScreen.drawPixels(this.menu_arrow_pix, this.menu_arrow_pix, 0, 8, 88, 60, 8, 5, 0, 1);
            if (this.state == 0) {
                ++this.draw_loading;
                if ((this.draw_loading & 8) != 0) {
                    this.gameScreen.drawPixels(this.menu_pix, null, 0, 24, 72, 53, 24, 8, 0, 1);
                }
            }
        }
    }

    private void menuExec(int n) {
        switch (n) {
            case 0: {
                this.drawBack = true;
                break;
            }
            case 1: {
                this.removeAll();
                this.state = 12;
                this.menuSet(this.state);
                break;
            }
            case 2: {
                this.removeAll();
                this.state = 13;
                this.menuSet(this.state);
                break;
            }
            case 3: {
                this.game.bSound = true;
                this.menu[2] = 9;
                this.menuOn = true;
                break;
            }
            case 5: {
                this.switchToHelp();
                break;
            }
            case 6: {
                this.switchToHighScore();
                break;
            }
            case 7: {
                this.switchToMenu();
                break;
            }
            case 8: {
                this.switchToAbout();
                break;
            }
            case 9: {
                this.game.bSound = false;
                this.menu[2] = 3;
                this.menuOn = true;
                break;
            }
            case 11: {
                this.running = false;
                BlockBreaker.appz.destroyApp(true);
                break;
            }
            case 15: {
                this.state = this.last_state;
                this.drawBack = true;
                this.menuSet(this.state);
                break;
            }
            case 16: {
                ++this.help_height;
                if (this.help_height <= 3) break;
                this.help_height = 0;
                break;
            }
            case 17: {
                --this.help_height;
                if (this.help_height >= 0) break;
                this.help_height = 3;
                break;
            }
            case 18: {
                this.state = this.last_state;
                this.drawBack = true;
                this.menuSet(this.state);
            }
        }
    }

    public void run() {
        while (this.running) {
            try {
                long l = System.currentTimeMillis();
                this.repaint();
                this.serviceRepaints();
                DeviceControl.stopVibra();
                Thread.sleep(5L);
                l = System.currentTimeMillis() - l;
                if (l >= (long)70) continue;
                Thread.sleep((long)70 - l);
            }
            catch (Exception exception) {}
        }
    }

    static {
        MENU = 0;
        GAME = 1;
        HELP = 2;
        ABOUT = 3;
        ERROR = 4;
        CONSTRUCT = 5;
        LOAD = 6;
        NEW_HIGH_SCORE = 7;
        GAME_OVER = 8;
        HIGH_SCORE = 9;
        END_OF_GAME = 10;
        LOADSCREEN = 11;
        PRE_NEW = 12;
        PRE_CONTINUE = 13;
        NEXT_LEVEL = 14;
        GAME_AREA_WIDTH = 80;
        GAME_AREA_HEIGHT = 65;
        GAME_AREA_POSX = 8;
        GAME_AREA_POSY = 0;
        LEVEL_HEADER_POSX = 32;
        LIFE_HEADER_POSX = 0;
        SCORE_HEADER_POSX = 62;
        HEADER_POSY = 30;
        GAME_SCREEN_WIDTH = 96;
        GAME_SCREEN_HEIGHT = 65;
        PRESSED = 1;
        RELEASED = 0;
        BONUS_MAX = 8;
        EXPLOSION_MAX = 5;
    }
}

