/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework;

import com.appon.miniframework.Container;
import com.appon.miniframework.Control;
import com.appon.miniframework.EventQueue;
import com.appon.miniframework.MenuSerilize;
import com.appon.miniframework.ScrollableContainer;
import com.appon.miniframework.Settings;
import com.appon.miniframework.controls.TabControl;
import com.appon.miniframework.controls.TabPane;
import com.appon.miniframework.layout.PropotionLayout;
import com.appon.miniframework.layout.RelativeLayout;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Util {
    private static int[] sin_tabel = new int[]{0, 286, 572, 857, 1143, 1428, 1713, 1997, 2280, 2563, 2845, 3126, 3406, 3686, 3964, 4240, 4516, 4790, 5063, 5334, 5604, 5872, 6138, 6402, 6664, 6924, 7182, 7438, 7692, 7943, 8193, 8438, 8682, 8923, 9162, 9397, 9630, 9860, 10087, 10311, 10531, 10749, 10963, 11174, 11381, 11585, 11786, 11982, 12176, 12365, 12551, 12733, 12911, 13085, 13255, 13421, 13583, 13741, 13894, 14044, 14189, 14330, 14466, 14598, 14726, 14849, 14968, 15082, 15191, 15296, 15396, 15491, 15582, 15668, 15749, 15826, 15897, 15964, 16026, 16083, 16135, 16182, 16225, 16262, 16294, 16322, 16344, 16362, 16374, 16382, 16384, 16382, 16374, 16362, 16344, 16322, 16294, 16262, 16225, 16182, 16135, 16083, 16026, 15964, 15897, 15826, 15749, 15668, 15582, 15491, 15396, 15296, 15191, 15082, 14968, 14849, 14726, 14598, 14466, 14330, 14189, 14044, 13894, 13741, 13583, 13421, 13255, 13085, 12911, 12733, 12551, 12365, 12176, 11982, 11786, 11585, 11381, 11174, 10963, 10749, 10531, 10311, 10087, 9860, 9630, 9397, 9162, 8923, 8682, 8438, 8193, 7943, 7692, 7438, 7182, 6924, 6664, 6402, 6138, 5872, 5604, 5334, 5063, 4790, 4516, 4240, 3964, 3686, 3406, 3126, 2845, 2563, 2280, 1997, 1713, 1428, 1143, 857, 572, 286, 0, -285, -571, -857, -1142, -1427, -1712, -1996, -2280, -2563, -2845, -3126, -3406, -3685, -3963, -4240, -4516, -4790, -5062, -5334, -5603, -5871, -6137, -6401, -6663, -6924, -7182, -7438, -7691, -7943, -8192, -8438, -8682, -8923, -9161, -9397, -9630, -9860, -10086, -10310, -10531, -10748, -10963, -11173, -11381, -11585, -11785, -11982, -12175, -12365, -12550, -12732, -12910, -13084, -13254, -13420, -13582, -13740, -13894, -14043, -14188, -14329, -14466, -14598, -14725, -14848, -14967, -15081, -15190, -15295, -15395, -15491, -15582, -15668, -15749, -15825, -15897, -15964, -16025, -16082, -16135, -16182, -16224, -16261, -16294, -16321, -16344, -16361, -16374, -16381, -16384, -16381, -16374, -16361, -16344, -16321, -16294, -16261, -16224, -16182, -16135, -16082, -16025, -15964, -15897, -15825, -15749, -15668, -15582, -15491, -15395, -15295, -15190, -15081, -14967, -14848, -14725, -14598, -14466, -14329, -14188, -14043, -13894, -13740, -13582, -13420, -13254, -13084, -12910, -12732, -12550, -12365, -12175, -11982, -11785, -11585, -11381, -11173, -10963, -10748, -10531, -10310, -10086, -9860, -9630, -9397, -9161, -8923, -8682, -8438, -8192, -7943, -7691, -7438, -7182, -6924, -6663, -6401, -6137, -5871, -5603, -5334, -5062, -4790, -4516, -4240, -3963, -3685, -3406, -3126, -2845, -2563, -2280, -1996, -1712, -1427, -1142, -857, -571, -285};
    private static int[] cos_tabel = new int[]{16384, 16382, 16374, 16362, 16344, 16322, 16294, 16262, 16225, 16182, 16135, 16083, 16026, 15964, 15897, 15826, 15749, 15668, 15582, 15491, 15396, 15296, 15191, 15082, 14968, 14849, 14726, 14598, 14466, 14330, 14189, 14044, 13894, 13741, 13583, 13421, 13255, 13085, 12911, 12733, 12551, 12365, 12176, 11982, 11786, 11585, 11381, 11174, 10963, 10749, 10531, 10311, 10087, 9860, 9630, 9397, 9162, 8923, 8682, 8438, 8192, 7943, 7692, 7438, 7182, 6924, 6664, 6402, 6138, 5872, 5604, 5334, 5063, 4790, 4516, 4240, 3964, 3686, 3406, 3126, 2845, 2563, 2280, 1997, 1713, 1428, 1143, 857, 572, 286, 0, -285, -571, -857, -1142, -1427, -1712, -1996, -2280, -2563, -2845, -3126, -3406, -3685, -3963, -4240, -4516, -4790, -5062, -5334, -5603, -5871, -6137, -6401, -6663, -6924, -7182, -7438, -7691, -7943, -8191, -8438, -8682, -8923, -9161, -9397, -9630, -9860, -10086, -10310, -10531, -10748, -10963, -11173, -11381, -11585, -11785, -11982, -12175, -12365, -12550, -12732, -12910, -13084, -13254, -13420, -13582, -13740, -13894, -14043, -14188, -14329, -14466, -14598, -14725, -14848, -14967, -15081, -15190, -15295, -15395, -15491, -15582, -15668, -15749, -15825, -15897, -15964, -16025, -16082, -16135, -16182, -16224, -16261, -16294, -16321, -16344, -16361, -16374, -16381, -16384, -16381, -16374, -16361, -16344, -16321, -16294, -16261, -16224, -16182, -16135, -16082, -16025, -15964, -15897, -15825, -15749, -15668, -15582, -15491, -15395, -15295, -15190, -15081, -14967, -14848, -14725, -14598, -14466, -14329, -14188, -14043, -13894, -13740, -13582, -13420, -13254, -13084, -12910, -12732, -12550, -12365, -12175, -11982, -11785, -11585, -11381, -11173, -10963, -10748, -10531, -10310, -10086, -9860, -9630, -9397, -9161, -8923, -8682, -8438, -8192, -7943, -7691, -7438, -7182, -6924, -6663, -6401, -6137, -5871, -5603, -5334, -5062, -4790, -4516, -4240, -3963, -3685, -3406, -3126, -2845, -2563, -2280, -1996, -1712, -1427, -1142, -857, -571, -285, 0, 286, 572, 857, 1143, 1428, 1713, 1997, 2280, 2563, 2845, 3126, 3406, 3686, 3964, 4240, 4516, 4790, 5063, 5334, 5604, 5872, 6138, 6402, 6664, 6924, 7182, 7438, 7692, 7943, 8192, 8438, 8682, 8923, 9162, 9397, 9630, 9860, 10087, 10311, 10531, 10749, 10963, 11174, 11381, 11585, 11786, 11982, 12176, 12365, 12551, 12733, 12911, 13085, 13255, 13421, 13583, 13741, 13894, 14044, 14189, 14330, 14466, 14598, 14726, 14849, 14968, 15082, 15191, 15296, 15396, 15491, 15582, 15668, 15749, 15826, 15897, 15964, 16026, 16083, 16135, 16182, 16225, 16262, 16294, 16322, 16344, 16362, 16374, 16382};
    private static int[] xPoints = new int[4];
    private static int[] yPoints = new int[4];
    private static byte[] bytes1 = new byte[1];
    private static byte[] bytes2 = new byte[2];
    private static byte[] bytes3 = new byte[3];
    private static byte[] bytes4 = new byte[4];

    public static int sin(int theta) {
        theta %= 360;
        while (theta < 0) {
            theta = 360 - theta;
        }
        return sin_tabel[theta];
    }

    public static int cos(int theta) {
        theta %= 360;
        while (theta < 0) {
            theta = 360 - theta;
        }
        return cos_tabel[theta];
    }

    public static boolean isInRect(int xPos, int yPos, int width, int height, int x, int y) {
        return x >= xPos && x <= xPos + width && y >= yPos && y <= yPos + height;
    }

    public static void selectControl(Control c) {
        Control child = c;
        for (Container parent = c.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof ScrollableContainer) {
                ((ScrollableContainer)parent).selectChild(child, false);
            }
            if (parent instanceof TabControl) {
                ((TabControl)parent).selectTabPane((TabPane)child);
            }
            parent.setSelected(true, false);
            child.setSelected(true, false);
            child = parent;
        }
    }

    public static boolean isInRect(Control control, int x, int y) {
        if (control.getRotation() == 0) {
            return Util.isInRect(control.getX(), control.getY(), control.getWidth(), control.getHeight(), x, y);
        }
        return Util.isInPoly(control, x, y, false);
    }

    public static boolean isInActualRect(Control control, int x, int y) {
        if (control.getRotation() == 0) {
            return Util.isInRect(Util.getActualX(control), Util.getActualY(control), control.getWidth(), control.getHeight(), x, y);
        }
        return Util.isInPoly(control, x, y, true);
    }

    public static int getApproxDistance(int x1, int y1, int x2, int y2) {
        int max;
        int min;
        int dy;
        int dx = Math.abs(x1 - x2);
        if (dx < (dy = Math.abs(y1 - y2))) {
            min = dx;
            max = dy;
        } else {
            min = dy;
            max = dx;
        }
        return (max << 8) + (max << 3) - (max << 4) - (max << 1) + (min << 7) - (min << 5) + (min << 3) - (min << 1) >> 8;
    }

    public static int getColor(int color) {
        return color & 0xFFFFFF;
    }

    public static int getActualX(Control control) {
        int x = control.getX();
        for (Container parent = control.getParent(); parent != null; parent = parent.getParent()) {
            x += parent.getX() + parent.getLeftInBound();
            if (!(parent instanceof Container)) continue;
            x -= parent.getScrolledX();
        }
        return x;
    }

    public static int getActualY(Control control) {
        int y = control.getY();
        for (Container parent = control.getParent(); parent != null; parent = parent.getParent()) {
            y += parent.getY() + parent.getTopInBound();
            if (!(parent instanceof Container)) continue;
            y -= parent.getScrolledY();
        }
        return y;
    }

    public static int getWrappedHeight(Container c) {
        if (c.getSizeSettingY() != 0) {
            return c.getHeight();
        }
        if (!(c.getLayout() instanceof PropotionLayout) && c.getLayout() != null) {
            return c.getLayout().getPreferedHeight(c) + c.getTopInBound() + c.getBottomInBound();
        }
        int h = Integer.MIN_VALUE;
        for (int i = 0; i < c.getSize(); ++i) {
            int tmp;
            Control control = c.getChild(i);
            if (control.getHeightWeight() == -2 || control.isSkipParentWrapSizeCalc()) continue;
            if (control.getRelativeLocation() != null && Util.isHeightParentDepended(control.getRelativeLocation())) {
                tmp = control.getRelativeLocation().getAdditionalPaddingY();
                tmp = control.getSizeSettingY() == 0 && !control.isAdjustDimentionsFromBgImage() ? (tmp += control.getPreferredHeight()) : (tmp += control.getHeight());
                if (h >= tmp) continue;
                h = tmp;
                continue;
            }
            if (control.getSizeSettingY() == 0) {
                tmp = control.getY() + control.getPreferredHeight();
                if (h >= tmp) continue;
                h = tmp;
                continue;
            }
            tmp = control.getY() + control.getHeight();
            if (h >= tmp) continue;
            h = tmp;
        }
        if (h == Integer.MIN_VALUE) {
            return 0;
        }
        return h + c.getTopInBound() + c.getBottomInBound();
    }

    public static boolean isHeightParentDepended(RelativeLayout relativeLocation) {
        return relativeLocation.getRelativeRelationY() == 7 || relativeLocation.getRelativeRelationY() == 5 || relativeLocation.getRelativeRelationY() == 6;
    }

    public static boolean isWidthParentDepended(RelativeLayout relativeLocation) {
        return relativeLocation.getRelativeRelationX() == 7 || relativeLocation.getRelativeRelationX() == 5 || relativeLocation.getRelativeRelationX() == 6;
    }

    public static int getWrappedWidth(Container c) {
        if (c.getSizeSettingX() != 0) {
            return c.getWidth();
        }
        if (!(c.getLayout() instanceof PropotionLayout) && c.getLayout() != null) {
            return c.getLayout().getPreferedWidth(c) + c.getLeftInBound() + c.getRightInBound();
        }
        int w = Integer.MIN_VALUE;
        for (int i = 0; i < c.getSize(); ++i) {
            int tmp;
            Control control = c.getChild(i);
            if (control.getWidthWeight() == -2 || control.isSkipParentWrapSizeCalc()) continue;
            if (control.getRelativeLocation() != null && Util.isWidthParentDepended(control.getRelativeLocation())) {
                tmp = control.getRelativeLocation().getAdditionalPaddingX();
                tmp = control.getSizeSettingX() == 0 && !control.isAdjustDimentionsFromBgImage() ? (tmp += control.getPreferredWidth()) : (tmp += control.getWidth());
                if (w >= tmp) continue;
                w = tmp;
                continue;
            }
            if (control.getSizeSettingX() == 0) {
                tmp = control.getX() + control.getPreferredWidth();
                if (w >= tmp) continue;
                w = tmp;
                continue;
            }
            tmp = control.getX() + control.getWidth();
            if (w >= tmp) continue;
            w = tmp;
        }
        if (w == Integer.MIN_VALUE) {
            return 0;
        }
        return w + c.getLeftInBound() + c.getRightInBound();
    }

    public static int getScaleValue(int value, int scale) {
        boolean sign = value >= 0;
        value = Math.abs(value);
        value += value * scale / 100;
        if (!sign) {
            value = -value;
        }
        return value;
    }

    public static int getScaleX() {
        return 100 * (Settings.SCREEN_WIDTH - Settings.MASTER_SCREEN_WIDTH) / Settings.MASTER_SCREEN_WIDTH;
    }

    public static int getScaleY() {
        return 100 * (Settings.SCREEN_HEIGHT - Settings.MASTER_SCREEN_HEIGHT) / Settings.MASTER_SCREEN_HEIGHT;
    }

    public static boolean isInPoly(Control c, int x, int y, boolean isActual) {
        int _x = c.getX();
        int _y = c.getY();
        if (isActual) {
            _x = Util.getActualX(c);
            _y = Util.getActualY(c);
        }
        Util.xPoints[0] = _x;
        Util.yPoints[0] = _y;
        Util.xPoints[1] = _x + c.getWidth();
        Util.yPoints[1] = _y;
        Util.xPoints[2] = _x + c.getWidth();
        Util.yPoints[2] = _y + c.getHeight();
        Util.xPoints[3] = _x;
        Util.yPoints[3] = _y + c.getHeight();
        Util.rotateCoordinates(xPoints, yPoints, _x + (c.getWidth() >> 1), _y + (c.getHeight() >> 1), c.getRotation());
        return Util.pnpoly(4, xPoints, yPoints, x, y);
    }

    public static void rotateCoordinates(int[] x, int[] y, int centerX, int centerY, int rotation) {
    }

    public static boolean pnpoly(int npol, int[] xp, int[] yp, int x, int y) {
        boolean c = false;
        int i = 0;
        int j = npol - 1;
        while (i < npol) {
            if ((yp[i] <= y && y < yp[j] || yp[j] <= y && y < yp[i]) && x < (xp[j] - xp[i]) * (y - yp[i]) / (yp[j] - yp[i]) + xp[i]) {
                c = !c;
            }
            j = i++;
        }
        return c;
    }

    public static boolean isRectCollision(int xPos1, int ypos1, int width1, int height1, int xPos2, int ypos2, int width2, int height2) {
        if (xPos1 > xPos2 + width2 || xPos1 + width1 < xPos2) {
            return false;
        }
        return ypos1 <= ypos2 + height2 && ypos1 + height1 >= ypos2;
    }

    public static Container getRootControl(Control c) {
        if (c == null) {
            return null;
        }
        while (c.getParent() != null) {
            c = c.getParent();
        }
        if (c instanceof Container) {
            return (Container)c;
        }
        return null;
    }

    public static Control findControl(Container parent, int id) {
        if (id == -1) {
            throw new RuntimeException("Trying to found invalid control");
        }
        if (parent.getId() == id) {
            return parent;
        }
        for (int i = 0; i < parent.getSize(); ++i) {
            Control found;
            Control object = parent.getChild(i);
            if (object.getId() == id) {
                return object;
            }
            if (!(object instanceof Container) || (found = Util.findControl((Container)object, id)) == null) continue;
            return found;
        }
        return null;
    }

    public static int getChildernLayoutWrapHeight(Control control) {
        int h = control.getHeight();
        if (control.isSkipParentWrapSizeCalc()) {
            return 0;
        }
        if (control instanceof Container) {
            h = Util.getWrappedHeight((Container)control);
        } else if (control.getSizeSettingY() == 0 && control.getHeightWeight() <= 0 && !control.isAdjustDimentionsFromBgImage()) {
            h = control.getPreferredHeight();
        }
        return h;
    }

    public static int getChildernLayoutWrapWidth(Control control) {
        int h = control.getWidth();
        if (control.isSkipParentWrapSizeCalc()) {
            return 0;
        }
        if (control instanceof Container) {
            h = Util.getWrappedWidth((Container)control);
        } else if (control.getSizeSettingX() == 0 && control.getWidthWeight() <= 0 && !control.isAdjustDimentionsFromBgImage()) {
            h = control.getPreferredWidth();
        }
        return h;
    }

    public static int readSignedInt(ByteArrayInputStream bis, int numOfBytes) throws Exception {
        int value = Util.read(bis, numOfBytes);
        int signBit = 0;
        int valueWitoutSign = value;
        if (numOfBytes == 1) {
            signBit = value & 0x80;
            valueWitoutSign &= 0x7F;
        } else if (numOfBytes == 2) {
            signBit = value & 0x8000;
            valueWitoutSign &= Short.MAX_VALUE;
        } else if (numOfBytes == 3) {
            signBit = value & 0x800000;
            valueWitoutSign &= 0x7FFFFF;
        } else if (numOfBytes == 4) {
            signBit = value & 0x800000;
            valueWitoutSign &= 0x7FFFFF;
        }
        if (signBit > 0) {
            valueWitoutSign = -valueWitoutSign;
        }
        return valueWitoutSign;
    }

    public static void writeSignedInt(ByteArrayOutputStream bos, int i, int numOfBytes) throws Exception {
        int valueWithoutSign = Math.abs(i);
        int signValue = 1;
        if (i < 0) {
            signValue = numOfBytes == 1 ? 128 : (numOfBytes == 2 ? 32768 : (numOfBytes == 3 ? 0x800000 : 0x800000));
            valueWithoutSign = signValue | valueWithoutSign;
        }
        Util.write(bos, valueWithoutSign, numOfBytes);
    }

    public static int read(ByteArrayInputStream fis, int noofBytes) throws Exception {
        byte[] data = new byte[noofBytes];
        fis.read(data);
        return Util.byteToint(data, noofBytes);
    }

    public static int byteToint(byte[] temp, int noofBytes) {
        int _lib_pOffset = 0;
        switch (noofBytes) {
            case 1: {
                _lib_pOffset = temp[0] & 0xFF;
                break;
            }
            case 2: {
                _lib_pOffset = temp[0] & 0xFF;
                _lib_pOffset += (temp[1] & 0xFF) << 8;
                break;
            }
            case 3: {
                _lib_pOffset = temp[0] & 0xFF;
                _lib_pOffset += (temp[1] & 0xFF) << 8;
                if (temp[2] != 1) break;
                _lib_pOffset *= -1;
                break;
            }
            case 4: {
                _lib_pOffset = temp[0] & 0xFF;
                _lib_pOffset += (temp[1] & 0xFF) << 8;
                _lib_pOffset += (temp[2] & 0xFF) << 16;
                _lib_pOffset += (temp[3] & 0xFF) << 24;
            }
        }
        return _lib_pOffset;
    }

    public static void write(ByteArrayOutputStream bos, int value, int noofBytes) throws Exception {
        bos.write(Util.intToBytes(value, noofBytes));
    }

    public static byte[] intToBytes(int i, int noofBytes) {
        boolean negative = false;
        if (i < 0) {
            negative = true;
            i *= -1;
        }
        byte[] dword = null;
        switch (noofBytes) {
            case 1: {
                dword = bytes1;
                dword[0] = (byte)(i & 0xFF);
                break;
            }
            case 2: {
                dword = bytes2;
                dword[0] = (byte)(i & 0xFF);
                dword[1] = (byte)(i >> 8 & 0xFF);
                break;
            }
            case 3: {
                dword = bytes3;
                dword[0] = (byte)(i & 0xFF);
                dword[1] = (byte)(i >> 8 & 0xFF);
                if (negative) {
                    dword[2] = 1;
                    break;
                }
                dword[2] = 0;
                break;
            }
            case 4: {
                dword = bytes4;
                dword[0] = (byte)(i & 0xFF);
                dword[1] = (byte)(i >> 8 & 0xFF);
                dword[2] = (byte)(i >> 16 & 0xFF);
                dword[3] = (byte)(i >> 24 & 0xFF);
            }
        }
        return dword;
    }

    public static void writeInt(ByteArrayOutputStream bos, int value, int numOfBytes) throws Exception {
        bos.write(Util.intToBytes(value, numOfBytes));
    }

    public static void writeBoolean(ByteArrayOutputStream bos, boolean value) throws Exception {
        int val = 0;
        if (value) {
            val = 1;
        }
        bos.write(val);
    }

    public static boolean readBoolean(ByteArrayInputStream bis) throws Exception {
        byte val = (byte)bis.read();
        return val == 1;
    }

    public static void writeColor(ByteArrayOutputStream bos, int value) throws Exception {
        if (value == -1) {
            bos.write(0);
        } else {
            bos.write(1);
            if (value < 0) {
                bos.write(1);
            } else {
                bos.write(0);
            }
            bos.write(Util.intToBytes(Math.abs(value), 4));
        }
    }

    public static int readColor(ByteArrayInputStream bis) throws Exception {
        int val = bis.read();
        if (val == 0) {
            return -1;
        }
        int sign = bis.read();
        bis.read(bytes4);
        int finalValue = Util.byteToint(bytes4, 4);
        if (sign == 1) {
            finalValue = -finalValue;
        }
        return finalValue;
    }

    public static void writeString(ByteArrayOutputStream bos, String value) throws Exception {
        if (value == null) {
            bos.write(0);
        } else {
            bos.write(1);
            MenuSerilize.serialize(value, bos);
        }
    }

    public static int readInt(ByteArrayInputStream bis, int numOfBytes) throws Exception {
        byte[] b = Util.getByteArray(numOfBytes);
        bis.read(b);
        return Util.byteToint(b, numOfBytes);
    }

    public static String readString(ByteArrayInputStream bis) throws Exception {
        int value = bis.read();
        if (value == 0) {
            return null;
        }
        return (String)MenuSerilize.deserialize(bis, null);
    }

    private static byte[] getByteArray(int numOfBytes) {
        switch (numOfBytes) {
            case 1: {
                return bytes1;
            }
            case 2: {
                return bytes2;
            }
            case 3: {
                return bytes3;
            }
        }
        return bytes4;
    }

    public static void writeIntArray(ByteArrayOutputStream bos, int[] value) throws Exception {
        if (value == null) {
            bos.write(0);
        } else {
            bos.write(1);
            MenuSerilize.serialize(value, bos);
        }
    }

    public static int[] readIntArray(ByteArrayInputStream bis) throws Exception {
        int value = bis.read();
        if (value == 0) {
            return null;
        }
        return (int[])MenuSerilize.deserialize(bis, null);
    }

    public static void write2DIntArray(ByteArrayOutputStream bos, int[][] value) throws Exception {
        if (value == null) {
            bos.write(0);
        } else {
            bos.write(1);
            MenuSerilize.serialize(value, bos);
        }
    }

    public static int[][] read2DIntArray(ByteArrayInputStream bis) throws Exception {
        int value = bis.read();
        if (value == 0) {
            return null;
        }
        return (int[][])MenuSerilize.deserialize(bis, null);
    }

    public static void writeBooleanArray(ByteArrayOutputStream bos, boolean[] value) throws Exception {
        if (value == null) {
            bos.write(0);
        } else {
            bos.write(1);
            MenuSerilize.serialize(value, bos);
        }
    }

    public static boolean[] readBooleanArray(ByteArrayInputStream bis) throws Exception {
        int value = bis.read();
        if (value == 0) {
            return null;
        }
        return (boolean[])MenuSerilize.deserialize(bis, null);
    }

    public static void prepareDisplay(ScrollableContainer container) {
        container.showNotify();
        container.resetAnimations();
        EventQueue.getInstance().reset();
        if (container.isSelectable()) {
            container.fourceSelect();
        }
    }

    public static void reallignContainer(ScrollableContainer container) {
        container.init();
        Util.prepareDisplay(container);
    }

    public static ScrollableContainer loadContainer(byte[] data) throws Exception {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ScrollableContainer container = (ScrollableContainer)MenuSerilize.deserialize(bis, MenuSerilize.getInstance());
        container.port();
        container.init();
        Util.prepareDisplay(container);
        return container;
    }

    public static ScrollableContainer loadContainer(byte[] data, int masterWidth, int masterHeight, int newWidth, int newHeight, boolean isTouch) throws Exception {
        Settings.MASTER_SCREEN_WIDTH = masterWidth;
        Settings.MASTER_SCREEN_HEIGHT = masterHeight;
        Settings.SCREEN_WIDTH = newWidth;
        Settings.SCREEN_HEIGHT = newHeight;
        Settings.TOUCH_DEVICE = isTouch;
        Settings.enableAnimations = true;
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        Settings.VERSION_NUMBER_FOUND = Util.readInt(bis, 1);
        ScrollableContainer container = (ScrollableContainer)MenuSerilize.deserialize(bis, MenuSerilize.getInstance());
        container.port();
        container.init();
        Util.prepareDisplay(container);
        return container;
    }

    public static final int getAddonParentsX(Control control) {
        int addonX = 0;
        while (control.getParent() != null) {
            addonX += control.getParent().getX() + control.getParent().getLeftInBound();
            control = control.getParent();
        }
        return addonX;
    }

    public static final int getAddonParentsY(Control control) {
        int addonY = 0;
        while (control.getParent() != null) {
            addonY += control.getParent().getY() + control.getParent().getTopInBound();
            control = control.getParent();
        }
        return addonY;
    }

    public static int getImageWidth(Image image) {
        return image.getWidth();
    }

    public static int getImageHeight(Image image) {
        return image.getHeight();
    }

    public static void drawImage(Graphics g, Image image, int x, int y) {
        g.drawImage(image, x, y, 0);
    }
}

