/*
 * Decompiled with CFR 0.152.
 */
package com.appon.leaderBoard;

import com.appon.gtantra.GFont;
import com.appon.leaderBoard.LeaderBoardListener;
import com.appon.leaderBoard.Tag;
import com.appon.leaderBoard.XMLParser;
import com.appon.util.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;

public class LeaderBoard
implements Runnable,
CommandListener {
    private int screenWidth;
    private int screenHeight;
    private int[] scores;
    private String[] names;
    private GFont font;
    private GFont titleFont;
    private GFont softKeyFont;
    private static final int PADDING = 2;
    private Image arrowImage;
    private String[] displayList;
    private int scrolledY;
    private int maxScrolledY;
    private int boxX;
    private int boxY;
    private int boxWidth;
    private int boxHeight;
    private static final int STATE_SCORE_FETCH = 0;
    private static final int STATE_SCORE_POST = 1;
    private static final int STATE_DISPLAY = 2;
    private static final int STATE_ERROR = 3;
    private int scoreState = 0;
    private int usersScore;
    private String userName = "";
    private static final String RMS_USER_NAME = "usernamerms";
    private Display display;
    private Canvas gameCanvas;
    private TextBox textBox;
    private Command commandBack = new Command("Back", 2, 0);
    private Command commandSumbit = new Command("Submit", 4, 1);
    private int userId = -1;
    private LeaderBoardListener listener;
    private Vector scoreVector;
    private boolean scrollAtFirst = false;
    private String gameKey;
    private int currentFetchedScore = -1;
    private int loadingEllipsesCount = 0;
    int lastY;
    private static final String TITLE_TEXT = "HighScores";

    public LeaderBoard(Canvas gameCanvas, Display display, int screenWidth, int screenHeight, GFont font, GFont titleFont, GFont softKeyFont, Image downArrow, String gameKey) {
        this.screenWidth = screenWidth;
        this.screenHeight = screenHeight;
        this.font = font;
        this.titleFont = titleFont;
        this.softKeyFont = softKeyFont;
        this.arrowImage = downArrow;
        this.display = display;
        this.gameCanvas = gameCanvas;
        this.textBox = new TextBox("Please Enter name: ", "", 10, 0);
        this.textBox.addCommand(this.commandBack);
        this.textBox.addCommand(this.commandSumbit);
        this.textBox.setCommandListener((CommandListener)this);
        this.gameKey = gameKey;
    }

    public void setListener(LeaderBoardListener listener) {
        this.listener = listener;
    }

    public void start(int userScore) {
        this.usersScore = userScore;
        this.setScoreState(0);
    }

    private void drawScoreBox(Graphics g, int x, int y, int width, int height) {
        this.boxX = x;
        this.boxY = y;
        this.boxWidth = width;
        this.boxHeight = height;
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        g.setClip(x, y, width, height);
        g.translate(0, y + this.scrolledY);
        int _y = 0;
        this.maxScrolledY = 0;
        for (int i = 0; i < this.displayList.length; ++i) {
            Entry entry = (Entry)this.scoreVector.elementAt(i);
            if (entry.userId == (long)this.userId) {
                this.currentFetchedScore = this.scores[i];
                int itemHeight = this.drawYourScore(g, 0, _y, i);
                if (this.scrollAtFirst && _y > height - itemHeight) {
                    this.scrolledY = -_y;
                }
                _y += itemHeight;
                continue;
            }
            _y += this.drawOtherScore(g, 0, _y, i);
        }
        this.maxScrolledY = _y - height;
        g.setClip(clipX, clipY, clipWidth, clipHeight);
        this.scrollAtFirst = false;
    }

    private void paintScore(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.screenWidth, this.screenHeight);
        int _y = 2;
        int height = 0;
        _y += height;
        if (this.isScrollableUp()) {
            g.drawRegion(this.arrowImage, 0, 0, this.arrowImage.getWidth(), this.arrowImage.getHeight(), 1, this.screenWidth - this.arrowImage.getWidth() >> 1, _y, 20);
        }
        _y += this.arrowImage.getHeight();
        int bottomY = this.screenHeight - this.drawSoftKeys(g);
        bottomY -= this.drawYourHighscore(g, 0, bottomY);
        bottomY -= this.arrowImage.getHeight();
        if (this.isScrollableDown()) {
            g.drawImage(this.arrowImage, this.screenWidth - this.arrowImage.getWidth() >> 1, bottomY, 20);
        }
        int remainingHeight = bottomY - _y;
        this.drawScoreBox(g, 0, _y, this.screenWidth, remainingHeight);
    }

    public void PAINT(Graphics g) {
        switch (this.scoreState) {
            case 2: {
                this.paintScore(g);
                break;
            }
            case 3: {
                this.drawErrorScreen(g);
                break;
            }
            case 0: 
            case 1: {
                this.paintLoading(g);
            }
        }
    }

    private String getScoreRow(int index) {
        int rightWidth = this.font.getStringWidth(this.scores[index] + "") + 2;
        int additionalWidth = this.font.getStringWidth(" - ");
        int remainingWidth = this.screenWidth - rightWidth - additionalWidth - 2 - this.font.getStringWidth("9 ");
        String text = "";
        for (int charIndex = 0; charIndex < this.names[index].length() && this.font.getStringWidth(text) < remainingWidth; ++charIndex) {
            text = text + this.names[index].charAt(charIndex);
        }
        if (index < text.length() && this.font.getStringWidth(text + ".") > remainingWidth) {
            text = text.substring(0, text.length() - 1);
            text = text + ".";
        }
        return index + 1 + " " + text;
    }

    public boolean keyPRESSED(int gameKey, int keycode) {
        switch (this.scoreState) {
            case 3: {
                if (!Util.isLeftSoftkeyPressed(keycode)) break;
                this.backPressedOnError();
                return true;
            }
            case 2: {
                if (Util.isLeftSoftkeyPressed(keycode)) {
                    this.backPressedOnDisplay();
                    return true;
                }
                if (Util.isRightSoftkeyPressed(keycode)) {
                    this.submitPressedOnDisplay();
                    return true;
                }
                if (Util.isUpPressed(gameKey) && this.isScrollableUp()) {
                    this.scrolledY += this.font.getFontHeight();
                    return true;
                }
                if (Util.isDownPressed(gameKey) && this.isScrollableDown()) {
                    this.scrolledY -= this.font.getFontHeight();
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean isScrollableUp() {
        return this.scrolledY < 0;
    }

    private boolean isScrollableDown() {
        return this.scrolledY > -this.maxScrolledY;
    }

    public void pointerPressed(int x, int y) {
        this.lastY = y;
        if (this.scoreState == 3) {
            if (this.checkLSKCollision(x, y)) {
                this.backPressedOnError();
            }
        } else if (this.scoreState == 2) {
            if (this.checkLSKCollision(x, y)) {
                this.backPressedOnDisplay();
            } else if (this.checkRSKCollision(x, y)) {
                this.submitPressedOnDisplay();
            }
        }
    }

    public void pointerReleased(int x, int y) {
        this.lastY = y;
    }

    public boolean pointerDragged(int x, int y) {
        if (this.scoreState == 2) {
            int diff = y - this.lastY;
            this.lastY = y;
            if (LeaderBoard.isInRect(this.boxX, this.boxY, this.boxWidth, this.boxHeight, x, y)) {
                this.scrolledY += diff;
                if (this.scrolledY < -this.maxScrolledY) {
                    this.scrolledY = -this.maxScrolledY;
                    return true;
                }
                if (this.scrolledY > 0) {
                    this.scrolledY = 0;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static boolean isInRect(int xPos, int yPos, int width, int height, int x, int y) {
        return x >= xPos && x <= xPos + width && y >= yPos && y <= yPos + height;
    }

    public static void deleteRMS(String rms) {
        try {
            RecordStore.deleteRecordStore((String)rms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateRecord() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(bos);
            dos.writeUTF(this.userName);
            if (this.userId == -1) {
                dos.writeInt(-2);
            } else {
                dos.writeInt(this.userId);
            }
            dos.flush();
            byte[] data = bos.toByteArray();
            LeaderBoard.updateRecord(RMS_USER_NAME, data);
            dos.close();
            bos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void restoreRMS() {
        try {
            byte[] data = LeaderBoard.getRmsData(RMS_USER_NAME);
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            DataInputStream dis = new DataInputStream(bis);
            this.userName = dis.readUTF();
            this.userId = dis.readInt();
            if (this.userId == -2) {
                this.userId = -1;
            }
            dis.close();
            bis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRecord(String rmsname, byte[] data) {
        LeaderBoard.deleteRMS(rmsname);
        RecordStore rs = null;
        try {
            rs = RecordStore.openRecordStore((String)rmsname, (boolean)true);
            rs.addRecord(data, 0, data.length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                rs.closeRecordStore();
            }
            catch (Exception exception) {}
        }
    }

    private static byte[] getRmsData(String rmsName) {
        try {
            RecordEnumeration enu;
            RecordStore rs = RecordStore.openRecordStore((String)rmsName, (boolean)false);
            if (rs.getNumRecords() > 0 && (enu = rs.enumerateRecords(null, null, false)).hasNextElement()) {
                byte[] data = enu.nextRecord();
                enu.destroy();
                rs.closeRecordStore();
                return data;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void run() {
        if (this.scoreState == 0) {
            this.restoreRMS();
            try {
                byte[] data = this.fetchData(this.getScoreFetchUrl());
                ByteArrayInputStream bis = new ByteArrayInputStream(data);
                XMLParser parser = new XMLParser(bis);
                Tag tag = parser.read();
                this.scoreVector = new Vector();
                while (tag.get_Event() != 1) {
                    switch (tag.get_Event()) {
                        case 2: {
                            if (!tag.get_TagName().equals("row")) break;
                            Entry entry = new Entry();
                            while (tag.get_Event() != 3 || !tag.get_TagName().equals("row")) {
                                tag = parser.read();
                                if (tag.get_Event() != 2) continue;
                                if (tag.get_TagName().equals("username")) {
                                    entry.username = tag.get_TagText();
                                    continue;
                                }
                                if (tag.get_TagName().equals("score")) {
                                    entry.score = Integer.parseInt(tag.get_TagText());
                                    continue;
                                }
                                if (tag.get_TagName().equals("additionaldata")) {
                                    entry.addtionalData = tag.get_TagText();
                                    continue;
                                }
                                if (!tag.get_TagName().equals("userid")) continue;
                                entry.userId = Long.parseLong(tag.get_TagText().trim());
                            }
                            this.scoreVector.addElement(entry);
                        }
                    }
                    tag = parser.read();
                }
                if (this.scoreVector.size() == 0) {
                    throw new Exception();
                }
                this.scores = new int[this.scoreVector.size()];
                this.names = new String[this.scoreVector.size()];
                this.displayList = new String[this.scoreVector.size()];
                for (int i = 0; i < this.scoreVector.size(); ++i) {
                    Entry entry = (Entry)this.scoreVector.elementAt(i);
                    this.scores[i] = entry.score;
                    this.names[i] = entry.username;
                    this.displayList[i] = this.getScoreRow(i);
                }
                this.setScoreState(2);
            }
            catch (Exception e) {
                this.setScoreState(3);
            }
        } else if (this.scoreState == 1) {
            this.display.setCurrent((Displayable)this.gameCanvas);
            this.userName = this.textBox.getString();
            this.updateRecord();
            try {
                byte[] data = this.fetchData(this.getPostScoreUrl());
                if (data != null) {
                    ByteArrayInputStream bis = new ByteArrayInputStream(data);
                    XMLParser parser = new XMLParser(bis);
                    Tag tag = parser.read();
                    while (tag.get_Event() != 1) {
                        if (tag.get_TagName() != null && tag.get_TagName().equals("UserId")) {
                            this.userId = Integer.parseInt(tag.get_TagText().trim());
                            break;
                        }
                        tag = parser.read();
                    }
                }
                if (this.userId == -1 || this.userId == -2) {
                    Alert alert = new Alert("Score", "Sorry, Your score do not stand in top scorers list.", null, AlertType.INFO);
                    alert.setTimeout(-2);
                    this.display.setCurrent(alert, (Displayable)this.gameCanvas);
                } else {
                    this.updateRecord();
                }
                System.out.println("After posting: " + this.userId);
                this.setScoreState(0);
            }
            catch (Exception e) {
                this.setScoreState(3);
            }
        }
    }

    private void setScoreState(int state) {
        this.scoreState = state;
        if (state == 0 || state == 1) {
            this.scrollAtFirst = true;
            new Thread(this).start();
        }
    }

    private byte[] fetchData(String url) throws Exception {
        int rd;
        HttpConnection connection = null;
        InputStream is = null;
        connection = (HttpConnection)Connector.open((String)url, (int)1, (boolean)true);
        connection.setRequestProperty("Connection", "close");
        connection.setRequestMethod("GET");
        is = connection.openInputStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[256];
        while ((rd = is.read(buf, 0, 256)) != -1) {
            bos.write(buf, 0, rd);
        }
        bos.flush();
        buf = bos.toByteArray();
        is.close();
        connection.close();
        System.out.println("data: " + buf.length);
        return buf;
    }

    private boolean checkRSKCollision(int x, int y) {
        int _y = this.screenHeight - this.softKeyFont.getFontHeight();
        return LeaderBoard.isInRect(this.screenWidth >> 1, _y, this.screenWidth >> 1, this.softKeyFont.getFontHeight(), x, y);
    }

    private boolean checkLSKCollision(int x, int y) {
        int _y = this.screenHeight - (this.softKeyFont.getFontHeight() << 1);
        return LeaderBoard.isInRect(0, _y, this.screenWidth >> 1, this.softKeyFont.getFontHeight() << 1, x, y);
    }

    private void backPressedOnError() {
        if (this.listener != null) {
            this.listener.onBackFromLeaderBoard();
        }
    }

    private void backPressedOnDisplay() {
        if (this.listener != null) {
            this.listener.onBackFromLeaderBoard();
        }
    }

    private void submitPressedOnDisplay() {
        if (this.currentFetchedScore >= this.usersScore) {
            return;
        }
        if (this.userName != null) {
            this.textBox.setString(this.userName);
        }
        this.display.setCurrent((Displayable)this.textBox);
    }

    public void commandAction(Command c, Displayable d) {
        if (c.equals(this.commandBack)) {
            this.display.setCurrent((Displayable)this.gameCanvas);
        } else if (c.equals(this.commandSumbit)) {
            String name = this.textBox.getString();
            if (name != null && name.trim().length() != 0) {
                this.setScoreState(1);
            } else {
                Alert alert = new Alert("Score", "Please enter valid name.", null, AlertType.INFO);
                alert.setTimeout(-2);
                this.display.setCurrent((Displayable)alert);
            }
        }
    }

    private String getValidUrl(String url) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < url.length(); ++i) {
            char ch = url.charAt(i);
            if (ch == ' ') {
                buffer.append("%20");
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    private void drawErrorScreen(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.screenWidth, this.screenHeight);
        this.softKeyFont.drawPage(g, "Error while fetching data.", 0, 2, this.screenWidth, -1, 20);
        int bottomY = this.screenHeight - this.softKeyFont.getFontHeight();
        this.softKeyFont.drawString(g, "Back", 0, bottomY, 20);
    }

    private int drawYourHighscore(Graphics g, int x, int bottomY) {
        String text = "Your Score: ";
        if (this.userName != null && this.userName.trim().length() != 0) {
            text = this.userName + ": ";
        }
        text = text + "" + this.usersScore;
        g.setColor(30374);
        int height = this.font.getFontHeight();
        g.fillRect(0, bottomY - this.font.getFontHeight(), this.screenWidth, height);
        this.font.drawString(g, text, x, bottomY - this.font.getFontHeight(), 20);
        return this.font.getFontHeight();
    }

    private int drawHighScoreTitle(Graphics g, int _y) {
        int height = this.titleFont.getFontHeight() + 4;
        g.setColor(34492);
        g.fillRect(0, 0, this.screenWidth, height);
        this.titleFont.drawString(g, TITLE_TEXT, this.screenWidth >> 1, _y + 2, 17);
        return height;
    }

    private int drawSoftKeys(Graphics g) {
        int bottomY = this.screenHeight - this.softKeyFont.getFontHeight();
        this.softKeyFont.drawString(g, "Back", 0, bottomY, 20);
        if (this.currentFetchedScore < this.usersScore && this.usersScore != 0) {
            this.softKeyFont.drawString(g, "Submit", this.screenWidth - this.softKeyFont.getStringWidth("Submit"), bottomY, 20);
        }
        return this.softKeyFont.getFontHeight();
    }

    private int drawOtherScore(Graphics g, int x, int _y, int index) {
        int height = this.font.getFontHeight() + 4;
        g.setColor(1650010);
        g.fillRect(x, _y + 2, this.screenWidth, height - 4);
        this.font.drawString(g, this.displayList[index], x, _y + 2, 20);
        this.font.drawString(g, ": " + this.scores[index], this.screenWidth - 2, _y + 2, 24);
        return this.font.getFontHeight() + 4;
    }

    private int drawYourScore(Graphics g, int x, int _y, int index) {
        int _height = this.font.getFontHeight() + 4;
        g.setColor(30374);
        g.fillRect(x, _y, this.screenWidth, _height);
        this.font.drawString(g, this.displayList[index], x, _y + 2, 20);
        this.font.drawString(g, ": " + this.scores[index], this.screenWidth - 2, _y + 2, 24);
        return _height;
    }

    private String getScoreFetchUrl() {
        return "http://www.appon.co.in/PostScore.aspx?type=displayRank&GameKey=GladiatorEscape";
    }

    private String getPostScoreUrl() {
        String textUserId = "";
        if (this.userId != -1) {
            textUserId = ("" + this.userId).trim();
        }
        return this.getValidUrl("http://www.appon.co.in/PostScore.aspx?type=postscore&UserId=" + textUserId + "&UserName=" + this.userName.trim() + "&Score=" + this.usersScore + "&Additional=null&GameKey=GladiatorEscape");
    }

    private void paintLoading(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, this.screenWidth, this.screenHeight);
        String text = "Fetching";
        if (this.scoreState == 1) {
            text = "Submitting";
        }
        for (int i = 0; i < this.loadingEllipsesCount; ++i) {
            text = text + ".";
        }
        int _y = this.screenHeight - this.screenHeight * 25 / 100;
        this.softKeyFont.drawString(g, text, 0, _y, 20);
        _y += this.softKeyFont.getFontHeight() + 2;
        ++this.loadingEllipsesCount;
        if (this.loadingEllipsesCount > 3) {
            this.loadingEllipsesCount = 0;
        }
        g.setColor(0xFFFF00);
        g.drawLine(0, _y, this.screenWidth, _y);
        g.drawLine(0, _y + 2, this.screenWidth, _y + 2);
    }

    class Entry {
        String username;
        int score;
        String addtionalData;
        long userId;

        Entry() {
        }
    }
}

