/*
 * Decompiled with CFR 0.152.
 */
package com.appon.runner;

import com.appon.knighttestgame.customShapes.MovingLog;
import com.appon.knighttestgame.customShapes.Rope;
import com.appon.runner.RunnerCheckPoint;
import com.appon.runner.RunnerListener;
import com.appon.runner.customize.Customize;
import com.appon.runner.model.AddedShape;
import com.appon.runner.model.CustomShape;
import com.appon.runner.model.EmptyCustom;
import com.appon.runner.model.ImageShape;
import com.appon.runner.model.Shape;
import com.appon.runner.model.ShapeGroup;
import com.appon.runner.util.Util;
import com.indiagames.arjunprince.Constant;
import com.indiagames.arjunprince.Hero;
import com.indiagames.arjunprince.KnightTestEngine;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class RunnerManager {
    private static RunnerManager manager;
    private static int quickplayLevelcounter;
    private Vector shapeList = new Vector();
    private Vector onScreenObjects = new Vector();
    private Vector requestAddObject = new Vector();
    private Vector requestRemoveObject = new Vector();
    ByteArrayInputStream levelData;
    private AddedShape nextShape;
    private int totalShapesAdded = 0;
    private int shapesConsumed = 0;
    public static boolean horizontalMovement;
    private RunnerListener listener;
    private int currentCamX;
    public static boolean isJointInfoPresent;
    private Vector sortedVector = new Vector();
    private Vector bgShapesVector = new Vector();
    RunnerCheckPoint checkPoint;
    int _heroX;
    int OnscreenShapePos;
    int oldX = 0;
    private Vector quickPlayData = new Vector();
    private int quickPlayShiftX;
    private boolean isInQuickPlay = false;
    private int endShapeId;
    private boolean startNewQuickPlaySession = false;
    private static int portPercent;

    public static RunnerManager getManager() {
        if (manager == null) {
            manager = new RunnerManager();
        }
        return manager;
    }

    public void addShapeDynamically(AddedShape addedShape) {
        this.requestAddObject.addElement(addedShape);
    }

    public void removeAddedShape(AddedShape addedShape) {
        if (addedShape.getShape() instanceof MovingLog) {
            KnightTestEngine.getInstance().MovinLogisEnter = false;
        }
        this.requestRemoveObject.addElement(addedShape);
    }

    public void setListener(RunnerListener listener) {
        this.listener = listener;
    }

    public RunnerListener getListener() {
        return this.listener;
    }

    public int getCurrentCamX() {
        return this.currentCamX;
    }

    public Vector getOnScreenObjects() {
        return this.onScreenObjects;
    }

    public void checkPointReached() {
        this.checkPoint = new RunnerCheckPoint();
        this.checkPoint.setCheckPointsBytes(this.levelData.available());
        this.checkPoint.setNextObject(this.nextShape);
        this.checkPoint.insertOnScreenObjects(this.onScreenObjects);
        this.checkPoint.setCamX(KnightTestEngine.coverCamX);
        this.checkPoint.setCamY(KnightTestEngine.coverCamY);
        this.checkPoint.setAvailableheart(KnightTestEngine.totalheart);
        this.checkPoint.setColleactedCoin(KnightTestEngine.collectedCoin);
        this.checkPoint.setHeroY(KnightTestEngine.hero.currentPlatFormY);
        this.checkPoint.setShaperemoved(this.shapesConsumed);
    }

    public void restoreCheckPointReached() {
        int available = this.levelData.available();
        int skip = available - this.checkPoint.getCheckPointsBytes();
        this.levelData.skip(skip);
        this.nextShape = this.checkPoint.getNextObject();
        this.onScreenObjects = this.checkPoint.getItemsStored();
        for (int i = 0; i < this.onScreenObjects.size(); ++i) {
            ((AddedShape)this.onScreenObjects.elementAt(i)).reset();
            AddedShape bgshape = (AddedShape)this.onScreenObjects.elementAt(i);
            if (!(bgshape.getShape() instanceof ImageShape) || KnightTestEngine.checkpointID == -1 || !this.isShapeFromBg(bgshape.getShape()) || KnightTestEngine.isHeroYSet) continue;
            Constant.HERO_Y_POS = bgshape.getY() + Constant.HERO_POS;
            KnightTestEngine.hero.currentPlatFormY = bgshape.getY() + Constant.HERO_POS;
            KnightTestEngine.isHeroYSet = true;
            KnightTestEngine.hero.setHeroY(Constant.HERO_Y_POS);
        }
        this.nextShape.reset();
        KnightTestEngine.setCamX(this.checkPoint.getCamX());
        Constant.camera.setCamY(this.checkPoint.getCamY());
        KnightTestEngine.totalheart = this.checkPoint.getAvailableheart();
        KnightTestEngine.collectedCoin = this.checkPoint.getColleactedCoin();
        Constant.HERO_Y_POS = this.checkPoint.getHeroY();
        KnightTestEngine.hero.currentPlatFormY = this.checkPoint.getHeroY();
        KnightTestEngine.isHeroYSet = true;
        KnightTestEngine.hero.setHeroY(Constant.HERO_Y_POS);
        this.shapesConsumed = this.checkPoint.getShaperemoved();
        this.setCurrentCamX(this.checkPoint.getCamX());
    }

    public void PAINT(Graphics g, int camY) {
        this.getSortedObjects();
        int size = this.sortedVector.size();
        for (int i = 0; i < size; ++i) {
            AddedShape shape = (AddedShape)this.sortedVector.elementAt(i);
            shape.setAdditionalX(-RunnerManager.getManager().getCurrentCamX());
            shape.setAdditionalY(0);
            if (!shape.getShape().isIsVisible() || !shape.isIsVisible()) continue;
            shape.PAINT(g, camY);
        }
    }

    public boolean isAddedShapePresent(int id) {
        int size = this.onScreenObjects.size();
        for (int i = 0; i < size; ++i) {
            AddedShape shape = (AddedShape)this.onScreenObjects.elementAt(i);
            if (shape.getId() != id) continue;
            return true;
        }
        return false;
    }

    public boolean isShapeOnScreen(int id, int hx, int hwidth) {
        int closestShapeId = -1;
        int size = this.onScreenObjects.size();
        for (int i = 0; i < size; ++i) {
            AddedShape shape = (AddedShape)this.onScreenObjects.elementAt(i);
            if (this.isShapeFromBg(shape.getShape()) || id != 18 && id != 17 && id != 28 && id != 4 && id != 36) continue;
            this.OnscreenShapePos = shape.getX() - this.getCurrentCamX();
            if (this.OnscreenShapePos <= hx || this.OnscreenShapePos >= (Constant.SCREEN_WIDTH >> 1) + (Constant.SCREEN_WIDTH >> 2) || (closestShapeId = shape.getShape().getId()) != id) continue;
            return true;
        }
        return false;
    }

    public boolean isCreatureClosetst(int id, int hx, int hwidth) {
        int closestShapeId = -1;
        int distance = Integer.MAX_VALUE;
        int size = this.onScreenObjects.size();
        for (int i = 0; i < size; ++i) {
            AddedShape shape = (AddedShape)this.onScreenObjects.elementAt(i);
            if (this.isShapeFromBg(shape.getShape()) || shape.getShape().getId() != 31 && shape.getShape().getId() != 36 && shape.getShape().getId() != 28 || shape.getX() >= distance || shape.getX() - this.getCurrentCamX() <= hx) continue;
            closestShapeId = shape.getShape().getId();
            distance = shape.getX();
        }
        return id == closestShapeId;
    }

    public boolean isShapeClosest(int id, int hx, int hwidth) {
        int closestShapeId = -1;
        int distance = Integer.MAX_VALUE;
        int size = this.onScreenObjects.size();
        for (int i = 0; i < size; ++i) {
            AddedShape shape = (AddedShape)this.onScreenObjects.elementAt(i);
            if (this.isShapeFromBg(shape.getShape()) || !this.checkInArray(Constant.CollidableElements, shape.getShape().getId()) || shape.getX() >= distance || shape.getX() - this.getCurrentCamX() <= hx) continue;
            closestShapeId = shape.getShape().getId();
            distance = shape.getX();
        }
        return id == closestShapeId;
    }

    public boolean isHoleNear(AddedShape movingShape) {
        for (int i = 0; i < this.onScreenObjects.size(); ++i) {
            if (!this.isHoleShape(((AddedShape)this.onScreenObjects.elementAt(i)).getShape())) continue;
            AddedShape shape = (AddedShape)this.onScreenObjects.elementAt(i);
            if (movingShape.getY() >= shape.getY() || !(Hero.getHeroState() == 10 ? shape.getX() - this.getCurrentCamX() - (movingShape.getX() - this.getCurrentCamX()) <= (Constant.HERO_HEIGHT << 1) + Constant.HERO_HEIGHT && KnightTestEngine.hero.getCollisionY() < shape.getY() : shape.getX() - this.getCurrentCamX() - (movingShape.getX() - this.getCurrentCamX()) <= Constant.HERO_HEIGHT << 1 && KnightTestEngine.hero.getCollisionY() < shape.getY())) continue;
            return true;
        }
        return false;
    }

    public boolean isstaticObjNear(AddedShape movingShape) {
        for (int i = 0; i < this.onScreenObjects.size(); ++i) {
            if (!this.checkInArray(Constant.staticColldableObjToLog, ((AddedShape)this.onScreenObjects.elementAt(i)).getShape().getId())) continue;
            AddedShape shape = (AddedShape)this.onScreenObjects.elementAt(i);
            if (Hero.getHeroState() != 10 || shape.getX() - this.getCurrentCamX() - (movingShape.getX() - this.getCurrentCamX()) > Constant.HERO_HEIGHT << 2) continue;
            return true;
        }
        return false;
    }

    public boolean isOnRect() {
        for (int i = 0; i < this.onScreenObjects.size(); ++i) {
            AddedShape shape;
            if (!this.isHoleShape(((AddedShape)this.onScreenObjects.elementAt(i)).getShape()) || !Util.isRectCollision((shape = (AddedShape)this.onScreenObjects.elementAt(i)).getX(), shape.getY(), shape.getShape().getWidth(), shape.getShape().getHeight(), KnightTestEngine.hero.getCollisionX(), KnightTestEngine.hero.getCollisionY(), KnightTestEngine.hero.getHeroWidth() - (KnightTestEngine.hero.getHeroWidth() >> 2), KnightTestEngine.hero.getHeroHeight())) continue;
            return true;
        }
        return false;
    }

    public boolean collideToStaticObject(AddedShape addedShape) {
        for (int i = 0; i < this.onScreenObjects.size(); ++i) {
            AddedShape shape;
            if (!this.checkInArray(Constant.staticColldableObjToLog, ((AddedShape)this.onScreenObjects.elementAt(i)).getShape().getId()) || !Util.isRectCollision((shape = (AddedShape)this.onScreenObjects.elementAt(i)).getX(), shape.getY() + shape.getAdditionalY(), shape.getShape().getWidth(), shape.getShape().getHeight(), addedShape.getX() - RunnerManager.getManager().getCurrentCamX(), addedShape.getY(), addedShape.getShape().getWidth(), addedShape.getShape().getHeight())) continue;
            return true;
        }
        return false;
    }

    public boolean CollideToRect(AddedShape shape) {
        for (int i = 0; i < this.onScreenObjects.size(); ++i) {
            AddedShape rectShape;
            if (!this.isHoleShape(((AddedShape)this.onScreenObjects.elementAt(i)).getShape()) || !Util.isRectCollision((rectShape = (AddedShape)this.onScreenObjects.elementAt(i)).getX(), rectShape.getY() + rectShape.getAdditionalY(), rectShape.getShape().getWidth(), rectShape.getShape().getHeight(), shape.getX() - RunnerManager.getManager().getCurrentCamX(), shape.getY(), shape.getShape().getWidth(), shape.getShape().getHeight()) || !(shape.getShape() instanceof MovingLog)) continue;
            return true;
        }
        return false;
    }

    public boolean isRopeShapeClosest(int id, int hx, int hwidth) {
        return false;
    }

    public boolean checkInArray(int[] array, int element) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != element) continue;
            return true;
        }
        return false;
    }

    private int findInsertLocation(int value) {
        int left = 0;
        int right = this.sortedVector.size();
        int middle = 0;
        while (left < right) {
            middle = left + right >> 1;
            int valueAtMiddle = ((AddedShape)this.sortedVector.elementAt(middle)).getY();
            if (value == valueAtMiddle) {
                return middle;
            }
            if (right - left <= 1) {
                if (((AddedShape)this.sortedVector.elementAt(left)).getY() < value) {
                    return left;
                }
                return right;
            }
            if (value < valueAtMiddle) {
                left = middle + 1;
                continue;
            }
            right = middle;
        }
        return right;
    }

    public void getSortedObjects() {
        int i;
        this.sortedVector.removeAllElements();
        this.bgShapesVector.removeAllElements();
        int size = this.onScreenObjects.size();
        for (i = 0; i < size; ++i) {
            AddedShape newShape = (AddedShape)this.onScreenObjects.elementAt(i);
            if (this.isShapeFromBg(newShape.getShape()) && !this.checkInArray(Constant.staticColldableObjToLog, newShape.getShape().getId())) {
                this.bgShapesVector.addElement(newShape);
                continue;
            }
            int pos = this.findInsertLocation(newShape.getY());
            this.sortedVector.insertElementAt(newShape, pos);
        }
        for (i = 0; i < this.bgShapesVector.size(); ++i) {
            this.sortedVector.insertElementAt(this.bgShapesVector.elementAt(i), 0);
        }
    }

    public boolean isShapeFromBg(Shape shape) {
        for (int i = 0; i < Constant.BG_USED_SHAPES.length; ++i) {
            if (Constant.BG_USED_SHAPES[i] != shape.getId()) continue;
            return true;
        }
        return false;
    }

    public boolean isHoleShape(Shape shape) {
        for (int i = 0; i < Constant.PATCH_CUST_ID.length; ++i) {
            if (Constant.PATCH_CUST_ID[i] != shape.getId()) continue;
            return true;
        }
        return false;
    }

    public void insertObjectOnScreen(AddedShape addedShape) {
        CustomShape newShape;
        if (addedShape.getShape() instanceof ShapeGroup) {
            addedShape.setShape(((ShapeGroup)addedShape.getShape()).clone());
        }
        if (this.isInQuickPlay) {
            if (addedShape.getShape().getId() != 5) {
                this.onScreenObjects.addElement(addedShape);
            }
        } else {
            this.onScreenObjects.addElement(addedShape);
        }
        if (addedShape.getShape() instanceof EmptyCustom && (newShape = Customize.getDynamicCustomClassObject(((CustomShape)addedShape.getShape()).getClassId())) != null) {
            newShape.setIsCollidable(addedShape.getShape().isIsCollidable());
            newShape.setId(addedShape.getShape().getId());
            addedShape.setShape(newShape);
        }
        if (addedShape.getShape() instanceof ShapeGroup) {
            ShapeGroup group = (ShapeGroup)addedShape.getShape();
            Vector listAddedObjects = group.getShapeGroup();
            for (int i = 0; i < listAddedObjects.size(); ++i) {
                CustomShape newShape2;
                AddedShape object = (AddedShape)listAddedObjects.elementAt(i);
                if (!(object.getShape() instanceof EmptyCustom) || (newShape2 = Customize.getDynamicCustomClassObject(((CustomShape)object.getShape()).getClassId())) == null) continue;
                newShape2.setId(object.getShape().getId());
                newShape2.setIsCollidable(object.getShape().isIsCollidable());
                object.setShape(newShape2);
            }
            group.calculateHeight(addedShape);
            group.calculateWidth(addedShape);
            ((ShapeGroup)addedShape.getShape()).reset(addedShape);
        } else if (addedShape.getShape() instanceof CustomShape) {
            ((CustomShape)addedShape.getShape()).reset();
        }
        addedShape.setCollisionOccured(false);
        if (this.getListener() != null) {
            if (this.isInQuickPlay && addedShape.getShape().getId() == 5) {
                return;
            }
            this.getListener().shapeEnteredInScreen(addedShape);
        }
        Customize.newShapeLoaded(addedShape.getShape());
    }

    public void update(int camX, int camY, int camWidth, int camHeight, int heroX, int heroY, int heroWidth, int heroHeight) {
        this.currentCamX = camX;
        if (this.startNewQuickPlaySession) {
            AddedShape lastShape = (AddedShape)this.onScreenObjects.elementAt(this.onScreenObjects.size() - 1);
            this.startNewQuickPlaySession = false;
            this.startNewQuickPlaySession(lastShape.getX() + lastShape.getShape().getWidth());
        }
        this.oldX = this.currentCamX;
        if (horizontalMovement) {
            if (this.nextShape != null && this.isShapeEnteredInScreen(camX, camY, camWidth, camHeight, this.nextShape)) {
                this.insertObjectOnScreen(this.nextShape);
                boolean next = this.readShape();
                while (next && this.isShapeEnteredInScreen(camX, camY, camWidth, camHeight, this.nextShape)) {
                    this.insertObjectOnScreen(this.nextShape);
                    if (this.readShape()) continue;
                }
            }
            for (int i = 0; i < this.onScreenObjects.size(); ++i) {
                AddedShape object = (AddedShape)this.onScreenObjects.elementAt(i);
                object.update();
                object.setAdditionalX(0);
                object.setAdditionalY(0);
                int value = this.checkCollision(object, camX, camY, camWidth, camHeight, heroX, heroY, heroWidth, heroHeight);
                if (value >= 0) continue;
                --i;
            }
        }
        this.checkRemovalNAddition();
    }

    public void checkRemovalNAddition() {
        AddedShape addedShape;
        while (this.requestAddObject.size() > 0) {
            addedShape = (AddedShape)this.requestAddObject.elementAt(0);
            if (this.isInQuickPlay) {
                if (addedShape.getShape().getId() != 5) {
                    this.onScreenObjects.addElement(addedShape);
                }
            } else {
                this.onScreenObjects.addElement(addedShape);
            }
            this.requestAddObject.removeElementAt(0);
        }
        while (this.requestRemoveObject.size() > 0) {
            addedShape = (AddedShape)this.requestRemoveObject.elementAt(0);
            if (addedShape.getParent() != null) {
                addedShape.setIsVisible(false);
            } else {
                this.onScreenObjects.removeElement(addedShape);
            }
            this.requestRemoveObject.removeElementAt(0);
        }
    }

    public void setCurrentCamX(int currentCamX) {
        this.currentCamX = currentCamX;
    }

    public void checkAddionalCollision(int camX, int camY, int camWidth, int camHeight, int heroX, int heroY, int heroWidth, int heroHeight) {
        this.currentCamX = camX;
        for (int i = 0; i < this.onScreenObjects.size(); ++i) {
            AddedShape object = (AddedShape)this.onScreenObjects.elementAt(i);
            object.setAdditionalX(0);
            object.setAdditionalY(0);
            int value = this.checkCollision(object, camX, camY, camWidth, camHeight, heroX, heroY, heroWidth, heroHeight);
            if (value >= 0) continue;
            --i;
        }
        this.checkRemovalNAddition();
    }

    private int checkCollision(AddedShape object, int camX, int camY, int camWidth, int camHeight, int heroX, int heroY, int heroWidth, int heroHeight) {
        if (object.getShape() instanceof ShapeGroup && this.isOutSideOfScreen(camX, camY, camWidth, camHeight, object)) {
            for (int i = 0; i < this.onScreenObjects.size(); ++i) {
                if (this.onScreenObjects.elementAt(i).equals(object)) {
                    this.onScreenObjects.removeElementAt(i);
                }
                if (this.getListener() != null) {
                    this.getListener().shapeRemovedFromScreen(object);
                }
                if (this.shapesConsumed < this.totalShapesAdded - 1 || this.onScreenObjects.size() != 0) continue;
                this.getListener().levelOver();
            }
            return -1;
        }
        if (object.getShape() instanceof ShapeGroup) {
            ShapeGroup group = (ShapeGroup)object.getShape();
            int size = group.getShapeGroup().size();
            for (int i = 0; i < size; ++i) {
                int value;
                AddedShape object1 = (AddedShape)group.getShapeGroup().elementAt(i);
                if (object.getShape() instanceof ShapeGroup) {
                    object1.setAdditionalX(object.getX());
                    object1.setAdditionalY(object.getY());
                }
                if ((value = this.checkCollision(object1, camX, camY, camWidth, camHeight, heroX, heroY, heroWidth, heroHeight)) >= 0) continue;
                return -1;
            }
        } else {
            if (this.isOutSideOfScreen(camX, camY, camWidth, camHeight, object)) {
                if (object.getParent() != null) {
                    return 1;
                }
                for (int i = 0; i < this.onScreenObjects.size(); ++i) {
                    if (!this.onScreenObjects.elementAt(i).equals(object)) continue;
                    this.onScreenObjects.removeElementAt(i);
                }
                object.setCollisionOccured(false);
                if (object.getShape() instanceof ShapeGroup) {
                    ((ShapeGroup)object.getShape()).reset(object);
                }
                if (this.getListener() != null) {
                    this.getListener().shapeRemovedFromScreen(object);
                }
                if (this.shapesConsumed >= this.totalShapesAdded - 1 && this.onScreenObjects.size() == 0) {
                    this.getListener().levelOver();
                }
                return -1;
            }
            if (heroWidth > 0 && heroHeight > 0 && object.getShape().isIsCollidable()) {
                AddedShape value = null;
                value = object.getShape().checkRelativeCollision(heroX, heroY, heroWidth, heroHeight, object);
                if (value != null && !value.isCollisionOccured() && this.getListener() != null) {
                    value.setCollisionOccured(true);
                    this.getListener().shapeCollisionOcurrent(value);
                }
            }
        }
        return 1;
    }

    public boolean isOutSideOfScreen(int camX, int camY, int camWidth, int camHeight, AddedShape addedShape) {
        if (addedShape.getShape() instanceof MovingLog) {
            if (!((MovingLog)addedShape.getShape()).isCollidetoStaticObj() && addedShape.getX() + addedShape.getShape().getWidth() + addedShape.getAdditionalX() > camX + Constant.SCREEN_WIDTH) {
                return true;
            }
            if (((MovingLog)addedShape.getShape()).isCollidetoStaticObj() && addedShape.getX() - this.getCurrentCamX() < 0) {
                return true;
            }
        } else if (addedShape.getShape() instanceof Rope) {
            if (addedShape.getX() + addedShape.getShape().getHeight() + addedShape.getAdditionalX() < camX) {
                if (Hero.getHeroState() == 6 && !Hero.isRopeIsCut()) {
                    Hero.setRopeIsCut(true);
                    ((Rope)addedShape.getShape()).setRopeCut(true);
                    ((Rope)addedShape.getShape()).setIsRopeHold(false);
                    return false;
                }
                return true;
            }
        } else if (addedShape.getX() + addedShape.getShape().getWidth() + addedShape.getAdditionalX() < camX) {
            return true;
        }
        return false;
    }

    public boolean isShapeEnteredInScreen(int camX, int camY, int camWidth, int camHeight, AddedShape addedShape) {
        return addedShape.getX() + addedShape.getAdditionalX() <= camX + camWidth;
    }

    public void loadLevel(int levelIndex, InputStream is) throws Exception {
        int i;
        this.startNewQuickPlaySession = false;
        this.isInQuickPlay = false;
        this.quickPlayShiftX = 0;
        this.shapeList.removeAllElements();
        this.onScreenObjects.removeAllElements();
        this.shapesConsumed = 0;
        this.totalShapesAdded = 0;
        isJointInfoPresent = Util.readBool(is);
        int totalShapes = Util.read(is, 2);
        for (int i2 = 0; i2 < totalShapes; ++i2) {
            int objectType = Util.read(is, 1);
            Shape shape = Customize.getNewShapeObject(objectType);
            if (shape == null) {
                shape = new EmptyCustom();
            }
            if (shape instanceof ShapeGroup) {
                // empty if block
            }
            if (shape instanceof CustomShape) {
                ((CustomShape)shape).setClassId(objectType);
            }
            shape.deserilize(is);
            this.shapeList.addElement(shape);
        }
        int totalLevels = Util.read(is, 2);
        int[] levelsLength = new int[totalLevels];
        for (i = 0; i < totalLevels; ++i) {
            levelsLength[i] = Util.read(is, 4);
        }
        for (i = 0; i < levelIndex; ++i) {
            is.skip(levelsLength[i]);
        }
        byte[] data = new byte[levelsLength[levelIndex]];
        is.read(data);
        this.levelData = new ByteArrayInputStream(data);
        this.totalShapesAdded = Util.read(this.levelData, 2);
        this.readShape();
        data = null;
        is.close();
    }

    public void loadQuickPlayLevel(InputStream is, int endShapeId) throws Exception {
        int i;
        this.startNewQuickPlaySession = false;
        this.isInQuickPlay = true;
        this.quickPlayShiftX = 0;
        this.endShapeId = endShapeId;
        this.shapeList.removeAllElements();
        this.quickPlayData.removeAllElements();
        this.onScreenObjects.removeAllElements();
        this.shapesConsumed = 0;
        this.totalShapesAdded = 0;
        isJointInfoPresent = Util.readBool(is);
        int totalShapes = Util.read(is, 2);
        KnightTestEngine.vilanPosition = 0;
        for (int i2 = 0; i2 < totalShapes; ++i2) {
            int objectType = Util.read(is, 1);
            Shape shape = Customize.getNewShapeObject(objectType);
            if (shape == null) {
                shape = new EmptyCustom();
            }
            if (shape instanceof CustomShape) {
                ((CustomShape)shape).setClassId(objectType);
            }
            shape.deserilize(is);
            this.shapeList.addElement(shape);
        }
        int totalLevels = Util.read(is, 2);
        int[] levelsLength = new int[totalLevels];
        for (i = 0; i < totalLevels; ++i) {
            levelsLength[i] = Util.read(is, 4);
        }
        for (i = 0; i < levelsLength.length; ++i) {
            byte[] data = new byte[levelsLength[i]];
            is.read(data);
            this.quickPlayData.addElement(data);
            data = null;
        }
        quickplayLevelcounter = 0;
        this.playNextQuickPlaySession(2);
        is.close();
    }

    private void startNewQuickPlaySession(int extraX) {
        this.shapesConsumed = 0;
        this.quickPlayShiftX = extraX;
        if (++quickplayLevelcounter % 4 == 0) {
            int randomLevel = com.appon.util.Util.getRandomNumber(0, this.quickPlayData.size() - 1);
            System.out.println("randome Level : " + randomLevel);
            KnightTestEngine.vilanPosition = randomLevel / 5 - 1;
            this.playNextQuickPlaySession(randomLevel);
        } else {
            int randomLevel = com.appon.util.Util.getRandomNumber(1, 9);
            System.out.println("randome Level : " + randomLevel);
            KnightTestEngine.vilanPosition = randomLevel / 5 - 1;
            this.playNextQuickPlaySession(randomLevel);
        }
    }

    private void playNextQuickPlaySession(int index) {
        try {
            this.levelData = new ByteArrayInputStream((byte[])this.quickPlayData.elementAt(index));
            this.totalShapesAdded = Util.read(this.levelData, 2);
            this.readShape();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int getScaleValue(int value, int scale) {
        value += value * scale / 100;
        return value;
    }

    public void portAddedShape(int percent, AddedShape addedShape) {
        addedShape.rescale(percent);
        if (addedShape.getShape() instanceof ShapeGroup) {
            this.portShapeGroup(percent, (ShapeGroup)addedShape.getShape());
        }
    }

    public void portShapeGroup(int percent, ShapeGroup shapeGroup) {
        shapeGroup.rescale(percent);
    }

    public static void setPortPercent(int portPercent) {
        RunnerManager.portPercent = portPercent;
    }

    public AddedShape getAddedShapeByID(int id) {
        for (int i = 0; i < this.onScreenObjects.size(); ++i) {
            AddedShape addedShape = (AddedShape)this.onScreenObjects.elementAt(i);
            if (id != addedShape.getId()) continue;
            return addedShape;
        }
        return null;
    }

    public boolean readShape() {
        try {
            if (this.shapesConsumed < this.totalShapesAdded) {
                ++this.shapesConsumed;
                this.nextShape = new AddedShape();
                this.nextShape.deserilize(this.levelData);
                if (this.nextShape.getShape() instanceof ShapeGroup) {
                    ((ShapeGroup)this.nextShape.getShape()).calculateHeight(this.nextShape);
                    ((ShapeGroup)this.nextShape.getShape()).calculateWidth(this.nextShape);
                }
                this.portAddedShape(portPercent, this.nextShape);
                if (isJointInfoPresent) {
                    AddedShape jointedToShape;
                    int jointedTo = this.nextShape.getJointInfo();
                    if (this.nextShape.isJointInfoThere() && (jointedToShape = this.getAddedShapeByID(this.nextShape.getId())) != null) {
                        this.nextShape.setX(jointedToShape.getX() + jointedToShape.getShape().getWidth());
                    }
                }
                this.nextShape.setX(this.nextShape.getX() + this.quickPlayShiftX);
                if (this.nextShape.getShape() instanceof ImageShape && KnightTestEngine.checkpointID == -1 && this.isShapeFromBg(this.nextShape.getShape()) && !KnightTestEngine.isHeroYSet) {
                    Constant.HERO_Y_POS = this.nextShape.getY() + Constant.HERO_POS;
                    KnightTestEngine.hero.currentPlatFormY = this.nextShape.getY() + Constant.HERO_POS;
                    KnightTestEngine.isHeroYSet = true;
                }
                if (this.isInQuickPlay && this.nextShape.getShape().getId() == this.endShapeId) {
                    return this.readShape();
                }
                return true;
            }
            this.nextShape = null;
            if (this.isInQuickPlay) {
                this.startNewQuickPlaySession = true;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Vector getShapeList() {
        return this.shapeList;
    }

    public Shape findShape(int shapeId) {
        for (int i = 0; i < this.shapeList.size(); ++i) {
            Shape object = (Shape)this.shapeList.elementAt(i);
            if (object.getId() != shapeId) continue;
            return object;
        }
        return null;
    }

    static {
        quickplayLevelcounter = 0;
        horizontalMovement = true;
        isJointInfoPresent = false;
    }
}

