/*
 * Decompiled with CFR 0.152.
 */
package com.appon.gtantra;

import com.appon.gtantra.GAnimListener;
import com.appon.gtantra.GTantra;
import com.indiagames.arjunprince.KnightTestEngine;
import javax.microedition.lcdui.Graphics;

public class GAnim {
    private int currentFrame;
    private int timer;
    private boolean isAnimOver = false;
    private GTantra gTantra;
    private int animId;
    private GAnimListener animListener;
    private int animUID;
    private Object userData;
    int counter;
    public static long prevTime;
    private static boolean isBlinking;
    private boolean doUpdate = false;
    int cellId = -1;
    private int lastFrame;
    private int randomizeCounter = 0;

    public GAnim(GTantra gTantra, int animId) {
        this.gTantra = gTantra;
        this.animId = animId;
    }

    public GAnim(GTantra gTantra, int animId, int UID) {
        this(gTantra, animId);
        this.animUID = UID;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public Object getUserData() {
        return this.userData;
    }

    public int getCurrentFrameWidth() {
        return this.gTantra.getFrameWidth(this.gTantra.getFrameId(this.animId, this.currentFrame));
    }

    public int getCurrentFrameHeight() {
        return this.gTantra.getFrameHeight(this.gTantra.getFrameId(this.animId, this.currentFrame));
    }

    public int getCurrentFrameMinimumX() {
        return this.gTantra.getFrameMinimumX(this.gTantra.getFrameId(this.animId, this.currentFrame));
    }

    public int getCurrentFrameMinimumY() {
        return this.gTantra.getFrameMinimumY(this.gTantra.getFrameId(this.animId, this.currentFrame));
    }

    public void setAnimUID(int animUID) {
        this.animUID = animUID;
    }

    public int getAnimUID() {
        return this.animUID;
    }

    public void setAnimListener(GAnimListener animListener) {
        this.animListener = animListener;
    }

    public boolean isAnimationOver() {
        return this.isAnimOver;
    }

    public void reset() {
        this.currentFrame = 0;
        this.isAnimOver = false;
        this.doUpdate = false;
    }

    public int getCurrentFrame() {
        return this.gTantra._iAnimFrames[this.animId][this.currentFrame];
    }

    public int getAnimationFrameX(int frameLocation) {
        return this.gTantra._iAnimFrameX[this.animId][frameLocation];
    }

    public int getAnimationFrameY(int frameLocation) {
        return this.gTantra._iAnimFrameY[this.animId][frameLocation];
    }

    public int getAnimationCurrentCycle(int animation) {
        return this.currentFrame;
    }

    public int getAnimationCurrentCycle() {
        return this.currentFrame;
    }

    public int getNumberOfFrames() {
        return this.gTantra._iAnimFrameCnt[this.animId];
    }

    public void setCurrentFrame(int currentFrame) {
        this.currentFrame = currentFrame;
    }

    public boolean isAnimRendering() {
        return this.getAnimationCurrentCycle() >= 1 && this.getAnimationCurrentCycle() <= this.getNumberOfFrames();
    }

    public void renderWithoutTimer(Graphics g, int posX, int posY, int flags, boolean loop) {
        this.gTantra.DrawAnimationFrame(g, this.animId, this.currentFrame, posX, posY, flags);
        if (KnightTestEngine.getInstance().getInGameStatus() != 1 && KnightTestEngine.getInstance().getInGameStatus() != 4 && KnightTestEngine.getInstance().getInGameStatus() != 6 && KnightTestEngine.getInstance().getInGameStatus() != 2 && KnightTestEngine.getInstance().getInGameStatus() != 3) {
            ++this.currentFrame;
        }
        if (this.currentFrame >= this.gTantra._iAnimFrameCnt[this.animId]) {
            if (loop) {
                this.currentFrame = 0;
            } else {
                this.currentFrame = this.gTantra._iAnimFrameCnt[this.animId] - 1;
                this.isAnimOver = true;
            }
            if (this.animListener != null) {
                this.animListener.animationOver(this);
            }
        }
        if (this.animListener != null) {
            this.animListener.frameChanged(this);
        }
    }

    public void render(Graphics g, int posX, int posY, int flags, boolean loop) {
        boolean isOver = false;
        if (this.doUpdate && KnightTestEngine.getInstance().getInGameStatus() != 1 && KnightTestEngine.getInstance().getInGameStatus() != 4 && KnightTestEngine.getInstance().getInGameStatus() != 6 && KnightTestEngine.getInstance().getInGameStatus() != 2 && KnightTestEngine.getInstance().getInGameStatus() != 3) {
            isOver = this.updateFrame(loop);
        }
        this.gTantra.DrawAnimationFrame(g, this.animId, this.currentFrame, posX, posY, flags);
        this.doUpdate = !isOver;
    }

    public void renderStar(Graphics g, int posX, int posY, int flags, boolean loop) {
        boolean isOver = false;
        if (this.doUpdate) {
            isOver = this.updateFrame(loop);
        }
        this.gTantra.DrawAnimationFrame(g, this.animId, this.currentFrame, posX, posY, flags);
        this.doUpdate = !isOver;
    }

    public void randomRender(Graphics g, int posX, int posY, int flags, int cellId) {
        this.gTantra.DrawAnimationFrame(g, this.animId, this.currentFrame, posX, posY, flags);
        ++this.randomizeCounter;
        if (this.cellId == -1 || this.randomizeCounter > 25) {
            this.cellId = cellId;
            this.lastFrame = this.currentFrame;
            this.randomizeCounter = 0;
        } else if (cellId == this.cellId && this.lastFrame == this.currentFrame) {
            this.cellId = -1;
            this.updateFrame(true);
        }
        this.updateFrame(true);
    }

    public boolean updateFrame(boolean loop) {
        boolean isOver = false;
        byte currentTimer = this.gTantra.frameTimer[this.animId][this.currentFrame];
        if (this.timer + 1 >= currentTimer) {
            this.timer = 0;
            ++this.currentFrame;
            if (this.currentFrame >= this.gTantra._iAnimFrameCnt[this.animId]) {
                if (loop) {
                    this.currentFrame = 0;
                    isOver = false;
                } else {
                    this.currentFrame = this.gTantra._iAnimFrameCnt[this.animId] - 1;
                    isOver = true;
                }
            } else if (this.currentFrame == this.gTantra._iAnimFrameCnt[this.animId] - 1) {
                if (!loop) {
                    this.isAnimOver = true;
                }
                if (this.animListener != null) {
                    this.animListener.animationOver(this);
                }
            }
            if (this.animListener != null) {
                this.animListener.frameChanged(this);
            }
        } else {
            ++this.timer;
        }
        return isOver;
    }

    public GTantra getgTantra() {
        return this.gTantra;
    }

    public int getCurrentFrameIndex() {
        return this.currentFrame;
    }

    public void renderWithoutUpdate(Graphics g, int posX, int posY, int flags, boolean loop) {
        this.gTantra.DrawAnimationFrame(g, this.animId, this.currentFrame, posX, posY, flags);
    }

    public int getAnimId() {
        return this.animId;
    }

    static {
        isBlinking = false;
    }
}

