/*
 * Decompiled with CFR 0.152.
 */
package com.appon.knighttestgame.customShapes;

import com.appon.gtantra.GAnim;
import com.appon.knighttestgame.helper.ParabolicUtil;
import com.indiagames.arjunprince.Constant;
import com.indiagames.arjunprince.KnightTestEngine;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class CoinMagnet {
    int x;
    int y;
    private boolean coinCollide = false;
    public static final int SPEED = 30;
    private GAnim coinAnim = new GAnim(Constant.effectsTantra, 0);
    private GAnim coinCollect = new GAnim(Constant.effectsTantra, 4);
    private static Vector coins = new Vector();
    public static Random random = new Random();

    public CoinMagnet(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void paint(Graphics g) {
        if (!this.coinCollide) {
            this.coinAnim.render(g, this.x, this.y, 0, true);
        } else if (this.coinCollide && !this.coinCollect.isAnimationOver()) {
            this.coinCollect.render(g, this.x, this.y, 0, false);
        }
    }

    public static void paintAll(Graphics g) {
        for (int i = 0; i < coins.size(); ++i) {
            CoinMagnet object = (CoinMagnet)coins.elementAt(i);
            object.paint(g);
        }
    }

    public static void updateAll(int heroX, int heroY, int heroW, int heroH) {
        for (int i = 0; i < coins.size(); ++i) {
            CoinMagnet object = (CoinMagnet)coins.elementAt(i);
            if (!CoinMagnet.update(object, heroX, heroY, heroW, heroH)) continue;
            CoinMagnet.coinCollided();
            ((CoinMagnet)CoinMagnet.coins.elementAt((int)i)).coinCollide = true;
            if (!((CoinMagnet)CoinMagnet.coins.elementAt((int)i)).coinCollect.isAnimationOver()) continue;
            coins.removeElementAt(i);
            --i;
        }
    }

    private static void coinCollided() {
        ++KnightTestEngine.collectedCoin;
        KnightTestEngine.score += 100;
    }

    public static void reset() {
        coins.removeAllElements();
    }

    public static void generate(int coinX, int coinY) {
        coins.addElement(new CoinMagnet(coinX, coinY));
    }

    public static boolean update(CoinMagnet coin, int destx, int desty, int destWidth, int destHeight) {
        int speed = 30;
        int finalX = destx + (destWidth >> 1);
        int finalY = desty + (destHeight >> 1);
        int dist = CoinMagnet.getApproxDistance(coin.x, coin.y, finalX, finalY);
        if (dist < speed) {
            speed = dist;
        }
        if (speed < 3) {
            return true;
        }
        int theta = ParabolicUtil.getSlope(coin.x, coin.y, finalX, finalY);
        long largeValue = speed * ParabolicUtil.cos(theta);
        coin.x = (int)((long)coin.x + (largeValue >>= 14));
        largeValue = speed * ParabolicUtil.sin(theta);
        coin.y = (int)((long)coin.y + (largeValue >>= 14));
        return CoinMagnet.isInRect(destx, desty, destWidth, destHeight, coin.x, coin.y);
    }

    public static boolean isInRect(int xPos, int yPos, int width, int height, int x, int y) {
        return x >= xPos && x <= xPos + width && y >= yPos && y <= yPos + height;
    }

    public static int getRandomNumber(int min, int max) {
        if (max == min) {
            return 0;
        }
        int randomNum = Math.abs(random.nextInt());
        return min + Math.abs(randomNum % (max - min));
    }

    public static int getApproxDistance(int x1, int y1, int x2, int y2) {
        int max;
        int min;
        int dy;
        int dx = Math.abs(x1 - x2);
        if (dx < (dy = Math.abs(y1 - y2))) {
            min = dx;
            max = dy;
        } else {
            min = dy;
            max = dx;
        }
        return (max << 8) + (max << 3) - (max << 4) - (max << 1) + (min << 7) - (min << 5) + (min << 3) - (min << 1) >> 8;
    }
}

