/*
 * Decompiled with CFR 0.152.
 */
package com.appon.knighttestgame.helper;

import com.indiagames.arjunprince.Hero;

public class ProjectileMotion {
    private int g = 10;
    private int x;
    private int y;
    private int initialX;
    private int initialY;
    private int theta = 0;
    private int time;
    private int velocity;
    private static int[] sin_tabel = new int[]{0, 286, 572, 857, 1143, 1428, 1713, 1997, 2280, 2563, 2845, 3126, 3406, 3686, 3964, 4240, 4516, 4790, 5063, 5334, 5604, 5872, 6138, 6402, 6664, 6924, 7182, 7438, 7692, 7943, 8193, 8438, 8682, 8923, 9162, 9397, 9630, 9860, 10087, 10311, 10531, 10749, 10963, 11174, 11381, 11585, 11786, 11982, 12176, 12365, 12551, 12733, 12911, 13085, 13255, 13421, 13583, 13741, 13894, 14044, 14189, 14330, 14466, 14598, 14726, 14849, 14968, 15082, 15191, 15296, 15396, 15491, 15582, 15668, 15749, 15826, 15897, 15964, 16026, 16083, 16135, 16182, 16225, 16262, 16294, 16322, 16344, 16362, 16374, 16382, 16384, 16382, 16374, 16362, 16344, 16322, 16294, 16262, 16225, 16182, 16135, 16083, 16026, 15964, 15897, 15826, 15749, 15668, 15582, 15491, 15396, 15296, 15191, 15082, 14968, 14849, 14726, 14598, 14466, 14330, 14189, 14044, 13894, 13741, 13583, 13421, 13255, 13085, 12911, 12733, 12551, 12365, 12176, 11982, 11786, 11585, 11381, 11174, 10963, 10749, 10531, 10311, 10087, 9860, 9630, 9397, 9162, 8923, 8682, 8438, 8193, 7943, 7692, 7438, 7182, 6924, 6664, 6402, 6138, 5872, 5604, 5334, 5063, 4790, 4516, 4240, 3964, 3686, 3406, 3126, 2845, 2563, 2280, 1997, 1713, 1428, 1143, 857, 572, 286, 0, -285, -571, -857, -1142, -1427, -1712, -1996, -2280, -2563, -2845, -3126, -3406, -3685, -3963, -4240, -4516, -4790, -5062, -5334, -5603, -5871, -6137, -6401, -6663, -6924, -7182, -7438, -7691, -7943, -8192, -8438, -8682, -8923, -9161, -9397, -9630, -9860, -10086, -10310, -10531, -10748, -10963, -11173, -11381, -11585, -11785, -11982, -12175, -12365, -12550, -12732, -12910, -13084, -13254, -13420, -13582, -13740, -13894, -14043, -14188, -14329, -14466, -14598, -14725, -14848, -14967, -15081, -15190, -15295, -15395, -15491, -15582, -15668, -15749, -15825, -15897, -15964, -16025, -16082, -16135, -16182, -16224, -16261, -16294, -16321, -16344, -16361, -16374, -16381, -16384, -16381, -16374, -16361, -16344, -16321, -16294, -16261, -16224, -16182, -16135, -16082, -16025, -15964, -15897, -15825, -15749, -15668, -15582, -15491, -15395, -15295, -15190, -15081, -14967, -14848, -14725, -14598, -14466, -14329, -14188, -14043, -13894, -13740, -13582, -13420, -13254, -13084, -12910, -12732, -12550, -12365, -12175, -11982, -11785, -11585, -11381, -11173, -10963, -10748, -10531, -10310, -10086, -9860, -9630, -9397, -9161, -8923, -8682, -8438, -8192, -7943, -7691, -7438, -7182, -6924, -6663, -6401, -6137, -5871, -5603, -5334, -5062, -4790, -4516, -4240, -3963, -3685, -3406, -3126, -2845, -2563, -2280, -1996, -1712, -1427, -1142, -857, -571, -285};
    private static int[] cos_tabel = new int[]{16384, 16382, 16374, 16362, 16344, 16322, 16294, 16262, 16225, 16182, 16135, 16083, 16026, 15964, 15897, 15826, 15749, 15668, 15582, 15491, 15396, 15296, 15191, 15082, 14968, 14849, 14726, 14598, 14466, 14330, 14189, 14044, 13894, 13741, 13583, 13421, 13255, 13085, 12911, 12733, 12551, 12365, 12176, 11982, 11786, 11585, 11381, 11174, 10963, 10749, 10531, 10311, 10087, 9860, 9630, 9397, 9162, 8923, 8682, 8438, 8192, 7943, 7692, 7438, 7182, 6924, 6664, 6402, 6138, 5872, 5604, 5334, 5063, 4790, 4516, 4240, 3964, 3686, 3406, 3126, 2845, 2563, 2280, 1997, 1713, 1428, 1143, 857, 572, 286, 0, -285, -571, -857, -1142, -1427, -1712, -1996, -2280, -2563, -2845, -3126, -3406, -3685, -3963, -4240, -4516, -4790, -5062, -5334, -5603, -5871, -6137, -6401, -6663, -6924, -7182, -7438, -7691, -7943, -8191, -8438, -8682, -8923, -9161, -9397, -9630, -9860, -10086, -10310, -10531, -10748, -10963, -11173, -11381, -11585, -11785, -11982, -12175, -12365, -12550, -12732, -12910, -13084, -13254, -13420, -13582, -13740, -13894, -14043, -14188, -14329, -14466, -14598, -14725, -14848, -14967, -15081, -15190, -15295, -15395, -15491, -15582, -15668, -15749, -15825, -15897, -15964, -16025, -16082, -16135, -16182, -16224, -16261, -16294, -16321, -16344, -16361, -16374, -16381, -16384, -16381, -16374, -16361, -16344, -16321, -16294, -16261, -16224, -16182, -16135, -16082, -16025, -15964, -15897, -15825, -15749, -15668, -15582, -15491, -15395, -15295, -15190, -15081, -14967, -14848, -14725, -14598, -14466, -14329, -14188, -14043, -13894, -13740, -13582, -13420, -13254, -13084, -12910, -12732, -12550, -12365, -12175, -11982, -11785, -11585, -11381, -11173, -10963, -10748, -10531, -10310, -10086, -9860, -9630, -9397, -9161, -8923, -8682, -8438, -8192, -7943, -7691, -7438, -7182, -6924, -6663, -6401, -6137, -5871, -5603, -5334, -5062, -4790, -4516, -4240, -3963, -3685, -3406, -3126, -2845, -2563, -2280, -1996, -1712, -1427, -1142, -857, -571, -285, 0, 286, 572, 857, 1143, 1428, 1713, 1997, 2280, 2563, 2845, 3126, 3406, 3686, 3964, 4240, 4516, 4790, 5063, 5334, 5604, 5872, 6138, 6402, 6664, 6924, 7182, 7438, 7692, 7943, 8192, 8438, 8682, 8923, 9162, 9397, 9630, 9860, 10087, 10311, 10531, 10749, 10963, 11174, 11381, 11585, 11786, 11982, 12176, 12365, 12551, 12733, 12911, 13085, 13255, 13421, 13583, 13741, 13894, 14044, 14189, 14330, 14466, 14598, 14726, 14849, 14968, 15082, 15191, 15296, 15396, 15491, 15582, 15668, 15749, 15826, 15897, 15964, 16026, 16083, 16135, 16182, 16225, 16262, 16294, 16322, 16344, 16362, 16374, 16382};
    private int maxHeight;
    private boolean isOnHalf;
    private int updateSpeed = 25;
    private int lastY;
    private int lastDirection;
    private boolean reachedTop;

    public void init(int intialX, int intialY, int velocity, int theta) {
        this.reachedTop = false;
        this.x = this.initialX = intialX;
        this.y = this.initialY = intialY;
        this.theta = theta;
        this.velocity = velocity;
        this.time = 0;
        this.maxHeight = (velocity * ProjectileMotion.sin(theta) >> 14) * (velocity * ProjectileMotion.sin(theta) >> 14) / (2 * this.g);
        this.setIsOnHalf(false);
        this.lastDirection = -1;
        this.lastY = -1;
    }

    public void initFromHeight(int intialX, int intialY, int maxHeight, int theta) {
        this.reachedTop = false;
        this.x = this.initialX = intialX;
        this.y = this.initialY = intialY;
        this.theta = theta;
        this.time = 0;
        this.maxHeight = maxHeight;
        this.velocity = (ProjectileMotion.sqrt(2 * this.g * maxHeight) << 14) / ProjectileMotion.sin(theta);
        this.setIsOnHalf(false);
        this.lastDirection = -1;
        this.lastY = -1;
    }

    public void setUpdateSpeed(int updateSpeed) {
        this.updateSpeed = updateSpeed;
    }

    public int getCurrentHeight() {
        return Math.abs(this.y - this.initialY);
    }

    public int getX() {
        return this.x;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getY() {
        return this.y;
    }

    public void update() {
        this.x = this.velocity * ProjectileMotion.cos(this.theta) * this.time >> 21;
        int yFirstPart = this.velocity * ProjectileMotion.sin(this.theta) * this.time >> 21;
        int ySecondPart = this.g * this.time * this.time >> 15;
        this.y = yFirstPart - ySecondPart;
        this.y = this.initialY - this.y;
        this.x += this.initialX;
        this.time += this.updateSpeed;
        if (this.lastY == -1) {
            this.lastY = this.y;
        } else {
            int direction = this.lastY - this.y;
            if (this.lastDirection == -1) {
                this.lastDirection = direction;
            } else {
                int signOfLastDirection;
                int signOfDirection;
                if (this.lastDirection != 0 && direction != 0 && (signOfDirection = this.lastDirection / Math.abs(this.lastDirection)) != (signOfLastDirection = direction / Math.abs(direction))) {
                    if (!this.reachedTop) {
                        this.onTop();
                        this.reachedTop = true;
                    }
                    this.setIsOnHalf(true);
                }
                this.lastY = this.y;
            }
        }
    }

    public void onTop() {
        Hero.onTop = true;
    }

    public boolean isOnHalf() {
        return this.isOnHalf;
    }

    public static int sin(int theta) {
        if ((theta %= 360) < 0) {
            theta = 360 - theta;
        }
        return sin_tabel[theta];
    }

    public static int cos(int theta) {
        if ((theta %= 360) < 0) {
            theta = 360 - theta;
        }
        return cos_tabel[theta];
    }

    public static int sqrt(int nRoot) {
        int nSqrt = 0;
        for (int i = 0x10000000; i != 0; i >>= 2) {
            int nTemp = nSqrt + i;
            nSqrt >>= 1;
            if (nTemp > nRoot) continue;
            nRoot -= nTemp;
            nSqrt += i;
        }
        return nSqrt;
    }

    public void setIsOnHalf(boolean isOnHalf) {
        this.isOnHalf = isOnHalf;
    }
}

