/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework;

import com.appon.gtantra.GFont;
import com.appon.gtantra.GTantra;
import com.appon.miniframework.CornersPNGBox;
import java.util.Hashtable;
import javax.microedition.lcdui.Image;

public class ResourceManager {
    private Hashtable fontTable = new Hashtable();
    private Hashtable imageTable = new Hashtable();
    private Hashtable cornerPNGBox = new Hashtable();
    private Hashtable gtantraTable = new Hashtable();
    private static ResourceManager instance;

    private ResourceManager() {
    }

    public static ResourceManager getInstance() {
        if (instance == null) {
            instance = new ResourceManager();
        }
        return instance;
    }

    public void clear() {
        this.fontTable.clear();
        this.imageTable.clear();
        this.cornerPNGBox.clear();
        this.gtantraTable.clear();
    }

    public void setGTantraResource(int id, GTantra tantra) {
        if (tantra == null) {
            return;
        }
        if (this.gtantraTable.get(id + "") != null) {
            this.gtantraTable.remove(id + "");
        }
        this.gtantraTable.put("" + id, tantra);
    }

    public GTantra getGTantraResource(int id) {
        return (GTantra)this.gtantraTable.get(id + "");
    }

    public void setFontResource(int id, GFont font) {
        if (font == null) {
            return;
        }
        if (this.fontTable.get(id + "") != null) {
            this.fontTable.remove(id + "");
        }
        this.fontTable.put("" + id, font);
    }

    public void setPNGBoxResource(int id, CornersPNGBox box) {
        if (this.cornerPNGBox.get(id + "") != null) {
            this.cornerPNGBox.remove(id + "");
        }
        this.cornerPNGBox.put("" + id, box);
    }

    public CornersPNGBox getCornerPNGBox(int id) {
        return (CornersPNGBox)this.cornerPNGBox.get(id + "");
    }

    public GFont getFontResource(int id) {
        return (GFont)this.fontTable.get(id + "");
    }

    public void setImageResource(int id, Image image) {
        if (image == null) {
            return;
        }
        if (this.imageTable.get(id + "") != null) {
            this.imageTable.remove(id + "");
        }
        this.imageTable.put("" + id, image);
    }

    public Image getImageResource(int id) {
        return (Image)this.imageTable.get(id + "");
    }
}

