/*
 * Decompiled with CFR 0.152.
 */
package com.indiagames.arjunprince;

import com.appon.gtantra.GAnim;
import com.appon.gtantra.GTantra;
import com.indiagames.arjunprince.Constant;
import com.indiagames.arjunprince.FightSystem;
import com.indiagames.arjunprince.FighterCharactor;

public class VillainCharactor
extends FighterCharactor {
    private int command = 2;
    private static final int GO_LEFT_TO_HERO = 0;
    private static final int GO_RIGHT_TO_HERO = 1;
    private static final int DO_NOTHING = 2;
    private static final int ESCAPE_TO_LEFT = 4;
    private static final int ESCAPE_TO_RIGHT = 5;
    private static final int JUMP_ATTACK = 6;
    private static int ESCAPE_DISTANCE_MIN;
    private static int ESCAPE_DISTANCE_MAX;
    private static int ATTACK_DISTANCE;
    FightSystem system;
    private long attackCooler;
    private int escapeDistance;
    private static int attackIdGenerator;
    int villainDamage;
    int villainLife;
    private int currentAttackId;
    public static final int RANDOM_ESCAPE_PERCENTAGE = 20;
    public static final int MAINTAIN_ATTACK_DISTANCE_PERCENTAGE = 8;
    public static final int JUMP_HIT_PERCENTAGE = 3;
    private static final int DELAY_IN_ATTACK = 5;

    public VillainCharactor(int villainType, GTantra tantra, int screenWidth, int x, FightSystem system, int villainDamage, int villainLife) {
        super(tantra, screenWidth, villainType, villainLife, villainDamage);
        this.heroX = x;
        this.system = system;
        this.direction = x < 0 ? 1 : 0;
        this.villainDamage = villainDamage;
        this.villainLife = villainLife;
        ESCAPE_DISTANCE_MIN = screenWidth >> 4;
        ESCAPE_DISTANCE_MAX = screenWidth >> 2;
    }

    public int generateAttackId() {
        return attackIdGenerator++;
    }

    public void setAttackCooler(long attackCooler) {
        this.attackCooler = attackCooler;
    }

    public void init() {
        this.attackRight = new GAnim[2];
        this.attackLeft = new GAnim[2];
        if (this.charactorType == 0) {
            this.runRight = new GAnim(this.tantra, 0);
            this.runLeft = new GAnim(this.tantra, 10);
            this.attackRight[0] = new GAnim(this.tantra, 2);
            this.attackRight[1] = new GAnim(this.tantra, 3);
            this.attackLeft[0] = new GAnim(this.tantra, 12);
            this.attackLeft[1] = new GAnim(this.tantra, 13);
            this.standLeft = new GAnim(this.tantra, 22);
            this.standRight = new GAnim(this.tantra, 20);
            this.jumpAttackRight = new GAnim(this.tantra, 4);
            this.jumpAttackLeft = new GAnim(this.tantra, 14);
        } else {
            this.runRight = new GAnim(this.tantra, 5);
            this.runLeft = new GAnim(this.tantra, 15);
            this.attackRight[0] = new GAnim(this.tantra, 7);
            this.attackRight[1] = new GAnim(this.tantra, 8);
            this.attackLeft[0] = new GAnim(this.tantra, 17);
            this.attackLeft[1] = new GAnim(this.tantra, 18);
            this.standLeft = new GAnim(this.tantra, 23);
            this.standRight = new GAnim(this.tantra, 21);
            this.jumpAttackRight = new GAnim(this.tantra, 9);
            this.jumpAttackLeft = new GAnim(this.tantra, 19);
        }
        ATTACK_DISTANCE = this.attackLeft[0].getCurrentFrameWidth() * 3 >> 2;
        this.bloodRight = new GAnim(Constant.effectsTantra, 3);
        this.bloodLeft = new GAnim(Constant.effectsTantra, 8);
    }

    public void setCommand(int command) {
        this.command = command;
        if (command == 2) {
            this.setState(0);
        }
    }

    private int getLeftOrRightMoveCommand() {
        if ((this.isLeftToHero() && this.direction == 1 || !this.isLeftToHero() && this.direction == 0) && this.getDistanceFromHero() >= this.COMBO_ATTACK_RANGE && this.getDistanceFromHero() <= this.COMBO_ATTACK_RANGE + ATTACK_DISTANCE) {
            if (this.isLeftToHero()) {
                this.setDirection(1);
            } else {
                this.setDirection(0);
            }
            this.jumpAttackLeft.reset();
            this.jumpAttackRight.reset();
            this.currentAttackId = this.generateAttackId();
            this.setState(3);
            this.setCommand(6);
            return 6;
        }
        int distance = this.getDistanceFromHero();
        if (distance >= ATTACK_DISTANCE) {
            if (this.isLeftToHero()) {
                return 0;
            }
            return 1;
        }
        return -1;
    }

    public void update() {
        ++this.attackCooler;
        if (this.isHitting() && this.getCurrentGAnim().getAnimationCurrentCycle() != 0) {
            this.collisionRect = this.getCurrentSwordCollsionRect();
            this.system.villainAttacked(this.collisionRect[0], this.collisionRect[1], this.collisionRect[2], this.collisionRect[3], this.currentAttackId, this.villainDamage, this);
        }
        if (this.command == 2 && !this.isHitting()) {
            int moveCommand = this.getLeftOrRightMoveCommand();
            if (moveCommand != -1) {
                this.movedSoFar = 0;
                this.setCommand(moveCommand);
            } else {
                int value = VillainCharactor.getRandomNumber(0, 20);
                if (value == 1) {
                    this.escapeDistance = VillainCharactor.getRandomNumber(ESCAPE_DISTANCE_MIN, ESCAPE_DISTANCE_MAX);
                    this.performEscape();
                } else if (this.attackCooler > 5L) {
                    value = VillainCharactor.getRandomNumber(0, 8);
                    int d = this.getDistanceFromHero();
                    if (value == 1 && d < ATTACK_DISTANCE - 5 - 1) {
                        this.escapeDistance = ATTACK_DISTANCE - d;
                        this.performEscape();
                    } else {
                        if (this.isLeftToHero()) {
                            this.setDirection(1);
                        } else {
                            this.setDirection(0);
                        }
                        this.hittingAnimId = VillainCharactor.getRandomNumber(0, 2);
                        this.attackRight[this.hittingAnimId].reset();
                        this.attackLeft[this.hittingAnimId].reset();
                        this.currentAttackId = this.generateAttackId();
                        this.setState(2);
                    }
                }
            }
        } else if (this.getState() == 2 && this.getCurrentGAnim().isAnimationOver()) {
            this.setCommand(2);
            this.attackCooler = 0L;
        }
        switch (this.command) {
            case 6: {
                boolean over = false;
                if (this.direction == 0) {
                    over = this.jumpAttackLeft.isAnimationOver();
                    this.heroX -= 5;
                    if (this.heroX - this.getCurrentGAnim().getCurrentFrameWidth() < 0) {
                        this.heroX = this.getCurrentGAnim().getCurrentFrameWidth();
                    }
                } else {
                    over = this.jumpAttackRight.isAnimationOver();
                    this.heroX += 5;
                    if (this.heroX + this.getCurrentGAnim().getCurrentFrameWidth() > SCREEN_WIDTH) {
                        this.heroX = SCREEN_WIDTH - this.getCurrentGAnim().getCurrentFrameWidth();
                    }
                }
                this.movedSoFar += 5;
                if (!over) break;
                this.movedSoFar = 0;
                this.setState(0);
                this.setCommand(2);
                break;
            }
            case 4: {
                this.setDirection(0);
                this.heroX -= 5;
                this.movedSoFar += 5;
                if (this.escapeDistance >= this.movedSoFar) break;
                this.setCommand(2);
                break;
            }
            case 5: {
                this.setDirection(1);
                this.heroX += 5;
                this.movedSoFar += 5;
                if (this.escapeDistance >= this.movedSoFar) break;
                this.setCommand(2);
                break;
            }
            case 0: 
            case 1: {
                this.attackCooler = 0L;
                int distance = this.getDistanceFromHero();
                if (this.isLeftToHero()) {
                    this.setDirection(1);
                    this.heroX += 5;
                    if (this.heroX + this.getCurrentGAnim().getCurrentFrameWidth() > SCREEN_WIDTH) {
                        this.heroX = SCREEN_WIDTH - this.getCurrentGAnim().getCurrentFrameWidth();
                        this.movedSoFar = 0;
                        this.setCommand(2);
                        this.setState(0);
                        return;
                    }
                } else {
                    this.setDirection(0);
                    this.heroX -= 5;
                    if (this.heroX - this.getCurrentGAnim().getCurrentFrameWidth() < 0) {
                        this.heroX = this.getCurrentGAnim().getCurrentFrameWidth();
                        this.movedSoFar = 0;
                        this.setCommand(2);
                        this.setState(0);
                        return;
                    }
                }
                this.movedSoFar += 5;
                if (this.movedSoFar >= 25) {
                    this.movedSoFar = 0;
                    int moveCommand = this.getLeftOrRightMoveCommand();
                    if (moveCommand != -1) {
                        this.setCommand(moveCommand);
                    } else {
                        this.setCommand(2);
                        this.setState(0);
                    }
                } else {
                    this.setState(1);
                }
                if (distance > ATTACK_DISTANCE) break;
                this.movedSoFar = 0;
                this.setCommand(2);
                this.setState(0);
            }
        }
    }

    private void performEscape() {
        if (this.isLeftToHero()) {
            if (this.heroX - this.escapeDistance > 0) {
                this.setCommand(4);
            } else {
                this.setCommand(5);
            }
        } else if (this.heroX + this.getCurrentFrameWidth() + this.escapeDistance > SCREEN_WIDTH) {
            this.setCommand(4);
        } else {
            this.setCommand(5);
        }
        this.movedSoFar = 0;
        this.setState(1);
    }

    public boolean isLeftToHero() {
        return VillainCharactor.getDistance(this, this.system.getHero()) < 0;
    }

    public int getDistanceFromHero() {
        return Math.abs(VillainCharactor.getDistance(this, this.system.getHero()));
    }

    public boolean gotAttacked(int damage) {
        if (damage == -1) {
            this.villainLife = -1;
            return true;
        }
        this.villainLife -= damage;
        return this.villainLife <= 0;
    }
}

