/*
 * Decompiled with CFR 0.152.
 */
package com.appon.effectengine;

import com.appon.effectengine.EArc;
import com.appon.effectengine.EGAnimationFrame;
import com.appon.effectengine.EGFont;
import com.appon.effectengine.EGFrame;
import com.appon.effectengine.EGModule;
import com.appon.effectengine.EImage;
import com.appon.effectengine.ELine;
import com.appon.effectengine.EPolygon;
import com.appon.effectengine.ERect;
import com.appon.effectengine.ETimeFrameShape;
import com.appon.effectengine.ETraingle;
import com.appon.effectengine.Effect;
import com.appon.effectengine.EffectGroup;
import com.appon.effectengine.EffectLayer;
import com.appon.effectengine.TimeFrame;
import com.appon.util.Serilizable;
import com.appon.util.Serilize;

public class EffectsSerilize
extends Serilize {
    private static EffectsSerilize instance;
    public static final int EFFECT_TYPE = 2000;
    public static final int EFFECT_LAYER_TYPE = 2001;
    public static final int TIME_FRAME_TYPE = 2002;
    public static final int EFFECT_GROUP_TYPE = 2003;
    public static final int SHAPE_TYPE_EARC = 2010;
    public static final int SHAPE_TYPE_EGANIMATIONFRAME = 2011;
    public static final int SHAPE_TYPE_EGFONT = 2012;
    public static final int SHAPE_TYPE_EGFRAME = 2013;
    public static final int SHAPE_TYPE_EGMODULE = 2014;
    public static final int SHAPE_TYPE_IMAGE = 2015;
    public static final int SHAPE_TYPE_LINE = 2016;
    public static final int SHAPE_TYPE_POLYGON = 2017;
    public static final int SHAPE_TYPE_TRAINGLE = 2018;
    public static final int SHAPE_TYPE_RECT = 2019;
    public static final int SHAPE_TYPE_TIMEFRAME = 2020;

    private EffectsSerilize() {
    }

    public static EffectsSerilize getInstance() {
        if (instance == null) {
            instance = new EffectsSerilize();
        }
        return instance;
    }

    public static boolean isShapeType(int classcode) {
        return classcode >= 2010 && classcode <= 2020;
    }

    public Serilizable getClassObject(int classcode, int id, int additionalData) {
        switch (classcode) {
            case 2000: {
                return new Effect();
            }
            case 2001: {
                return new EffectLayer();
            }
            case 2002: {
                return new TimeFrame();
            }
            case 2003: {
                return new EffectGroup();
            }
            case 2010: {
                return new EArc(id);
            }
            case 2011: {
                return new EGAnimationFrame(id);
            }
            case 2012: {
                return new EGFont(id);
            }
            case 2013: {
                return new EGFrame(id);
            }
            case 2014: {
                return new EGModule(id);
            }
            case 2015: {
                return new EImage(id);
            }
            case 2016: {
                return new ELine(id);
            }
            case 2017: {
                return new EPolygon(id);
            }
            case 2018: {
                return new ETraingle(id);
            }
            case 2019: {
                return new ERect(id);
            }
            case 2020: {
                return new ETimeFrameShape(id);
            }
        }
        return null;
    }
}

