/*
 * Decompiled with CFR 0.152.
 */
package com.appon.knighttestgame.customShapes;

import com.appon.camera.CameraLockable;
import com.appon.runner.RunnerManager;
import com.appon.runner.model.AddedShape;
import com.appon.runner.model.CustomShape;
import com.appon.runner.util.Util;
import com.appon.util.BoxUtil;
import com.indiagames.arjunprince.Constant;
import javax.microedition.lcdui.Graphics;

public class Hammer
extends CustomShape
implements CameraLockable {
    private boolean hammerNear = false;
    private int ctr = 0;

    public void paint(Graphics g, int x, int y) {
        ++this.ctr;
        g.drawImage(Constant.IMG_PIKEWOOD.getImage(), x, y, 0);
        if (!this.isHammerNear() && this.ctr % 2 == 0) {
            g.drawImage(Constant.IMG_HURDLE_ALERT.getImage(), x + (this.getWidth() - Constant.IMG_HURDLE_ALERT.getWidth() >> 1), y + this.getHeight(), 0);
        }
    }

    public int getHeight() {
        return Constant.IMG_PIKEWOOD.getHeight();
    }

    public void update(AddedShape addedShape) {
        if (addedShape.getX() - RunnerManager.getManager().getCurrentCamX() < Constant.SCREEN_WIDTH >> 1) {
            this.hammerNear = true;
        }
        if (this.isHammerNear() && !BoxUtil.isCollisionAtBottom(addedShape.getX() - RunnerManager.getManager().getCurrentCamX(), addedShape.getY() + this.getHeight() - Constant.HERO_POS, this)) {
            addedShape.setY(addedShape.getY() + (Constant.FALL_DOWN_SPEED - Constant.HERO_POS));
        }
    }

    public int getWidth() {
        return Constant.IMG_PIKEWOOD.getWidth();
    }

    public void reset() {
        this.hammerNear = false;
        this.ctr = 0;
    }

    public AddedShape checkCollision(int rectX, int rectY, int rectWidth, int rectHeight, AddedShape addedShape) {
        if (Util.isRectCollision(addedShape.getX() + addedShape.getAdditionalX(), addedShape.getY() + addedShape.getAdditionalY(), this.getWidth(), this.getHeight(), rectX, rectY, rectWidth, rectHeight)) {
            return addedShape;
        }
        return null;
    }

    public int getX() {
        return -1;
    }

    public int getY() {
        return -1;
    }

    public int getAllignment() {
        return -1;
    }

    public int lockedObjectIsOf() {
        return 3;
    }

    public boolean isHammerNear() {
        return this.hammerNear;
    }
}

