/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework.controls;

import com.appon.gtantra.GFont;
import com.appon.miniframework.Control;
import com.appon.miniframework.Event;
import com.appon.miniframework.EventQueue;
import com.appon.miniframework.ResourceManager;
import com.appon.miniframework.Settings;
import com.appon.miniframework.Util;
import com.appon.miniframework.controls.RadioGroup;
import java.io.ByteArrayInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ToggleIconControl
extends Control {
    private int imageResourceId;
    private int selectionImageResourceId;
    private boolean isToggleSelected;
    RadioGroup group;
    private boolean disabled = false;
    private String text;
    private String selectionText;
    private String disabledText;
    private int localTextId = -1;
    private int localSelectionTextId = -1;
    private int localDisabledTextId = -1;
    private int disabledImageResourceId;
    private GFont font;
    private GFont disabledFont;
    private int fontResourceId;
    private int disabledFontResourceId;
    private int pallet;
    private int selectedPallet;
    private int disabledPallet;
    private Image image;
    private Image selectionImage;
    private Image disabledImage;

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setLocalTextId(int localTextId) {
        this.localTextId = localTextId;
    }

    public void setLocalSelectionTextId(int localSelectionTextId) {
        this.localSelectionTextId = localSelectionTextId;
    }

    public void setLocalDisabledTextId(int localDisabledTextId) {
        this.localDisabledTextId = localDisabledTextId;
    }

    public void setDisabledFont(GFont disabledFont) {
        this.disabledFont = disabledFont;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public GFont getDisabledFont() {
        return this.disabledFont;
    }

    public int getDisabledFontResourceId() {
        return this.disabledFontResourceId;
    }

    public void setDisabledFontResourceId(int disabledResourceId) {
        this.disabledFontResourceId = disabledResourceId;
    }

    public int getDisabledPallet() {
        return this.disabledPallet;
    }

    public void setDisabledPallet(int disabledPallet) {
        this.disabledPallet = disabledPallet;
    }

    public int getPallet() {
        return this.pallet;
    }

    public void setPallet(int pallet) {
        this.pallet = pallet;
    }

    public int getSelectedPallet() {
        return this.selectedPallet;
    }

    public void setSelectedPallet(int selectedPallet) {
        this.selectedPallet = selectedPallet;
    }

    public ToggleIconControl(int id) {
        super(id);
    }

    public ToggleIconControl() {
        this(-1);
    }

    protected void setRadioGroup(RadioGroup group) {
        this.group = group;
    }

    public Image getDisabledImage() {
        return this.disabledImage;
    }

    public void setDisabledImage(Image disabledBitmap) {
        this.disabledImage = disabledBitmap;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    public void setSelectionImage(Image selectionBitmap) {
        this.selectionImage = selectionBitmap;
    }

    public Image getImage() {
        return this.image;
    }

    public Image getSelectionImage() {
        return this.selectionImage;
    }

    public void setImageResourceId(int imageResourceId) {
        this.imageResourceId = imageResourceId;
    }

    public void setSelectionImageResourceId(int selectionImageResourceId) {
        this.selectionImageResourceId = selectionImageResourceId;
    }

    public int getImageResourceId() {
        return this.imageResourceId;
    }

    public int getSelectionImageResourceId() {
        return this.selectionImageResourceId;
    }

    public void setToggleSelected(boolean value) {
        this.isToggleSelected = value;
    }

    public boolean isToggleSelected() {
        return this.isToggleSelected;
    }

    public void paint(Graphics g) {
        if (this.disabled && (this.disabledText != null || this.disabledImage != null)) {
            if (this.disabledImage != null) {
                Util.drawImage(g, this.disabledImage, this.getBoundWidth() - Util.getImageWidth(this.disabledImage) >> 1, this.getBoundHeight() - Util.getImageHeight(this.disabledImage) >> 1);
            }
            if (this.disabledText != null && this.disabledFont != null) {
                this.disabledFont.setColor(this.disabledPallet);
                this.disabledFont.drawString(g, this.disabledText, this.getWidth() >> 1, this.getHeight() >> 1, 65);
            }
        } else {
            Image img = this.image;
            if (this.isToggleSelected()) {
                img = this.selectionImage;
            }
            if (img != null) {
                Util.drawImage(g, img, this.getBoundWidth() - Util.getImageWidth(img) >> 1, this.getBoundHeight() - Util.getImageHeight(img) >> 1);
            }
            if (this.font != null && !this.disabled) {
                if (this.isToggleSelected() && this.selectionText != null) {
                    this.font.setColor(this.selectedPallet);
                    this.font.drawString(g, this.selectionText, this.getWidth() >> 1, this.getHeight() >> 1, 65);
                }
                if (!this.isToggleSelected() && this.text != null) {
                    this.font.setColor(this.pallet);
                    this.font.drawString(g, this.text, this.getWidth() >> 1, this.getHeight() >> 1, 65);
                }
            }
        }
    }

    public int getPreferredWidth() {
        int w = 10;
        if (this.disabledImage != null) {
            w = Util.getImageWidth(this.disabledImage);
        }
        if (this.image != null) {
            w = Util.getImageWidth(this.image);
        }
        if (this.selectionImage != null) {
            w = Util.getImageWidth(this.selectionImage);
        }
        if (this.disabledFont != null && this.disabledText != null) {
            w = Math.max(w, this.disabledFont.getStringWidth(this.disabledText));
        }
        if (this.font != null && this.text != null) {
            w = Math.max(w, this.font.getStringWidth(this.text));
        }
        if (this.font != null && this.selectionText != null) {
            w = Math.max(w, this.font.getStringWidth(this.selectionText));
        }
        return w + this.getLeftInBound() + this.getRightInBound();
    }

    public int getPreferredHeight() {
        int w = 10;
        if (this.disabledImage != null) {
            w = Util.getImageHeight(this.disabledImage);
        }
        if (this.image != null) {
            w = Util.getImageHeight(this.image);
        }
        if (this.selectionImage != null) {
            w = Util.getImageHeight(this.selectionImage);
        }
        if (this.font != null) {
            w = Math.max(w, this.font.getFontHeight());
        }
        if (this.disabledFont != null) {
            w = Math.max(w, this.disabledFont.getFontHeight());
        }
        return w + this.getTopInBound() + this.getBottomInBound();
    }

    public int getClassCode() {
        return 1013;
    }

    public String toString() {
        return "ToggleIconControl-" + this.getId();
    }

    private void action() {
        if (!this.disabled) {
            if (this.group != null && !this.isToggleSelected) {
                this.group.selectControl(this);
                if (this.getEventListener() != null) {
                    this.getEventListener().event(new Event(3, this, this.group));
                }
            } else if (this.group == null) {
                boolean bl = this.isToggleSelected = !this.isToggleSelected;
                if (this.getEventListener() != null) {
                    this.getEventListener().event(new Event(2, this, null));
                }
            }
        }
    }

    public boolean keyPressed(int keycode, int gameKey) {
        super.keyPressed(keycode, gameKey);
        if (gameKey == 8 || gameKey == 8) {
            this.action();
            return true;
        }
        return false;
    }

    public boolean pointerReleased(int x, int y) {
        super.pointerReleased(x, y);
        if (this.isSelected()) {
            this.action();
        }
        return true;
    }

    public byte[] serialize() throws Exception {
        return null;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        super.deserialize(bis);
        this.setImageResourceId(Util.readSignedInt(bis, 2));
        this.setImage(ResourceManager.getInstance().getImageResource(this.getImageResourceId()));
        this.setSelectionImageResourceId(Util.readSignedInt(bis, 2));
        this.setSelectionImage(ResourceManager.getInstance().getImageResource(this.getSelectionImageResourceId()));
        this.setDisabledImageResourceId(Util.readSignedInt(bis, 2));
        this.setDisabledImage(ResourceManager.getInstance().getImageResource(this.getDisabledImageResourceId()));
        this.setText(Util.readString(bis));
        this.setSelectionText(Util.readString(bis));
        this.setDisabledText(Util.readString(bis));
        this.setFontResourceId(Util.readSignedInt(bis, 1));
        this.setDisabledFontResourceId(Util.readSignedInt(bis, 1));
        this.setFont(ResourceManager.getInstance().getFontResource(this.getFontResourceId()));
        this.setDisabledFont(ResourceManager.getInstance().getFontResource(this.getDisabledFontResourceId()));
        if (Settings.VERSION_NUMBER_FOUND >= 2) {
            this.setPallet(Util.readInt(bis, 1));
            this.setSelectedPallet(Util.readInt(bis, 1));
            this.setDisabledPallet(Util.readInt(bis, 1));
        }
        this.setDisabled(Util.readBoolean(bis));
        this.setToggleSelected(Util.readBoolean(bis));
        bis.close();
        return null;
    }

    public void showNotify() {
        if (EventQueue.getInstance().getLocalText(this.localTextId) != null) {
            this.setText(EventQueue.getInstance().getLocalText(this.localTextId));
        }
        if (EventQueue.getInstance().getLocalText(this.localDisabledTextId) != null) {
            this.setDisabledText(EventQueue.getInstance().getLocalText(this.localDisabledTextId));
        }
        if (EventQueue.getInstance().getLocalText(this.localSelectionTextId) != null) {
            this.setSelectionText(EventQueue.getInstance().getLocalText(this.localSelectionTextId));
        }
        super.showNotify();
        if (this.group != null) {
            this.group.reset();
        }
    }

    public boolean isIsToggleSelected() {
        return this.isToggleSelected;
    }

    public void setIsToggleSelected(boolean isToggleSelected) {
        this.isToggleSelected = isToggleSelected;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getSelectionText() {
        return this.selectionText;
    }

    public void setSelectionText(String selectionText) {
        this.selectionText = selectionText;
    }

    public String getDisabledText() {
        return this.disabledText;
    }

    public void setDisabledText(String disabledText) {
        this.disabledText = disabledText;
    }

    public int getDisabledImageResourceId() {
        return this.disabledImageResourceId;
    }

    public void setDisabledImageResourceId(int disabledImageResourceId) {
        this.disabledImageResourceId = disabledImageResourceId;
    }

    public GFont getFont() {
        return this.font;
    }

    public void setFont(GFont font) {
        this.font = font;
    }

    public int getFontResourceId() {
        return this.fontResourceId;
    }

    public void setFontResourceId(int fontResourceId) {
        this.fontResourceId = fontResourceId;
    }

    public void cleanup() {
        super.cleanup();
        this.font = null;
        this.disabledFont = null;
        this.text = null;
        this.selectionImage = null;
        this.disabledText = null;
        this.disabledImage = null;
        this.image = null;
    }
}

