/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.DDDebug;
import com.ea.game.DDFile;
import com.ea.game.DDMath;
import com.ea.game.Game;
import com.ea.game.MicroGame;
import com.ea.game.XMLMenuSystem;
import com.ea.sdk.ResourceLoader;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGame;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKMoreGames16;
import com.ea.sdk.SDKSoundManager;
import com.ea.sdk.SDKString;
import com.ea.sdk.SDKUtils;

public class MainFrame
implements SDKGame,
ResourceLoader {
    public static int m_masterNextState;
    private static final int DEVICE_SCREEN_WIDTH = 352;
    private static final int DEVICE_SCREEN_HEIGHT = 416;
    public static final int FRAMES_PER_SECOND = 200;
    private static final int FRAMERATE_MAXIMUM = 200;
    private static final int FRAME_DURATION = 5;
    public static final int KEY_STAR = 131072;
    public static final int KEY_POUND = 262144;
    public static final int KEY_NUM0 = 128;
    public static final int KEY_NUM1 = 256;
    public static final int KEY_NUM2 = 512;
    public static final int KEY_NUM3 = 1024;
    public static final int KEY_NUM4 = 2048;
    public static final int KEY_NUM5 = 4096;
    public static final int KEY_NUM6 = 8192;
    public static final int KEY_NUM7 = 16384;
    public static final int KEY_NUM8 = 32768;
    public static final int KEY_NUM9 = 65536;
    public static int[] m_cheatBuffer;
    public static final int[][] m_Cheats;
    public static int m_cheatPointer;
    private static final boolean CHEATS_ON = false;
    private static final boolean DEBUG_FPS = false;
    public static final int MASTERSTATE_LOADLANGUAGE = 0;
    public static final int MASTERSTATE_LANGUAGE = 1;
    public static final int MASTERSTATE_LOGOS = 2;
    public static final int MASTERSTATE_LOADFRONTEND = 3;
    public static final int MASTERSTATE_FRONTEND = 4;
    public static final int MASTERSTATE_LOADGAME = 5;
    public static final int MASTERSTATE_INGAME = 6;
    public static final int MASTERSTATE_PAUSED = 7;
    public static final int MASTERSTATE_MOREGAMES = 8;
    public static final int MASTERSTATE_ROTATED = 9;
    public static final int MASTERSTATE_STARTUP = 10;
    private static final int G_LEFT = 4;
    private static final int G_RIGHT = 8;
    private static final int G_HCENTER = 1;
    private static final int G_VCENTER = 2;
    private static final int G_TOP = 16;
    private static final int G_BOTTOM = 32;
    public static final int JOYSTICK_LEFT = 1;
    public static final int JOYSTICK_RIGHT = 2;
    public static final int JOYSTICK_UP = 4;
    public static final int JOYSTICK_DOWN = 8;
    public static final int JOYSTICK_FIRE = 16;
    public static final int JOYSTICK_LSK = 64;
    public static final int JOYSTICK_RSK = 32;
    public static final int JOYSTICK_OTHER1 = 128;
    public static final int JOYSTICK_DIR = 15;
    public static final int JOYSTICK_ACTION = 80;
    public static final int JOYSTICK_BACK = 512;
    private static final boolean SIMPLE_KEYS = true;
    private static final int MOREGAMES_BACKGROUND_COLOUR = 0;
    public static int m_lastCheatKey;
    private static final int LOADCOUNT_MAX = 10;
    private static final int LOADCOUNT_SHIFT = 4;
    private static final int LOADCOUNT_MASK = 15;
    private static final int LOADCOUNT_INGAME = 8;
    public static final int SOUND_NORMALHIT = 0;
    public static final int SOUND_EDGE = 1;
    public static final int SOUND_TAP = 2;
    public static final int SOUND_BODY = 3;
    public static final int SOUND_BOUNCE = 4;
    public static final int SOUND_DEFENSIVE = 5;
    public static final int SOUND_STUMPS = 6;
    public static final int SOUND_BIGHIT = 7;
    public static final int SOUND_WAITING = 8;
    public static final int SOUND_CANCEL = 9;
    public static final int SOUND_RUN1 = 10;
    public static final int SOUND_RUN2 = 11;
    public static final int SOUND_CROWD = 12;
    public static final int MUSIC_MENU = 13;
    public static final int NUM_GAME_SOUNDS = 2;
    public static final int NUM_MENU_SOUNDS = 1;
    public static final int NUM_SOUNDS = 3;
    public static final int SOUNDFLAG_PLAYONCE = 1;
    public static final int SOUNDFLAG_LOOP = 2;
    public static final int SOUNDFLAG_RESUME = 4;
    public static final int SOUNDFLAG_QUEUEUP = 8;
    public static final int SOUNDFLAG_IMMEDIATEPLAY = 16;
    public static SDKCanvas m_canvas;
    private static boolean m_readyToPaint;
    public static int m_masterState;
    public static int m_resumeState;
    private static SDKImage m_logoImage;
    private static SDKImage m_warningImage;
    public static SDKImage m_eaLogo;
    private static int m_logoCurrent;
    private static int m_logoTimer;
    private static int m_loadTimer;
    private static int m_loadTimerEnd;
    private static int m_loadNextState;
    private static int m_loadMenuID;
    public static int m_loadReturnMenu;
    public static int m_loadError;
    private static long m_frameRateTime;
    private static int m_frameRateCount;
    private static int m_frameRate;
    private static int m_freeMemory;
    private static int m_frameCount;
    private static final int DBG_STRING_COUNT = 4;
    public static String[] m_debugString;
    public static MainFrame dbgInst;
    public static boolean m_frameRateOn;
    public static boolean m_memoryOn;
    private static long m_frameRateLimiterTime;
    private static int m_interruptTime;
    private static volatile boolean m_inPaint;
    public static final int LOGO_DELAY = 3000;
    private static final int LOGO_NUM = 2;
    private static boolean m_wrongScreen;
    private static int m_lastMenu;
    public static int m_currentFrame;
    public static long m_appStartTime;
    public static int m_appFrameTime;
    public static boolean m_gameMenuLoaded;
    public static StringBuffer m_strBuff;
    private static SDKImage m_backBufferImage;
    private static SDKGraphics m_backBufferGraphics;
    public static SDKMoreGames16 m_mgInstance;
    public static int m_joystick;
    private static int m_keyState;
    private static int m_keysPressedLastFrame;
    private static int m_keysReleasedLastFrame;
    public static boolean m_interrupted;
    public static long m_gameTime;
    private static SDKSoundManager m_soundManager;
    private static boolean m_vibrateOn;
    private static int m_joystickPress;
    private static int m_joystickRestore;
    private static boolean m_pressAnyKey;
    public static final int MUSIC_RESTART_DELAY_FRAMES = 2;
    private static final boolean FEATURE_NO_MUSIC = false;
    public static boolean m_OVIEnabled;
    public static int m_prevPointerPosX;
    public static int m_prevPointerPosY;
    public static int m_pointerPressedPosX;
    public static int m_pointerPressedPosY;
    public static int m_pointerDraggedX;
    public static int m_pointerDraggedY;
    public static boolean pointerReleased;
    private static final int ANYKEY_BACKGROUND_COLOUR = 0xFFFFFF;
    private static boolean m_mgEnabled;

    public static SDKMoreGames16 getMoreGamesInstance() {
        return m_mgInstance;
    }

    public MainFrame(SDKCanvas sDKCanvas) {
        m_canvas = sDKCanvas;
        dbgInst = this;
    }

    public void init() {
        MainFrame.setMasterState(10);
    }

    public void appPointerPressed(int n2, int n3, long l2) {
    }

    public void appPointerReleased(int n2, int n3, long l2) {
    }

    public void appPointerDragged(int n2, int n3, long l2) {
    }

    public void update(long l2) {
        try {
            int n2;
            m_gameTime = l2;
            int n3 = 0;
            n3 = m_joystick;
            if (n3 == 0) {
                n2 = m_keysPressedLastFrame & m_keysReleasedLastFrame;
                n3 = MainFrame.mapSDKKeysToJoystick(n2);
            }
            m_keysReleasedLastFrame = 0;
            m_keysPressedLastFrame = 0;
            switch (m_masterState) {
                case 10: {
                    this.startup();
                    break;
                }
                case 2: {
                    MainFrame.logoUpdate(l2);
                    break;
                }
                case 0: 
                case 3: 
                case 5: {
                    MainFrame.loadUpdate();
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    XMLMenuSystem.update(l2, n3, m_interrupted);
                    MainFrame.clearJoystick();
                    break;
                }
                case 6: {
                    if (Game.m_gameControl == 4) {
                        XMLMenuSystem.update(l2, n3, m_interrupted);
                        MainFrame.clearJoystick();
                        break;
                    }
                    n2 = n3;
                    int n4 = m_joystick;
                    m_joystick = n3;
                    Game.gameUpdate(l2, m_interrupted);
                    if (n2 != m_joystick) break;
                    m_joystick = n4;
                    break;
                }
                case 8: {
                    if (m_mgInstance.isActive()) {
                        m_mgInstance.update();
                        XMLMenuSystem.checkMusicRestart();
                        break;
                    }
                    if (!SDKUtils.isLoadedStringsChunk(2)) {
                        SDKUtils.loadStringsChunk(2);
                    }
                    MainFrame.setMasterState(4);
                    break;
                }
            }
            MainFrame.frameRateProcess();
            m_interrupted = false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void draw(SDKGraphics sDKGraphics) {
        SDKGraphics sDKGraphics2 = sDKGraphics;
        if (m_readyToPaint) {
            if (!m_inPaint) {
                m_inPaint = true;
                switch (m_masterState) {
                    case 10: {
                        sDKGraphics2.setColor(0);
                        sDKGraphics2.setClip(0, 0, 352, 416);
                        sDKGraphics2.fillRect(0, 0, 352, 416);
                        break;
                    }
                    case 9: {
                        break;
                    }
                    case 2: {
                        MainFrame.logoDraw(sDKGraphics2);
                        break;
                    }
                    case 6: {
                        Game.gameDraw(sDKGraphics2);
                        break;
                    }
                    case 0: 
                    case 3: 
                    case 5: {
                        XMLMenuSystem.drawLoading(sDKGraphics2, m_loadTimer, m_loadTimerEnd);
                        break;
                    }
                    case 1: 
                    case 4: 
                    case 7: {
                        XMLMenuSystem.draw(sDKGraphics2);
                        break;
                    }
                    case 8: {
                        if (!m_mgInstance.isActive()) break;
                        m_mgInstance.paint(sDKGraphics2);
                    }
                }
                MainFrame.frameRateDraw(sDKGraphics2);
            }
            m_inPaint = false;
        }
    }

    private static void drawPressAnyKeyScreen(SDKGraphics sDKGraphics) {
    }

    public static void setMasterState(int n2) {
        int n3 = m_masterState;
        m_joystick = 0;
        m_masterState = n2;
        switch (n2) {
            case 2: {
                MainFrame.logoInit();
                break;
            }
            case 6: {
                break;
            }
            case 4: {
                if (n3 == 8) break;
                MainFrame.soundPlay(13, 2);
                break;
            }
            case 0: {
                m_loadTimer = -2;
                m_loadMenuID = 2;
                m_loadTimerEnd = 10;
                m_loadNextState = 1;
                break;
            }
            case 3: {
                m_loadTimer = -2;
                m_loadMenuID = 1;
                m_loadTimerEnd = 10;
                m_loadNextState = 4;
                break;
            }
            case 5: {
                m_loadTimer = -2;
                m_loadMenuID = 3;
                m_loadTimerEnd = 10;
                m_loadNextState = 6;
                break;
            }
            case 7: {
                XMLMenuSystem.SetMenu(0);
                break;
            }
            case 8: {
                if (!SDKUtils.isLoadedStringsChunk(5)) {
                    SDKUtils.loadStringsChunk(5);
                }
                m_mgInstance.reset("mnu");
            }
        }
    }

    public static int getMasterState() {
        return m_masterState;
    }

    private void startup() {
        m_readyToPaint = true;
        m_soundManager = SDKSoundManager.getManager();
        m_soundManager.setLoader(this);
        DDFile.fileInit();
        DDMath.init();
        XMLMenuSystem.menuInit();
        Game.gameLogicInit();
        MainFrame.setMasterState(0);
        MicroGame.m_markerPoints = new int[30];
    }

    public static int getAppTime() {
        return (int)(m_gameTime - m_appStartTime);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadUpdate() {
        if (++m_loadTimer == 0) {
            XMLMenuSystem.unload();
            MainFrame.unloadMoreGames();
            Game.unload();
            m_loadError = 0;
        }
        if (m_loadError != 0) {
            m_loadTimer = -1;
            return;
        } else if (m_loadTimer == m_loadTimerEnd + 2) {
            m_loadReturnMenu = -1;
            MainFrame.setMasterState(m_loadNextState);
            if (m_loadNextState == 4) return;
            XMLMenuSystem.m_soundMenuRestart = false;
            return;
        } else {
            if (m_loadTimer < 0 || m_loadTimer >= m_loadTimerEnd) return;
            switch (m_loadTimer >> 2) {
                case 0: {
                    switch (m_masterState) {
                        case 0: {
                            XMLMenuSystem.load(m_loadMenuID, m_loadTimer & 3, m_loadReturnMenu);
                            return;
                        }
                        case 3: {
                            if ((m_loadTimer & 3) == 0) {
                                // empty if block
                            }
                            XMLMenuSystem.load(m_loadMenuID, m_loadTimer & 3, m_loadReturnMenu);
                            MainFrame.loadMoreGames();
                            if ((m_loadTimer & 3) != 3) break;
                            Game.m_fontHeight = XMLMenuSystem.GetMenuFontHeight(0);
                            return;
                        }
                        case 5: {
                            XMLMenuSystem.load(m_loadMenuID, m_loadTimer & 3, m_loadReturnMenu);
                        }
                    }
                    return;
                }
                case 1: {
                    switch (m_masterState) {
                        case 5: {
                            Game.load(m_loadTimer & 3);
                            if ((m_loadTimer & 3) != 3) return;
                            Game.initBall();
                        }
                    }
                }
            }
        }
    }

    private static void logoInit() {
        m_logoCurrent = -1;
        m_logoImage = null;
        m_eaLogo = null;
    }

    private static void logoDraw(SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(0xFFFFFF);
        sDKGraphics.fillRect(0, 0, 352, 416);
        if (m_logoImage != null) {
            sDKGraphics.drawImage(m_logoImage, 176, 208, 3);
        }
    }

    private static void logoUpdate(long l2) {
        int n2 = -1;
        int n3 = (int)l2 - m_logoTimer;
        if (m_logoCurrent < 0) {
            XMLMenuSystem.unload();
        }
        if (n3 > 3000 || m_logoCurrent < 0) {
            m_logoImage = null;
            System.gc();
            if (++m_logoCurrent >= 2) {
                n2 = 3;
            } else {
                m_logoImage = DDFile.loadImage("/logo" + m_logoCurrent + ".png");
                if (m_logoCurrent == 0) {
                    // empty if block
                }
            }
            m_logoTimer = (int)l2;
        }
        if (n2 >= 0) {
            m_masterNextState = 4;
            MainFrame.setMasterState(n2);
        }
    }

    public static boolean isMoreGamesEnabled() {
        return m_mgEnabled;
    }

    public static void loadMoreGames() {
        m_mgInstance = new SDKMoreGames16(352, 416){

            public void drawBackground(SDKGraphics sDKGraphics) {
                sDKGraphics.setClip(0, 0, 352, 416);
                sDKGraphics.setColor(0);
                sDKGraphics.fillRect(0, 0, 352, 416);
            }
        };
        Object[] objectArray = XMLMenuSystem.getMoreGamesFonts();
        m_mgInstance.setFonts(objectArray);
        byte[] byArray = SDKInputStream.loadResourceAsByteArray("/moregames", null, 0);
        m_mgInstance.setProductData(byArray);
        m_mgEnabled = m_mgInstance.isAvailable();
    }

    private static void unloadMoreGames() {
        m_mgInstance = null;
    }

    public static void clearJoystick() {
        m_keyState = 0;
        m_joystick = 0;
    }

    private static int mapSDKKeysToJoystick(int n2) {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 |= 4;
        }
        if ((n2 & 2) != 0) {
            n3 |= 8;
        }
        if ((n2 & 4) != 0) {
            n3 |= 1;
        }
        if ((n2 & 8) != 0) {
            n3 |= 2;
        }
        if ((n2 & 0x10) != 0) {
            n3 |= 0x10;
        }
        if ((n2 & 0x20) != 0) {
            n3 |= 0x40;
        }
        if ((n2 & 0x40) != 0) {
            n3 |= 0x20;
        }
        if ((n2 & 0x100000) != 0) {
            n3 |= 0x80;
        }
        if ((n2 & 0x80000) != 0) {
            n3 |= 0x200;
        }
        if ((n2 & 0x200) != 0) {
            n3 |= 4;
        }
        if ((n2 & 0x8000) != 0) {
            n3 |= 8;
        }
        if ((n2 & 0x800) != 0) {
            n3 |= 1;
        }
        if ((n2 & 0x2000) != 0) {
            n3 |= 2;
        }
        if ((n2 & 0x1000) != 0) {
            n3 |= 0x10;
        }
        return n3;
    }

    public void pause() {
        m_interrupted = true;
        MainFrame.clearJoystick();
        XMLMenuSystem.m_soundMenuRestart = false;
        MainFrame.soundUnload();
    }

    public void resume() {
        m_interrupted = true;
        MainFrame.clearJoystick();
    }

    public void exiting() {
    }

    public void appKeyPressed(int n2, long l2) {
        m_keyState |= n2;
        m_keysPressedLastFrame |= n2;
        m_joystick = MainFrame.mapSDKKeysToJoystick(n2);
        if (m_masterState == 8) {
            m_mgInstance.processKey(n2);
        }
    }

    public void appKeyReleased(int n2, long l2) {
        m_keyState &= ~n2;
        m_keysReleasedLastFrame |= n2;
        m_joystick = 0;
        m_keysReleasedLastFrame = n2;
    }

    public void appLetterPressed(int n2, long l2) {
    }

    public void appLetterReleased(int n2, long l2) {
    }

    public void appScreenChanged(int n2, int n3) {
    }

    private static void orientationWarningDraw(SDKGraphics sDKGraphics) {
    }

    public void updateSoftKeyLabels(String string, String string2) {
    }

    public static void vibratePlay(int n2) {
        if (m_vibrateOn) {
            m_soundManager.vibrate(n2);
        }
    }

    public static void vibrateSetOnOff(boolean bl) {
        m_vibrateOn = bl;
    }

    public static boolean vibrateIsEnabled() {
        return m_vibrateOn;
    }

    public static void soundPlay(int n2) {
        MainFrame.soundPlay(n2, 0);
    }

    public static void soundPlay(int n2, int n3) {
        if ((n3 & 2) == 2) {
            m_soundManager.setCurrentLoop(-1);
        } else {
            m_soundManager.setCurrentLoop(1);
        }
        try {
            m_soundManager.playSound(n2);
        }
        catch (Exception exception) {
            DDDebug.msg("Sound error on " + n2);
        }
    }

    public static void soundStopAll() {
        m_soundManager.stopSounds();
    }

    public static void soundSetOnOff(boolean bl) {
        m_soundManager.setSoundEnabled(bl);
    }

    public static boolean soundIsEnabled() {
        return m_soundManager.isSoundEnabled();
    }

    public static void soundLoad() {
        for (int i2 = 0; i2 < 2; ++i2) {
            m_soundManager.loadSound(i2);
        }
        m_soundManager.loadSound(13);
    }

    public static void soundUnload() {
        for (int i2 = 0; i2 < 2; ++i2) {
            m_soundManager.unloadSound(i2);
        }
        m_soundManager.unloadSound(13);
    }

    public byte[] loadResource(int n2) {
        byte[] byArray = null;
        switch (n2) {
            case 1: {
                byArray = DDFile.loadFileBytes("/edge5.mid");
                break;
            }
            case 0: {
                byArray = DDFile.loadFileBytes("/hit8.mid");
                break;
            }
            case 13: {
                byArray = DDFile.loadFileBytes("/music.mid");
            }
        }
        return byArray;
    }

    private static void frameRateProcess() {
        if (m_frameRateOn) {
            long l2 = m_gameTime;
            if (l2 - m_frameRateTime >= 1000L) {
                m_frameRate = m_frameRateCount;
                m_frameRateCount = 0;
                m_frameRateTime = m_gameTime;
            }
            ++m_frameRateCount;
        }
    }

    private static void frameRateDraw(SDKGraphics sDKGraphics) {
        if (m_frameRateOn) {
            sDKGraphics.setClip(0, 0, 352, 416);
            sDKGraphics.setColor(0x7F7F7F);
            sDKGraphics.fillRect(328, 0, 24, 16);
            SDKString sDKString = new SDKString(3, 1);
            sDKString.setLength(0);
            sDKString.append(m_frameRate);
            SDKUtils.setGraphics(sDKGraphics);
            SDKUtils.drawString(sDKString, 328, 0, 20);
            sDKString = null;
        }
    }

    static {
        m_cheatBuffer = new int[]{-1, -1, -1, -1, -1, -1, -1, -1};
        m_Cheats = new int[][]{{131072, 16384, 256, 1024, 65536, 262144, 128, 128}, {131072, 16384, 256, 1024, 65536, 262144, 128, 256}, {131072, 16384, 256, 1024, 65536, 262144, 128, 512}, {131072, 16384, 256, 1024, 65536, 262144, 128, 1024}, {131072, 16384, 256, 1024, 65536, 262144, 128, 2048}, {131072, 16384, 256, 1024, 65536, 262144, 128, 4096}, {131072, 16384, 256, 1024, 65536, 262144, 128, 8192}, {131072, 16384, 256, 1024, 65536, 262144, 128, 16384}, {131072, 16384, 256, 1024, 65536, 262144, 128, 32768}, {131072, 16384, 256, 1024, 65536, 262144, 128, 65536}, {131072, 16384, 256, 1024, 65536, 262144, 256, 128}};
        m_cheatPointer = 0;
        m_logoImage = null;
        m_warningImage = null;
        m_eaLogo = null;
        m_logoCurrent = -1;
        m_loadReturnMenu = -1;
        m_debugString = new String[4];
        dbgInst = null;
        m_frameRateOn = false;
        m_memoryOn = false;
        m_wrongScreen = false;
        m_lastMenu = -1;
        m_appFrameTime = 0;
        m_gameMenuLoaded = false;
        m_strBuff = new StringBuffer();
        m_joystick = 0;
        m_pressAnyKey = false;
        m_OVIEnabled = false;
        pointerReleased = false;
    }
}

