/*
 * Decompiled with CFR 0.152.
 */
package com.distinctive;

import com.distinctive.DDDebug;
import com.distinctive.DDFile;
import com.distinctive.DDLKeyEntry;
import com.distinctive.DDMath;
import com.distinctive.GameLogic;
import com.distinctive.XMLMenuSystem;
import com.ea.sdk.ResourceLoader;
import com.ea.sdk.SDKCanvas;
import com.ea.sdk.SDKGame;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKInputStream;
import com.ea.sdk.SDKMoreGames16;
import com.ea.sdk.SDKSoundManager;
import com.ea.sdk.SDKUtils;

public class MainFrame
implements SDKGame,
ResourceLoader {
    private static final boolean CHEATS_ON = true;
    public static final int MASTERSTATE_LOADLANGUAGE = 0;
    public static final int MASTERSTATE_LANGUAGE = 1;
    public static final int MASTERSTATE_LOGOS = 2;
    public static final int MASTERSTATE_LOADFRONTEND = 3;
    public static final int MASTERSTATE_FRONTEND = 4;
    public static final int MASTERSTATE_LOADGAME = 5;
    public static final int MASTERSTATE_INGAME = 6;
    public static final int MASTERSTATE_PAUSED = 7;
    public static final int MASTERSTATE_MOREGAMES = 8;
    public static final int MASTERSTATE_ROTATED = 9;
    public static final int MASTERSTATE_STARTUP = 10;
    public static final int JOYSTICK_LEFT = 1;
    public static final int JOYSTICK_RIGHT = 2;
    public static final int JOYSTICK_UP = 4;
    public static final int JOYSTICK_DOWN = 8;
    public static final int JOYSTICK_FIRE = 16;
    public static final int JOYSTICK_LSK = 64;
    public static final int JOYSTICK_RSK = 32;
    public static final int JOYSTICK_OTHER1 = 128;
    public static final int JOYSTICK_INFO = 256;
    public static final int JOYSTICK_BACK = 512;
    public static final int JOYSTICK_TOUCH = 2048;
    private static final int DEVICE_SCREEN_WIDTH = 240;
    private static final int DEVICE_SCREEN_HEIGHT = 320;
    private static final boolean FEATURE_DOUBLE_SCREEN = false;
    private static final boolean SIMPLE_KEYS = true;
    private static boolean reloadSounds = false;
    public static final int SOUND_CLICK = 0;
    public static final int SOUND_WHISTLE1 = 1;
    public static final int SOUND_WHISTLE2 = 2;
    public static final int SOUND_CROWD = 3;
    public static final int SOUND_BOO = 4;
    public static final int SOUND_SMS = 5;
    public static final int SOUND_NUM_SOUNDS = 6;
    public static final int WHISTLE2_SOUND_MILLIS = 1000;
    private static final int LOADCOUNT_MAX = 4;
    private static final int LOGO_DELAY = 2000;
    private static final int LOGO_NUM = 3;
    private static final int LANG_FR = 2;
    private static final int LANG_EFIGS = 1000;
    public static SDKCanvas m_canvas;
    private static boolean m_readyToPaint;
    private static int m_machineState;
    private static long m_exitTimer;
    private static int m_masterState;
    private static SDKImage m_logoImage;
    private static SDKImage m_logoImage2;
    private static SDKImage m_warningImage;
    private static int m_logoCurrent;
    private static int m_logoTimer;
    private static int m_loadTimer;
    private static int m_loadTimerEnd;
    private static int m_loadNextState;
    private static int m_loadMenuID;
    public static int m_loadReturnMenu;
    public static int m_loadError;
    private static boolean m_mgEnabled;
    private static int m_keyState;
    private static int m_keysPressedLastFrame;
    private static int m_keysReleasedLastFrame;
    private static int m_pointerX;
    private static int m_pointerY;
    private static SDKImage m_backBuffer;
    private static SDKGraphics m_backBufferGraphics;
    private static int[] m_rgbBuffer;
    private static SDKSoundManager m_soundManager;
    private static boolean m_vibrateOn;
    private static boolean[] m_soundsLoaded;
    public static boolean m_doneFirstSetVolume;
    public static MainFrame dbgInst;
    public static int m_joystick;
    public static long prevKeyPressedTime;
    private static int m_resumeState;
    public static boolean m_interrupted;
    public static long m_gameTime;
    private static long m_lastPaintTime;
    private static boolean m_paintedSinceLastUpdate;
    private static int m_missedPaintCounter;
    private static final int PAINT_COUNTER_MAX = 6;
    private static final int PAINT_DELAY_MAX = 500;
    public static boolean rmsWriteInProgress;
    public static boolean showPleaseWait;
    private static boolean forcePause;
    private static int m_frameCountGC;
    public static long lastFrameTimeMe;
    private static SDKMoreGames16 m_mgInstance;
    private static final int MOREGAMES_BACKGROUND_COLOUR = 0;

    public static int getMasterState() {
        return m_masterState;
    }

    public MainFrame(SDKCanvas sDKCanvas) {
        m_canvas = sDKCanvas;
        dbgInst = this;
    }

    public void init() {
        MainFrame.setMasterState(10);
    }

    private void startup() {
        m_soundManager = SDKSoundManager.getManager();
        m_soundManager.setLoader(this);
        m_soundManager.setSoundVolume(70);
        DDFile.fileInit();
        DDMath.init();
        XMLMenuSystem.menuInit(m_canvas);
        GameLogic.gameLogicInit();
        MainFrame.setMasterState(0);
    }

    public void update(long l) {
        long l2 = System.currentTimeMillis();
        if (Integer.parseInt("0") > 0 && reloadSounds) {
            System.gc();
            try {
                MainFrame.m_soundsLoaded[Integer.parseInt((String)"0") - 1] = false;
                m_soundManager.loadSound(Integer.parseInt("0") - 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            reloadSounds = false;
        }
        try {
            m_gameTime = l;
            int n = 0;
            n = m_joystick;
            if (n == 0) {
                int n2 = m_keysPressedLastFrame & m_keysReleasedLastFrame;
                n = MainFrame.mapSDKKeysToJoystick(n2);
            }
            m_keysReleasedLastFrame = 0;
            m_keysPressedLastFrame = 0;
            switch (m_masterState) {
                case 10: {
                    this.startup();
                    break;
                }
                case 2: {
                    MainFrame.logoUpdate(l);
                    break;
                }
                case 0: 
                case 3: 
                case 5: {
                    MainFrame.loadUpdate();
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    XMLMenuSystem.update(l, n, m_interrupted);
                    MainFrame.clearJoystick();
                    break;
                }
                case 8: {
                    if (m_mgInstance.isActive()) {
                        m_mgInstance.update();
                        break;
                    }
                    SDKUtils.loadStringsChunk(2);
                    MainFrame.setMasterState(4);
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        lastFrameTimeMe = System.currentTimeMillis();
    }

    public void draw(SDKGraphics sDKGraphics) {
        SDKGraphics sDKGraphics2 = sDKGraphics;
        try {
            if (m_masterState != 9) {
                // empty if block
            }
            switch (m_masterState) {
                case 10: {
                    sDKGraphics2.setColor(0);
                    sDKGraphics2.setClip(0, 0, 240, 320);
                    sDKGraphics2.fillRect(0, 0, 240, 320);
                    break;
                }
                case 2: {
                    MainFrame.logoDraw(sDKGraphics2);
                    break;
                }
                case 9: {
                    break;
                }
                case 0: {
                    sDKGraphics2.setColor(0);
                    sDKGraphics2.setClip(0, 0, 240, 320);
                    sDKGraphics2.fillRect(0, 0, 240, 320);
                    XMLMenuSystem.drawLoading(sDKGraphics2, m_loadTimer, m_loadTimerEnd);
                    break;
                }
                case 3: {
                    if (m_interrupted) {
                        m_interrupted = false;
                        sDKGraphics2.setColor(0xFFFFFF);
                        sDKGraphics2.setClip(0, 0, 240, 320);
                        sDKGraphics2.fillRect(0, 0, 240, 320);
                        m_logoImage = DDFile.loadImage("/logo2.png");
                        sDKGraphics2.drawImage(m_logoImage, 120, 160, 3);
                    }
                    XMLMenuSystem.drawLoading(sDKGraphics2, m_loadTimer, m_loadTimerEnd);
                    break;
                }
                case 1: 
                case 4: 
                case 7: {
                    XMLMenuSystem.draw(sDKGraphics2);
                    break;
                }
                case 5: {
                    XMLMenuSystem.draw(sDKGraphics2);
                    XMLMenuSystem.drawLoading(sDKGraphics2, m_loadTimer, m_loadTimerEnd);
                    break;
                }
                case 8: {
                    if (!m_mgInstance.isActive()) break;
                    SDKUtils.setGraphics(sDKGraphics2);
                    m_mgInstance.paint(sDKGraphics2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setMasterState(int n) {
        MainFrame.clearJoystick();
        m_interrupted = false;
        m_masterState = n;
        switch (n) {
            case 0: {
                m_loadTimer = -2;
                m_loadMenuID = 2;
                m_loadTimerEnd = 4;
                m_loadNextState = 1;
                break;
            }
            case 2: {
                MainFrame.logoInit();
                break;
            }
            case 3: {
                m_loadTimer = -2;
                m_loadMenuID = 1;
                m_loadTimerEnd = 4;
                m_loadNextState = 4;
                break;
            }
            case 5: {
                m_loadTimer = -2;
                m_loadMenuID = 3;
                m_loadTimerEnd = 4;
                m_loadNextState = 4;
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                SDKUtils.loadStringsChunk(4);
                m_mgInstance.reset("mnu");
                break;
            }
            case 9: {
                m_exitTimer = System.currentTimeMillis();
            }
        }
    }

    private static void loadUpdate() {
        if (++m_loadTimer == 0) {
            switch (m_masterState) {
                case 0: 
                case 3: {
                    XMLMenuSystem.unload();
                    MainFrame.unloadMoreGames();
                    break;
                }
            }
            m_loadError = 0;
        }
        if (m_loadError != 0) {
            m_loadTimer = -1;
        } else if (m_loadTimer == m_loadTimerEnd + 2) {
            if (m_masterState == 5) {
                XMLMenuSystem.onMenuFunction(XMLMenuSystem.m_menuSystemId, XMLMenuSystem.m_currMenu, 0, 50);
            }
            m_loadReturnMenu = -1;
            MainFrame.setMasterState(m_loadNextState);
        } else if (m_loadTimer >= 0 && m_loadTimer < m_loadTimerEnd) {
            block3 : switch (m_loadTimer >> 2) {
                case 0: {
                    switch (m_masterState) {
                        case 0: {
                            XMLMenuSystem.load(m_loadMenuID, m_loadTimer & 3, m_loadReturnMenu);
                            break block3;
                        }
                        case 3: {
                            if (m_loadTimer == 1) {
                                GameLogic.load();
                                MainFrame.loadMoreGames();
                            }
                            XMLMenuSystem.load(m_loadMenuID, m_loadTimer & 3, m_loadReturnMenu);
                            break block3;
                        }
                    }
                }
            }
        }
    }

    private static void logoInit() {
        m_logoCurrent = -1;
        m_logoImage = null;
    }

    private static void logoUpdate(long l) {
        int n = -1;
        int n2 = (int)l - m_logoTimer;
        if (m_logoCurrent < 0) {
            XMLMenuSystem.setupLoadingImage(1, 2);
        }
        if (n2 > 2000 || m_logoCurrent < 0) {
            m_logoImage = null;
            m_logoImage2 = null;
            int n3 = 0;
            if (++m_logoCurrent >= 3 - n3) {
                n = 3;
            } else {
                m_logoImage = DDFile.loadImage("/logo" + m_logoCurrent + ".png");
                if (m_logoCurrent == 1) {
                    m_logoImage2 = DDFile.loadImage("/logo3.png");
                }
            }
            m_logoTimer = (int)l;
        }
        if (n >= 0) {
            MainFrame.setMasterState(n);
        }
    }

    private static void logoDraw(SDKGraphics sDKGraphics) {
        sDKGraphics.setColor(0xFFFFFF);
        sDKGraphics.fillRect(0, 0, 240, 320);
        if (m_logoImage != null) {
            if (m_logoCurrent == 1 && XMLMenuSystem.m_selectedLanguage == 1) {
                sDKGraphics.drawImage(m_logoImage, 120, 160, 3);
            } else if (m_logoCurrent != 1 || m_logoCurrent == 1) {
                sDKGraphics.drawImage(m_logoImage, 120, 160, 3);
            }
        }
    }

    private static void landscapeWarningDraw(SDKGraphics sDKGraphics) {
    }

    public static boolean isMoreGamesEnabled() {
        return m_mgEnabled;
    }

    public static void loadMoreGames() {
        m_mgInstance = new SDKMoreGames16(240, 320){

            public void drawBackground(SDKGraphics sDKGraphics) {
                sDKGraphics.setClip(0, 0, 240, 320);
                sDKGraphics.setColor(0);
                sDKGraphics.fillRect(0, 0, 240, 320);
            }
        };
        Object[] objectArray = XMLMenuSystem.getMoreGamesFonts();
        m_mgInstance.setFonts(objectArray);
        byte[] byArray = SDKInputStream.loadResourceAsByteArray("/moregames", null, 0);
        m_mgInstance.setProductData(byArray);
        m_mgEnabled = m_mgInstance.isAvailable();
    }

    private static void unloadMoreGames() {
        m_mgInstance = null;
    }

    public void pause() {
        m_interrupted = true;
    }

    public void resume() {
        m_interrupted = true;
    }

    public void exiting() {
    }

    public void appScreenChanged(int n, int n2) {
    }

    public static void clearJoystick() {
        m_keyState = 0;
        m_joystick = 0;
    }

    private static int mapSDKKeysToJoystick(int n) {
        int n2 = 0;
        if ((n & 1) != 0) {
            n2 |= 4;
        }
        if ((n & 2) != 0) {
            n2 |= 8;
        }
        if ((n & 4) != 0) {
            n2 |= 1;
        }
        if ((n & 8) != 0) {
            n2 |= 2;
        }
        if ((n & 0x10) != 0) {
            n2 |= 0x10;
        }
        if ((n & 0x20) != 0) {
            n2 |= 0x40;
        }
        if ((n & 0x40) != 0) {
            n2 |= 0x20;
        }
        if ((n & 0x100000) != 0) {
            n2 |= 0x80;
        }
        if ((n & 0x80000) != 0) {
            n2 |= 0x200;
        }
        if ((n & 0x200) != 0) {
            n2 |= 4;
        }
        if ((n & 0x8000) != 0) {
            n2 |= 8;
        }
        if ((n & 0x800) != 0) {
            n2 |= 1;
        }
        if ((n & 0x2000) != 0) {
            n2 |= 2;
        }
        if ((n & 0x1000) != 0) {
            n2 |= 0x10;
        }
        if ((n & 0x80) != 0) {
            n2 |= 0x100;
        }
        return n2;
    }

    public void appKeyPressed(int n, long l) {
        if (XMLMenuSystem.m_currMenu == 61 && DDLKeyEntry.keyInputKeyPressed(n)) {
            return;
        }
        m_keysPressedLastFrame |= n;
        if ((m_keyState |= n) != n) {
            // empty if block
        }
        m_joystick = MainFrame.mapSDKKeysToJoystick(n);
        if (m_masterState == 8) {
            m_mgInstance.processKey(n);
        } else {
            GameLogic.processCheats(n);
        }
    }

    public void appKeyReleased(int n, long l) {
        m_keyState &= ~n;
        m_keysReleasedLastFrame |= n;
        m_joystick = 0;
        m_keysReleasedLastFrame = n;
    }

    public void appLetterPressed(int n, long l) {
    }

    public void appLetterReleased(int n, long l) {
    }

    public void updateSoftKeyLabels(String string, String string2) {
    }

    public void appPointerPressed(int n, int n2, long l) {
    }

    public void appPointerReleased(int n, int n2, long l) {
    }

    public void appPointerDragged(int n, int n2, long l) {
    }

    public static void vibratePlay(int n) {
        if (m_vibrateOn) {
            m_soundManager.vibrate(n);
        }
    }

    public static void vibrateSetOnOff(boolean bl) {
        m_vibrateOn = bl;
    }

    public static boolean vibrateIsEnabled() {
        return m_vibrateOn;
    }

    public static void soundPlay(int n) {
        try {
            m_soundManager.playSound(n);
        }
        catch (Exception exception) {
            DDDebug.msg("Sound error on " + n);
        }
    }

    public static void soundStopAll() {
        if (Integer.parseInt("0") > 0) {
            m_soundManager.stopSounds();
            if (!reloadSounds) {
                for (int i = 0; i < 6; ++i) {
                    m_soundManager.unloadSound(i);
                }
                System.gc();
                reloadSounds = true;
            }
        } else {
            m_soundManager.stopSounds();
        }
    }

    public static void soundSetOnOff(boolean bl) {
        m_soundManager.setSoundEnabled(bl);
    }

    public static boolean soundIsEnabled() {
        return m_soundManager.isSoundEnabled();
    }

    public byte[] loadResource(int n) {
        byte[] byArray = null;
        if (n < 6) {
            switch (n) {
                case 0: {
                    byArray = DDFile.loadFileBytes("/click.wav");
                    break;
                }
                case 1: {
                    byArray = DDFile.loadFileBytes("/whistle1.wav");
                    break;
                }
                case 2: {
                    byArray = DDFile.loadFileBytes("/whistle2.wav");
                    break;
                }
                case 3: {
                    byArray = DDFile.loadFileBytes("/crowd.wav");
                    break;
                }
                case 4: {
                    byArray = DDFile.loadFileBytes("/boo.wav");
                    break;
                }
                case 5: {
                    byArray = DDFile.loadFileBytes("/sms.wav");
                }
            }
        }
        return byArray;
    }

    public void loadAllSounds() {
        for (int i = 0; i < 6; ++i) {
            try {
                MainFrame.m_soundsLoaded[i] = false;
                m_soundManager.loadSound(i);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        m_warningImage = null;
        m_loadReturnMenu = -1;
        m_soundsLoaded = new boolean[6];
        m_doneFirstSetVolume = false;
        dbgInst = null;
        m_joystick = 0;
        prevKeyPressedTime = System.currentTimeMillis();
        rmsWriteInProgress = false;
        showPleaseWait = false;
        forcePause = false;
        lastFrameTimeMe = -1L;
    }
}

