/*
 * Decompiled with CFR 0.152.
 */
package com.lemonquest.juegohorca;

import com.lemonquest.juegohorca.GameEngine;
import com.lemonquest.utils.SSAnimation;
import com.lemonquest.utils.SSFont;
import com.lemonquest.utils.SSResourceManager;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GameCanvas {
    private GameEngine ge;
    public static final int TLOADING = 0;
    public static final int TSTART = 1;
    public static final int THELP = 2;
    public static final int TABOUT = 3;
    public static final int TEXIT = 4;
    public static final int TLANGUAGE = 5;
    public static final int TSOUND = 6;
    public static final int TON = 7;
    public static final int TOFF = 8;
    public static final int THELPTEXT = 9;
    public static final int TABOUTTEXT = 10;
    public static final int TSOUNDQUESTION = 11;
    public static final int TYES = 12;
    public static final int TNO = 13;
    public static final int TOK = 14;
    public static final int TBACK = 15;
    public static final int TMENU = 16;
    public static final int TRANDOM = 17;
    public static final int T1PLAYER = 18;
    public static final int T2PLAYERS = 19;
    public static final int TJOINGAME = 20;
    public static final int TCREATEGAME = 21;
    public static final int TCHOOSELETTER = 22;
    public static final int TWIN = 23;
    public static final int TLOSE = 24;
    public static final int TNEWGAME = 25;
    public static final int TCONTINUE = 26;
    public static final int TWAITINGCLIENT = 27;
    public static final int TSEARCHINGSERVER = 28;
    public static final int TCHOOSESERVER = 29;
    public static final int TDISCONECT = 30;
    public static final int TWAITOPONENT = 31;
    public static final int TOPONENTLOSE = 32;
    public static final int TOPONENTWIN = 33;
    public static final int TWELOSE = 34;
    public static final int TWEWIN = 35;
    public static final int TERROR = 36;
    public static final int TNOSERVER = 37;
    public static final int T6LETTERS = 38;
    public static final int T7LETTERS = 39;
    public static final int T8LETTERS = 40;
    public static final int TCFGGAME = 41;
    public static final int TMOREGAMES = 42;
    public static final int TMOREGAMESTEXT = 43;
    public static final int TCHOOSECATEGORY = 44;
    public static final int TCATEGORY1 = 45;
    public static final int TCATEGORY2 = 46;
    public static final int TCATEGORY3 = 47;
    public static final int TCATEGORY4 = 48;
    public static final int T5LETTERS = 49;
    public static final int TDEVICES = 50;
    public static final int TSERVICES = 51;
    public static final int TALPHABET = 52;
    public static final int ICON_NO_ICON = -1;
    public static final int ICON_YES = 0;
    public static final int ICON_NO = 1;
    public static final int ICON_OK = 2;
    public static final int ICON_BACK = 3;
    public static final int ICON_MENU = 4;
    public static final int ICON_RANDOM = 5;
    public static final int RES_SPLASH = 0;
    public static final int RES_FONT_MENU = 1;
    public static final int RES_COVER = 2;
    public static final int RES_CURSOR_MENU = 4;
    public static final int RES_HANGMAN = 5;
    public static final int RES_BUDDY = 6;
    public static final int RES_MAX = 10;
    public static final int POPUP_TILE_SIZE = 9;
    private SSAnimation logo = null;
    private SSAnimation cursorMenu = null;
    private SSAnimation hangman = null;
    private SSAnimation buddy = null;
    public SSFont fntMenu = null;
    public Image cover = null;
    public int coverY;
    public int coverPosY;
    private int stateLoading = 0;
    private int maxLoadResources = 0;
    public SSResourceManager resManager;
    private int lineHeight;
    private int linesPaper;
    private int linesPaperX;
    public static final int HANGMAN_INIT = 0;
    public static final int HANGMAN_DEAD = 7;
    public static final int HANGMAN_WIN = 8;
    public static final int CURSOR_ERROR = 9;
    public static final int CURSOR_SELECT = 10;
    public static final int MAX_LANGUAGES = 4;
    public static final int FLAG_W = 18;
    public static final int FLAG_H = 12;
    public static final int FLAG_GAP = 5;
    public static final int FLAG_TEXT_Y = 5;
    public static final int FLAG_TEXT_HEIGHT_Y = 30;
    public static final int FLAG_X = 55;
    public static final int FLAG_Y = 66;
    public static final String[] CHOOSE_YOUR_LANGUAGE = new String[]{"SELECCIONE IDIOMA:", "CHOOSE YOUR LANGUAGE:", "W\u00c4HLEN SIE IHRE SPRACHE:", "CHOISIR VOTRE LANGUE:"};
    public static final String[] LANGUAGES = new String[]{"ESPA\u00d1OL", "ENGLISH", "DEUTSCH", "FRENCH"};
    public static final String[] LANGUAGES_OK = new String[]{"ACEPTAR", "ACCEPT", "ANNEHEM", "ACCEPTER"};

    public GameCanvas(GameEngine ge) {
        this.ge = ge;
        this.resManager = new SSResourceManager();
    }

    public void setMaxLoadResources(int maxLoadResources) {
        this.maxLoadResources = maxLoadResources;
        this.stateLoading = 0;
    }

    public void loadResource(int resource) {
        boolean resourceLoaded = false;
        switch (resource) {
            case 6: {
                this.buddy = new SSAnimation(this.resManager.getResourceAsStream("buddy.lqa"));
                break;
            }
            case 5: {
                this.hangman = new SSAnimation(this.resManager.getResourceAsStream("hangman.lqa"));
                break;
            }
            case 1: {
                this.fntMenu = new SSFont(this.resManager.getResource("fontMenu.ssf"));
                this.lineHeight = this.fntMenu.getFontHeight() + this.fntMenu.getLineSpacing();
                this.linesPaper = 160 / this.lineHeight;
                this.linesPaperX = 128 / this.lineHeight - 1;
                break;
            }
            case 0: {
                this.logo = new SSAnimation(this.resManager.getResourceAsStream("logo.lqa"));
                break;
            }
            case 4: {
                this.cursorMenu = new SSAnimation(this.resManager.getResourceAsStream("menucursor.lqa"));
                break;
            }
            case 2: {
                this.cover = this.resManager.getImage("cover.png");
            }
        }
        this.resourceLoaded();
        this.ge.repaint();
        this.ge.serviceRepaints();
    }

    public void resourceLoaded() {
        ++this.stateLoading;
    }

    public void unloadResource(int resource) {
        switch (resource) {
            case 1: {
                this.fntMenu = null;
                break;
            }
            case 0: {
                this.logo = null;
                break;
            }
            case 2: {
                this.cover = null;
            }
        }
        System.gc();
        this.ge.repaint();
        this.ge.serviceRepaints();
    }

    public void paintCover(Graphics g) {
        this.paintPaper(g);
        g.drawImage(this.cover, 64, 80, 3);
    }

    public void calculatePosYCover() {
        this.coverPosY = (160 - this.getYfromLinePaper(this.linesPaper - this.ge.maxItemMenuLength - 2)) / 2;
        this.coverY = 80 - this.cover.getHeight() / 2;
    }

    public void paintInGameMenu(Graphics g) {
        this.paintPaper(g);
        this.paintLettersTop(g);
        int heightHangman = this.hangman.getFrameHeight(0);
        int lineTop = 3;
        int lineBottom = 2 + this.ge.lettersGame.length + heightHangman / this.lineHeight + 1;
        int x = 64;
        int y = this.getYfromLinePaper(lineTop + (lineBottom - lineTop) / 2 - this.ge.maxOptions / 2);
        for (int i = 0; i < this.ge.maxOptions; ++i) {
            this.fntMenu.drawString(g, this.ge.optionsMenu[i].toCharArray(), x, y, 17);
            if (i == this.ge.optionActual) {
                this.paintCursorMenu(g, x, y + this.fntMenu.getFontHeight() / 2);
            }
            y += this.lineHeight;
        }
        this.paintWord(g);
    }

    public void paintGame(Graphics g) {
        this.paintPaper(g);
        this.paintLettersTop(g);
        if (this.ge.lastProcessTime >= this.ge.timeHangman + 1000L && this.ge.state == 3) {
            this.paintCursor(g, this.ge.cursorX, this.ge.cursorY);
        }
        this.paintMessage(g);
        this.paintHangman(g);
        this.paintWord(g);
    }

    private void paintWord(Graphics g) {
        int heightHangman = this.hangman.getFrameHeight(0);
        int y = this.getYfromLinePaper((160 - (160 - (heightHangman + this.ge.lettersGame.length)) / 2) / this.lineHeight + 1);
        int x = 3 + (128 - this.ge.actualWordLength * (this.lineHeight + this.fntMenu.getLineSpacing())) / 2;
        for (int i = 0; i < this.ge.actualWordLength; ++i) {
            char letter = this.ge.actualWordOpenLetter[i] ? (char)this.ge.actualWord.charAt(i) : (char)'_';
            this.fntMenu.drawString(g, String.valueOf(letter).toCharArray(), x, y, 20);
            x += this.lineHeight + this.fntMenu.getLineSpacing();
        }
    }

    private void paintMessage(Graphics g) {
        boolean x = false;
        boolean y = false;
        boolean width = false;
        boolean height = false;
    }

    private void paintHangman(Graphics g) {
        int x = this.getXfromLinePaper() + this.lineHeight;
        int y = this.getYfromLinePaper(1 + this.ge.lettersGame.length);
        x = (128 - this.hangman.getFrameWidth(0)) / 2;
        this.hangman.drawAnimation(g, this.ge.hangmanState, System.currentTimeMillis() - this.ge.timeHangman, x, y, false);
    }

    private void paintCursor(Graphics g, int cursorX, int cursorY) {
        int y = this.getYfromLinePaper(0) + this.fntMenu.getFontHeight() / 2 + 2;
        int x = 15;
        this.hangman.drawAnimation(g, 10, System.currentTimeMillis(), x += this.lineHeight * cursorX + this.fntMenu.getLineWidth(String.valueOf(this.ge.lettersGame[cursorY][cursorX]).toCharArray()) / 2, y += this.lineHeight * cursorY, true);
    }

    private void paintLettersTop(Graphics g) {
        int y = this.getYfromLinePaper(0) + 2;
        int dx = this.lineHeight;
        for (int j = 0; j < this.ge.lettersGame.length; ++j) {
            int x = 15;
            for (int i = 0; i < this.ge.lettersGame[j].length; ++i) {
                this.fntMenu.drawString(g, String.valueOf(this.ge.lettersGame[j][i]).toCharArray(), x, y, 20);
                if (this.ge.lettersClosed[j][i]) {
                    int width = this.fntMenu.getLineWidth(String.valueOf(this.ge.lettersGame[j][i]).toCharArray());
                    this.hangman.drawAnimation(g, 9, 0L, x + width / 2, y + this.fntMenu.getFontHeight() / 2 + 2, false);
                }
                x += dx;
            }
            y += this.lineHeight;
        }
    }

    private void resetClip(Graphics g) {
        g.setClip(0, 0, 128, 160);
    }

    public void paintSplash(Graphics g) {
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, 128, 160);
        this.logo.drawAnimation(g, 0, System.currentTimeMillis(), 64, 80, true);
    }

    private void paintMenuTitle(Graphics g) {
        this.resetClip(g);
        g.drawImage(this.cover, 64, this.coverY, 17);
    }

    private void paintPaper(Graphics g) {
        int i;
        this.resetClip(g);
        g.setColor(0xFFFFFF);
        g.fillRect(0, 0, 128, 160);
        g.setColor(13028043);
        int y = this.lineHeight;
        for (i = 0; i < this.linesPaper; ++i) {
            g.drawLine(0, y, 128, y);
            y += this.lineHeight;
        }
        int x = this.lineHeight * 2;
        for (i = 0; i < this.linesPaperX; ++i) {
            g.drawLine(x, 0, x, 160);
            x += this.lineHeight;
        }
        g.setColor(16231138);
        g.drawLine(this.lineHeight, 0, this.lineHeight, 160);
    }

    public void paintMainMenu(Graphics g) {
        this.paintPaper(g);
        this.paintMenuTitle(g);
        if (this.ge.menuActual == 9) {
            this.paintBuddy(g);
        } else if (!this.ge.optionsMenu[this.ge.optionActual].equals(this.ge.lang[21]) && !this.ge.optionsMenu[this.ge.optionActual].equals(this.ge.lang[20])) {
            this.paintBuddy(g);
        }
        this.paintMenuItems(g);
    }

    public void paintWaitingBluetooth(Graphics g, String text) {
        this.paintPaper(g);
        this.paintMenuTitle(g);
        int y = this.getYfromLinePaper((this.linesPaper - (this.coverY + this.cover.getHeight()) / this.lineHeight) / 2 + (this.coverY + this.cover.getHeight()) / this.lineHeight - 2);
        this.fntMenu.drawString(g, text.toCharArray(), this.fntMenu.getFontHeight() * 2, y, 128 - this.fntMenu.getFontHeight() * 4, 160, 17);
    }

    public void paintMoreGames(Graphics g, String text) {
        this.paintPaper(g);
        this.paintMenuTitle(g);
        int y = this.getYfromLinePaper(this.linesPaper / 2 + 1);
        this.fntMenu.drawString(g, text.toCharArray(), this.fntMenu.getFontHeight() * 2, y, 128 - this.fntMenu.getFontHeight() * 4, 160, 17);
    }

    private void paintBuddy(Graphics g) {
        this.resetClip(g);
        int x = this.getXfromLinePaper();
        int y = this.getYfromLinePaper(this.linesPaper - this.ge.maxItemMenuLength - 2) + this.ge.maxItemMenuLength * this.lineHeight / 2;
        int width = this.buddy.getFrameWidth(0);
        this.buddy.drawAnimation(g, 0, System.currentTimeMillis() - this.ge.timeHangman, 96, y, true);
    }

    private int getYfromLinePaper(int lineNumber) {
        return lineNumber * this.lineHeight + this.fntMenu.getLineSpacing() - 1;
    }

    private int getXfromLinePaper() {
        return this.lineHeight + this.fntMenu.getLineSpacing();
    }

    private void paintCursorMenu(Graphics g, int x, int y) {
        this.cursorMenu.drawAnimation(g, 0, System.currentTimeMillis(), x, y, true);
    }

    private void paintMenuItems(Graphics g) {
        int y;
        this.resetClip(g);
        int x = this.getXfromLinePaper() + this.lineHeight;
        if (this.ge.menuActual == 9) {
            y = this.getYfromLinePaper(this.linesPaper - this.ge.maxItemMenuLength - 4);
            y = this.getYfromLinePaper(this.linesPaper - this.ge.maxItemMenuLength - 3);
            this.fntMenu.drawString(g, this.ge.lang[44].toCharArray(), x, y, 20);
            y += this.lineHeight;
            y += this.lineHeight;
        } else {
            y = this.getYfromLinePaper(this.linesPaper - this.ge.maxItemMenuLength - 2);
        }
        for (int i = 0; i < this.ge.maxOptions; ++i) {
            this.fntMenu.drawString(g, this.ge.optionsMenu[i].toCharArray(), x, y, 20);
            if (i == this.ge.optionActual) {
                int length = this.fntMenu.getLineWidth(this.ge.optionsMenu[i].toCharArray());
                this.paintCursorMenu(g, x + length / 2, y + this.fntMenu.getFontHeight() / 2);
            }
            y += this.lineHeight;
        }
    }

    public void paintLanguageIconsBottom(Graphics g) {
        this.fntMenu.drawString(g, LANGUAGES_OK[this.ge.optionActual].toCharArray(), this.getXfromLinePaper(), 158, 36);
    }

    public void paintIconsBottom(Graphics g) {
        if (this.ge.iconLeft != -1) {
            this.fntMenu.drawString(g, this.ge.lang[12 + this.ge.iconLeft].toCharArray(), this.getXfromLinePaper(), 158, 36);
        }
        if (this.ge.iconRight != -1) {
            this.fntMenu.drawString(g, this.ge.lang[12 + this.ge.iconRight].toCharArray(), 128 - this.getXfromLinePaper(), 158, 40);
        }
    }

    public void paintLoading(Graphics g) {
        int width = 128 - this.getXfromLinePaper() * 2;
        int height = this.fntMenu.getFontHeight();
        int x = (128 - width) / 2;
        int y = this.getYfromLinePaper(this.linesPaper / 2) - this.fntMenu.getLineSpacing() / 2 + 1;
        this.paintPaper(g);
        this.resetClip(g);
        g.setColor(0xFFAADD);
        g.drawRect(x, y, width - 1, height - 1);
        g.setColor(7233214);
        g.fillRect(x + 1, y + 1, this.stateLoading * (width - 2) / this.maxLoadResources, height - 2);
        if (this.fntMenu != null && this.ge.lang != null) {
            this.fntMenu.drawString(g, this.ge.lang[0].toCharArray(), 64, this.getYfromLinePaper(this.linesPaper / 2 - 1), 17);
        }
    }

    public void paintHelp(Graphics g) {
        int height = 160 - (this.fntMenu.getFontHeight() + this.fntMenu.getLineSpacing()) * 3;
        int y = this.fntMenu.getFontHeight() + this.fntMenu.getLineSpacing() * 2;
        this.paintPaper(g);
        this.ge.maxLines = this.ge.lineData.length - height / (this.fntMenu.getFontHeight() + this.fntMenu.getLineSpacing());
        this.fntMenu.drawFastString(g, this.ge.lang[9].toCharArray(), this.ge.lineData, y, y, 128, 20, this.ge.lineActual, height / (this.fntMenu.getFontHeight() + this.fntMenu.getLineSpacing()));
    }

    public void paintAbout(Graphics g) {
        int height = 160 - (this.fntMenu.getFontHeight() + this.fntMenu.getLineSpacing()) * 2;
        int y = this.fntMenu.getFontHeight() + this.fntMenu.getLineSpacing() * 2;
        this.paintPaper(g);
        this.ge.maxLines = this.ge.lineData.length - height / (this.fntMenu.getFontHeight() + this.fntMenu.getLineSpacing());
        this.fntMenu.drawFastString(g, this.ge.lang[10].toCharArray(), this.ge.lineData, y, y, 128, 20, this.ge.lineActual, height / (this.fntMenu.getFontHeight() + this.fntMenu.getLineSpacing()) - 1);
    }

    public void paintQuestion(Graphics g, String text) {
        int y = this.getYfromLinePaper(this.linesPaper / 2);
        this.paintPaper(g);
        this.fntMenu.drawString(g, text.toCharArray(), 15, y, 98, this.lineHeight * 4, 17);
    }

    public void paintWriteWord(Graphics g) {
        this.paintPaper(g);
        int indexX = 0;
        int indexY = 0;
        int y = 80;
        int yDown = y + this.fntMenu.getFontHeight();
        int x = (128 - GameEngine.numLetters * (this.lineHeight + this.fntMenu.getLineSpacing())) / 2;
        int i = 0;
        while (true) {
            if (i >= GameEngine.writeWord.length) break;
            indexY = GameEngine.writeWord[i] / this.ge.lettersGame[0].length;
            indexX = GameEngine.writeWord[i] - indexY * this.ge.lettersGame[0].length;
            char letter = this.ge.lettersGame[indexY][indexX];
            this.fntMenu.drawString(g, String.valueOf(letter).toCharArray(), x, y, 20);
            this.fntMenu.drawString(g, String.valueOf('_').toCharArray(), x, yDown, 20);
            if (GameEngine.indexWriteWord == i) {
                this.hangman.drawAnimation(g, 10, System.currentTimeMillis(), x + this.fntMenu.getLineWidth(String.valueOf(letter).toCharArray()) / 2, y + (this.fntMenu.getFontHeight() + this.fntMenu.getLineSpacing()) / 2 + this.fntMenu.getFontHeight(), true);
            }
            x += this.lineHeight + this.fntMenu.getLineSpacing();
            ++i;
        }
    }

    public void paintCFGGame(Graphics g) {
        int length;
        int y = this.getYfromLinePaper(this.linesPaper / 2);
        int heightLine = this.fntMenu.getFontHeight() + this.fntMenu.getLineSpacing();
        this.paintPaper(g);
        this.fntMenu.drawString(g, this.ge.lang[41].toCharArray(), 15, y - heightLine - heightLine - heightLine, 98, this.lineHeight * 3, 17);
        this.fntMenu.drawString(g, this.ge.lang[49].toCharArray(), 15, y, 98, this.lineHeight * 3, 17);
        if (0 == this.ge.optionActual) {
            length = this.fntMenu.getLineWidth(this.ge.optionsMenu[0].toCharArray());
            this.paintCursorMenu(g, 64, y + this.fntMenu.getFontHeight() / 2);
        }
        this.fntMenu.drawString(g, this.ge.lang[38].toCharArray(), 15, y += heightLine, 98, this.lineHeight * 3, 17);
        if (1 == this.ge.optionActual) {
            length = this.fntMenu.getLineWidth(this.ge.optionsMenu[1].toCharArray());
            this.paintCursorMenu(g, 64, y + this.fntMenu.getFontHeight() / 2);
        }
        this.fntMenu.drawString(g, this.ge.lang[39].toCharArray(), 15, y += heightLine, 98, this.lineHeight * 3, 17);
        if (2 == this.ge.optionActual) {
            length = this.fntMenu.getLineWidth(this.ge.optionsMenu[2].toCharArray());
            this.paintCursorMenu(g, 64, y + this.fntMenu.getFontHeight() / 2);
        }
        this.fntMenu.drawString(g, this.ge.lang[40].toCharArray(), 15, y += heightLine, 98, this.lineHeight * 3, 17);
        if (3 == this.ge.optionActual) {
            length = this.fntMenu.getLineWidth(this.ge.optionsMenu[3].toCharArray());
            this.paintCursorMenu(g, 64, y + this.fntMenu.getFontHeight() / 2);
        }
    }

    public void paintLanguageMenu(Graphics g, int optionSelected) {
        this.paintPaper(g);
        this.fntMenu.drawString(g, CHOOSE_YOUR_LANGUAGE[optionSelected].toCharArray(), 64, 66 - (this.fntMenu.getFontHeight() + this.fntMenu.getLineSpacing()) * 2, 17);
        int y = 66;
        for (int i = 0; i < 4; ++i) {
            g.setClip(0, 0, 128, 160);
            if (i == optionSelected) {
                this.paintCursorMenu(g, 64, y + this.fntMenu.getFontHeight() / 2);
            }
            int length = this.fntMenu.getLineWidth(LANGUAGES[i].toCharArray());
            this.fntMenu.drawString(g, LANGUAGES[i].toCharArray(), 64, y, 17);
            y += 17;
        }
    }
}

