/*
 * Decompiled with CFR 0.152.
 */
package de.mef.state.concrete;

import de.mef.menu.Frame;
import de.mef.menu.Pair;
import de.mef.menu.Picture;
import de.mef.menu.ScrollBar;
import de.mef.menu.ScrollBox;
import de.mef.menu.Space;
import de.mef.menu.TextBlock;
import de.mef.menu.TextItem;
import de.mef.state.State;
import de.mef.util.Handset;
import de.mef.util.KeyListener;
import de.mef.util.Locale;
import de.mef.util.Refreshable;
import de.mef.util.Updateable;
import javax.microedition.lcdui.Graphics;

public final class InfoState
extends State
implements KeyListener,
Updateable,
Refreshable {
    private Frame frame;
    private ScrollBox scrollbox;
    private TextItem header = new TextItem("menu-about");

    public final void update() {
        State.repaint();
    }

    public InfoState() {
        this.header.enabled_color = TextItem.DEFAULT_FOCUS_COLOR;
        this.header.enabled_outline = TextItem.DEFAULT_FOCUS_OUTLINE;
        this.scrollbox = new ScrollBox(State.canvas.getWidth() * 8 / 10, State.canvas.getHeight() - 3 * Handset.fnt_bold.getHeight());
        this.scrollbox.setAlignment(17);
        this.scrollbox.addElement(new Space(8));
        this.scrollbox.addElement(new TextBlock(State.host.getAppProperty("MIDlet-Name"), Handset.fnt_mediumbold, this.scrollbox.getWidth(), 0xFFFFFF, 1));
        StringBuffer stringBuffer = new StringBuffer("v");
        stringBuffer.append(State.host.getAppProperty("MIDlet-Version"));
        this.scrollbox.addElement(new TextBlock(stringBuffer.toString(), Handset.fnt_small, this.scrollbox.getWidth(), 0xCCCCCC, 1));
        this.scrollbox.addElement(new Space(16));
        try {
            this.scrollbox.addElement(new Space(8));
            this.scrollbox.addElement(new TextBlock(Locale.string("copyright"), Handset.fnt_small, this.scrollbox.getWidth(), 0xCCCCCC, 1));
            this.scrollbox.addElement(new Space(4));
            this.scrollbox.addElement(new Picture("/mef.png"));
        }
        catch (Exception exception) {}
        this.scrollbox.addElement(new Space(8));
        this.scrollbox.addElement(new TextBlock("Mobile", Handset.fnt_smallbold, this.scrollbox.getWidth(), 0xFFFFFF, 1));
        this.scrollbox.addElement(new TextBlock("Entertainment", Handset.fnt_smallbold, this.scrollbox.getWidth(), 0xFFFFFF, 1));
        this.scrollbox.addElement(new TextBlock("Factory", Handset.fnt_smallbold, this.scrollbox.getWidth(), 0xFFFFFF, 1));
        this.scrollbox.addElement(new TextBlock("GmbH", Handset.fnt_smallbold, this.scrollbox.getWidth(), 0xFFFFFF, 1));
        this.scrollbox.addElement(new Space(16));
        this.scrollbox.addElement(new TextBlock("www.m-e-f.net", Handset.fnt_underline, this.scrollbox.getWidth(), 4227312, 1));
        this.scrollbox.addElement(new Space(16));
        ScrollBar scrollBar = new ScrollBar(this.scrollbox, State.canvas.getWidth() / 40, this.scrollbox.getHeight(), 0);
        this.frame = new Frame(new Pair(this.scrollbox, scrollBar));
        this.frame.enabled_background = 1125953;
        this.frame.enabled_color = 0;
    }

    public final void enter() {
        State.right = Locale.string("command-menu");
        this.refresh();
        State.repaint();
    }

    public final void paint(Graphics graphics) {
        State.menuBackground(graphics, false);
        this.header.paint(graphics, State.canvas.getWidth() / 2, 0, 17);
        this.frame.paint(graphics, State.canvas.getWidth() / 2, State.canvas.getHeight() / 2, 3);
    }

    public final void leave() {
        this.scrollbox.scrollTo(0, 0);
    }

    public final void keyPressed(int n) {
        if (n == Handset.MENU_RIGHT) {
            State.setNamedState("mainmenu");
            return;
        }
        this.scrollbox.keyPressed(n);
    }

    public final void keyRepeated(int n) {
        this.scrollbox.keyRepeated(n);
    }

    public final void keyReleased(int n) {
        this.scrollbox.keyReleased(n);
    }

    public final void refresh() {
        this.scrollbox.refresh();
        this.header.refresh();
    }
}

