/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Game {
    FrameWork frameWork;
    Scene scene;
    public int iState;
    protected int gameStateOld;
    protected int gameStateNew;
    protected int gameState;
    private int gamestate;
    private Image off_img;
    private Graphics off_g;
    private byte[][] backMap1;
    private byte[][] backMap2;
    private int focus;
    private String[] menu;
    private int menuLength;
    private byte menuControl;
    private final byte MENUIN;
    private final byte MENUOK = (byte)2;
    private final byte MENUOUT = (byte)3;
    private static boolean bPause = false;
    private int Index;
    public int level;
    public int playMode;
    private static int mapNum = 20;
    private Tangram[] tangram;
    private final int tangramNum;
    private int cursorState;
    private boolean putdown = false;
    private int putNum;
    public static int mapGrid;
    private int putGrid;
    private boolean gamewin;
    public int score;
    private int time;
    public int gameTime;
    private long currentTime;
    private boolean timeOut;
    private int effectGameMenu;
    public static final int GRID_X = 25;
    public static final int GRID_Y = 22;
    public static final int initX = 8;
    public static final int initY = 6;
    private int[][] TAN_COR = new int[][]{{4, 169}, {40, 169}, {59, 174}, {77, 173}, {96, 174}, {104, 174}, {139, 169}};
    private int[] tanW = new int[]{33, 25, 16, 17, 16, 33, 33};
    private int[] Cur_Cor = new int[]{27, 46, 64, 82, 100, 120, 141};
    private byte[][] tan_act = new byte[][]{{-2, 0}, {-1, -1}, {0, -2}, {1, -1}, {2, 0}, {1, 1}, {0, 2}, {-1, 1}};
    private int[] tanType = new int[]{1, 4, 7, 5, 6, 3, 2};
    public static final int TAN_INIT = 0;
    public static final int TAN_UP = 1;
    public static final int TAN_DOWN = 2;
    private int counter;
    private int effectID;
    public final int EFFECT_NON;
    public final int EFFECT_PASS;
    public final int EFFECT_LOST;
    private Vector starVec;
    public static final int starw = 152;
    public static final int starh = 132;
    public static int midX;
    public static int midY;
    private int rollX;
    private int rollY;
    public int[][] point;
    public int[] lineColor = new int[]{16594432, 16599836, 16604209, 16609096, 16612956, 16617587};
    private int hiScore;
    private boolean[] inGame = new boolean[]{true, true, true, true};

    public Game(FrameWork frameWork) {
        this.MENUIN = 1;
        this.tangramNum = 7;
        this.EFFECT_NON = 0;
        this.EFFECT_PASS = 1;
        this.EFFECT_LOST = 2;
        this.frameWork = frameWork;
        this.gameStateOld = -1;
        this.gameState = -1;
        this.gameStateNew = 41;
        this.off_img = Image.createImage((int)176, (int)220);
        this.off_g = this.off_img.getGraphics();
        this.tangram = new Tangram[7];
        for (int i = 0; i < 7; ++i) {
            this.tangram[i] = new Tangram(this.tanType[i], 8, 6);
        }
        this.starVec = new Vector();
        this.scene = new Scene(this);
    }

    public void Close() {
        this.off_img = null;
    }

    public void Init() {
        if (this.gameStateNew == this.gameState) {
            return;
        }
        switch (this.gameStateNew) {
            case 41: {
                this.InitInGame();
                break;
            }
            case 45: {
                this.InitGameMenu();
                break;
            }
            case 49: {
                this.InitGamePass1();
                break;
            }
            case 52: {
                this.InitGamePass2();
                break;
            }
            case 48: {
                this.InitGameLose();
                break;
            }
            case 47: {
                this.InitDialogue();
                break;
            }
            case 40: {
                this.InitLevelUp();
                break;
            }
            case 50: {
                this.InitGameFinished();
                break;
            }
            case 51: {
                this.InitQuitInGame();
            }
        }
        this.gameStateOld = this.gameState;
        this.gameState = this.gameStateNew;
    }

    public void Running() {
        ++this.counter;
        if (this.counter > 65534) {
            this.counter = 0;
        }
        switch (this.gameState) {
            case 41: {
                if (bPause) {
                    return;
                }
                this.RunningInGame();
                break;
            }
            case 45: {
                this.RunningGameMenu();
                break;
            }
            case 47: {
                this.RunningDialog();
                break;
            }
            case 40: {
                this.RunningLevelUp();
                break;
            }
            case 49: {
                this.RunningGamePass1();
                break;
            }
            case 52: {
                this.RunningGamePass2();
                break;
            }
            case 48: {
                this.RunningGameLose();
                break;
            }
            case 50: {
                this.RunningGameFinished();
                break;
            }
            case 51: {
                this.RunningQuitInGame();
            }
        }
    }

    public void paint(Graphics graphics) {
        switch (this.gameState) {
            case 41: 
            case 45: 
            case 47: 
            case 48: 
            case 49: 
            case 52: {
                this.PaintInGame(graphics);
                if (this.timeOut) {
                    this.PaintTimeOut(graphics);
                }
                if (this.gameState == 45) {
                    this.paintGameMenu(graphics);
                    break;
                }
                if (this.gameState != 47) break;
                this.PaintDialogue(graphics);
                break;
            }
            case 40: {
                this.PaintLevelUp(graphics);
                break;
            }
            case 50: {
                this.PaintGameFinished(graphics);
                break;
            }
            case 51: {
                this.PaintQuitInGame(graphics);
            }
        }
    }

    public void keyPressed(int n) {
        switch (this.gameState) {
            case 41: {
                this.OnKeyPressedInGame(n);
                break;
            }
            case 45: {
                this.OnKeyPressedGameMenu(n);
                break;
            }
            case 47: {
                this.OnKeyPressedDialogue(n);
                break;
            }
            case 50: {
                this.OnKeyPressedGameFinished(n);
                break;
            }
            case 51: {
                this.OnKeyPressedQuitInGame(n);
            }
        }
    }

    public void keyReleased(int n) {
        switch (this.gameState) {
            case 41: {
                this.OnKeyReleasedInGame(n);
                break;
            }
            case 45: {
                this.OnKeyReleasedGameMenu(n);
                break;
            }
            case 50: {
                this.OnKeyReleasedGameFinished(n);
                break;
            }
            case 51: {
                this.OnKeyReleasedQuitInGame(n);
            }
        }
    }

    public void InitInGame() {
        this.frameWork.addCommand(3);
        this.gameStateOld = 0;
        this.gameState = 0;
        this.counter = 0;
        this.rollY = 146;
        this.initVariable();
        if (!this.frameWork.loadRecord) {
            this.score = 0;
        }
        if (this.inGame[this.playMode - 1]) {
            this.frameWork.soundH = 100;
            this.frameWork.iPage = 0;
            this.frameWork.nextiPage = 6;
            this.frameWork.iPageindex = 0;
            this.frameWork.iPageindex2 = 5;
            this.frameWork.iPagedirect = 2;
            this.frameWork.textBox.setBoxSize(144, 90);
            this.frameWork.textBox.setString(Language.MODE_INFO[this.playMode - 1]);
        }
    }

    private void initVariable() {
        this.focus = 0;
        this.cursorState = 0;
        System.out.println("init variable putNum == 0");
        this.putNum = 0;
        bPause = false;
        this.effectID = 0;
        this.gamewin = false;
        if (this.playMode == 2) {
            this.time = this.gameTime = Constant.GAMETIME[this.level - 1];
            this.hiScore = this.frameWork.recordScore[0];
        } else {
            this.time = 0;
        }
        this.currentTime = System.currentTimeMillis();
    }

    public void setBackMap(int n) {
        int n2;
        this.frameWork.backImg[8] = FrameWork.pic.getImage("back" + (Math.abs(FrameWork.rnd.nextInt()) % 10 + 9));
        for (n2 = 0; n2 < 7; ++n2) {
            this.tangram[n2].setState(0);
        }
        this.backMap2 = new byte[22][25];
        if (this.playMode == 4) {
            this.backMap1 = new byte[22][25];
            return;
        }
        this.Index = n;
        this.backMap1 = this.scene.reset((this.level - 1) * mapNum + this.Index);
        this.putGrid = 0;
        for (n2 = 0; n2 < 22; ++n2) {
            System.arraycopy(this.backMap1[n2], 0, this.backMap2[n2], 0, 25);
        }
    }

    private void setAnimation(int n) {
        this.frameWork.effect[n].reset(Constant.SPRITE_TYPE_KEY[n], 1, (this.tangram[this.focus].circX + this.tangram[this.focus].x) * 5 + 25, (this.tangram[this.focus].circY + this.tangram[this.focus].y) * 5 + 35);
    }

    private void gamePass() {
        System.out.println("game pass ========= " + this.playMode);
        if (this.playMode == 1) {
            this.Index = Math.abs(FrameWork.rnd.nextInt()) % 200 + 1;
            this.level = (this.Index - 1) / 20 + 1;
            this.Index = (this.Index - 1) % 20 + 1;
        } else if (this.playMode == 2) {
            if (this.level < 10) {
                ++this.level;
            }
            this.Index = Math.abs(FrameWork.rnd.nextInt()) % 20 + 1;
        } else if (this.playMode == 3) {
            this.Index = this.Index % 20 + 1;
        }
        this.initVariable();
        this.setBackMap(this.Index);
    }

    private void gameLose() {
        this.initVariable();
        this.setBackMap(Math.abs(FrameWork.rnd.nextInt()) % 20 + 1);
    }

    private void RunningInGame() {
        if (this.inGame[this.playMode - 1]) {
            return;
        }
        if (this.timeOut) {
            if (System.currentTimeMillis() - this.currentTime > 3000L) {
                this.timeOut = false;
                this.gamestate = 48;
                this.gameStateNew = 47;
            }
            return;
        }
        if (System.currentTimeMillis() - this.currentTime > 1000L) {
            if (this.playMode != 2) {
                if (this.time < 5999) {
                    ++this.time;
                }
            } else if (this.time > 0) {
                --this.time;
            } else {
                FrameWork.sound1.soundPause();
                this.timeOut = true;
            }
            this.currentTime = System.currentTimeMillis();
        }
        if (this.putdown) {
            this.putDown();
            this.tangram[this.focus].setState(2);
            this.cursorState = 0;
            ++this.putNum;
            this.putdown = false;
            this.setAnimation(1);
            if (this.playMode == 4) {
                return;
            }
            if (this.putNum == 7 && this.putGrid == mapGrid) {
                this.gamewin = true;
                if (this.playMode == 2) {
                    this.score += this.time * (5 * this.level);
                    if (this.level == 10) {
                        FrameWork.frameStateNew = this.frameWork.highScoreUpdate() ? 10 : 7;
                    } else {
                        this.gamestate = 52;
                        this.gameStateNew = 47;
                    }
                } else {
                    this.gamestate = 52;
                    this.gameStateNew = 47;
                }
                if (this.frameWork.bySoundLevel > 0) {
                    FrameWork.sound1.soundPlay(0, 1);
                }
            }
        }
    }

    public void PaintInGame(Graphics graphics) {
        int n;
        graphics.setColor(0);
        graphics.fillRect(0, 0, 176, 220);
        graphics.drawImage(this.frameWork.backImg[8], 0, 0, 20);
        graphics.setClip(25, 35, 125, this.rollY - 35);
        this.paintGrid(graphics);
        graphics.setClip(0, 0, 176, 220);
        graphics.drawImage(this.frameWork.backImg[7], 9, 23, 20);
        graphics.setColor(0xCCCCCC);
        this.drawUI(graphics);
        for (n = 0; n < 7; ++n) {
            graphics.setClip(this.TAN_COR[n][0], this.TAN_COR[n][1], this.tanW[n], 33);
            if (this.tangram[n].state == 0) {
                if (this.cursorState == 0 && n == this.focus) {
                    graphics.setClip(this.TAN_COR[n][0] + this.tan_act[this.counter % 8][0], this.TAN_COR[n][1] + this.tan_act[this.counter % 8][1], this.tanW[n], 33);
                    graphics.drawImage(this.frameWork.backImg[n], this.TAN_COR[n][0] + this.tan_act[this.counter % 8][0], this.TAN_COR[n][1] + this.tan_act[this.counter % 8][1], 20);
                    continue;
                }
                graphics.drawImage(this.frameWork.backImg[n], this.TAN_COR[n][0], this.TAN_COR[n][1], 20);
                continue;
            }
            graphics.drawImage(this.frameWork.backImg[n], this.TAN_COR[n][0] - this.tanW[n], this.TAN_COR[n][1], 20);
        }
        graphics.setClip(25, 35, 125, this.rollY - 35);
        n = -1;
        for (int i = 0; i < 7; ++i) {
            if (this.tangram[i].state == 2) {
                graphics.drawImage(this.frameWork.tangramImage[this.tangram[i].type - 1][this.tangram[i].index - 1], 25 + this.tangram[i].x * 5, 35 + this.tangram[i].y * 5, 20);
                continue;
            }
            if (this.tangram[i].state != 1) continue;
            n = i;
        }
        if (n != -1) {
            this.tangram[n].move();
            graphics.drawImage(this.frameWork.tangramImage[this.tangram[n].type - 1][this.tangram[n].index - 1], 25 + this.tangram[n].x * 5 + 1, 35 + this.tangram[n].y * 5 - 1, 20);
        }
        this.tangramEffect(graphics);
        this.paintSelect(graphics);
        this.paintInfo(graphics);
    }

    private void tangramEffect(Graphics graphics) {
        for (int i = 0; i < 5; ++i) {
            if (this.frameWork.effect[i].state == 0) continue;
            try {
                this.frameWork.effect[i].update();
                this.frameWork.effect[i].paint(graphics, 0, 0);
                continue;
            }
            catch (Exception exception) {
                System.out.println("tangramEffect err!");
                exception.printStackTrace();
            }
        }
    }

    private void paintGrid(Graphics graphics) {
        graphics.setColor(0);
        for (int i = 0; i < 22; ++i) {
            block8: for (int j = 0; j < 25; ++j) {
                switch (this.backMap1[i][j]) {
                    case 1: {
                        graphics.fillRect(25 + j * 5, 35 + i * 5, 5, 5);
                        continue block8;
                    }
                    case 2: {
                        graphics.fillTriangle(25 + j * 5, 35 + i * 5, 25 + (j + 1) * 5, 35 + i * 5, 25 + j * 5, 35 + (i + 1) * 5);
                        continue block8;
                    }
                    case 3: {
                        graphics.fillTriangle(25 + j * 5, 35 + i * 5, 25 + (j + 1) * 5, 35 + i * 5, 25 + (j + 1) * 5, 35 + (i + 1) * 5);
                        continue block8;
                    }
                    case 4: {
                        graphics.fillTriangle(25 + j * 5, 35 + i * 5, 25 + j * 5, 35 + (i + 1) * 5, 25 + (j + 1) * 5, 35 + (i + 1) * 5);
                        continue block8;
                    }
                    case 5: {
                        graphics.fillTriangle(25 + (j + 1) * 5, 35 + i * 5, 25 + (j + 1) * 5, 35 + (i + 1) * 5, 25 + j * 5, 35 + (i + 1) * 5);
                    }
                }
            }
        }
    }

    private void drawLine(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        graphics.drawLine(n2, n3, n4, n5);
    }

    private void setCirCoor() {
        this.tangram[this.focus].x += this.tangram[this.focus].circX;
        this.tangram[this.focus].y += this.tangram[this.focus].circY;
        this.tangram[this.focus].setGridNum();
        this.tangram[this.focus].x -= this.tangram[this.focus].circX;
        this.tangram[this.focus].y -= this.tangram[this.focus].circY;
        if (this.tangram[this.focus].x + this.tangram[this.focus].gridx > 25) {
            this.tangram[this.focus].x -= this.tangram[this.focus].x + this.tangram[this.focus].gridx - 25;
        } else if (this.tangram[this.focus].x < 0) {
            this.tangram[this.focus].x = 0;
        }
        if (this.tangram[this.focus].y + this.tangram[this.focus].gridy > 22) {
            this.tangram[this.focus].y -= this.tangram[this.focus].y + this.tangram[this.focus].gridy - 22;
        } else if (this.tangram[this.focus].y < 0) {
            this.tangram[this.focus].y = 0;
        }
    }

    private void OnKeyPressedInGame(int n) {
        if ((this.timeOut || this.gamewin) && this.playMode != 4) {
            return;
        }
        if (this.inGame[this.playMode - 1]) {
            if (n == 8 || n == 18) {
                this.frameWork.OnKeyPressedAbout(n);
            } else if (n == 2 || n == 12) {
                this.frameWork.OnKeyPressedAbout(n);
            } else if (n == 5 || n == 10) {
                this.inGame[this.playMode - 1] = false;
            }
            return;
        }
        switch (n) {
            case 11: {
                if (this.tangram[this.focus].state != 1) break;
                --this.tangram[this.focus].index;
                switch (this.tangram[this.focus].type) {
                    case 1: 
                    case 2: {
                        if (this.tangram[this.focus].index >= 1) break;
                        this.tangram[this.focus].index = 8;
                        break;
                    }
                    case 3: {
                        if (this.tangram[this.focus].index >= 1) break;
                        this.tangram[this.focus].index = 4;
                        break;
                    }
                    case 4: {
                        if (this.tangram[this.focus].index >= 1) break;
                        this.tangram[this.focus].index = 8;
                        break;
                    }
                    case 5: {
                        if (this.tangram[this.focus].index >= 1) break;
                        this.tangram[this.focus].index = 2;
                        break;
                    }
                    case 6: 
                    case 7: {
                        if (this.tangram[this.focus].index >= 1) break;
                        this.tangram[this.focus].index = 8;
                    }
                }
                this.setCirCoor();
                this.setAnimation(2);
                break;
            }
            case 13: {
                if (this.tangram[this.focus].state != 1) break;
                switch (this.tangram[this.focus].type) {
                    case 1: 
                    case 2: {
                        this.tangram[this.focus].index = this.tangram[this.focus].index % 8 + 1;
                        break;
                    }
                    case 3: {
                        this.tangram[this.focus].index = this.tangram[this.focus].index % 4 + 1;
                        break;
                    }
                    case 4: {
                        this.tangram[this.focus].index = this.tangram[this.focus].index % 8 + 1;
                        break;
                    }
                    case 5: {
                        this.tangram[this.focus].index = this.tangram[this.focus].index % 2 + 1;
                        break;
                    }
                    case 6: 
                    case 7: {
                        this.tangram[this.focus].index = this.tangram[this.focus].index % 8 + 1;
                    }
                }
                this.setCirCoor();
                this.setAnimation(2);
                break;
            }
            case 20: {
                if (this.tangram[this.focus].state != 1) break;
                this.tangram[this.focus] = new Tangram(this.tanType[this.focus], 8, 6);
                this.cursorState = 0;
                break;
            }
            case 21: {
                for (int i = 0; i < 7; ++i) {
                    this.cursorState = 0;
                    if (this.tangram[i].state == 2) {
                        this.putUp(i);
                        this.setAnimation(0);
                    }
                    this.tangram[i] = new Tangram(this.tanType[i], 8, 6);
                }
                this.putNum = 0;
                break;
            }
            case 4: 
            case 14: {
                if (this.cursorState == 0) {
                    --this.focus;
                    this.focus = (this.focus + 7) % 7;
                    break;
                }
                this.tangram[this.focus].setMove(4);
                break;
            }
            case 6: 
            case 16: {
                if (this.cursorState == 0) {
                    ++this.focus;
                    this.focus = (this.focus + 7) % 7;
                    break;
                }
                this.tangram[this.focus].setMove(6);
                break;
            }
            case 2: 
            case 12: {
                if (this.cursorState != 1) break;
                this.tangram[this.focus].setMove(2);
                break;
            }
            case 8: 
            case 18: {
                if (this.cursorState != 1) break;
                this.tangram[this.focus].setMove(8);
                break;
            }
            case 5: 
            case 15: {
                if (this.cursorState == 0) {
                    if (this.tangram[this.focus].state == 0) {
                        this.tangram[this.focus].setCoord(8, 6);
                    } else if (this.tangram[this.focus].state == 2) {
                        this.putUp(this.focus);
                        --this.putNum;
                        this.setAnimation(0);
                    }
                    this.tangram[this.focus].setState(1);
                    this.cursorState = 1;
                    break;
                }
                if (this.playMode != 4) {
                    this.putdown = this.checkTangram();
                    break;
                }
                this.putdown = this.checkMap();
                break;
            }
            case 10: {
                this.tangram[this.focus].setMove(0);
                this.counter = 0;
                this.gameStateNew = 45;
                this.frameWork.bySoundState = (byte)2;
            }
        }
    }

    private void OnKeyReleasedInGame(int n) {
        this.tangram[this.focus].setMove(0);
    }

    private void gamePause() {
        bPause = true;
    }

    private void RunningGameMenu() {
        this.effectGameMenu = this.effectGameMenu != 2 ? ++this.effectGameMenu : 0;
    }

    private void InitGameMenu() {
        this.gamePause();
        if (this.frameWork.bySoundLevel > 0) {
            FrameWork.sound1.soundPlay(1, -1);
        }
        this.frameWork.deleteCommand();
        this.frameWork.addCommand(1);
        this.frameWork.addCommand(2);
        this.effectGameMenu = 0;
        this.frameWork.bySelectMenu = 1;
        if (this.playMode % 2 == 1) {
            this.menuLength = Language.SYSTEM_MENU1.length;
            this.menu = Language.SYSTEM_MENU1;
        } else {
            this.menuLength = Language.SYSTEM_MENU2.length;
            this.menu = Language.SYSTEM_MENU2;
        }
        this.counter = 0;
        this.frameWork.soundH = 100;
    }

    private void paintGameMenu(Graphics graphics) {
        int n = 31;
        int n2 = 115;
        this.drawBack(graphics, n, n2);
        graphics.drawImage(this.frameWork.gameUI[0], 40, n + 8, 20);
        for (int i = 0; i < this.menuLength; ++i) {
            int n3;
            int n4;
            graphics.setClip(43, n + 16 + i * 18, 100, 18);
            if (this.frameWork.bySelectMenu == i + 1) {
                n4 = 0;
                n3 = 4504318;
                this.frameWork.drawPane(graphics, 46 - this.effectGameMenu, n + 20 + i * 18 - this.effectGameMenu, 90 + this.effectGameMenu * 2, 9 + this.effectGameMenu * 2, n3, 0xFFFFFF);
                graphics.drawRect(45 - this.effectGameMenu, n + 18 + i * 18 - this.effectGameMenu, 92 + this.effectGameMenu * 2, 9 + this.effectGameMenu * 2 + 3);
            } else {
                n4 = 1;
                n3 = 0;
                this.frameWork.drawPane(graphics, 46, n + 20 + i * 18, 90, 9, n3, 10329760);
                graphics.drawRect(45, n + 18 + i * 18, 92, 12);
            }
            this.frameWork.drawCharactor(graphics, this.menu[i], (176 - this.menu[i].length() * 5 >> 1) - 3, n + 22 + i * 18, n4);
        }
    }

    private void drawBack(Graphics graphics, int n, int n2) {
        graphics.setClip(0, n, 176, n2);
        graphics.setColor(4213338);
        graphics.fillRect(0, n, 176, 4);
        graphics.fillRect(0, n + n2 - 4, 176, 3);
        graphics.setColor(0);
        graphics.drawLine(0, n + 4, 176, n + 4);
        graphics.drawLine(0, n + n2 - 5, 176, n + n2 - 5);
        graphics.setColor(16691712);
        graphics.fillRect(0, n + 5, 176, n2 - 9);
    }

    private void backToGame() {
        this.frameWork.deleteCommand();
        this.frameWork.addCommand(3);
        bPause = false;
        this.gameStateOld = 41;
        this.gameState = 41;
        this.gameStateNew = 41;
        this.currentTime = System.currentTimeMillis();
        if (this.frameWork.bySoundLevel > 0) {
            FrameWork.sound1.soundPlay(2, -1);
        }
    }

    private void OnKeyPressedGameMenu(int n) {
        switch (n) {
            case 2: 
            case 12: {
                if (this.frameWork.bySelectMenu > 1) {
                    this.frameWork.bySelectMenu = (byte)(this.frameWork.bySelectMenu - 1);
                    break;
                }
                this.frameWork.bySelectMenu = (byte)this.menuLength;
                break;
            }
            case 8: 
            case 18: {
                if (this.frameWork.bySelectMenu < this.menuLength) {
                    this.frameWork.bySelectMenu = (byte)(this.frameWork.bySelectMenu + 1);
                    break;
                }
                this.frameWork.bySelectMenu = 1;
                break;
            }
            case 5: 
            case 10: 
            case 15: {
                if (this.playMode % 2 == 1) {
                    switch (this.frameWork.bySelectMenu) {
                        case 1: {
                            this.backToGame();
                            break;
                        }
                        case 2: {
                            if (this.playMode == 1) {
                                this.gamestate = 52;
                                this.gameStateNew = 49;
                                break;
                            }
                            if (this.playMode == 3) {
                                FrameWork.frameStateNew = 6;
                                break;
                            }
                            this.gameStateNew = 47;
                            break;
                        }
                        case 3: {
                            this.gameStateNew = 47;
                            break;
                        }
                        case 4: {
                            this.gameState = -1;
                            FrameWork.frameStateNew = 2;
                            break;
                        }
                        case 5: {
                            this.gameState = -1;
                            FrameWork.frameStateNew = 4;
                        }
                    }
                    break;
                }
                switch (this.frameWork.bySelectMenu) {
                    case 1: {
                        this.backToGame();
                        break;
                    }
                    case 2: {
                        this.gameStateNew = 47;
                        break;
                    }
                    case 3: {
                        this.gameState = -1;
                        FrameWork.frameStateNew = 2;
                        break;
                    }
                    case 4: {
                        this.gameState = -1;
                        FrameWork.frameStateNew = 4;
                    }
                }
                break;
            }
            case 3: {
                this.backToGame();
            }
        }
    }

    private void OnKeyReleasedGameMenu(int n) {
    }

    private void paintInfo(Graphics graphics) {
        if (this.inGame[this.playMode - 1]) {
            this.frameWork.drawInfoBack(graphics, 16030512);
            this.frameWork.textBox.paintText(graphics, 16, 66, 0x393939, -1, this.frameWork.iPage, this.frameWork.nextiPage, this.frameWork.iPageindex, this.frameWork.iPageindex2, this.frameWork.iPagedirect, false, false);
            this.frameWork.paintArrow(graphics);
        }
    }

    private void InitDialogue() {
        this.frameWork.bySelectMenu = 1;
    }

    private void RunningDialog() {
    }

    private void PaintDialogue(Graphics graphics) {
        graphics.setClip(0, 0, 176, 220);
        int n = 88;
        int n2 = 90;
        if (this.gameStateOld == 45) {
            graphics.drawImage(this.frameWork.dialogImg[0], n, n2, 3);
            this.frameWork.drawCharactor(graphics, "exit game{", n - 5 * "exit game{".length() / 2, n2 - 10, 1);
            this.frameWork.drawCharactor(graphics, "yes", n - 45, n2 + 5, this.frameWork.bySelectMenu % 2);
            this.frameWork.drawCharactor(graphics, "no", n + 25, n2 + 5, (this.frameWork.bySelectMenu - 1) % 2);
        } else if (this.gameStateOld == 48) {
            graphics.drawImage(this.frameWork.dialogImg[1], 88, 90, 3);
            this.frameWork.drawCharactor(graphics, "continue", n - 45, n2 + 5, this.frameWork.bySelectMenu % 2);
            this.frameWork.drawCharactor(graphics, "quit", n + 25, n2 + 5, (this.frameWork.bySelectMenu - 1) % 2);
        } else {
            graphics.drawImage(this.frameWork.dialogImg[0], 88, 90, 3);
            this.frameWork.drawCharactor(graphics, "continue", n - 45, n2 - 5, this.frameWork.bySelectMenu % 2);
            this.frameWork.drawCharactor(graphics, "quit", n + 25, n2 - 5, (this.frameWork.bySelectMenu - 1) % 2);
        }
    }

    private void OnKeyPressedDialogue(int n) {
        switch (n) {
            case 4: 
            case 14: {
                this.frameWork.bySelectMenu = 1;
                break;
            }
            case 6: 
            case 16: {
                this.frameWork.bySelectMenu = (byte)2;
                break;
            }
            case 5: 
            case 10: {
                if (this.gameStateOld == 45) {
                    if (this.frameWork.bySelectMenu == 1) {
                        if (this.playMode == 2) {
                            this.frameWork.saveGame(this.level);
                        }
                        FrameWork.bGameRunning = false;
                        FrameWork.frameStateNew = -4;
                        break;
                    }
                    this.gameStateNew = this.gameStateOld;
                    break;
                }
                if (this.gamestate == 52) {
                    if (this.playMode == 3) {
                        this.frameWork.levelIn = !this.saveGame();
                    } else if (this.playMode == 2) {
                        this.frameWork.saveGame(this.level + 1);
                    }
                }
                if (this.frameWork.bySelectMenu == 1) {
                    this.gameStateNew = 49;
                    break;
                }
                FrameWork.bGameRunning = false;
                FrameWork.frameStateNew = -4;
                break;
            }
            case 3: {
                if (this.gameStateOld != 45) break;
                this.gameStateNew = this.gameStateOld;
            }
        }
    }

    private void InitGameLose() {
        this.counter = 0;
        this.gameLose();
    }

    private void RunningGameLose() {
        if (this.counter == 1) {
            // empty if block
        }
        if (this.counter < 12) {
            this.rollY += 10;
            this.frameWork.effect[3].setXY(88, this.rollY + 5);
        } else {
            if (this.frameWork.bySoundLevel > 0) {
                FrameWork.sound1.soundPlay(2, -1);
            }
            this.gameState = 41;
            this.gameStateNew = 41;
        }
    }

    private void PaintTimeOut(Graphics graphics) {
        graphics.setClip(0, 0, 176, 220);
        graphics.drawImage(this.frameWork.dialogImg[1], 88, 90, 17);
    }

    private void InitLevelUp() {
    }

    private void RunningLevelUp() {
        this.gameStateNew = 41;
    }

    private void PaintLevelUp(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 176, 220);
    }

    private void InitGamePass1() {
        this.frameWork.deleteCommand();
        this.frameWork.addCommand(3);
        this.counter = 0;
        this.frameWork.effect[3].reset(Constant.SPRITE_TYPE_KEY[3], 1, 88, this.rollY + 5);
    }

    private void RunningGamePass1() {
        if (this.counter < 12) {
            this.rollY -= 10;
            this.frameWork.effect[3].setXY(88, this.rollY + 3);
        } else if (this.counter == 12) {
            if (this.playMode == 3) {
                FrameWork.frameStateNew = 6;
            } else {
                this.gameStateNew = this.gamestate;
            }
        }
    }

    private void InitGamePass2() {
        this.counter = 0;
        this.gamePass();
        this.frameWork.effect[4].reset(Constant.SPRITE_TYPE_KEY[4], 1, 88, this.rollY + 5);
    }

    private void RunningGamePass2() {
        if (this.counter < 12) {
            this.rollY += 10;
            this.frameWork.effect[4].setXY(88, this.rollY + 5);
        } else {
            if (this.frameWork.bySoundLevel > 0) {
                FrameWork.sound1.soundPlay(2, -1);
            }
            this.gameState = 41;
            this.gameStateNew = 41;
        }
    }

    private void OnKeyPressedGamePass(int n) {
    }

    private void OnKeyReleasedGamePass(int n) {
    }

    private void InitGameFinished() {
    }

    private void RunningGameFinished() {
        this.gameStateNew = 51;
    }

    private void PaintGameFinished(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 176, 220);
    }

    private void OnKeyPressedGameFinished(int n) {
    }

    private void OnKeyReleasedGameFinished(int n) {
    }

    private void InitQuitInGame() {
    }

    private void RunningQuitInGame() {
        FrameWork.bGameRunning = false;
        FrameWork.frameStateNew = 0;
    }

    private void PaintQuitInGame(Graphics graphics) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 176, 220);
    }

    private void OnKeyPressedQuitInGame(int n) {
    }

    private void OnKeyReleasedQuitInGame(int n) {
    }

    private boolean checkTangram() {
        for (int i = 0; i < this.tangram[this.focus].gridy; ++i) {
            for (int j = 0; j < this.tangram[this.focus].gridx; ++j) {
                if (this.tangram[this.focus].gridMap[i][j] != 0 && this.backMap1[this.tangram[this.focus].y + i][this.tangram[this.focus].x + j] == 0) {
                    System.out.println("check false111:" + i + "," + j);
                    return false;
                }
                if (this.backMap1[this.tangram[this.focus].y + i][this.tangram[this.focus].x + j] > 1 && this.tangram[this.focus].gridMap[i][j] != 0 && this.tangram[this.focus].gridMap[i][j] + this.backMap1[this.tangram[this.focus].y + i][this.tangram[this.focus].x + j] != 6) {
                    System.out.println("check false222:" + i + "," + j);
                    return false;
                }
                if (this.tangram[this.focus].gridMap[i][j] != 0 && this.backMap2[this.tangram[this.focus].y + i][this.tangram[this.focus].x + j] == 6) {
                    System.out.println("check false333:" + i + "," + j + "," + this.tangram[this.focus].gridMap[i][j]);
                    return false;
                }
                if (this.backMap1[this.tangram[this.focus].y + i][this.tangram[this.focus].x + j] == this.backMap2[this.tangram[this.focus].y + i][this.tangram[this.focus].x + j] || this.tangram[this.focus].gridMap[i][j] == 0 || this.tangram[this.focus].gridMap[i][j] + this.backMap2[this.tangram[this.focus].y + i][this.tangram[this.focus].x + j] == 6) continue;
                System.out.println("check false 444:");
                return false;
            }
        }
        return true;
    }

    private boolean checkMap() {
        for (int i = 0; i < this.tangram[this.focus].gridy; ++i) {
            for (int j = 0; j < this.tangram[this.focus].gridx; ++j) {
                if (this.tangram[this.focus].gridMap[i][j] != 0 && this.backMap2[this.tangram[this.focus].y + i][this.tangram[this.focus].x + j] == 5) {
                    System.out.println("check false:" + i + "," + j + "," + this.tangram[this.focus].gridMap[i][j]);
                    return false;
                }
                if (this.backMap2[this.tangram[this.focus].y + i][this.tangram[this.focus].x + j] == 0 || this.tangram[this.focus].gridMap[i][j] == 0 || this.tangram[this.focus].gridMap[i][j] + this.backMap2[this.tangram[this.focus].y + i][this.tangram[this.focus].x + j] == 5) continue;
                return false;
            }
        }
        return true;
    }

    private void putUp(int n) {
        System.out.println("put up!!");
        for (int i = 0; i < this.tangram[n].gridy; ++i) {
            for (int j = 0; j < this.tangram[n].gridx; ++j) {
                if (this.backMap2[this.tangram[n].y + i][this.tangram[n].x + j] == 6 && this.tangram[n].gridMap[i][j] != 0) {
                    --this.putGrid;
                }
                byte[] byArray = this.backMap2[this.tangram[n].y + i];
                int n2 = this.tangram[n].x + j;
                byArray[n2] = (byte)(byArray[n2] - this.tangram[n].gridMap[i][j]);
            }
        }
    }

    private void putDown() {
        for (int i = 0; i < this.tangram[this.focus].gridy; ++i) {
            for (int j = 0; j < this.tangram[this.focus].gridx; ++j) {
                byte[] byArray = this.backMap2[this.tangram[this.focus].y + i];
                int n = this.tangram[this.focus].x + j;
                byArray[n] = (byte)(byArray[n] + this.tangram[this.focus].gridMap[i][j]);
                if (this.backMap2[this.tangram[this.focus].y + i][this.tangram[this.focus].x + j] != 6 || this.tangram[this.focus].gridMap[i][j] == 0) continue;
                ++this.putGrid;
            }
        }
    }

    private void paintSelect(Graphics graphics) {
        graphics.setClip(this.Cur_Cor[this.focus], 156, 7, 10);
        graphics.drawImage(this.frameWork.gameUI[1], this.Cur_Cor[this.focus], 156, 20);
    }

    public void setLevel(byte by) {
        this.level = by;
    }

    private void setEffectID(int n) {
        this.counter = 0;
        this.effectID = n;
        if (this.effectID != 0) {
            bPause = true;
        }
    }

    private boolean saveGame() {
        if (this.frameWork.levelState[this.level - 1] == 1 && this.frameWork.unfinishGate[this.Index - 1] != 1) {
            this.frameWork.unfinishGate[this.Index - 1] = 1;
            ++this.frameWork.progress;
            if (this.frameWork.progress % 10 == 0) {
                this.frameWork.levelState[this.level - 1] = 2;
                if (this.level < 10) {
                    this.frameWork.levelState[this.level] = 1;
                }
                this.frameWork.unfinishGate = new byte[10];
                this.frameWork.saveLevel();
                return true;
            }
            this.frameWork.saveLevel();
        }
        return false;
    }

    private void drawImgRoll(Graphics graphics, Image image, int n, int n2, int n3) {
        int n4 = n2 - this.counter % n3;
        graphics.drawImage(image, n, n4, 20);
        graphics.drawImage(image, n, n4 + n3, 20);
    }

    private void drawUI(Graphics graphics) {
        graphics.drawImage(this.frameWork.gameUI[5], 129, 5, 20);
        if (this.playMode == 2 && this.time < 30) {
            this.frameWork.drawPane(graphics, -(this.counter % 2) + 125, -(this.counter % 2) + 14, 35 + this.counter % 2 * 2, 7 + this.counter % 2 * 2, 8158591, 0xFF0000);
        } else {
            this.frameWork.drawPane(graphics, 125, 14, 35, 7, 8158591, 0);
        }
        graphics.drawImage(this.frameWork.gameUI[2], 8, this.rollY, 20);
        graphics.drawImage(this.frameWork.gameUI[3], 157, this.rollY, 20);
        graphics.setColor(11927538);
        int n = FrameWork.rnd.nextInt() % 2;
        graphics.drawLine(19, this.rollY + 5 + n, 156, this.rollY + 5 + n);
        n = FrameWork.rnd.nextInt() % 3;
        graphics.drawLine(19, this.rollY + 5 + n, 156, this.rollY + 5 + n);
        this.drawTime(graphics);
        graphics.setClip(0, 0, 176, 220);
        if (this.playMode != 4) {
            if (this.playMode == 2) {
                graphics.drawImage(this.frameWork.gameUI[4], 12, 6, 20);
                this.frameWork.drawPane(graphics, 18, 14, 35, 7, 16159378, 0);
            } else {
                graphics.drawImage(this.frameWork.fuhaoImg[3], 22, 6, 20);
                this.frameWork.drawPane(graphics, 18, 14, 35, 7, 8158591, 0);
            }
            if (this.playMode != 1 && this.playMode != 4) {
                graphics.drawImage(this.frameWork.gameUI[6 + this.playMode / 3], 88, 5, 17);
                this.frameWork.drawPane(graphics, 69, 14, 38, 7, 8158591, 0);
            }
            this.frameWork.drawPane(graphics, 68, 201, 40, 7, 10478662, 0);
            graphics.drawImage(this.frameWork.fuhaoImg[3], 70, 202, 20);
            this.drawMapLevel(graphics);
            if (this.playMode == 2) {
                this.drawNum(graphics, this.frameWork.numImg, 47, 15, this.hiScore, 5, 5, 0);
            } else {
                this.drawMapIndex(graphics);
            }
        }
        if (this.playMode == 3) {
            graphics.setClip(69, 14, 38, 7);
            graphics.drawImage(this.frameWork.fuhaoImg[4], 96, 15, 20);
            this.drawNum(graphics, this.frameWork.numImg, 93, 15, this.frameWork.progress, 5, 5, 1);
        } else if (this.playMode == 2) {
            this.drawScore(graphics, this.score, 102, 15);
        }
    }

    private void drawTime(Graphics graphics) {
        graphics.setColor(0xFFFFFF);
        graphics.fillRect(142, 15, 1, 1);
        graphics.fillRect(142, 18, 1, 1);
        this.drawNum(graphics, this.frameWork.numImg, 155, 15, this.time % 60, 5, 5, 1);
        if (this.time % 60 < 10) {
            this.drawNum(graphics, this.frameWork.numImg, 150, 15, 0, 5, 5, 1);
        }
        if (this.time / 60 < 10) {
            this.drawNum(graphics, this.frameWork.numImg, 136, 15, 0, 5, 5, 1);
        }
        this.drawNum(graphics, this.frameWork.numImg, 141, 15, this.time / 60, 5, 5, 1);
    }

    private void drawMapIndex(Graphics graphics) {
        graphics.setClip(18, 14, 35, 7);
        graphics.setColor(0xFFFFFF);
        graphics.drawLine(33, 17, 37, 17);
        this.drawNum(graphics, this.frameWork.numImg, 32, 15, this.level, 5, 5, 1);
        this.drawNum(graphics, this.frameWork.numImg, 48, 15, this.Index, 5, 5, 1);
    }

    private void drawMapLevel(Graphics graphics) {
        this.drawNum(graphics, this.frameWork.numImg, 108, 202, this.level, 5, 5, 0);
    }

    private void drawScore(Graphics graphics, int n, int n2, int n3) {
        this.drawNum(graphics, this.frameWork.numImg, n2, n3, n, 5, 5, 1);
    }

    public void drawNum(Graphics graphics, Image image, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 1;
        if (n3 == 0) {
            graphics.setClip(n - n4, n2, n4, n5);
            graphics.drawImage(image, n - n4, n2 - n6 * n5, 20);
            return;
        }
        int n8 = 0;
        while (n3 / n7 > 0) {
            graphics.setClip(n - (n8 + 1) * n4, n2, n4, n5);
            graphics.drawImage(image, n - (n8 + 1) * n4 - n3 / n7 % 10 * n4, n2 - n6 * n5, 20);
            n7 *= 10;
            ++n8;
        }
    }

    static {
        midX = 88;
        midY = 88;
    }
}

