/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class SpriteLibrary {
    public static final int version = 1634349568;
    private DataInputStream res;
    private String sTypeName;
    private int typeNum;
    private short[] typeName;
    private ANJ[] type;
    private int spriteImageNum;
    private String[] spriteImageName;
    private Image[] spriteImage;
    private int typeNumOld;
    private short[] typeNameOld;
    private ANJ[] typeOld;
    private int spriteImageNumOld;
    private String[] spriteImageNameOld;
    private Image[] spriteImageOld;
    private String ret_string;
    private int currentFrame;
    private int currentModule;
    private Runtime runner;
    private long freeMemory;
    private long totalMemory;

    public void reset(int n, short[] sArray) {
        this.saveOldData();
        this.typeNum = n;
        this.typeName = new short[n];
        this.type = new ANJ[n];
        this.spriteImageName = new String[n];
        for (int i = 0; i < n; ++i) {
            this.typeName[i] = sArray[i];
        }
        this.runner = Runtime.getRuntime();
        System.gc();
        this.totalMemory = this.runner.freeMemory();
        System.out.println("total:" + this.totalMemory + "B (" + (this.totalMemory >> 10) + "KB)");
        System.out.println("//===========================================//");
        System.out.println("//             ANJ Memory State              //");
        System.out.println("//===========================================//");
        this.readAnj();
        System.out.println("---------------------------------------------");
        System.gc();
        this.totalMemory -= this.runner.freeMemory();
        System.out.println("All anj files used " + this.totalMemory + "B (" + (this.totalMemory >> 10) + "KB)");
        this.totalMemory = this.runner.freeMemory();
        System.out.println();
        System.out.println("//===========================================//");
        System.out.println("//            RSP Memory State               //");
        System.out.println("//===========================================//");
        this.readResource();
        System.out.println("---------------------------------------------");
        System.gc();
        this.totalMemory -= this.runner.freeMemory();
        System.out.println("All rsp files used " + this.totalMemory + "B (" + (this.totalMemory >> 10) + "KB)");
        this.deleteOldData();
    }

    public void Close() {
        this.type = null;
        this.typeName = null;
        this.spriteImageName = null;
        this.spriteImage = null;
        System.gc();
    }

    private String readString(int n) throws Exception {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = this.res.readByte();
        }
        this.ret_string = new String(byArray, 0, n);
        return this.ret_string;
    }

    private String getTypeName(short s) {
        int n = 0;
        while (s != Constant.SPRITE_TYPE_KEY[n]) {
            if (++n != Constant.SPRITE_TYPE_KEY.length) continue;
            System.out.println("Type Key Error:" + s + " doesn't exit in type table.");
            return null;
        }
        return "effect" + (n + 1);
    }

    private int getImageIndex(String string) {
        int n = 0;
        if (this.spriteImageNum == 0) {
            this.spriteImageName[0] = string;
            ++this.spriteImageNum;
        } else {
            while (!string.equals(this.spriteImageName[n]) && ++n != this.spriteImageNum) {
            }
            if (n == this.spriteImageNum) {
                if (this.spriteImageNum == this.spriteImageName.length) {
                    String[] stringArray = this.spriteImageName;
                    this.spriteImageName = new String[stringArray.length + 1];
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.spriteImageName[i] = stringArray[i];
                    }
                    stringArray = null;
                }
                this.spriteImageName[n] = string;
                ++this.spriteImageNum;
            }
        }
        return n;
    }

    private void saveOldData() {
        this.typeNum = 0;
        this.spriteImageNum = 0;
        if (this.type == null) {
            return;
        }
        this.typeNumOld = this.typeNum;
        this.typeNameOld = this.typeName;
        this.typeOld = this.type;
        this.spriteImageNumOld = this.spriteImageNum;
        this.spriteImageNameOld = this.spriteImageName;
        this.spriteImageOld = this.spriteImage;
        this.typeName = null;
        this.type = null;
        this.spriteImageName = null;
        this.spriteImage = null;
    }

    private void deleteOldData() {
        this.typeNumOld = 0;
        this.typeNameOld = null;
        this.typeOld = null;
        this.spriteImageNumOld = 0;
        this.spriteImageNameOld = null;
        this.spriteImageOld = null;
    }

    private void readAnj() {
        int n;
        block8: for (n = 0; n < this.typeNum; ++n) {
            for (int i = 0; i < this.typeNumOld; ++i) {
                if (this.typeName[n] != this.typeNameOld[i]) continue;
                this.type[n] = this.typeOld[i];
                for (int j = 0; j < this.typeOld[i].imgNum; ++j) {
                    ((ANJ)this.type[n]).imgIndex[j] = this.getImageIndex(this.spriteImageNameOld[this.typeOld[i].imgIndex[j]]);
                }
                continue block8;
            }
        }
        this.typeOld = null;
        for (n = 0; n < this.typeNum; ++n) {
            if (this.type[n] != null) continue;
            this.type[n] = new ANJ();
            this.sTypeName = this.getTypeName(this.typeName[n]);
            try {
                this.res = new DataInputStream(this.getClass().getResourceAsStream(this.sTypeName + ".anj"));
            }
            catch (Exception exception) {
                System.out.println(this.sTypeName + ".anj not exist!");
                this.type[n] = null;
            }
            try {
                if (this.res.readInt() != 1634349568) {
                    System.out.println("Animate version error.Please update your Animate.exe to version 1.60c.");
                    return;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.gc();
            this.freeMemory = this.runner.freeMemory();
            if (this.type[n] != null) {
                try {
                    this.type[n].decode();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            System.gc();
            this.freeMemory -= this.runner.freeMemory();
            System.out.println(this.sTypeName + ".anj used " + this.freeMemory + "B (" + (this.freeMemory >> 10) + "KB)");
            try {
                this.res.close();
                this.res = null;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void readResource() {
        int n;
        Resource resource = new Resource();
        this.spriteImage = new Image[this.spriteImageNum];
        block0: for (n = 0; n < this.spriteImageNum; ++n) {
            for (int i = 0; i < this.spriteImageNumOld; ++i) {
                if (!this.spriteImageName[n].equals(this.spriteImageNameOld[i])) continue;
                this.spriteImage[n] = this.spriteImageOld[i];
                continue block0;
            }
        }
        this.spriteImageOld = null;
        for (n = 0; n < this.spriteImageNum; ++n) {
            if (this.spriteImage[n] != null) continue;
            System.gc();
            this.freeMemory = this.runner.freeMemory();
            this.spriteImage[n] = resource.getImage(this.spriteImageName[n]);
            System.gc();
            this.freeMemory -= this.runner.freeMemory();
            System.out.println(this.spriteImageName[n] + " used " + this.freeMemory + "B (" + (this.freeMemory >> 10) + "KB)");
        }
        resource = null;
    }

    public int searchTypeIndex(short s) {
        int n = 0;
        while (s != this.typeName[n]) {
            if (++n != this.typeNum) continue;
            System.out.println("Resource Type " + s + " haven't load.");
            return 0;
        }
        return n;
    }

    public int searchActionIndex(int n, int n2) {
        int n3 = 0;
        if (this.type[n] == null) {
            System.out.println(" -- typeIndex:" + n);
        }
        System.out.println(" -- type[typeIndex] not null:" + n);
        System.out.println(this.type[n].ActionIndex[n3] + " -- actionName:" + n2);
        while (n2 != this.type[n].ActionIndex[n3]) {
            if (++n3 != this.type[n].ActionNum) continue;
            System.out.println("Action " + n2 + " not found in " + this.getTypeName(this.typeName[n]));
            return 0;
        }
        return n3;
    }

    public int getFrameNumber(int n, int n2) {
        return this.type[n].FrameUsed[n2];
    }

    public int getRegionID(int n, int n2, int n3, int n4) {
        if (this.type[n].RegionNum[this.type[n].FrameIndex[n2][n3]] == 0) {
            return -1;
        }
        byte by = 0;
        while (n4 != this.type[n].RegionID[this.type[n].FrameIndex[n2][n3]][by]) {
            if (++by != this.type[n].RegionNum[this.type[n].FrameIndex[n2][n3]]) continue;
            return -1;
        }
        return by;
    }

    public byte getRegionX(int n, int n2, int n3, int n4) {
        return this.type[n].RegionX[this.type[n].FrameIndex[n2][n3]][n4];
    }

    public byte getRegionY(int n, int n2, int n3, int n4) {
        return this.type[n].RegionY[this.type[n].FrameIndex[n2][n3]][n4];
    }

    public byte getRegionW(int n, int n2, int n3, int n4) {
        return this.type[n].RegionW[this.type[n].FrameIndex[n2][n3]][n4];
    }

    public byte getRegionH(int n, int n2, int n3, int n4) {
        return this.type[n].RegionH[this.type[n].FrameIndex[n2][n3]][n4];
    }

    public short getCurrentFrame(int n, int n2, int n3) {
        short s;
        for (s = 0; s < this.type[n].FrameUsed[n2]; s = (short)(s + 1)) {
            if (n3 >= this.type[n].FrameStamp[n2][s]) {
                continue;
            }
            return (short)(s - 1);
        }
        return (short)(s - 1);
    }

    public void PaintSprite(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        if (n5 >= this.type[n3].FrameUsed[n4]) {
            System.out.println("Action Frame Overflow:");
            System.out.println("type: " + this.getTypeName(this.typeName[n3]));
            System.out.println("action: " + this.type[n3].ActionIndex[n4]);
            System.out.println("frame state: " + (n5 + 1) + "/" + this.type[n3].FrameUsed[n4]);
            n5 = 0;
        }
        this.currentFrame = this.type[n3].FrameIndex[n4][n5];
        for (int i = 0; i < this.type[n3].ModuleUsed[this.currentFrame]; ++i) {
            this.currentModule = this.type[n3].ModuleIndex[this.currentFrame][i];
            if (this.spriteImage[this.type[n3].imgIndex[this.type[n3].ModuleImage[this.currentModule]]] == null) continue;
            graphics.setClip(n + this.type[n3].CenterX[this.currentFrame] + this.type[n3].ModuleExcX[this.currentFrame][i], n2 + this.type[n3].CenterY[this.currentFrame] + this.type[n3].ModuleExcY[this.currentFrame][i], (int)this.type[n3].ModuleW[this.currentModule], (int)this.type[n3].ModuleH[this.currentModule]);
            graphics.drawImage(this.spriteImage[this.type[n3].imgIndex[this.type[n3].ModuleImage[this.currentModule]]], n + this.type[n3].CenterX[this.currentFrame] + this.type[n3].ModuleExcX[this.currentFrame][i] - this.type[n3].ModuleX[this.currentModule], n2 + this.type[n3].CenterY[this.currentFrame] + this.type[n3].ModuleExcY[this.currentFrame][i] - this.type[n3].ModuleY[this.currentModule], 20);
        }
    }

    public void loadResource() {
        Resource resource = new Resource();
        this.spriteImage = new Image[this.spriteImageNum];
        for (int i = 0; i < this.spriteImageNum; ++i) {
            this.spriteImage[i] = resource.getImage(this.spriteImageName[i]);
        }
        resource = null;
    }

    public void deleteResource() {
        for (int i = 0; i < this.spriteImageNum; ++i) {
            this.spriteImage[i] = null;
        }
    }

    private final class ANJ {
        private byte imgNum;
        private int[] imgIndex;
        private short ModuleNum;
        private byte[] ModuleImage;
        private short[] ModuleX;
        private short[] ModuleY;
        private short[] ModuleW;
        private short[] ModuleH;
        private short FrameNum;
        private byte[] CenterX;
        private byte[] CenterY;
        private byte[] ModuleUsed;
        private byte[][] ModuleIndex;
        private byte[][] ModuleExcX;
        private byte[][] ModuleExcY;
        private byte[][] ModuleAffine;
        private byte[] RegionNum;
        private byte[][] RegionID;
        private byte[][] RegionX;
        private byte[][] RegionY;
        private byte[][] RegionW;
        private byte[][] RegionH;
        private int ActionNum;
        private short[] ActionIndex;
        private short[] FrameUsed;
        private short[][] FrameStamp;
        private short[][] FrameIndex;

        private ANJ() {
        }

        private void decode() {
            try {
                int n;
                int n2;
                this.imgNum = SpriteLibrary.this.res.readByte();
                this.imgIndex = new int[this.imgNum];
                for (n2 = 0; n2 < this.imgNum; ++n2) {
                    this.imgIndex[n2] = SpriteLibrary.this.getImageIndex(SpriteLibrary.this.readString(SpriteLibrary.this.res.readShort() - 3));
                }
                this.ModuleNum = (short)SpriteLibrary.this.res.readUnsignedByte();
                this.ModuleImage = new byte[this.ModuleNum];
                this.ModuleX = new short[this.ModuleNum];
                this.ModuleY = new short[this.ModuleNum];
                this.ModuleW = new short[this.ModuleNum];
                this.ModuleH = new short[this.ModuleNum];
                for (n2 = 0; n2 < this.ModuleNum; ++n2) {
                    this.ModuleImage[n2] = SpriteLibrary.this.res.readByte();
                    this.ModuleX[n2] = (short)SpriteLibrary.this.res.readUnsignedByte();
                    this.ModuleY[n2] = (short)SpriteLibrary.this.res.readUnsignedByte();
                    this.ModuleW[n2] = (short)SpriteLibrary.this.res.readUnsignedByte();
                    this.ModuleH[n2] = (short)SpriteLibrary.this.res.readUnsignedByte();
                }
                this.FrameNum = SpriteLibrary.this.res.readShort();
                this.CenterX = new byte[this.FrameNum];
                this.CenterY = new byte[this.FrameNum];
                this.RegionNum = new byte[this.FrameNum];
                this.RegionID = new byte[this.FrameNum][];
                this.RegionX = new byte[this.FrameNum][];
                this.RegionY = new byte[this.FrameNum][];
                this.RegionW = new byte[this.FrameNum][];
                this.RegionH = new byte[this.FrameNum][];
                this.ModuleUsed = new byte[this.FrameNum];
                this.ModuleIndex = new byte[this.FrameNum][];
                this.ModuleExcX = new byte[this.FrameNum][];
                this.ModuleExcY = new byte[this.FrameNum][];
                this.ModuleAffine = new byte[this.FrameNum][];
                for (n2 = 0; n2 < this.FrameNum; ++n2) {
                    this.CenterX[n2] = SpriteLibrary.this.res.readByte();
                    this.CenterY[n2] = SpriteLibrary.this.res.readByte();
                    this.RegionNum[n2] = SpriteLibrary.this.res.readByte();
                    if (this.RegionNum[n2] > 0) {
                        this.RegionID[n2] = new byte[this.RegionNum[n2]];
                        this.RegionX[n2] = new byte[this.RegionNum[n2]];
                        this.RegionY[n2] = new byte[this.RegionNum[n2]];
                        this.RegionW[n2] = new byte[this.RegionNum[n2]];
                        this.RegionH[n2] = new byte[this.RegionNum[n2]];
                        for (n = 0; n < this.RegionNum[n2]; ++n) {
                            this.RegionID[n2][n] = SpriteLibrary.this.res.readByte();
                            this.RegionX[n2][n] = SpriteLibrary.this.res.readByte();
                            this.RegionY[n2][n] = SpriteLibrary.this.res.readByte();
                            this.RegionW[n2][n] = SpriteLibrary.this.res.readByte();
                            this.RegionH[n2][n] = SpriteLibrary.this.res.readByte();
                        }
                    }
                    this.ModuleUsed[n2] = SpriteLibrary.this.res.readByte();
                    this.ModuleIndex[n2] = new byte[this.ModuleUsed[n2]];
                    this.ModuleExcX[n2] = new byte[this.ModuleUsed[n2]];
                    this.ModuleExcY[n2] = new byte[this.ModuleUsed[n2]];
                    this.ModuleAffine[n2] = new byte[this.ModuleUsed[n2]];
                    for (n = 0; n < this.ModuleUsed[n2]; ++n) {
                        this.ModuleIndex[n2][n] = SpriteLibrary.this.res.readByte();
                        this.ModuleExcX[n2][n] = SpriteLibrary.this.res.readByte();
                        this.ModuleExcY[n2][n] = SpriteLibrary.this.res.readByte();
                        this.ModuleAffine[n2][n] = SpriteLibrary.this.res.readByte();
                    }
                }
                this.ActionNum = SpriteLibrary.this.res.readByte();
                this.ActionIndex = new short[this.ActionNum];
                this.FrameUsed = new short[this.ActionNum];
                this.FrameStamp = new short[this.ActionNum][];
                this.FrameIndex = new short[this.ActionNum][];
                for (n2 = 0; n2 < this.ActionNum; ++n2) {
                    this.ActionIndex[n2] = SpriteLibrary.this.res.readShort();
                    this.FrameUsed[n2] = SpriteLibrary.this.res.readShort();
                    this.FrameStamp[n2] = new short[this.FrameUsed[n2]];
                    this.FrameIndex[n2] = new short[this.FrameUsed[n2]];
                    for (n = 0; n < this.FrameUsed[n2]; ++n) {
                        this.FrameStamp[n2][n] = SpriteLibrary.this.res.readShort();
                        this.FrameIndex[n2][n] = SpriteLibrary.this.res.readShort();
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

