/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Game {
    private int cheat_number = 0;
    public boolean isGameCompetedByCheat = true;
    private World world;
    private static final byte STATE_GAME = 10;
    private static final byte STATE_PAUSE = 11;
    private static final byte STATE_FINISHED = 12;
    private static final byte STATE_LEVEL_COMPLETE = 13;
    private static final byte STATE_VIEW_GIRL = 14;
    private byte gameState;
    private boolean isGameOver;
    private boolean isGameFinished;
    private int levelCompliteCounter;
    private Image imgPrize;
    private Image gradient;
    private int numKey = 0;
    private int counter;
    private int posBeg;
    private int posEnd;

    public Game(byte[] parameters) {
        this.world = new World(parameters[1]);
        try {
            this.gradient = Image.createImage((String)"/skin/gradient.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.gameState = (byte)10;
    }

    public void deleteGame() {
        this.world = null;
    }

    public void load(DataInputStream dis) {
        this.world.load(dis);
    }

    public void save(DataOutputStream dos) {
        this.world.save(dos);
    }

    public void draw(Graphics g) {
        this.world.draw(g);
        if (this.gameState == 10) {
            GameCanvas.drawSoftkeys(0, 17);
            return;
        }
        int str = 0;
        if (this.gameState == 13 || this.gameState == 11) {
            if (this.gameState == 11) {
                GameCanvas.drawSoftkeys(15, this.gameState == 13 ? 3 : 16);
            }
            str = this.gameState == 13 ? 32 : 17;
            GraphicFont.prepareWrapText(str, 2, Skin.gameFieldW - 4);
            GraphicFont.drawWrapedText(Skin.gameFieldX + Skin.gameFieldW / 2, GameCanvas.HEIGHT / 2 - 0, false, 2, 0);
            if (this.gameState == 13) {
                GraphicFont.prepareWrapText(38, 2, Skin.gameFieldW - 4);
                GraphicFont.drawWrapedText(Skin.gameFieldX + Skin.gameFieldW / 2, Skin.gameFieldY + Skin.gameFieldH / 2 - GraphicFont.textHeight(2) / 2 + 5 + GraphicFont.textHeight(2) * 2 - 0, false, 2, 0);
            }
        }
        if (this.gameState == 14 && this.levelCompliteCounter <= 0) {
            g.setColor(0);
            g.fillRect(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
            this.drawPrizeWithAnimation(g);
            GameCanvas.drawSoftkeys(15, this.gameState == 13 ? 3 : 31);
            if (this.posBeg <= this.posEnd) {
                this.counter += 2;
            }
            return;
        }
        if (this.gameState == 12) {
            str = this.isGameOver ? 34 : 33;
            int str1 = this.isGameOver ? 26 : 25;
            int y = Skin.gameFieldY + Skin.gameFieldH / 2 - 0;
            GameCanvas.drawSoftkeys(15, 2);
            g.setColor(0);
            g.fillRect(0, y - 5, GameCanvas.WIDTH, 2 * PortingConst.LABEL_FONT_HEIGHT);
            GraphicFont.prepareWrapText(str, 2, GameCanvas.WIDTH - 3);
            GraphicFont.drawWrapedText(Skin.gameFieldX + Skin.gameFieldW / 2, y, true, 2, 0);
            GraphicFont.prepareWrapText(str1, 2, GameCanvas.WIDTH - 3);
            GraphicFont.drawWrapedText(Skin.gameFieldX + Skin.gameFieldW / 2, y + GraphicFont.textHeight(2), true, 2, 0);
        }
    }

    public void process() {
        if (this.world != null) {
            this.world.process();
            if (this.gameState != 13 || this.levelCompliteCounter > 0) {
                // empty if block
            }
            if (this.gameState != 10) {
                return;
            }
            if (this.world.isGameOver()) {
                this.gameState = (byte)12;
                Settings.addScore(this.world.allScores, Settings.currentGameType);
                Settings.setMaxLevel(this.world.gameLevel);
                this.isGameOver = true;
                this.isGameFinished = true;
            }
            if (this.world.isLevelComplite()) {
                if (this.world.isGameComplite()) {
                    this.gameState = (byte)12;
                    this.isGameFinished = true;
                    Settings.addScore(this.world.allScores, Settings.currentGameType);
                } else {
                    this.gameState = (byte)13;
                    Settings.setMaxLevel(this.world.gameLevel + 1);
                    this.levelCompliteCounter = 10;
                    Settings.isGameHasContinue = false;
                }
            }
        }
    }

    public boolean isGameFinished() {
        return this.isGameFinished;
    }

    public int processKey(int keyCode, int gameAction, boolean isPressed) {
        switch (this.gameState) {
            case 10: {
                if ((gameAction == 2 || keyCode == 52) && keyCode != -6) {
                    this.world.Left(isPressed);
                }
                if ((gameAction == 5 || keyCode == 54) && keyCode != -7) {
                    this.world.Right(isPressed);
                }
                if ((gameAction == 1 || keyCode == 50) && isPressed) {
                    this.world.Up();
                }
                if ((gameAction == 6 || keyCode == 56) && isPressed) {
                    this.world.Down();
                }
                if (!isPressed) {
                    return 0;
                }
                if (keyCode == -7) {
                    this.pause();
                }
                if (keyCode == 42) {
                    this.cheat_number = this.cheat_number == 2 ? 3 : 1;
                }
                if (keyCode == 48) {
                    this.cheat_number = this.cheat_number == 3 ? 4 : 2;
                }
                if (keyCode != 35 || this.cheat_number < 4) break;
                ++this.cheat_number;
                if (this.cheat_number != 7) break;
                this.cheat_number = 0;
                this.world.allScores += 250;
                break;
            }
            case 13: {
                if (keyCode == 0) break;
                ++this.numKey;
                if (this.numKey != 2) break;
                try {
                    this.levelCompliteCounter = 0;
                    this.imgPrize = Image.createImage((String)("/picture/girl" + this.world.gameLevel + ".png"));
                    this.gameState = (byte)14;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                break;
            }
            case 14: {
                if (keyCode == -6) {
                    Settings.addScore(this.world.allScores, 0);
                    return 1;
                }
                if (keyCode != 0) {
                    ++this.numKey;
                }
                if (keyCode != -7) break;
                this.world.restart();
                Settings.isGameHasContinue = true;
                this.gameState = (byte)10;
                this.counter = 0;
                this.numKey = 0;
                System.gc();
                break;
            }
            case 11: {
                if (!isPressed) {
                    return 0;
                }
                if (keyCode == -7) {
                    this.resume();
                }
                if (keyCode != -6) break;
                return 1;
            }
            case 12: {
                if (!isPressed) {
                    return 0;
                }
                if (keyCode == -7) {
                    return 3;
                }
                if (keyCode != -6) break;
                return 1;
            }
        }
        return 0;
    }

    public void pause() {
        if (this.gameState != 10) {
            return;
        }
        this.world.pause();
        this.gameState = (byte)11;
    }

    public void resume() {
        if (this.gameState != 11) {
            return;
        }
        this.world.resume();
        this.gameState = (byte)(this.world.isGameComplite() || this.world.isGameOver() ? 12 : 10);
    }

    private void drawPrizeWithAnimation(Graphics g) {
        int linesInSplashAnimation = 8;
        int delay = 20;
        this.posBeg = GameCanvas.HEIGHT / 2 - this.imgPrize.getHeight() / 2 + (this.counter - 2) * linesInSplashAnimation - delay;
        this.posEnd = this.posBeg + this.imgPrize.getHeight();
        if (this.posBeg <= this.posEnd) {
            g.setClip(0, 0, GameCanvas.WIDTH, this.posBeg);
            g.drawImage(this.imgPrize, GameCanvas.WIDTH / 2, GameCanvas.HEIGHT / 2, 3);
            g.drawImage(this.gradient, GameCanvas.WIDTH / 2, this.posBeg, 33);
        }
    }
}

