/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class Chicktris
extends MIDlet {
    public Display display;
    private GameCanvas canvas;
    public static final String RS_NAME = "Chicktris";
    public static Chicktris instance;
    public static final int STR_NONE = 0;
    public static final int STR_NEWGAME = 2;
    public static final int STR_CONTINUE = 3;
    public static final int STR_LEVEL = 4;
    public static final int STR_ABOUT = 5;
    public static final int STR_HISCORES = 6;
    public static final int STR_SETTINGS = 7;
    public static final int STR_HELP = 8;
    public static final int STR_LASTGAME = 9;
    public static final int STR_HELPTEXT = 10;
    public static final int STR_ABOUTTEXT = 11;
    public static final int STR_EXIT = 12;
    public static final int STR_SELECT = 13;
    public static final int STR_BACK = 14;
    public static final int STR_MENU = 15;
    public static final int STR_RESUME = 16;
    public static final int STR_PAUSE = 17;
    public static final int STR_DONE = 18;
    public static final int STR_YES = 19;
    public static final int STR_NO = 20;
    public static final int STR_CHANGE = 21;
    public static final int STR_ON = 22;
    public static final int STR_OFF = 23;
    public static final int STR_RESET = 24;
    public static final int STR_CONGRATULATIONS = 25;
    public static final int STR_TRYAGAIN = 26;
    public static final int STR_YOURSCOREIS = 27;
    public static final int STR_SOUNDTEXT = 28;
    public static final int STR_LOADING = 29;
    public static final int STR_SCORES = 30;
    public static final int STR_NEXT = 31;
    public static final int STR_LEVELCOMPLETE = 32;
    public static final int STR_GAMECOMPLETE = 33;
    public static final int STR_GAMEOVER = 34;
    public static final int STR_LINES = 35;
    public static final int STR_RESETHITEXT = 36;
    public static final int STR_EXITTEXT = 37;
    public static final int STR_PRESSANYKEY = 38;
    public static final int STR_SOUND = 39;
    public static final int STR_LANG = 40;

    public Chicktris() {
        instance = this;
    }

    public final void startApp() throws MIDletStateChangeException {
        if (this.canvas == null) {
            this.display = Display.getDisplay((MIDlet)this);
            this.canvas = new GameCanvas(this.display, this);
            this.display.setCurrent((Displayable)this.canvas);
        }
        this.canvas.deviceStart();
    }

    public final void pauseApp() {
        this.canvas.devicePause();
    }

    public final void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        this.canvas.saveDataBeforeExit();
        this.notifyDestroyed();
    }

    public static void loadLanguages() {
        try {
            InputStream inputStreamTxt = ((Object)((Object)instance)).getClass().getResourceAsStream("/textes/LANG.txt");
            Vector lines = Chicktris.loadTexts(inputStreamTxt);
            GraphicFont.LANGUAGE_COUNT = (byte)(lines.size() - 3);
            String[] lang = new String[GraphicFont.LANGUAGE_COUNT];
            for (int i = 3; i < lines.size(); ++i) {
                lang[i - 3] = lines.elementAt(i).toString();
            }
            GraphicFont.shortLang = lang;
            Object[] s = new String[lines.capacity()];
            lines.copyInto(s);
            GraphicFont._TextsStr = s;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        GraphicFont.initTextLanguages(GraphicFont.LANGUAGE_COUNT);
        GraphicFont.setClip(0, 0, GameCanvas.WIDTH, GameCanvas.HEIGHT);
    }

    public static void loadLanguage(String path) {
        try {
            Vector lines = Chicktris.loadTexts(((Object)((Object)instance)).getClass().getResourceAsStream(path));
            Object[] s = new String[lines.capacity()];
            lines.copyInto(s);
            GraphicFont._TextsStr = s;
            System.gc();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static final void setLanguage(int language) {
        GraphicFont.currentLanguage = (byte)language;
        Chicktris.loadLanguage("/textes/" + GraphicFont.shortLang[language].substring(0, 2) + ".txt");
        Settings.optionsLanguage = language;
        System.gc();
    }

    private static Vector loadTexts(InputStream inputStreamTxt) throws IOException {
        int c;
        StringBuffer buf = new StringBuffer();
        Vector<String> lines = new Vector<String>();
        lines.addElement("");
        lines.addElement(" ");
        while ((c = inputStreamTxt.read()) != -1) {
            char ch = (char)c;
            if (ch == '\n') {
                if ((buf = buf.delete(buf.length() - 1, buf.length())).charAt(0) != '/') {
                    lines.addElement(buf.toString());
                }
                buf.delete(0, buf.length());
                continue;
            }
            buf.append(ch);
        }
        inputStreamTxt.close();
        return lines;
    }
}

