/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Field {
    public boolean[][] gameField;
    private boolean[][] gameField1;
    private boolean[][] gameField2;
    public byte[][] imageField;
    private byte[][] imageField1;
    private byte[][] imageField2;
    public byte[][] kindImageField;
    private byte[][] kindImageField1;
    private byte[][] kindImageField2;
    private Image[][] blocksImages;
    private Image fadeBlockImages;
    private byte[] rowFade = new byte[15];
    public byte rowFadeNum;

    public Field() {
        this.blocksImages = Settings.getBlockImages(0);
        this.fadeBlockImages = Settings.getFadeBlocks();
        this.clearFields();
    }

    private boolean isRowFull(int index) {
        boolean result = false;
        for (int i = 0; i < this.rowFadeNum; ++i) {
            boolean bl = result = index == this.rowFade[i];
            if (!result) continue;
            return result;
        }
        return result;
    }

    private int minimalY(int x, int y) {
        for (int i = y; i < 15; ++i) {
            if (!this.gameField[x][i]) continue;
            return i;
        }
        return 15;
    }

    private boolean rowFull(int j) {
        for (int i = 0; i < 12; ++i) {
            if (this.gameField[i][j]) continue;
            return false;
        }
        return true;
    }

    public void draw(Graphics g) {
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < 15; ++j) {
                if (!this.gameField[i][j]) continue;
                g.drawImage(this.blocksImages[this.imageField[i][j]][this.kindImageField[i][j]], World.xLToR(i), World.yLToR(j), 20);
            }
        }
    }

    public void draw(Graphics g, int counter) {
        for (int j = 0; j < 15; ++j) {
            for (int i = 0; i < 12; ++i) {
                if (this.isRowFull(j)) {
                    this.drawFadeImage(g, World.xLToR(i), World.yLToR(j), 12 / counter >= 6 ? 5 : 12 / counter);
                    continue;
                }
                if (!this.gameField[i][j]) continue;
                g.drawImage(this.blocksImages[this.imageField[i][j]][this.kindImageField[i][j]], World.xLToR(i), World.yLToR(j), 20);
            }
        }
    }

    private void drawFadeImage(Graphics g, int x, int y, int i) {
        g.setClip(x, y, 10, 10);
        g.drawImage(this.fadeBlockImages, x - i * 10, y, 20);
        g.setClip(0, 0, 240, 320);
    }

    public void clearFields() {
        this.gameField = null;
        this.imageField = null;
        this.kindImageField = null;
        this.gameField1 = null;
        this.imageField1 = null;
        this.kindImageField1 = null;
        this.gameField1 = new boolean[12][15];
        this.imageField1 = new byte[12][15];
        this.kindImageField1 = new byte[12][15];
        this.gameField = this.gameField1;
        this.imageField = this.imageField1;
        this.kindImageField = this.kindImageField1;
    }

    public boolean isReplaceFields() {
        boolean res = false;
        for (int i = 0; i < 15; i = (int)((byte)(i + 1))) {
            if (!this.rowFull(i)) continue;
            res = true;
            byte by = this.rowFadeNum;
            this.rowFadeNum = (byte)(by + 1);
            this.rowFade[by] = i;
        }
        return res;
    }

    public void replaceFields() {
        byte[][] tmpKIF;
        byte[][] tmpIF;
        boolean[][] tmpGF;
        this.rowFadeNum = 0;
        if (this.gameField == this.gameField1) {
            tmpGF = this.gameField2 = new boolean[12][15];
            tmpIF = this.imageField2 = new byte[12][15];
            tmpKIF = this.kindImageField2 = new byte[12][15];
        } else {
            this.gameField1 = new boolean[12][15];
            tmpGF = this.gameField1;
            this.imageField1 = new byte[12][15];
            tmpIF = this.imageField1;
            this.kindImageField1 = new byte[12][15];
            tmpKIF = this.kindImageField1;
        }
        int j = 14;
        for (int i = 14; i >= 0; --i) {
            if (this.rowFull(i)) continue;
            for (int k = 0; k < 12; ++k) {
                tmpGF[k][j] = this.gameField[k][i];
                tmpIF[k][j] = this.imageField[k][i];
                tmpKIF[k][j] = this.kindImageField[k][i];
            }
            --j;
        }
        if (this.gameField == this.gameField1) {
            this.gameField1 = null;
            this.gameField = this.gameField2;
            this.imageField1 = null;
            this.imageField = this.imageField2;
            this.kindImageField1 = null;
            this.kindImageField = this.kindImageField2;
        } else {
            this.gameField2 = null;
            this.gameField = this.gameField1;
            this.imageField2 = null;
            this.imageField = this.imageField1;
            this.kindImageField2 = null;
            this.kindImageField = this.kindImageField1;
        }
    }

    public int downMove(Figure figure) {
        byte currKind = figure.kind;
        byte currPos = figure.pos;
        byte cX = figure.currLogX;
        byte cY = figure.currLogY;
        switch (currKind) {
            case 0: {
                return Math.min(this.minimalY(cX, cY), this.minimalY(cX + 1, cY)) - 2;
            }
            case 1: {
                if (currPos == 0) {
                    return this.minimalY(cX, cY) - 4;
                }
                if (currPos != 1) break;
                return Math.min(Math.min(this.minimalY(cX, cY), this.minimalY(cX + 1, cY)), Math.min(this.minimalY(cX + 2, cY), this.minimalY(cX + 3, cY))) - 1;
            }
            case 2: {
                if (currPos == 0) {
                    return Math.min(Math.min(this.minimalY(cX, cY + 1), this.minimalY(cX - 1, cY + 1)), this.minimalY(cX + 1, cY + 1)) - 2;
                }
                if (currPos == 1) {
                    return Math.min(this.minimalY(cX, cY), this.minimalY(cX - 1, cY + 1) + 1) - 3;
                }
                if (currPos == 2) {
                    return Math.min(Math.min(this.minimalY(cX, cY) + 1, this.minimalY(cX + 2, cY) + 1), this.minimalY(cX + 1, cY)) - 2;
                }
                if (currPos != 3) break;
                return Math.min(this.minimalY(cX, cY), this.minimalY(cX + 1, cY + 1) + 1) - 3;
            }
            case 3: {
                if (currPos == 0) {
                    return Math.min(Math.min(this.minimalY(cX + 1, cY + 1), this.minimalY(cX + 2, cY + 1)), this.minimalY(cX, cY) + 1) - 2;
                }
                if (currPos != 1) break;
                return Math.min(this.minimalY(cX, cY) + 1, this.minimalY(cX - 1, cY + 1)) - 3;
            }
            case 4: {
                if (currPos == 0) {
                    return Math.min(Math.min(this.minimalY(cX - 1, cY + 1), this.minimalY(cX, cY + 1)), this.minimalY(cX + 1, cY) + 1) - 2;
                }
                if (currPos != 1) break;
                return Math.min(this.minimalY(cX, cY) + 1, this.minimalY(cX + 1, cY + 1)) - 3;
            }
            case 5: {
                if (currPos == 0) {
                    return Math.min(this.minimalY(cX, cY), this.minimalY(cX - 1, cY + 2)) - 3;
                }
                if (currPos == 1) {
                    return Math.min(Math.min(this.minimalY(cX, cY), this.minimalY(cX + 1, cY)) + 1, this.minimalY(cX + 2, cY + 1)) - 2;
                }
                if (currPos == 2) {
                    return Math.min(this.minimalY(cX, cY), this.minimalY(cX + 1, cY) + 2) - 3;
                }
                if (currPos != 3) break;
                return Math.min(Math.min(this.minimalY(cX, cY), this.minimalY(cX + 1, cY)), this.minimalY(cX + 2, cY + 1)) - 2;
            }
            case 6: {
                if (currPos == 0) {
                    return Math.min(this.minimalY(cX, cY), this.minimalY(cX + 1, cY + 2)) - 3;
                }
                if (currPos == 1) {
                    return Math.min(Math.min(this.minimalY(cX - 2, cY), this.minimalY(cX - 1, cY)), this.minimalY(cX, cY)) - 2;
                }
                if (currPos == 2) {
                    return Math.min(this.minimalY(cX, cY) + 2, this.minimalY(cX + 1, cY)) - 3;
                }
                if (currPos != 3) break;
                return Math.min(Math.min(this.minimalY(cX + 2, cY), this.minimalY(cX + 1, cY)) + 1, this.minimalY(cX, cY + 1)) - 2;
            }
        }
        return -1;
    }

    public void setToLogicalField(Figure figure) {
        byte currKind = figure.kind;
        byte currPos = figure.pos;
        byte cX = figure.currLogX;
        byte cY = figure.currLogY;
        switch (currKind) {
            case 0: {
                this.gameField[cX][cY] = true;
                this.gameField[cX + 1][cY] = true;
                this.gameField[cX][cY + 1] = true;
                this.gameField[cX + 1][cY + 1] = true;
                break;
            }
            case 1: {
                if (currPos == 0) {
                    this.gameField[cX][cY] = true;
                    this.gameField[cX][cY + 1] = true;
                    this.gameField[cX][cY + 2] = true;
                    this.gameField[cX][cY + 3] = true;
                    break;
                }
                if (currPos != 1) break;
                this.gameField[cX][cY] = true;
                this.gameField[cX + 1][cY] = true;
                this.gameField[cX + 2][cY] = true;
                this.gameField[cX + 3][cY] = true;
                break;
            }
            case 2: {
                if (currPos == 0) {
                    this.gameField[cX][cY] = true;
                    this.gameField[cX][cY + 1] = true;
                    this.gameField[cX - 1][cY + 1] = true;
                    this.gameField[cX + 1][cY + 1] = true;
                    break;
                }
                if (currPos == 1) {
                    this.gameField[cX][cY] = true;
                    this.gameField[cX][cY + 1] = true;
                    this.gameField[cX][cY + 2] = true;
                    this.gameField[cX - 1][cY + 1] = true;
                    break;
                }
                if (currPos == 2) {
                    this.gameField[cX][cY] = true;
                    this.gameField[cX + 1][cY] = true;
                    this.gameField[cX + 2][cY] = true;
                    this.gameField[cX + 1][cY + 1] = true;
                    break;
                }
                if (currPos != 3) break;
                this.gameField[cX][cY] = true;
                this.gameField[cX][cY + 1] = true;
                this.gameField[cX][cY + 2] = true;
                this.gameField[cX + 1][cY + 1] = true;
                break;
            }
            case 3: {
                if (currPos == 0) {
                    this.gameField[cX][cY] = true;
                    this.gameField[cX + 1][cY] = true;
                    this.gameField[cX + 1][cY + 1] = true;
                    this.gameField[cX + 2][cY + 1] = true;
                    break;
                }
                if (currPos != 1) break;
                this.gameField[cX][cY] = true;
                this.gameField[cX][cY + 1] = true;
                this.gameField[cX - 1][cY + 1] = true;
                this.gameField[cX - 1][cY + 2] = true;
                break;
            }
            case 4: {
                if (currPos == 0) {
                    this.gameField[cX][cY] = true;
                    this.gameField[cX + 1][cY] = true;
                    this.gameField[cX][cY + 1] = true;
                    this.gameField[cX - 1][cY + 1] = true;
                    break;
                }
                if (currPos != 1) break;
                this.gameField[cX][cY] = true;
                this.gameField[cX][cY + 1] = true;
                this.gameField[cX + 1][cY + 1] = true;
                this.gameField[cX + 1][cY + 2] = true;
                break;
            }
            case 5: {
                if (currPos == 0) {
                    this.gameField[cX][cY] = true;
                    this.gameField[cX][cY + 1] = true;
                    this.gameField[cX][cY + 2] = true;
                    this.gameField[cX - 1][cY + 2] = true;
                    break;
                }
                if (currPos == 1) {
                    this.gameField[cX][cY] = true;
                    this.gameField[cX + 1][cY] = true;
                    this.gameField[cX + 2][cY] = true;
                    this.gameField[cX + 2][cY + 1] = true;
                    break;
                }
                if (currPos == 2) {
                    this.gameField[cX][cY] = true;
                    this.gameField[cX][cY + 1] = true;
                    this.gameField[cX][cY + 2] = true;
                    this.gameField[cX + 1][cY] = true;
                    break;
                }
                if (currPos != 3) break;
                this.gameField[cX][cY] = true;
                this.gameField[cX][cY + 1] = true;
                this.gameField[cX + 1][cY + 1] = true;
                this.gameField[cX + 2][cY + 1] = true;
                break;
            }
            case 6: {
                if (currPos == 0) {
                    this.gameField[cX][cY] = true;
                    this.gameField[cX][cY + 1] = true;
                    this.gameField[cX][cY + 2] = true;
                    this.gameField[cX + 1][cY + 2] = true;
                    break;
                }
                if (currPos == 1) {
                    this.gameField[cX][cY] = true;
                    this.gameField[cX][cY + 1] = true;
                    this.gameField[cX - 1][cY + 1] = true;
                    this.gameField[cX - 2][cY + 1] = true;
                    break;
                }
                if (currPos == 2) {
                    this.gameField[cX][cY] = true;
                    this.gameField[cX + 1][cY] = true;
                    this.gameField[cX + 1][cY + 1] = true;
                    this.gameField[cX + 1][cY + 2] = true;
                    break;
                }
                if (currPos != 3) break;
                this.gameField[cX][cY] = true;
                this.gameField[cX + 1][cY] = true;
                this.gameField[cX + 2][cY] = true;
                this.gameField[cX][cY + 1] = true;
            }
        }
    }

    public void setToColorField(Figure figure) {
        byte currKind = figure.kind;
        byte currPos = figure.pos;
        byte cX = figure.currLogX;
        byte cY = figure.currLogY;
        switch (currKind) {
            case 0: {
                this.imageField[cX][cY] = currKind;
                this.imageField[cX + 1][cY] = currKind;
                this.imageField[cX][cY + 1] = currKind;
                this.imageField[cX + 1][cY + 1] = currKind;
                this.kindImageField[cX][cY] = currPos;
                this.kindImageField[cX + 1][cY] = currPos;
                this.kindImageField[cX][cY + 1] = currPos;
                this.kindImageField[cX + 1][cY + 1] = currPos;
                break;
            }
            case 1: {
                if (currPos == 0) {
                    this.imageField[cX][cY] = currKind;
                    this.imageField[cX][cY + 1] = currKind;
                    this.imageField[cX][cY + 2] = currKind;
                    this.imageField[cX][cY + 3] = currKind;
                    this.kindImageField[cX][cY] = currPos;
                    this.kindImageField[cX][cY + 1] = currPos;
                    this.kindImageField[cX][cY + 2] = currPos;
                    this.kindImageField[cX][cY + 3] = currPos;
                    break;
                }
                if (currPos != 1) break;
                this.imageField[cX][cY] = currKind;
                this.imageField[cX + 1][cY] = currKind;
                this.imageField[cX + 2][cY] = currKind;
                this.imageField[cX + 3][cY] = currKind;
                this.kindImageField[cX][cY] = currPos;
                this.kindImageField[cX + 1][cY] = currPos;
                this.kindImageField[cX + 2][cY] = currPos;
                this.kindImageField[cX + 3][cY] = currPos;
                break;
            }
            case 2: {
                if (currPos == 0) {
                    this.imageField[cX][cY] = currKind;
                    this.imageField[cX][cY + 1] = currKind;
                    this.imageField[cX - 1][cY + 1] = currKind;
                    this.imageField[cX + 1][cY + 1] = currKind;
                    this.kindImageField[cX][cY] = currPos;
                    this.kindImageField[cX][cY + 1] = currPos;
                    this.kindImageField[cX - 1][cY + 1] = currPos;
                    this.kindImageField[cX + 1][cY + 1] = currPos;
                    break;
                }
                if (currPos == 1) {
                    this.imageField[cX][cY] = currKind;
                    this.imageField[cX][cY + 1] = currKind;
                    this.imageField[cX][cY + 2] = currKind;
                    this.imageField[cX - 1][cY + 1] = currKind;
                    this.kindImageField[cX][cY] = currPos;
                    this.kindImageField[cX][cY + 1] = currPos;
                    this.kindImageField[cX][cY + 2] = currPos;
                    this.kindImageField[cX - 1][cY + 1] = currPos;
                    break;
                }
                if (currPos == 2) {
                    this.imageField[cX][cY] = currKind;
                    this.imageField[cX + 1][cY] = currKind;
                    this.imageField[cX + 2][cY] = currKind;
                    this.imageField[cX + 1][cY + 1] = currKind;
                    this.kindImageField[cX][cY] = currPos;
                    this.kindImageField[cX + 1][cY] = currPos;
                    this.kindImageField[cX + 2][cY] = currPos;
                    this.kindImageField[cX + 1][cY + 1] = currPos;
                    break;
                }
                if (currPos != 3) break;
                this.imageField[cX][cY] = currKind;
                this.imageField[cX][cY + 1] = currKind;
                this.imageField[cX][cY + 2] = currKind;
                this.imageField[cX + 1][cY + 1] = currKind;
                this.kindImageField[cX][cY] = currPos;
                this.kindImageField[cX][cY + 1] = currPos;
                this.kindImageField[cX][cY + 2] = currPos;
                this.kindImageField[cX + 1][cY + 1] = currPos;
                break;
            }
            case 3: {
                if (currPos == 0) {
                    this.imageField[cX][cY] = currKind;
                    this.imageField[cX + 1][cY] = currKind;
                    this.imageField[cX + 1][cY + 1] = currKind;
                    this.imageField[cX + 2][cY + 1] = currKind;
                    this.kindImageField[cX][cY] = currPos;
                    this.kindImageField[cX + 1][cY] = currPos;
                    this.kindImageField[cX + 1][cY + 1] = currPos;
                    this.kindImageField[cX + 2][cY + 1] = currPos;
                    break;
                }
                if (currPos != 1) break;
                this.imageField[cX][cY] = currKind;
                this.imageField[cX][cY + 1] = currKind;
                this.imageField[cX - 1][cY + 1] = currKind;
                this.imageField[cX - 1][cY + 2] = currKind;
                this.kindImageField[cX][cY] = currPos;
                this.kindImageField[cX][cY + 1] = currPos;
                this.kindImageField[cX - 1][cY + 1] = currPos;
                this.kindImageField[cX - 1][cY + 2] = currPos;
                break;
            }
            case 4: {
                if (currPos == 0) {
                    this.imageField[cX][cY] = (byte)(currKind - 1);
                    this.imageField[cX + 1][cY] = (byte)(currKind - 1);
                    this.imageField[cX][cY + 1] = (byte)(currKind - 1);
                    this.imageField[cX - 1][cY + 1] = (byte)(currKind - 1);
                    this.kindImageField[cX][cY] = currPos;
                    this.kindImageField[cX + 1][cY] = currPos;
                    this.kindImageField[cX][cY + 1] = currPos;
                    this.kindImageField[cX - 1][cY + 1] = currPos;
                    break;
                }
                if (currPos != 1) break;
                this.imageField[cX][cY] = (byte)(currKind - 1);
                this.imageField[cX][cY + 1] = (byte)(currKind - 1);
                this.imageField[cX + 1][cY + 1] = (byte)(currKind - 1);
                this.imageField[cX + 1][cY + 2] = (byte)(currKind - 1);
                this.kindImageField[cX][cY] = currPos;
                this.kindImageField[cX][cY + 1] = currPos;
                this.kindImageField[cX + 1][cY + 1] = currPos;
                this.kindImageField[cX + 1][cY + 2] = currPos;
                break;
            }
            case 5: {
                if (currPos == 0) {
                    this.imageField[cX][cY] = (byte)(currKind - 1);
                    this.imageField[cX][cY + 1] = (byte)(currKind - 1);
                    this.imageField[cX][cY + 2] = (byte)(currKind - 1);
                    this.imageField[cX - 1][cY + 2] = (byte)(currKind - 1);
                    this.kindImageField[cX][cY] = currPos;
                    this.kindImageField[cX][cY + 1] = currPos;
                    this.kindImageField[cX][cY + 2] = currPos;
                    this.kindImageField[cX - 1][cY + 2] = currPos;
                    break;
                }
                if (currPos == 1) {
                    this.imageField[cX][cY] = (byte)(currKind - 1);
                    this.imageField[cX + 1][cY] = (byte)(currKind - 1);
                    this.imageField[cX + 2][cY] = (byte)(currKind - 1);
                    this.imageField[cX + 2][cY + 1] = (byte)(currKind - 1);
                    this.kindImageField[cX][cY] = currPos;
                    this.kindImageField[cX + 1][cY] = currPos;
                    this.kindImageField[cX + 2][cY] = currPos;
                    this.kindImageField[cX + 2][cY + 1] = currPos;
                    break;
                }
                if (currPos == 2) {
                    this.imageField[cX][cY] = (byte)(currKind - 1);
                    this.imageField[cX][cY + 1] = (byte)(currKind - 1);
                    this.imageField[cX][cY + 2] = (byte)(currKind - 1);
                    this.imageField[cX + 1][cY] = (byte)(currKind - 1);
                    this.kindImageField[cX][cY] = currPos;
                    this.kindImageField[cX][cY + 1] = currPos;
                    this.kindImageField[cX][cY + 2] = currPos;
                    this.kindImageField[cX + 1][cY] = currPos;
                    break;
                }
                if (currPos != 3) break;
                this.imageField[cX][cY] = (byte)(currKind - 1);
                this.imageField[cX][cY + 1] = (byte)(currKind - 1);
                this.imageField[cX + 1][cY + 1] = (byte)(currKind - 1);
                this.imageField[cX + 2][cY + 1] = (byte)(currKind - 1);
                this.kindImageField[cX][cY] = currPos;
                this.kindImageField[cX][cY + 1] = currPos;
                this.kindImageField[cX + 1][cY + 1] = currPos;
                this.kindImageField[cX + 2][cY + 1] = currPos;
                break;
            }
            case 6: {
                if (currPos == 0) {
                    this.imageField[cX][cY] = (byte)(currKind - 2);
                    this.imageField[cX][cY + 1] = (byte)(currKind - 2);
                    this.imageField[cX][cY + 2] = (byte)(currKind - 2);
                    this.imageField[cX + 1][cY + 2] = (byte)(currKind - 2);
                    this.kindImageField[cX][cY] = currPos;
                    this.kindImageField[cX][cY + 1] = currPos;
                    this.kindImageField[cX][cY + 2] = currPos;
                    this.kindImageField[cX + 1][cY + 2] = currPos;
                    break;
                }
                if (currPos == 1) {
                    this.imageField[cX][cY] = (byte)(currKind - 2);
                    this.imageField[cX][cY + 1] = (byte)(currKind - 2);
                    this.imageField[cX - 1][cY + 1] = (byte)(currKind - 2);
                    this.imageField[cX - 2][cY + 1] = (byte)(currKind - 2);
                    this.kindImageField[cX][cY] = currPos;
                    this.kindImageField[cX][cY + 1] = currPos;
                    this.kindImageField[cX - 1][cY + 1] = currPos;
                    this.kindImageField[cX - 2][cY + 1] = currPos;
                    break;
                }
                if (currPos == 2) {
                    this.imageField[cX][cY] = (byte)(currKind - 2);
                    this.imageField[cX + 1][cY] = (byte)(currKind - 2);
                    this.imageField[cX + 1][cY + 1] = (byte)(currKind - 2);
                    this.imageField[cX + 1][cY + 2] = (byte)(currKind - 2);
                    this.kindImageField[cX][cY] = currPos;
                    this.kindImageField[cX + 1][cY] = currPos;
                    this.kindImageField[cX + 1][cY + 1] = currPos;
                    this.kindImageField[cX + 1][cY + 2] = currPos;
                    break;
                }
                if (currPos != 3) break;
                this.imageField[cX][cY] = (byte)(currKind - 2);
                this.imageField[cX + 1][cY] = (byte)(currKind - 2);
                this.imageField[cX + 2][cY] = (byte)(currKind - 2);
                this.imageField[cX][cY + 1] = (byte)(currKind - 2);
                this.kindImageField[cX][cY] = currPos;
                this.kindImageField[cX + 1][cY] = currPos;
                this.kindImageField[cX + 2][cY] = currPos;
                this.kindImageField[cX][cY + 1] = currPos;
            }
        }
    }

    public boolean isLeftMove(Figure figure) {
        byte currKind = figure.kind;
        byte currPos = figure.pos;
        byte cX = figure.currLogX;
        byte cY = figure.currLogY;
        switch (currKind) {
            case 0: {
                if (currPos != 0) break;
                return cX - 1 >= 0 && !this.gameField[cX - 1][cY] && !this.gameField[cX - 1][cY + 1];
            }
            case 1: {
                if (currPos == 0) {
                    return cX - 1 >= 0 && !this.gameField[cX - 1][cY] && !this.gameField[cX - 1][cY + 1] && !this.gameField[cX - 1][cY + 2] && !this.gameField[cX - 1][cY + 3];
                }
                if (currPos != 1) break;
                return cX - 1 >= 0 && !this.gameField[cX - 1][cY];
            }
            case 2: {
                if (currPos == 0) {
                    return cX - 2 >= 0 && !this.gameField[cX - 1][cY] && !this.gameField[cX - 2][cY + 1];
                }
                if (currPos == 1) {
                    return cX - 2 >= 0 && !this.gameField[cX - 1][cY] && !this.gameField[cX - 2][cY + 1] && !this.gameField[cX - 1][cY + 2];
                }
                if (currPos == 2) {
                    return cX - 1 >= 0 && !this.gameField[cX - 1][cY] && !this.gameField[cX][cY + 1];
                }
                if (currPos != 3) break;
                return cX - 1 >= 0 && !this.gameField[cX - 1][cY] && !this.gameField[cX - 1][cY + 1] && !this.gameField[cX - 1][cY + 2];
            }
            case 3: {
                if (currPos == 0) {
                    return cX - 1 >= 0 && !this.gameField[cX - 1][cY] && !this.gameField[cX - 1][cY + 1] && !this.gameField[cX - 1][cY + 2];
                }
                if (currPos != 1) break;
                return cX - 2 >= 0 && !this.gameField[cX - 1][cY] && !this.gameField[cX - 2][cY + 1] && !this.gameField[cX - 2][cY + 2];
            }
            case 4: {
                if (currPos == 0) {
                    return cX - 2 >= 0 && !this.gameField[cX - 1][cY] && !this.gameField[cX - 2][cY + 1];
                }
                if (currPos != 1) break;
                return cX - 1 >= 0 && !this.gameField[cX - 1][cY] && !this.gameField[cX - 1][cY + 1] && !this.gameField[cX][cY + 2];
            }
            case 5: {
                if (currPos == 0) {
                    return cX - 2 >= 0 && !this.gameField[cX - 1][cY] && !this.gameField[cX - 1][cY + 1] && !this.gameField[cX - 2][cY + 2];
                }
                if (currPos == 1) {
                    return cX - 1 >= 0 && !this.gameField[cX - 1][cY] && !this.gameField[cX + 1][cY + 1];
                }
                if (currPos == 2) {
                    return cX - 1 >= 0 && !this.gameField[cX - 1][cY] && !this.gameField[cX - 1][cY + 1] && !this.gameField[cX - 1][cY + 2];
                }
                if (currPos != 3) break;
                return cX - 1 >= 0 && !this.gameField[cX - 1][cY] && !this.gameField[cX - 1][cY + 1];
            }
            case 6: {
                if (currPos == 0) {
                    return cX - 1 >= 0 && !this.gameField[cX - 1][cY] && !this.gameField[cX - 1][cY + 1] && !this.gameField[cX - 1][cY + 2];
                }
                if (currPos == 1) {
                    return cX - 3 >= 0 && !this.gameField[cX - 1][cY] && !this.gameField[cX - 3][cY + 1];
                }
                if (currPos == 2) {
                    return cX - 1 >= 0 && !this.gameField[cX - 1][cY] && !this.gameField[cX][cY + 1] && !this.gameField[cX][cY + 2];
                }
                if (currPos != 3) break;
                return cX - 1 >= 0 && !this.gameField[cX - 1][cY] && !this.gameField[cX - 1][cY + 1];
            }
        }
        return false;
    }

    public boolean isRightMove(Figure figure) {
        byte currKind = figure.kind;
        byte currPos = figure.pos;
        byte cX = figure.currLogX;
        byte cY = figure.currLogY;
        switch (currKind) {
            case 0: {
                if (currPos != 0) break;
                return cX + 2 < 12 && !this.gameField[cX + 2][cY] && !this.gameField[cX + 2][cY + 1];
            }
            case 1: {
                if (currPos == 0) {
                    return cX + 1 < 12 && !this.gameField[cX + 1][cY] && !this.gameField[cX + 1][cY + 1] && !this.gameField[cX + 1][cY + 2] && !this.gameField[cX + 1][cY + 3];
                }
                if (currPos != 1) break;
                return cX + 4 < 12 && !this.gameField[cX + 4][cY];
            }
            case 2: {
                if (currPos == 0) {
                    return cX + 2 < 12 && !this.gameField[cX + 1][cY] && !this.gameField[cX + 2][cY + 1];
                }
                if (currPos == 1) {
                    return cX + 1 < 12 && !this.gameField[cX + 1][cY] && !this.gameField[cX + 1][cY + 1] && !this.gameField[cX + 1][cY + 2];
                }
                if (currPos == 2) {
                    return cX + 3 < 12 && !this.gameField[cX + 3][cY] && !this.gameField[cX + 2][cY + 1];
                }
                if (currPos != 3) break;
                return cX + 2 < 12 && !this.gameField[cX + 1][cY] && !this.gameField[cX + 2][cY + 1] && !this.gameField[cX + 1][cY + 2];
            }
            case 3: {
                if (currPos == 0) {
                    return cX + 3 < 12 && !this.gameField[cX + 2][cY] && !this.gameField[cX + 3][cY + 1];
                }
                if (currPos != 1) break;
                return cX + 1 < 12 && !this.gameField[cX + 1][cY] && !this.gameField[cX + 1][cY + 1] && !this.gameField[cX][cY + 2];
            }
            case 4: {
                if (currPos == 0) {
                    return cX + 2 < 12 && !this.gameField[cX + 2][cY] && !this.gameField[cX + 1][cY + 1];
                }
                if (currPos != 1) break;
                return cX + 2 < 12 && !this.gameField[cX + 1][cY] && !this.gameField[cX + 2][cY + 1] && !this.gameField[cX + 2][cY + 2];
            }
            case 5: {
                if (currPos == 0) {
                    return cX + 1 < 12 && !this.gameField[cX + 1][cY] && !this.gameField[cX + 1][cY + 1] && !this.gameField[cX + 1][cY + 2];
                }
                if (currPos == 1) {
                    return cX + 3 < 12 && !this.gameField[cX + 3][cY] && !this.gameField[cX + 3][cY + 1];
                }
                if (currPos == 2) {
                    return cX + 2 < 12 && !this.gameField[cX + 2][cY] && !this.gameField[cX + 1][cY + 1] && !this.gameField[cX + 1][cY + 2];
                }
                if (currPos != 3) break;
                return cX + 3 < 12 && !this.gameField[cX + 1][cY] && !this.gameField[cX + 3][cY + 1];
            }
            case 6: {
                if (currPos == 0) {
                    return cX + 2 < 12 && !this.gameField[cX + 1][cY] && !this.gameField[cX + 1][cY + 1] && !this.gameField[cX + 2][cY + 2];
                }
                if (currPos == 1) {
                    return cX + 1 < 12 && !this.gameField[cX + 1][cY] && !this.gameField[cX + 1][cY + 1];
                }
                if (currPos == 2) {
                    return cX + 2 < 12 && !this.gameField[cX + 2][cY] && !this.gameField[cX + 2][cY + 1] && !this.gameField[cX + 2][cY + 2];
                }
                if (currPos != 3) break;
                return cX + 3 < 12 && !this.gameField[cX + 3][cY] && !this.gameField[cX + 1][cY + 1];
            }
        }
        return true;
    }

    public boolean isRotate(Figure figure) {
        int pos = figure.getRotationPos();
        int x = figure.getRotationX();
        int y = figure.getRotationY();
        byte currKind = figure.kind;
        switch (currKind) {
            case 1: {
                if (pos == 0) {
                    return y + 3 < 15 && !this.gameField[x][y + 3] && !this.gameField[x][y + 2];
                }
                if (pos != 1) break;
                return x >= 0 && x + 3 < 12 && !this.gameField[x][y] && !this.gameField[x + 2][y] && !this.gameField[x + 3][y];
            }
            case 2: {
                if (pos == 0) {
                    return x - 1 >= 0 && !this.gameField[x - 1][y + 1];
                }
                if (pos == 1) {
                    return y + 2 < 15 && !this.gameField[x][y + 2];
                }
                if (pos == 2) {
                    return x + 2 < 12 && !this.gameField[x + 2][y];
                }
                if (pos != 3) break;
                return !this.gameField[x][y];
            }
            case 3: {
                if (pos == 0) {
                    return x + 2 < 12 && !this.gameField[x + 2][y + 1] && !this.gameField[x + 1][y + 1];
                }
                if (pos != 1) break;
                return y + 2 < 15 && y >= 0 && !this.gameField[x - 1][y + 2] && !this.gameField[x][y];
            }
            case 4: {
                if (pos == 0) {
                    return x - 1 >= 0 && !this.gameField[x - 1][y + 1] && !this.gameField[x][y + 1];
                }
                if (pos != 1) break;
                return y + 2 < 15 && y >= 0 && !this.gameField[x][y] && !this.gameField[x + 1][y + 2];
            }
            case 5: {
                if (pos == 0) {
                    return !this.gameField[x][y] && !this.gameField[x][y + 1];
                }
                if (pos == 1) {
                    return x >= 0 && !this.gameField[x][y] && !this.gameField[x + 1][y];
                }
                if (pos == 2) {
                    return y + 2 < 15 && !this.gameField[x][y + 2] && !this.gameField[x][y + 1];
                }
                if (pos != 3) break;
                return x + 2 < 12 && !this.gameField[x + 1][y + 1] && !this.gameField[x + 2][y + 1];
            }
            case 6: {
                if (pos == 0) {
                    return !this.gameField[x][y] && !this.gameField[x][y + 2];
                }
                if (pos == 1) {
                    return x - 2 >= 0 && !this.gameField[x][y] && !this.gameField[x - 2][y + 1];
                }
                if (pos == 2) {
                    return y + 2 < 15 && !this.gameField[x][y] && !this.gameField[x + 1][y + 2];
                }
                if (pos != 3) break;
                return x + 2 < 12 && !this.gameField[x][y + 1] && !this.gameField[x + 2][y];
            }
        }
        return false;
    }

    public boolean isDownMove(Figure figure) {
        byte currKind = figure.kind;
        byte currPos = figure.pos;
        byte cX = figure.currLogX;
        byte cY = figure.currLogY;
        switch (figure.kind) {
            case 0: {
                if (currPos != 0) break;
                return cY + 2 < 15 && !this.gameField[cX][cY + 2] && !this.gameField[cX + 1][cY + 2];
            }
            case 1: {
                if (currPos == 0) {
                    return cY + 4 < 15 && !this.gameField[cX][cY + 4];
                }
                if (currPos != 1) break;
                return cY + 1 < 15 && !this.gameField[cX][cY + 1] && !this.gameField[cX + 1][cY + 1] && !this.gameField[cX + 2][cY + 1] && !this.gameField[cX + 3][cY + 1];
            }
            case 2: {
                if (currPos == 0) {
                    return cY + 2 < 15 && !this.gameField[cX - 1][cY + 2] && !this.gameField[cX][cY + 2] && !this.gameField[cX + 1][cY + 2];
                }
                if (currPos == 1) {
                    return cY + 3 < 15 && !this.gameField[cX][cY + 3] && !this.gameField[cX - 1][cY + 2];
                }
                if (currPos == 2) {
                    return cY + 2 < 15 && !this.gameField[cX][cY + 1] && !this.gameField[cX + 1][cY + 2] && !this.gameField[cX + 2][cY + 1];
                }
                if (currPos != 3) break;
                return cY + 3 < 15 && !this.gameField[cX][cY + 3] && !this.gameField[cX + 1][cY + 2];
            }
            case 3: {
                if (currPos == 0) {
                    return cY + 2 < 15 && !this.gameField[cX][cY + 1] && !this.gameField[cX + 1][cY + 2] && !this.gameField[cX + 2][cY + 2];
                }
                if (currPos != 1) break;
                return cY + 3 < 15 && !this.gameField[cX][cY + 2] && !this.gameField[cX - 1][cY + 3];
            }
            case 4: {
                if (currPos == 0) {
                    return cY + 2 < 15 && !this.gameField[cX][cY + 2] && !this.gameField[cX - 1][cY + 2] && !this.gameField[cX + 1][cY + 1];
                }
                if (currPos != 1) break;
                return cY + 3 < 15 && !this.gameField[cX][cY + 2] && !this.gameField[cX + 1][cY + 3];
            }
            case 5: {
                if (currPos == 0) {
                    return cY + 3 < 15 && !this.gameField[cX][cY + 3] && !this.gameField[cX - 1][cY + 3];
                }
                if (currPos == 1) {
                    return cY + 2 < 15 && !this.gameField[cX][cY + 1] && !this.gameField[cX + 1][cY + 1] && !this.gameField[cX + 2][cY + 2];
                }
                if (currPos == 2) {
                    return cY + 3 < 15 && !this.gameField[cX][cY + 3] && !this.gameField[cX + 1][cY + 1];
                }
                if (currPos != 3) break;
                return cY + 2 < 15 && !this.gameField[cX][cY + 2] && !this.gameField[cX + 1][cY + 2] && !this.gameField[cX + 2][cY + 2];
            }
            case 6: {
                if (currPos == 0) {
                    return cY + 3 < 15 && !this.gameField[cX][cY + 3] && !this.gameField[cX + 1][cY + 3];
                }
                if (currPos == 1) {
                    return cY + 2 < 15 && !this.gameField[cX][cY + 2] && !this.gameField[cX - 1][cY + 2] && !this.gameField[cX - 2][cY + 2];
                }
                if (currPos == 2) {
                    return cY + 3 < 15 && !this.gameField[cX][cY + 1] && !this.gameField[cX + 1][cY + 3];
                }
                if (currPos != 3) break;
                return cY + 2 < 15 && !this.gameField[cX][cY + 2] && !this.gameField[cX + 1][cY + 1] && !this.gameField[cX + 2][cY + 1];
            }
        }
        return false;
    }
}

