/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class SoundPlayer {
    private String _soundFormat;
    private String _fileName;
    private boolean _isInit;
    private Player playerME = null;

    public SoundPlayer(String fileName) {
        this._fileName = fileName;
        if (fileName.endsWith(".amr")) {
            this._soundFormat = "audio/amr";
        } else if (fileName.endsWith(".wav")) {
            this._soundFormat = "audio/wav";
        } else if (fileName.endsWith(".mid")) {
            this._soundFormat = "audio/midi";
        }
        this._isInit = false;
    }

    public boolean isInit() {
        return this._isInit;
    }

    public void initSound() {
        InputStream inputstream = new Object().getClass().getResourceAsStream(this._fileName);
        try {
            this.playerME = Manager.createPlayer((InputStream)inputstream, (String)this._soundFormat);
        }
        catch (Exception e) {
            System.out.println("playerME error" + e.toString());
        }
        try {
            this.playerME.realize();
        }
        catch (Exception e) {
            System.out.println("re error " + e.toString());
        }
        try {
            this.playerME.prefetch();
        }
        catch (Exception e) {
            System.out.println("prefe error " + e.toString());
        }
        this._isInit = true;
    }

    public void closeSound() {
        try {
            this.playerME.stop();
            this.playerME.deallocate();
            this.playerME.close();
            this.playerME = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void playSound(int loop) {
        try {
            if (this.playerME.getState() != 400) {
                this.playerME.setLoopCount(loop);
            }
            this.playerME.start();
        }
        catch (Exception e) {
            System.out.println(e.toString() + " ------marker");
        }
    }

    public void stopSound() {
        try {
            if (this.playerME.getState() == 400) {
                this.playerME.stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isSoundPlaying() {
        try {
            if (this.playerME.getState() == 400) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void restartSound() {
        try {
            if (this.playerME.getState() == 400) {
                this.playerME.stop();
            }
            this.playerME.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getState() {
        return this.playerME.getState();
    }
}

