/*
 * Decompiled with CFR 0.152.
 */
package com.movaya.license.rms;

import com.movaya.M123456;
import com.movaya.license.gamecontrol.MResource;
import com.movaya.license.rms.RmsManager;
import com.movaya.license.structure.Array;
import com.movaya.license.structure.BuyBlock;
import com.movaya.license.structure.FeatureBlock;
import com.movaya.license.structure.LicenseBlock;
import com.movaya.license.structure.MLicense;
import com.movaya.license.structure.ProductInfoBlock;
import com.movaya.license.structure.TrialBlock;
import com.movaya.license.utils.HttpConn;
import com.movaya.license.utils.Utils;
import java.util.Date;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStoreFullException;

public final class RmsBiz {
    public static final String ORDER_TYPE_WAP = "waporder";
    public static final String ORDER_TYPE_MIDLET = "midorder";
    private RmsManager m_manager = null;
    private MLicense datLicense = null;
    private LicenseBlock datLicenseBlock = null;
    private MLicense rmsLicense = null;
    private LicenseBlock rmsLicenseBlock = null;
    private int orderStatus = -1;
    private int resultStatus = -1;
    private M123456 mmidlet = null;

    public MLicense getDatLicense() {
        return this.datLicense;
    }

    public LicenseBlock getDatLicenseBlock() {
        return this.datLicenseBlock;
    }

    public RmsBiz(final M123456 mmidlet) throws Exception {
        this.mmidlet = mmidlet;
        try {
            LicenseBlock.useRmsData = false;
            this.datLicense = new MLicense();
            this.datLicenseBlock = this.datLicense.getLicence();
            this.m_manager = new RmsManager(this.datLicense.getLicenseId());
            LicenseBlock.useRmsData = true;
            this.rmsLicenseBlock = this.m_manager.query(this.datLicenseBlock.getLicenseId());
            this.rmsLicense = new MLicense(this.rmsLicenseBlock);
        }
        catch (RecordStoreFullException ex) {
            String title = MResource.getResource((MLicense)this.datLicense).exception_rms_fullTitle;
            String msg = MResource.getResource((MLicense)this.datLicense).exception_rms_full;
            Alert alert = null;
            alert = Utils.getAlertError(title, msg);
            Display.getDisplay((MIDlet)this.mmidlet).setCurrent((Displayable)alert);
            alert.addCommand(Utils.getCmdExit());
            alert.setTimeout(-2);
            alert.setCommandListener(new CommandListener(){

                public void commandAction(Command cmd, Displayable d) {
                    if (cmd.getCommandType() == 7) {
                        mmidlet.notifyDestroyed();
                    }
                }
            });
            System.out.println("--->3");
            mmidlet.startAble = false;
        }
    }

    public boolean isPlayable(String featureID) {
        BuyBlock buyBlock;
        block8: {
            block7: {
                block6: {
                    try {
                        if (this.rmsLicenseBlock != null) break block6;
                        this.m_manager.update(this.datLicenseBlock);
                        this.rmsLicenseBlock = this.m_manager.query(this.datLicenseBlock.getLicenseId());
                        this.rmsLicense = new MLicense(this.rmsLicenseBlock);
                        return false;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        return false;
                    }
                }
                buyBlock = null;
                buyBlock = this.getPurchasedBlock(featureID);
                if (buyBlock != null) break block7;
                return false;
            }
            if (!this.isPurchaseSuccess(buyBlock)) break block8;
            return this.isUsable(buyBlock);
        }
        String url = MResource.getResource(this.datLicense).getOrderStatusURL();
        this.resultStatus = HttpConn.visit(url);
        if (this.resultStatus == 1) {
            buyBlock.setBuyFlag(buyBlock.getBuyFlag() + 4);
            this.updateLicense();
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTriable(String featureID) {
        try {
            if (this.rmsLicenseBlock == null) {
                this.m_manager.update(this.datLicenseBlock);
                this.rmsLicenseBlock = this.m_manager.query(this.datLicenseBlock.getLicenseId());
                return true;
            }
            Array trialArr = null;
            trialArr = this.rmsLicense.getFeaTrials(featureID);
            TrialBlock trialBlock = null;
            int flag = -1;
            long info = -1L;
            long used = -1L;
            int i = 0;
            while (true) {
                if (i >= trialArr.size()) {
                    return false;
                }
                trialBlock = (TrialBlock)trialArr.elementAt(i);
                flag = trialBlock.getTrialFlag();
                info = trialBlock.getTrialInfo();
                used = trialBlock.getTrialUsed();
                if ((flag & 1) == 1 && ((flag & 0x10) == 16 ? info > used : (flag & 0x20) == 32 && info > new Date().getTime())) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean isBuyable(String featureID) {
        BuyBlock buyBlock;
        block7: {
            block6: {
                block5: {
                    try {
                        if (this.rmsLicenseBlock != null) break block5;
                        this.m_manager.update(this.datLicenseBlock);
                        this.rmsLicenseBlock = this.m_manager.query(this.datLicenseBlock.getLicenseId());
                        return true;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        return false;
                    }
                }
                buyBlock = null;
                buyBlock = this.getPurchasedBlock(featureID);
                if (buyBlock != null) break block6;
                return true;
            }
            if (!this.isPurchaseSuccess(buyBlock)) break block7;
            return !this.isUsable(buyBlock);
        }
        return !this.isOrderFromMidlet(buyBlock);
    }

    public boolean isUnlockable(String featureID) {
        BuyBlock buyBlock;
        block3: {
            try {
                buyBlock = null;
                buyBlock = this.getPurchasedBlock(featureID);
                if (buyBlock != null) break block3;
                return false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return this.isOrderFromWap(buyBlock);
    }

    public boolean isOrderProcess(String featureID) {
        BuyBlock buyBlock;
        block3: {
            try {
                buyBlock = null;
                buyBlock = this.getPurchasedBlock(featureID);
                if (buyBlock != null) break block3;
                return false;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return !this.isOrderFromWap(buyBlock);
    }

    private BuyBlock getDatPurchasedBlock(String featureID, int buyFlag) {
        int purchaseFlag = -1;
        Array purchaseArray = null;
        purchaseArray = this.datLicense.getFeaSells(featureID);
        BuyBlock buyBlock = null;
        int i = 0;
        while (i < purchaseArray.size()) {
            buyBlock = (BuyBlock)purchaseArray.elementAt(i);
            purchaseFlag = buyBlock.getBuyFlag();
            if (purchaseFlag == buyFlag) {
                return buyBlock;
            }
            ++i;
        }
        return null;
    }

    private BuyBlock getPurchasedBlock(String featureID) {
        int purchaseFlag = -1;
        Array purchaseArray = null;
        purchaseArray = this.rmsLicense.getFeaSells(featureID);
        BuyBlock buyBlock = null;
        int i = 0;
        while (i < purchaseArray.size()) {
            buyBlock = (BuyBlock)purchaseArray.elementAt(i);
            purchaseFlag = buyBlock.getBuyFlag();
            if ((purchaseFlag & 1) == 1) {
                return buyBlock;
            }
            ++i;
        }
        return null;
    }

    private ProductInfoBlock getProductInfoBlock(BuyBlock buyBlock, String productId) {
        try {
            if (buyBlock == null) {
                throw new NullPointerException("The parameter buyBlock is null.");
            }
            ProductInfoBlock productInfoBlock = null;
            Array array = buyBlock.getProductinfo();
            int i = 0;
            while (i < array.size()) {
                productInfoBlock = (ProductInfoBlock)array.elementAt(i);
                if (productInfoBlock.getProductId().equals(productId)) {
                    return productInfoBlock;
                }
                ++i;
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private boolean isPurchaseSuccess(BuyBlock buyBlock) {
        if (buyBlock == null) {
            return false;
        }
        int purchaseFlag = -1;
        purchaseFlag = buyBlock.getBuyFlag();
        return (purchaseFlag & 4) == 4;
    }

    private boolean isUsable(BuyBlock buyBlock) {
        int flag = -1;
        long info = -1L;
        long used = -1L;
        flag = buyBlock.getBuyFlag();
        info = buyBlock.getBuyInfo();
        used = buyBlock.getBuyUsed();
        if ((flag & 0x40) == 64) {
            return true;
        }
        return (flag & 0x80) == 128 ? info > used : (flag & 0x100) == 256 && info > new Date().getTime();
    }

    private boolean isOrderFromWap(BuyBlock buyBlock) throws Exception {
        int buyFlag = -1;
        buyFlag = buyBlock.getBuyFlag();
        return (buyFlag & 0x400) == 1024;
    }

    private boolean isOrderFromMidlet(BuyBlock buyBlock) throws Exception {
        int flag = -1;
        flag = buyBlock.getBuyFlag();
        return (flag & 0x200) == 512;
    }

    public int order(String featureID, int buyFlag, String productId, String carrierName, String phoneNo) throws Exception {
        this.orderStatus = HttpConn.visit(MResource.getResource(this.datLicense).getOrderURL(carrierName, phoneNo, ORDER_TYPE_MIDLET));
        if (this.orderStatus == -1 && this.mmidlet.isAdvMIDP()) {
            try {
                this.orderStatus = this.mmidlet.wapCheckout(MResource.getResource(this.datLicense).getOrderURL(carrierName, phoneNo, ORDER_TYPE_WAP)) ? 3 : 4;
            }
            catch (Exception e) {
                this.orderStatus = 4;
            }
        }
        BuyBlock buyBlock = null;
        buyBlock = this.getDatPurchasedBlock(featureID, buyFlag);
        if (this.orderStatus == 1 || this.orderStatus == 3) {
            this.clearBuyModeUsed(featureID);
            buyBlock.setBuyFlag(buyBlock.getBuyFlag() + 2 + 1);
            if (this.orderStatus == 1) {
                buyBlock.setBuyFlag(buyBlock.getBuyFlag() + 512);
            } else {
                buyBlock.setBuyFlag(buyBlock.getBuyFlag() + 1024);
            }
            ProductInfoBlock productInfoBlock = null;
            productInfoBlock = this.getProductInfoBlock(buyBlock, productId);
            long buyInfo = -1L;
            buyInfo = productInfoBlock.getProductKey();
            buyBlock.setBuyInfo(buyInfo);
            buyBlock.setBuyUsed(0L);
            this.rmsLicense.getFeaSells(featureID).addElement(buyBlock);
            this.updateLicense();
        }
        return this.orderStatus;
    }

    private void clearBuyModeUsed(String featureID) {
        BuyBlock buyBlock = null;
        buyBlock = this.getPurchasedBlock(featureID);
        if (buyBlock != null) {
            buyBlock.setBuyFlag(buyBlock.getBuyFlag() - 1);
        }
    }

    public void updateTry(String featureID) throws Exception {
        FeatureBlock featureBlock = null;
        featureBlock = this.rmsLicense.getFeatureByID(featureID);
        Array trialArray = null;
        trialArray = featureBlock.getTrial();
        TrialBlock trialBlock = null;
        int trialFlag = -1;
        long trialUsed = -1L;
        int i = 0;
        while (i < trialArray.size()) {
            trialBlock = (TrialBlock)trialArray.elementAt(i);
            trialFlag = trialBlock.getTrialFlag();
            if ((trialFlag & 0x10) == 16) {
                trialUsed = trialBlock.getTrialUsed() + 1L;
                trialBlock.setTrialUsed(trialUsed);
                this.updateLicense();
                return;
            }
            ++i;
        }
    }

    public void updateBuy(String featureID) throws Exception {
        FeatureBlock featureBlock = null;
        featureBlock = this.rmsLicense.getFeatureByID(featureID);
        Array buyArray = null;
        buyArray = featureBlock.getBuy();
        BuyBlock buyBlock = null;
        int buyFlag = -1;
        long buyUsed = -1L;
        int i = 0;
        while (i < buyArray.size()) {
            buyBlock = (BuyBlock)buyArray.elementAt(i);
            buyFlag = buyBlock.getFlag();
            if ((buyFlag & 1) != 1 && (buyFlag & 0x10) == 16) {
                buyUsed = buyBlock.getBuyUsed() + 1L;
                buyBlock.setBuyUsed(++buyUsed);
                this.updateLicense();
                return;
            }
            ++i;
        }
    }

    public void unlock(String featureID) throws Exception {
        BuyBlock buyBlock = null;
        buyBlock = this.getPurchasedBlock(featureID);
        buyBlock.setBuyFlag(buyBlock.getBuyFlag() + 4);
        this.updateLicense();
    }

    public void updateLicense() throws Exception {
        this.m_manager.update(this.rmsLicenseBlock);
    }

    public long getTrialTimeLimit() {
        long defTimeLimit = 900000L;
        Array trialArray = null;
        trialArray = this.datLicense.getDefFeature().getTrial();
        TrialBlock trialBlock = null;
        int flag = -1;
        int i = 0;
        while (i < trialArray.size()) {
            trialBlock = (TrialBlock)trialArray.elementAt(i);
            flag = trialBlock.getTrialFlag();
            if ((flag & 0x40) == 64) {
                defTimeLimit = trialBlock.getTrialInfo();
                break;
            }
            ++i;
        }
        return defTimeLimit;
    }
}

