/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class FontEngine {
    private static final StringBuffer CHARSET = new StringBuffer().append("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789'\"(){}[].,:;?!~^+-*%/\\>=<_#&@").append("\u00c1").append("\u00c0").append("\u00c4").append("\u00c2").append("\u00c6").append("\u00c7").append("\u00c9").append("\u00c8").append("\u00cb").append("\u00ca").append("\u00cd").append("\u00cc").append("\u00cf").append("\u00ce").append("\u00d3").append("\u00d2").append("\u00d6").append("\u00d4").append("\u00da").append("\u00d9").append("\u00dc").append("\u00db").append("\u00e1").append("\u00e0").append("\u00e4").append("\u00e2").append("\u00e6").append("\u00e7").append("\u00e9").append("\u00e8").append("\u00eb").append("\u00ea").append("\u00ed").append("\u00ec").append("\u00ef").append("\u00ee").append("\u00f3").append("\u00f2").append("\u00f6").append("\u00f4").append("\u00fa").append("\u00f9").append("\u00fc").append("\u00fb").append("\u00bf").append("\u00df").append("\u00a1").append("\u00d1").append("\u00a9").append('\u00f0');
    private static final String charsetString = CHARSET.toString();
    private int fontNumbers = 0;
    private int screenWidth;
    private int bckupScreenWidth;
    private int[] fontHeight;
    private int[][] fontWidths;
    private int spacing = 0;
    private StringBuffer tempStringBuffer = new StringBuffer();
    private Image[] font;
    private Graphics gx;
    public static final int NOWRAP = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 4;
    public static final int CENTER = 8;
    public static final int TOP = 16;
    public static final int VCENTER = 32;
    public static final int BOTTOM = 64;
    public static final int SUPERCENTER = 128;
    private DataInputStream in = null;
    private InputStream ini = null;
    byte[] FontBuffer;
    private int oldResIdx = -1;

    public FontEngine(int n, int n2) {
        this.screenWidth = n;
        this.bckupScreenWidth = n;
        this.fontNumbers = n2;
        this.font = new Image[n2];
        this.fontHeight = new int[n2];
        this.fontWidths = new int[n2][CHARSET.length()];
    }

    public void openTextStream() {
        this.ini = this.getClass().getResourceAsStream("/RES_FONT.bin");
        this.in = new DataInputStream(this.ini);
    }

    public void closeTextStream() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.oldResIdx = -1;
    }

    public boolean addFont(int n, int n2, int[] nArray, int n3) {
        if (n >= this.fontNumbers) {
            return false;
        }
        this.font[n] = null;
        int n4 = Constants.RES_FONT[n2 + 1] - Constants.RES_FONT[n2];
        if (this.FontBuffer == null || this.FontBuffer.length < n4) {
            this.FontBuffer = new byte[n4];
        }
        try {
            if (this.oldResIdx != -1) {
                this.in.skipBytes(Constants.RES_FONT[n2] - Constants.RES_FONT[this.oldResIdx + 1]);
            } else {
                this.in.skipBytes(Constants.RES_FONT[n2]);
            }
            this.in.read(this.FontBuffer, 0, n4);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.oldResIdx = n2;
        this.font[n] = Image.createImage((byte[])this.FontBuffer, (int)0, (int)n4);
        this.fontWidths[n] = nArray;
        this.fontHeight[n] = n3;
        return true;
    }

    public boolean removeFont(int n) {
        if (this.font[n] == null) {
            return false;
        }
        this.font[n] = null;
        this.fontWidths[n] = null;
        this.fontHeight[n] = 0;
        System.gc();
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return true;
    }

    public int getFontHeight(int n) {
        return this.fontHeight[n];
    }

    public String wrapText(int n, String string, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.getCharIndex('_');
        int n8 = string.length();
        int n9 = 0;
        String string2 = new String();
        this.tempStringBuffer.setLength(0);
        int n10 = this.fontWidths[n][n7] + this.spacing;
        for (n3 = 0; n3 < n8; ++n3) {
            char c = string.charAt(n3);
            if (c != '|') {
                n6 = c == ' ' ? n7 : this.getCharIndex(c);
                n5 = this.fontWidths[n][n6];
            }
            if (c == '|') {
                n4 = 0;
            } else if (n4 + n9 - n10 > n2 && c == ' ') {
                n4 = 0;
                if (this.tempStringBuffer.charAt(this.tempStringBuffer.length() - 1) == ' ') {
                    this.tempStringBuffer.setCharAt(this.tempStringBuffer.length() - 1, '|');
                } else {
                    this.tempStringBuffer.append('|');
                }
            }
            if (c == ' ' && c != '|') {
                n4 += n9 + n5 + this.spacing;
                n9 = 0;
                this.tempStringBuffer.append(string2 + ' ');
                string2 = "";
                continue;
            }
            n9 += n5 + this.spacing;
            string2 = string2 + c;
        }
        if (n3 >= n8 - 2 && n4 + n9 <= n2) {
            this.tempStringBuffer.append(string2);
            string2 = "";
        } else {
            int n11 = this.tempStringBuffer.length();
            if (n11 != 0) {
                this.tempStringBuffer.deleteCharAt(n11 - 1);
            }
            if (string2.indexOf("|") == -1) {
                this.tempStringBuffer.append("|" + string2);
            } else {
                this.tempStringBuffer.append(string2);
            }
            string2 = "";
        }
        return this.tempStringBuffer.toString();
    }

    public void setGraphics(Graphics graphics) {
        this.gx = graphics;
    }

    public void drawFont(int n, String string, int n2, int n3, int n4) {
        this.drawFont(this.gx, n, string, n2, n3, n4);
    }

    public void drawFontR(int n, String string, int n2, int n3, int n4) {
        this.drawFont(this.gx, n, string, n2 - this.getTextWidth(n, string), n3, n4);
    }

    public void drawFont(Graphics graphics, int n, String string, int n2, int n3, int n4) {
        int n5 = n2;
        int n6 = n3;
        int n7 = graphics.getClipX();
        int n8 = graphics.getClipY();
        int n9 = graphics.getClipWidth();
        int n10 = graphics.getClipHeight();
        int n11 = 0;
        int n12 = 0;
        boolean bl = false;
        n12 = this.getMaxLineWidtht(n, string, 0);
        if ((n4 & 8) != 0) {
            if (this.screenWidth != this.bckupScreenWidth) {
                this.screenWidth = n12;
            }
            if ((n4 & 1) == 0) {
                string = this.wrapText(n, string, this.screenWidth);
            }
            n5 -= n12 >> 1;
        } else if ((n4 & 0x80) != 0) {
            if (this.screenWidth != this.bckupScreenWidth) {
                this.screenWidth = n12;
            }
            if ((n4 & 1) == 0) {
                string = this.wrapText(n, string, this.screenWidth);
            }
            n5 -= this.getLineWidth(n, string, 0) >> 1;
        } else if ((n4 & 4) != 0) {
            this.screenWidth = this.screenWidth != this.bckupScreenWidth ? n12 : n2;
            if ((n4 & 1) == 0) {
                string = this.wrapText(n, string, this.screenWidth);
            }
            n5 -= this.getLineWidth(n, string, 0);
        } else {
            this.screenWidth = this.screenWidth != this.bckupScreenWidth ? n12 : (this.screenWidth -= n2);
            if ((n4 & 1) == 0) {
                string = this.wrapText(n, string, this.screenWidth);
            }
        }
        if ((n4 & 0x20) != 0) {
            n6 -= this.getTextHeight(n, string) / 2;
        } else if ((n4 & 0x40) != 0) {
            n6 -= this.getTextHeight(n, string);
        }
        int n13 = string.length();
        for (int i = 0; i < n13; ++i) {
            char c = string.charAt(i);
            if (c == '|') {
                if ((n4 & 8) != 0) {
                    n5 = n2;
                    n5 -= n12 >> 1;
                    n6 += this.fontHeight[n];
                    continue;
                }
                if ((n4 & 0x80) != 0) {
                    n5 = n2;
                    n5 -= this.getLineWidth(n, string, i + 1) >> 1;
                    n6 += this.fontHeight[n];
                    continue;
                }
                if ((n4 & 4) != 0) {
                    n5 = n2;
                    n5 -= this.getLineWidth(n, string, i + 1);
                    n6 += this.fontHeight[n];
                    continue;
                }
                if ((n4 & 2) == 0) continue;
                n5 = n2;
                n6 += this.fontHeight[n];
                continue;
            }
            if (c == ' ') {
                bl = true;
                n11 = this.getCharIndex('_');
            } else {
                n11 = this.getCharIndex(c);
                bl = false;
            }
            int n14 = this.fontWidths[n][n11];
            if (n14 < 0) continue;
            int n15 = this.getCharPosX(n, n11);
            int n16 = this.getCharPosY(n, n11);
            graphics.setClip(n5, n6, n14, this.fontHeight[n]);
            if (!bl) {
                graphics.drawImage(this.font[n], n5 - n15, n6 - n16, 20);
            }
            n5 += n14 + this.spacing;
        }
        this.resetWidth();
        graphics.setClip(n7, n8, n9, n10);
    }

    public int getTextHeight(int n, String string) {
        int n2 = 0;
        int n3 = 0;
        while (n3 != -1) {
            ++n2;
            if ((n3 = string.indexOf(124, n3)) == -1) continue;
            ++n3;
        }
        return n2 * this.fontHeight[n];
    }

    public int getTextWidth(int n, String string) {
        int n2 = string.length();
        char c = '\u0000';
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            c = string.charAt(i);
            n5 = c == ' ' ? this.getCharIndex('_') : this.getCharIndex(c);
            n4 = this.fontWidths[n][n5];
            n3 += n4 + this.spacing;
        }
        return n3;
    }

    public int getLineWidth(int n, String string, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = string.length();
        int n7 = 0;
        int n8 = 0;
        char c = '\u0000';
        n8 = this.fontWidths[n][this.getCharIndex('_')] + this.spacing;
        while (n2 < n6 && (c = string.charAt(n2)) != '|' && n3 + n7 <= this.screenWidth) {
            n5 = c == ' ' ? this.getCharIndex('_') : this.getCharIndex(c);
            n4 = this.fontWidths[n][n5];
            if (c == ' ' && c != '|') {
                n3 += n7;
                n7 = n8 + this.spacing;
            } else {
                n7 += n4 + this.spacing;
            }
            ++n2;
        }
        return n3 += n7;
    }

    public int getMaxLineWidtht(int n, String string, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = string.length();
        int n7 = 0;
        int n8 = 0;
        int n9 = this.fontWidths[n][this.getCharIndex('_')] + this.spacing;
        int n10 = --n2;
        char c = '\u0000';
        while (n2 < n6) {
            if (n10 != n2) {
                if (c == ' ' && c != '|') {
                    n3 += n7;
                    n7 = n9 + this.spacing;
                } else {
                    n7 += n4 + this.spacing;
                }
            }
            if (++n2 != n6) {
                c = string.charAt(n2);
                if (c != '|' && n3 + n7 <= this.screenWidth) {
                    n5 = c == ' ' ? this.getCharIndex('_') : this.getCharIndex(c);
                    n4 = this.fontWidths[n][n5];
                    continue;
                }
                if (n3 > n8) {
                    n8 = n3;
                }
                n3 = 0;
                continue;
            }
            if (n3 + n7 <= n8) continue;
            n8 = n3 + n7;
        }
        if (n3 + n7 <= this.screenWidth && n3 + n7 > n8) {
            n8 = n3 + n7;
        }
        return n8;
    }

    public int getLineWidth(int n, String string) {
        return this.getLineWidth(n, string, 0);
    }

    public int getCharIndex(char c) {
        return charsetString.indexOf(c);
    }

    private int getCharPosX(int n, int n2) {
        int n3 = 0;
        for (int i = this.getLineBreak(this.getFontLineNumber(n2)); i < n2; ++i) {
            n3 += this.fontWidths[n][i];
        }
        return n3;
    }

    private int getCharPosY(int n, int n2) {
        return this.fontHeight[n] * this.getFontLineNumber(n2);
    }

    private int getFontLineNumber(int n) {
        int n2 = 0;
        if (n <= 14) {
            n2 = 0;
        }
        if (n > 14 && n <= 30) {
            n2 = 1;
        }
        if (n > 30 && n <= 53) {
            n2 = 2;
        }
        if (n > 53 && n <= 80) {
            n2 = 3;
        }
        if (n > 80 && n <= 97) {
            n2 = 4;
        }
        if (n > 97 && n <= 114) {
            n2 = 5;
        }
        if (n > 114 && n <= 139) {
            n2 = 6;
        }
        return n2;
    }

    private int getLineBreak(int n) {
        int n2 = 0;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 1: {
                n2 = 15;
                break;
            }
            case 2: {
                n2 = 31;
                break;
            }
            case 3: {
                n2 = 54;
                break;
            }
            case 4: {
                n2 = 81;
                break;
            }
            case 5: {
                n2 = 98;
                break;
            }
            case 6: {
                n2 = 115;
            }
        }
        return n2;
    }

    private boolean isFontLoaded(int n) {
        return this.font[n] != null;
    }

    public void setSpacing(int n) {
        this.spacing = n;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void resetSpacing() {
        this.spacing = 0;
    }

    public void setDrawWidth(int n) {
        this.screenWidth = n;
    }

    public void resetWidth() {
        this.screenWidth = this.bckupScreenWidth;
    }
}

