/*
 * Decompiled with CFR 0.152.
 */
package bomba;

import bomba.Bomba;
import bomba.Clock;
import bomba.Config_generic;
import bomba.Number;
import bomba.Player;
import bomba.StartDisplayable;
import java.io.InputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;

public class Config
extends Config_generic {
    public static final int FPS = 40;
    public static final int SCREENWIDTH = 176;
    public static final int SCREENHEIGHT = 220;
    public static final int LARGESCREENHEIGHT = 220;
    public static final int FONT_SMALL = 8;
    public static final int FONT_MEDIUM = 0;
    public static final int FONT_LARGE = 16;
    public static final Font HELP_FONT;
    public static final int HELP_HEIGHT;
    public static final int HELP_ARRAY_WIDTH = 8;
    public static final int SOFTKEY1 = -6;
    public static final int SOFTKEY2 = -7;
    public static final int ELEMENTWIDTH = 16;
    public static final int ELEMENTHEIGHT = 16;
    public static final int PLAYFIELDSTARTX = 24;
    public static final int PLAYFIELDSTARTY = 70;
    public static final int PLAYFIELDWIDTH = 128;
    public static final int PLAYFIELDHEIGHT = 128;
    public static final int PLAYERDISPLAYX = 9;
    public static final int PLAYERDISPLAYY = 4;
    public static final int PLAYERDISPLAYWIDTH = 47;
    public static final int PLAYERDISPLAYHEIGHT = 42;
    public static final String RESOURCE = "/";
    public static final int MENUFONTSIZE = 16;
    public static final int MENUYPOS = 20;
    public static final int MENU_X = 88;
    public static final int MENU_WIDTH = 114;
    public static final int MENU_Y_CORRECT = 0;
    private static final int TEXT1_X = 45;
    private static final int TEXT1_Y = 28;
    private static final int TEXT2_X = 45;
    private static final int TEXT2_Y = 42;
    private static final int TEXT3_X = 60;
    private static final int TEXT3_Y = 73;
    public static Image idCard;
    private static int idCardX;
    private static int idCardY;
    private static javax.microedition.media.Player exploSound;
    private static javax.microedition.media.Player titleSound;
    private static javax.microedition.media.Player teleportSound;
    private static javax.microedition.media.Player lostLiveSound;
    private static javax.microedition.media.Player gameOverSound;
    private static javax.microedition.media.Player startSound;
    private static javax.microedition.media.Player nextLevelSound;
    private static Number number;

    public Config() {
        try {
            Image image = Image.createImage((String)"/segment.png");
            number = new Number(image, 4, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        exploSound = this.createSound("explo.amr", "audio/amr", 1);
        titleSound = this.createSound("titel.mid", "audio/midi", 1);
        teleportSound = this.createSound("teleport.mid", "audio/midi", 1);
        lostLiveSound = this.createSound("lost.mid", "audio/midi", 1);
        gameOverSound = this.createSound("gameOver.mid", "audio/midi", 1);
        startSound = this.createSound("start.mid", "audio/midi", 1);
        nextLevelSound = this.createSound("win.mid", "audio/midi", 1);
    }

    private javax.microedition.media.Player createSound(String name, String type, int loop) {
        try {
            InputStream stream = this.getClass().getResourceAsStream(RESOURCE.concat(String.valueOf(String.valueOf(name))));
            javax.microedition.media.Player player = Manager.createPlayer((InputStream)stream, (String)type);
            player.setLoopCount(loop);
            javax.microedition.media.Player player2 = player;
            return player2;
        }
        catch (Exception e) {
            e.printStackTrace();
            javax.microedition.media.Player player = null;
            return player;
        }
    }

    private static void playSound(javax.microedition.media.Player sound, boolean stop) {
        if (sound == null) {
            return;
        }
        try {
            if (stop) {
                sound.deallocate();
            }
            sound.start();
        }
        catch (MediaException e) {
            e.printStackTrace();
            return;
        }
    }

    public static void playLostLiveSound() {
        if (StartDisplayable.effectSound) {
            Config.playSound(lostLiveSound, true);
        }
    }

    public static void playGameOverSound() {
        if (StartDisplayable.effectSound) {
            Config.playSound(gameOverSound, true);
        }
    }

    public static void playNextLevelSound() {
        if (StartDisplayable.effectSound) {
            Config.playSound(nextLevelSound, true);
        }
    }

    public static void playStartSound() {
        if (StartDisplayable.effectSound) {
            Config.playSound(startSound, true);
        }
    }

    public static void playTeleportSound() {
        if (StartDisplayable.effectSound) {
            Config.playSound(teleportSound, true);
        }
    }

    public static void playExploSound() {
        if (StartDisplayable.effectSound) {
            Config.playSound(exploSound, false);
        }
    }

    public static void playTitleSound() {
        if (StartDisplayable.titleSound) {
            Config.playSound(titleSound, true);
        }
    }

    public static void stopTitleSound() {
        titleSound.deallocate();
    }

    public static void paintClock(Graphics g, Clock clock) {
        clock.paint(g, 88, 28, number);
    }

    public static void paintBombs(Graphics g, int bombs) {
        Config.number.digits = 1;
        Config.number.value = bombs;
        number.paint(g, 88, 8);
    }

    public static void paintLives(Graphics g, int lives, Player player) {
        int x = 115;
        int y = 6;
        for (int i = 0; i < 3; ++i) {
            if (i < lives) {
                player.paint(g, x, y, 0, 5);
            } else {
                g.setColor(14277614);
                g.fillRect(x, y, 16, 16);
            }
            x += 17;
        }
    }

    public static void paintIdCard(Graphics g, String string) {
        Config.paintID(g);
        g.setFont(Font.getFont((int)0, (int)1, (int)0));
        g.drawString(string, idCardX + 60, idCardY + 73, 65);
        g.setColor(0xFFFFFF);
        g.setFont(Font.getFont((int)0, (int)1, (int)8));
        g.drawString("Press any key", 88, 72, 17);
    }

    public static void paintLostLive(Graphics g) {
        Config.paintIdCard(g, "Lost a live!");
        idCard = null;
        Config.gc();
    }

    public static void paintGameOver(Graphics g) {
        Config.paintIdCard(g, "Game Over!");
        idCard = null;
        Config.gc();
    }

    public static void paintNextLevel(Graphics g) {
        Config.paintIdCard(g, String.valueOf(String.valueOf(new StringBuffer("Next Level ").append(Bomba.level.getLevelNum() + 1))));
        idCard = null;
        Config.gc();
    }

    public static void paintCountBonus(Graphics g, int bonus, int timebonus, int score) {
        Config.paintID(g);
        g.setFont(Font.getFont((int)0, (int)0, (int)0));
        g.drawString("Bonus: ".concat(String.valueOf(String.valueOf(bonus))), idCardX + 45, idCardY + 28, 68);
        g.drawString("Time: ".concat(String.valueOf(String.valueOf(timebonus))), idCardX + 45, idCardY + 42, 68);
        g.setFont(Font.getFont((int)0, (int)1, (int)0));
        g.drawString("Score: ".concat(String.valueOf(String.valueOf(score))), idCardX + 60, idCardY + 73, 65);
        if (bonus == 0 && timebonus == 0) {
            idCard = null;
            Config.gc();
            g.setColor(0xFFFFFF);
            g.setFont(Font.getFont((int)0, (int)1, (int)8));
            g.drawString("Press any key", 88, 72, 17);
        }
    }

    private static void paintID(Graphics g) {
        g.setColor(0);
        g.fillRect(24, 70, 128, 128);
        try {
            if (idCard == null) {
                idCard = Image.createImage((String)"/idcard.png");
            }
            int height = Font.getFont((int)0, (int)1, (int)8).getHeight();
            idCardX = 24 + (128 - idCard.getWidth()) / 2;
            idCardY = 70 + height + (128 - height - idCard.getHeight()) / 2;
            g.drawImage(idCard, idCardX, idCardY, 20);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void gc() {
        System.gc();
    }

    static {
        FPS = 40;
        SCREENWIDTH = 176;
        SCREENHEIGHT = 220;
        LARGESCREENHEIGHT = 220;
        FONT_SMALL = 8;
        FONT_MEDIUM = 0;
        FONT_LARGE = 16;
        HELP_FONT = Font.getFont((int)0, (int)0, (int)8);
        HELP_HEIGHT = HELP_FONT.getHeight() * 7;
        HELP_ARRAY_WIDTH = 8;
        SOFTKEY1 = -6;
        SOFTKEY2 = -7;
        ELEMENTWIDTH = 16;
        ELEMENTHEIGHT = 16;
        PLAYFIELDSTARTX = 24;
        PLAYFIELDSTARTY = 70;
        PLAYFIELDWIDTH = 128;
        PLAYFIELDHEIGHT = 128;
        PLAYERDISPLAYX = 9;
        PLAYERDISPLAYY = 4;
        PLAYERDISPLAYWIDTH = 47;
        PLAYERDISPLAYHEIGHT = 42;
        RESOURCE = RESOURCE;
        MENUFONTSIZE = 16;
        MENUYPOS = 20;
        MENU_X = 88;
        MENU_WIDTH = 114;
        MENU_Y_CORRECT = 0;
        TEXT1_X = 45;
        TEXT1_Y = 28;
        TEXT2_X = 45;
        TEXT2_Y = 42;
        TEXT3_X = 60;
        TEXT3_Y = 73;
    }
}

