/*
 * Decompiled with CFR 0.152.
 */
package bomba;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AnimatedElements {
    public static final int FRAMES_ROLL = 4;
    public static final int FRAMES_TELEPORTER = 4;
    public static final int FRAMES_DISSOLVE = 4;
    public static final int FRAMES_EXPLOSION = 8;
    public static int delayRoll;
    public static int delayTeleporter;
    public static int delayDissolve;
    public static int delayExplosion;
    private static final int DELAY_ROLL = 0;
    private static final int DELAY_TELEPORTER = 4;
    private static final int DELAY_DISSOLVE = 4;
    private static final int DELAY_EXPLOSION = 4;
    private int phaseRoll = 0;
    private int phaseTeleporter = 0;
    private Image rollV = Image.createImage((String)"/roll_v.png");
    private Image rollH = Image.createImage((String)"/roll_h.png");
    private Image teleporter = Image.createImage((String)"/teleporter.png");
    private Image dissolve = Image.createImage((String)"/dissolve.png");
    private Image explosion = Image.createImage((String)"/explode.png");

    public void free() {
        this.rollV = null;
        this.rollH = null;
        this.teleporter = null;
        this.dissolve = null;
        this.explosion = null;
    }

    public boolean paint(Graphics g, char id, int x, int y, int phase) {
        if (this.paintRoll(g, id, x, y)) {
            return true;
        }
        switch (id) {
            case 't': {
                this.paintTeleporter(g, x, y);
                return true;
            }
            case '-': {
                this.paintDissolve(g, x, y, phase);
                return true;
            }
            case '!': 
            case '#': 
            case '*': 
            case '+': {
                this.paintExplosion(g, x, y, phase);
                return true;
            }
        }
        return false;
    }

    public void paint(Graphics g, Image anim, int x, int y, int phase) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipW = g.getClipWidth();
        int clipH = g.getClipHeight();
        g.clipRect(x, y, 16, 16);
        g.drawImage(anim, x -= phase * 16, y, 20);
        g.setClip(clipX, clipY, clipW, clipH);
    }

    public boolean paintRoll(Graphics g, char id, int x, int y) {
        switch (id) {
            case 'u': {
                this.paint(g, this.rollV, x, y, this.phaseRoll);
                return true;
            }
            case 'd': {
                this.paint(g, this.rollV, x, y, 4 - this.phaseRoll - 1);
                return true;
            }
            case 'l': {
                this.paint(g, this.rollH, x, y, this.phaseRoll);
                return true;
            }
            case 'r': {
                this.paint(g, this.rollH, x, y, 4 - this.phaseRoll - 1);
                return true;
            }
        }
        return false;
    }

    public void paintTeleporter(Graphics g, int x, int y) {
        this.paint(g, this.teleporter, x, y, this.phaseTeleporter);
    }

    public void paintDissolve(Graphics g, int x, int y, int phase) {
        if (phase >= 0 && phase < 4) {
            this.paint(g, this.dissolve, x, y, phase);
        }
    }

    public void paintExplosion(Graphics g, int x, int y, int phase) {
        if (phase >= 0 && phase < 8) {
            this.paint(g, this.explosion, x, y, phase);
        }
    }

    public void nextPhase() {
        if (++delayRoll >= 0) {
            delayRoll = 0;
            ++this.phaseRoll;
            this.phaseRoll %= 4;
        }
        if (++delayTeleporter >= 4) {
            delayTeleporter = 0;
            ++this.phaseTeleporter;
            this.phaseTeleporter %= 4;
        }
        if (++delayDissolve >= 4) {
            delayDissolve = 0;
        }
        if (++delayExplosion >= 4) {
            delayExplosion = 0;
        }
    }

    static {
        FRAMES_ROLL = 4;
        FRAMES_TELEPORTER = 4;
        FRAMES_DISSOLVE = 4;
        FRAMES_EXPLOSION = 8;
        DELAY_ROLL = 0;
        DELAY_TELEPORTER = 4;
        DELAY_DISSOLVE = 4;
        DELAY_EXPLOSION = 4;
    }
}

