/*
 * Decompiled with CFR 0.152.
 */
package bomba;

import bomba.Bomba;
import bomba.Config;
import de.tuttas.GameAPI.ScrollText;
import de.tuttas.GameAPI.ScrollTextListener;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Help
implements ScrollTextListener {
    boolean first = true;
    public static final int HELP_1 = 1;
    public static final int HELP_2 = 2;
    public static final int HELP_3 = 3;
    public static final int HELP_4 = 4;
    public static final int ABOUT = 9;
    private static final int SHOWRADIUS = 7;
    private static final int DELAY = 45;
    private static String[] help1;
    private static String[] help2;
    private static String[] help3;
    private static String[] help4;
    private static String[] about;
    private ScrollText scrollText;
    private Image borderImage;
    private int page;
    private int delayCounter;
    private int stateBombArray = 0;

    public Help(int hstate) {
        try {
            help1 = this.getText("/help1.dat");
            help2 = this.getText("/help2.dat");
            help3 = this.getText("/help3.dat");
            help4 = this.getText("/help4.dat");
            about = this.getText("/about.dat");
            this.page = hstate;
            String[] text = null;
            text = this.page == 9 ? about : help1;
            this.scrollText = new ScrollText(text, 176, Config.HELP_HEIGHT, 1);
            this.scrollText.setListener(this);
            this.delayCounter = 45;
            this.borderImage = Image.createImage((String)"/border.png");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.reset();
    }

    private String[] getText(String name) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(name);
        String s = "";
        int rows = 0;
        int c = is.read();
        while (c != -1) {
            if (c == 13) {
                ++rows;
            } else {
                s = String.valueOf(String.valueOf(s)).concat(String.valueOf(String.valueOf((char)c)));
            }
            c = is.read();
        }
        String[] text = new String[rows];
        int beginIndex = 0;
        for (int i = 0; i < text.length; ++i) {
            int endIndex = s.indexOf("\n", beginIndex);
            text[i] = s.substring(beginIndex, endIndex);
            beginIndex = endIndex + 1;
        }
        return text;
    }

    private String[] getText() {
        switch (this.page) {
            case 1: {
                return help1;
            }
            case 2: {
                return help2;
            }
            case 3: {
                return help3;
            }
            case 4: {
                return help4;
            }
        }
        return null;
    }

    public void reset() {
        this.first = true;
    }

    public void next(int step) {
        this.reset();
        this.page += step;
        if (this.page < 1) {
            this.page = 4;
        } else if (this.page > 4) {
            this.page = 1;
        } else if (this.page == 2) {
            this.delayCounter = 45;
            this.stateBombArray = 0;
        }
        this.scrollText.reset();
        this.scrollText.text = this.getText();
    }

    public void paint(Graphics g) {
        if (this.first) {
            g.setClip(0, 0, 176, 220);
            g.setColor(0x888888);
            g.fillRect(0, 0, 176, Config.HELP_HEIGHT);
            for (int y = 0; y < Config.HELP_HEIGHT; y += this.borderImage.getHeight()) {
                g.drawImage(this.borderImage, 0, y, 20);
                g.drawImage(this.borderImage, 176, y, 24);
            }
            g.setColor(0);
            g.fillRect(0, Config.HELP_HEIGHT, 176, 220);
            switch (this.page) {
                case 1: {
                    Help.drawTeaser(g);
                    break;
                }
                case 2: {
                    switch (this.stateBombArray) {
                        case 0: {
                            Help.paintElementText(g, 'A', "small Bomb", 0);
                            Help.paintArray(g, 1);
                            break;
                        }
                        case 1: {
                            Help.paintElementText(g, 'B', "medium Bomb", 0);
                            Help.paintArray(g, 2);
                            break;
                        }
                        case 2: {
                            Help.paintElementText(g, 'C', "large Bomb", 0);
                            Help.paintArray(g, 3);
                        }
                    }
                    break;
                }
                case 3: {
                    Help.paintElementText(g, 'o', "Ice Field", 0);
                    Help.paintElementText(g, 'm', "Mine", 1);
                    Help.paintElementText(g, '1', "Rotten plate", 2);
                    break;
                }
                case 4: {
                    Help.paintElementText(g, 'f', "Steel plate", 0);
                    Help.paintElementText(g, 'l', "Conveyor belt", 1);
                    Help.paintElementText(g, 't', "Teleporter", 2);
                    break;
                }
                case 9: {
                    Help.drawTeaser(g);
                }
            }
            this.first = false;
        }
        g.setClip(this.borderImage.getWidth(), 0, 176 - 2 * this.borderImage.getWidth(), Config.HELP_HEIGHT);
        g.setColor(0x888888);
        g.fillRect(0, 0, 176, Config.HELP_HEIGHT);
        g.setClip(0, 0, 176, Config.HELP_HEIGHT);
        g.setColor(0);
        g.setFont(Config.HELP_FONT);
        this.scrollText.paint(g);
        if (this.page == 2) {
            if (this.delayCounter <= 0) {
                this.reset();
                this.delayCounter = 45;
                ++this.stateBombArray;
                if (this.stateBombArray >= 3) {
                    this.stateBombArray = 0;
                }
            }
            --this.delayCounter;
        }
        Bomba.animated.nextPhase();
    }

    private static void drawTeaser(Graphics g) {
        try {
            Image image = Image.createImage((String)"/teaser.png");
            g.drawImage(image, 88, 220, 33);
            image = null;
            Config.gc();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void paintElementText(Graphics g, char c, String t, int line) {
        Font font = Font.getFont((int)0, (int)1, (int)0);
        g.setFont(font);
        g.setColor(0xFFFFFF);
        int fontHeight = font.getHeight();
        int yOffset = Config.HELP_HEIGHT + 1;
        int y = yOffset + 17 * line;
        Bomba.level.paintElement(g, c, 5, y, 0);
        g.drawString(t, 26, y, 20);
    }

    private static void paintArray(Graphics g, int radius) {
        int yStart;
        int fontHeight = g.getFont().getHeight();
        int yOffset = Config.HELP_HEIGHT + fontHeight / 2 + fontHeight;
        int xStart = 60;
        int y = yStart = (220 - yOffset - 56) / 2 + yOffset;
        for (int i = -3; i <= 3; ++i) {
            int iAbs = i < 0 ? -i : i;
            int x = xStart;
            for (int j = -3; j <= 3; ++j) {
                int jAbs = j < 0 ? -j : j;
                g.setColor(0x666666);
                g.drawRect(x, y, 8, 8);
                if (iAbs + jAbs < radius) {
                    g.setColor(0xFF0000);
                } else if (iAbs + jAbs == radius) {
                    g.setColor(0xFF8800);
                } else {
                    g.setColor(0);
                }
                g.fillRect(x + 1, y + 1, 7, 7);
                x += 8;
            }
            y += 8;
        }
    }

    public void scrollFinished(ScrollText scrollText) {
        if (this.page == 9) {
            scrollText.reset();
        } else {
            this.next(1);
        }
    }

    static {
        HELP_1 = 1;
        HELP_2 = 2;
        HELP_3 = 3;
        HELP_4 = 4;
        ABOUT = 9;
        SHOWRADIUS = 7;
        DELAY = 45;
    }
}

