/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class SimonSprites {
    protected int posx;
    protected int posy;
    private boolean active = false;
    private int frame = 1;
    private int nframes;
    private Image[] sprites;
    private final int gtl;

    public SimonSprites(int n) {
        this.gtl = 20;
        this.nframes = n;
        this.sprites = new Image[n + 1];
    }

    public void setFrames(int n) {
        this.active = false;
        this.frame = 1;
        this.nframes = n;
        this.sprites = new Image[n + 1];
    }

    int getW() {
        return this.sprites[this.nframes].getWidth();
    }

    int getH() {
        return this.sprites[this.nframes].getHeight();
    }

    public void on() {
        this.active = true;
    }

    public void off() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public void selFrame(int n) {
        this.frame = n;
    }

    public int getSpFrame() {
        return this.frame;
    }

    public int frames() {
        return this.nframes;
    }

    public void addFrame(int n, String string) {
        try {
            this.sprites[n] = Image.createImage((String)string);
        }
        catch (Exception exception) {
            System.err.println("Can`t load the image " + exception.toString());
        }
    }

    public void addFrame(int n, Image image) {
        try {
            this.sprites[n] = image;
        }
        catch (Exception exception) {
            System.err.println("Can`t load the image : " + exception.toString());
        }
    }

    public void draw(Graphics graphics) {
        graphics.setClip(this.posx, this.posy, this.getW(), this.getH());
        graphics.drawImage(this.sprites[this.frame], this.posx, this.posy, 20);
    }
}

