/*
 * Decompiled with CFR 0.152.
 */
package kitUtils;

import Main.MainManager;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class KitSound {
    public static final byte SFX_MENU = 0;
    public static final byte SFX_LETS_PLAY = 1;
    public static final byte SFX_GAME_OVER = 2;
    public static final byte SFX_WRONG = 3;
    public static final byte SFX_GROUP_EXPLOCION = 4;
    public static final byte SFX_BOMB_EXPLOCION = 5;
    public static Player[] sounds;
    public static byte[] loadedSoundsId;
    public static byte currentSound;
    public static boolean loopSound;
    public static byte lastDeleted;
    public static long sleepTime;

    public KitSound() {
        sounds = new Player[4];
        loadedSoundsId = new byte[4];
        for (int i = 0; i < loadedSoundsId.length; ++i) {
            KitSound.loadedSoundsId[i] = -1;
        }
        currentSound = (byte)-1;
        sleepTime = MainManager.currentTime;
    }

    public int loadSound(byte by) {
        int n;
        int n2 = -1;
        for (n = 0; n < loadedSoundsId.length; ++n) {
            if (loadedSoundsId[n] != by) continue;
            return n;
        }
        for (n = 0; n < loadedSoundsId.length && n2 == -1; ++n) {
            if (loadedSoundsId[n] != -1) continue;
            n2 = (byte)n;
        }
        if (n2 == -1) {
            try {
                this.unloadSound(lastDeleted);
                n2 = lastDeleted;
                lastDeleted = (byte)(lastDeleted + 1);
                if (lastDeleted == 4) {
                    lastDeleted = 0;
                }
            }
            catch (Exception exception) {
                return -1;
            }
        }
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/" + this.getSoundString(by));
            KitSound.sounds[n2] = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
            KitSound.loadedSoundsId[n2] = by;
            return n2;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public void unloadSound(int n) {
        try {
            if (sounds[n] == null) {
                return;
            }
            if (sounds[n].getState() == 400) {
                sounds[n].stop();
            }
            sounds[n].close();
            KitSound.sounds[n] = null;
            KitSound.loadedSoundsId[n] = -1;
            return;
        }
        catch (MediaException mediaException) {
            MediaException mediaException2 = mediaException;
            mediaException.printStackTrace();
            return;
        }
    }

    public void unloadAll() {
        for (int i = 0; i < loadedSoundsId.length; ++i) {
            if (loadedSoundsId[i] == -1) continue;
            this.unloadSound(i);
        }
        currentSound = (byte)-1;
        System.gc();
    }

    public void playSound(byte by, boolean bl) {
        if (!MainManager.SoundOn) {
            return;
        }
        loopSound = bl;
        boolean bl2 = false;
        int n = 0;
        for (int i = 0; i < loadedSoundsId.length && !bl2; ++i) {
            if (loadedSoundsId[i] != by) continue;
            bl2 = true;
            n = i;
        }
        if (!bl2) {
            n = this.loadSound(by);
        }
        currentSound = (byte)n;
    }

    public void stopSounds() {
        for (int i = 0; i < sounds.length; ++i) {
            if (sounds[i] != null) {
                try {
                    if (sounds[i].getState() != 400) continue;
                    sounds[i].stop();
                    sounds[i].deallocate();
                    sounds[i].deallocate();
                }
                catch (MediaException mediaException) {
                    MediaException mediaException2 = mediaException;
                    mediaException.printStackTrace();
                }
                continue;
            }
            KitSound.loadedSoundsId[i] = -1;
        }
        currentSound = (byte)-1;
    }

    public void start() {
        if (MainManager.currentTime - sleepTime < 200L && currentSound == -1) {
            return;
        }
        sleepTime = MainManager.currentTime;
        try {
            if (currentSound == -1) {
                return;
            }
            for (int i = 0; i < sounds.length; ++i) {
                if (sounds[i] == null) continue;
                try {
                    if (sounds[i].getState() != 400 || loopSound && (!loopSound || i == currentSound)) continue;
                    sounds[i].stop();
                    sounds[i].deallocate();
                    sounds[i].deallocate();
                    continue;
                }
                catch (Exception exception) {
                    Exception exception2 = exception;
                    exception.printStackTrace();
                }
            }
            if (!loopSound || sounds[currentSound].getState() == 400) {
                if (!loopSound) {
                    if (sounds[currentSound].getState() == 400) {
                        sounds[currentSound].stop();
                        sounds[currentSound].deallocate();
                        sounds[currentSound].deallocate();
                    }
                    sounds[currentSound].start();
                    currentSound = (byte)-1;
                }
                return;
            }
            sounds[currentSound].start();
        }
        catch (MediaException mediaException) {
            MediaException mediaException2 = mediaException;
            mediaException.printStackTrace();
        }
    }

    public String getSoundString(byte by) {
        switch (by) {
            case 0: {
                return "MainMenu.mid";
            }
            case 5: {
                return "BombExplocion.mid";
            }
            case 2: {
                return "GameOver.mid";
            }
            case 4: {
                return "GroupSelected.mid";
            }
            case 1: {
                return "LetsPlay.mid";
            }
            case 3: {
                return "Wrong.mid";
            }
        }
        return null;
    }

    static {
        loopSound = false;
        lastDeleted = 0;
    }
}

