/*
 * Decompiled with CFR 0.152.
 */
package com.astrolink;

import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class MediaCenter {
    public static final String FORMAT_AUDIO_WAV = "audio/x-wav";
    public static final String FORMAT_AUDIO_AMR = "audio/amr";
    public static final String FORMAT_AUDIO_MIDI = "audio/midi";
    public static final String FORMAT_AUDIO_MP3 = "audio/mp3";
    Player player;

    public MediaCenter(String url, String format) {
        this.createMedia(url, format);
    }

    final void createMedia(String url, String format) {
        try {
            InputStream is = this.getClass().getResourceAsStream(url);
            this.player = Manager.createPlayer((InputStream)is, (String)format);
            this.player.setLoopCount(1);
            this.player.realize();
            this.player.prefetch();
        }
        catch (IOException ex) {
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public final void startPlay() {
        if (this.player != null) {
            try {
                this.player.start();
            }
            catch (MediaException ex) {
                System.out.println("***Start Player Error!");
            }
        }
    }

    public final void stopPlay() {
        if (this.player != null && this.player.getState() != 0) {
            try {
                this.player.deallocate();
                this.player.stop();
            }
            catch (MediaException ex) {
                System.out.println("***Stop Player Error!");
            }
        }
    }

    public final void closePlayer() {
        if (this.player != null) {
            this.player.close();
            this.player = null;
        }
    }
}

